/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieCertificationFilter
extends AbstractCheckComboBoxMovieUIFilter<Certification> {
    private MovieList movieList = MovieList.getInstance();

    public MovieCertificationFilter() {
        this.buildAndInstallCertificationArray();
        PropertyChangeListener propertyChangeListener = evt -> this.buildAndInstallCertificationArray();
        this.movieList.addPropertyChangeListener("certification", propertyChangeListener);
    }

    @Override
    public String getId() {
        return "movieCertification";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        return selectedItems.contains(movie.getCertification());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("metatag.certification"));
    }

    private void buildAndInstallCertificationArray() {
        ArrayList<Certification> certifications = new ArrayList<Certification>(this.movieList.getCertificationsInMovies());
        Collections.sort(certifications);
        this.setValues(certifications);
    }

    @Override
    protected String parseTypeToString(Certification type) throws Exception {
        return type.name();
    }

    @Override
    protected Certification parseStringToType(String string) throws Exception {
        return Certification.valueOf((String)string);
    }
}

