/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractMovieUIFilter;

public class MovieCountryFilter
extends AbstractMovieUIFilter {
    private JTextField textField;

    @Override
    public String getId() {
        return "movieCountry";
    }

    @Override
    public String getFilterValueAsString() {
        return this.textField.getText();
    }

    @Override
    public void setFilterValue(Object value) {
        if (value instanceof String) {
            this.textField.setText((String)value);
        }
    }

    @Override
    public boolean accept(Movie movie) {
        String name = this.textField.getText();
        if (StringUtils.isBlank((CharSequence)name)) {
            return true;
        }
        Pattern pattern = Pattern.compile("(?i)" + Pattern.quote(name));
        Matcher matcher = null;
        return StringUtils.isNotEmpty((CharSequence)movie.getCountry()) && (matcher = pattern.matcher(movie.getCountry())).find();
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("movieextendedsearch.country"));
    }

    @Override
    protected JComponent createFilterComponent() {
        this.textField = new JTextField();
        return this.textField;
    }
}

