/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieGenreFilter
extends AbstractCheckComboBoxMovieUIFilter<MediaGenres> {
    public MovieGenreFilter() {
        this.buildAndInstallMediaGenres();
        MediaGenres.addListener(evt -> SwingUtilities.invokeLater(this::buildAndInstallMediaGenres));
    }

    @Override
    public String getId() {
        return "movieGenre";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        if (selectedItems.isEmpty() && movie.getGenres().isEmpty()) {
            return true;
        }
        for (MediaGenres genre : movie.getGenres()) {
            if (!selectedItems.contains(genre)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("movieextendedsearch.genre"));
    }

    private void buildAndInstallMediaGenres() {
        this.setValues(MediaGenres.values());
    }

    @Override
    protected String parseTypeToString(MediaGenres type) throws Exception {
        return type.name();
    }

    @Override
    protected MediaGenres parseStringToType(String string) throws Exception {
        return MediaGenres.getGenre((String)string);
    }
}

