/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractMovieUIFilter;

public class MovieLanguageFilter
extends AbstractMovieUIFilter {
    private JTextField textField;

    @Override
    public String getId() {
        return "movieLanguage";
    }

    @Override
    public String getFilterValueAsString() {
        return this.textField.getText();
    }

    @Override
    public void setFilterValue(Object value) {
        if (value instanceof String) {
            this.textField.setText((String)value);
        }
    }

    @Override
    public boolean accept(Movie movie) {
        Pattern pattern;
        Matcher matcher;
        String langauge = this.textField.getText();
        if (StringUtils.isBlank((CharSequence)langauge)) {
            return true;
        }
        return StringUtils.isNotBlank((CharSequence)movie.getSpokenLanguages()) && (matcher = (pattern = Pattern.compile("(?i)" + Pattern.quote(langauge))).matcher(movie.getSpokenLanguages())).find();
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("metatag.language"));
    }

    @Override
    protected JComponent createFilterComponent() {
        this.textField = new JTextField();
        return this.textField;
    }
}

