/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieVideoContainerFilter
extends AbstractCheckComboBoxMovieUIFilter<String> {
    private MovieList movieList = MovieList.getInstance();

    public MovieVideoContainerFilter() {
        this.buildAndInstallContainerArray();
        PropertyChangeListener propertyChangeListener = evt -> this.buildAndInstallContainerArray();
        this.movieList.addPropertyChangeListener("videoContainer", propertyChangeListener);
    }

    @Override
    public String getId() {
        return "movieVideoContainer";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedValues = this.checkComboBox.getSelectedItems();
        return selectedValues.contains(movie.getMediaInfoContainerFormat());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("metatag.container"));
    }

    private void buildAndInstallContainerArray() {
        ArrayList<String> containers = new ArrayList<String>(this.movieList.getVideoContainersInMovies());
        Collections.sort(containers);
        this.setValues(containers);
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

