/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieYearFilter
extends AbstractCheckComboBoxMovieUIFilter<Integer> {
    private MovieList movieList = MovieList.getInstance();

    public MovieYearFilter() {
        this.buildAndInstallYears();
        PropertyChangeListener propertyChangeListener = evt -> this.buildAndInstallYears();
        this.movieList.addPropertyChangeListener("year", propertyChangeListener);
    }

    private void buildAndInstallYears() {
        ArrayList<Integer> years = new ArrayList<Integer>(this.movieList.getYearsInMovies());
        Collections.sort(years);
        this.setValues(years);
    }

    @Override
    public String getId() {
        return "movieYear";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        return selectedItems.contains(movie.getYear());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("metatag.year"));
    }

    @Override
    protected String parseTypeToString(Integer type) throws Exception {
        return type.toString();
    }

    @Override
    protected Integer parseStringToType(String string) throws Exception {
        return Integer.parseInt(string);
    }
}

