/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.panels;

import java.awt.Component;
import java.awt.LayoutManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.MovieSelectionModel;

public class MovieDetailsPanel
extends JPanel {
    private static final long serialVersionUID = 6273970118830324299L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieDetailsPanel.class);
    private MovieSelectionModel movieSelectionModel;
    private JLabel lblProduction;
    private JLabel lblTags;
    private JLabel lblEdition;
    private LinkLabel lblMoviePath;
    private JLabel lblMovieSet;
    private JLabel lblSpokenLanguages;
    private JLabel lblCountry;
    private JLabel lblReleaseDate;
    private JLabel lblNote;

    public MovieDetailsPanel(MovieSelectionModel model) {
        this.movieSelectionModel = model;
        this.initComponents();
        this.initDataBindings();
        this.lblMoviePath.addActionListener(arg0 -> {
            if (!StringUtils.isEmpty((CharSequence)this.lblMoviePath.getText())) {
                Path path = Paths.get(this.lblMoviePath.getText(), new String[0]);
                try {
                    if (Files.exists(path, new LinkOption[0])) {
                        TmmUIHelper.openFile(path);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("open filemanager", (Throwable)ex);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)path, "message.erroropenfolder", new String[]{":", ex.getLocalizedMessage()}));
                }
            }
        });
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("insets 0", "[][10lp][200lp,grow]", "[]2lp[]2lp[]2lp[]2lp[]2lp[]2lp[]2lp[]2lp[]"));
        TmmLabel lblReleaseDateT = new TmmLabel(BUNDLE.getString("metatag.releasedate"));
        this.add((Component)lblReleaseDateT, "cell 0 0");
        this.lblReleaseDate = new JLabel("");
        this.add((Component)this.lblReleaseDate, "cell 2 0,growx,wmin 0");
        TmmLabel lblProductionT = new TmmLabel(BUNDLE.getString("metatag.production"));
        this.add((Component)lblProductionT, "cell 0 1");
        this.lblProduction = new JLabel();
        this.add((Component)this.lblProduction, "cell 2 1,growx,wmin 0");
        TmmLabel lblCountryT = new TmmLabel(BUNDLE.getString("metatag.country"));
        this.add((Component)lblCountryT, "cell 0 2");
        this.lblCountry = new JLabel("");
        this.add((Component)this.lblCountry, "cell 2 2,growx,wmin 0");
        TmmLabel lblSpokenLanguagesT = new TmmLabel(BUNDLE.getString("metatag.spokenlanguages"));
        this.add((Component)lblSpokenLanguagesT, "cell 0 3");
        this.lblSpokenLanguages = new JLabel("");
        this.add((Component)this.lblSpokenLanguages, "cell 2 3,growx,wmin 0");
        TmmLabel lblMoviesetT = new TmmLabel(BUNDLE.getString("metatag.movieset"));
        this.add((Component)lblMoviesetT, "cell 0 4");
        this.lblMovieSet = new JLabel("");
        this.add((Component)this.lblMovieSet, "cell 2 4,growx,wmin 0");
        TmmLabel lblEditionT = new TmmLabel(BUNDLE.getString("metatag.edition"));
        this.add((Component)lblEditionT, "cell 0 5");
        this.lblEdition = new JLabel("");
        this.add((Component)this.lblEdition, "cell 2 5,growx,wmin 0");
        TmmLabel lblTagsT = new TmmLabel(BUNDLE.getString("metatag.tags"));
        this.add((Component)lblTagsT, "cell 0 6");
        this.lblTags = new JLabel("");
        this.add((Component)this.lblTags, "cell 2 6,growx,wmin 0");
        TmmLabel lblMoviePathT = new TmmLabel(BUNDLE.getString("metatag.path"));
        this.add((Component)lblMoviePathT, "cell 0 7");
        this.lblMoviePath = new LinkLabel("");
        this.add((Component)this.lblMoviePath, "cell 2 7,growx,wmin 0");
        TmmLabel lblNoteT = new TmmLabel(BUNDLE.getString("metatag.note"));
        this.add((Component)lblNoteT, "cell 0 8");
        this.lblNote = new JLabel("");
        this.add((Component)this.lblNote, "cell 2 8, growx, wmin 0");
    }

    protected void initDataBindings() {
        BeanProperty movieSelectionModelBeanProperty_4 = BeanProperty.create((String)"selectedMovie.tagsAsString");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_4, (Object)this.lblTags, (Property)jLabelBeanProperty);
        autoBinding_4.bind();
        BeanProperty movieSelectionModelBeanProperty_5 = BeanProperty.create((String)"selectedMovie.productionCompany");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_5, (Object)this.lblProduction, (Property)jLabelBeanProperty);
        autoBinding_5.bind();
        BeanProperty movieSelectionModelBeanProperty = BeanProperty.create((String)"selectedMovie.path");
        BeanProperty linkLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty, (Object)this.lblMoviePath, (Property)linkLabelBeanProperty);
        autoBinding.bind();
        BeanProperty movieSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedMovie.movieSetTitle");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_1, (Object)this.lblMovieSet, (Property)jLabelBeanProperty);
        autoBinding_1.bind();
        BeanProperty movieSelectionModelBeanProperty_2 = BeanProperty.create((String)"selectedMovie.spokenLanguages");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_2, (Object)this.lblSpokenLanguages, (Property)jLabelBeanProperty);
        autoBinding_2.bind();
        BeanProperty movieSelectionModelBeanProperty_3 = BeanProperty.create((String)"selectedMovie.country");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_3, (Object)this.lblCountry, (Property)jLabelBeanProperty);
        autoBinding_3.bind();
        BeanProperty movieSelectionModelBeanProperty_10 = BeanProperty.create((String)"selectedMovie.releaseDateAsString");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_10, (Object)this.lblReleaseDate, (Property)jLabelBeanProperty);
        autoBinding_6.bind();
        BeanProperty movieSelectionModelBeanProperty_9 = BeanProperty.create((String)"selectedMovie.edition.title");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_9, (Object)this.lblEdition, (Property)jLabelBeanProperty);
        autoBinding_8.bind();
        BeanProperty movieSelectionModelBeanProperty_6 = BeanProperty.create((String)"selectedMovie.note");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_6, (Object)this.lblNote, (Property)jLabelBeanProperty);
        autoBinding_7.bind();
    }
}

