/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.panels;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;

public class MovieScraperMetadataPanel
extends JPanel {
    private static final long serialVersionUID = 1053348917399322570L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private MovieScraperMetadataConfig config;
    private JCheckBox chckbxTitle;
    private JCheckBox chckbxOriginalTitle;
    private JCheckBox chckbxTagline;
    private JCheckBox chckbxPlot;
    private JCheckBox chckbxRating;
    private JCheckBox chckbxRuntime;
    private JCheckBox chckbxYear;
    private JCheckBox chckbxCertification;
    private JCheckBox chckbxCast;
    private JCheckBox chckbxCountry;
    private JCheckBox chckbxStudio;
    private JCheckBox chckbxGenres;
    private JCheckBox chckbxArtwork;
    private JCheckBox chckbxTrailer;
    private JCheckBox chckbxCollection;
    private JCheckBox chckbxTags;
    private JLabel lblMovieSetHint;

    public MovieScraperMetadataPanel(MovieScraperMetadataConfig config) {
        this.config = config;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("insets 0", "[][20lp:n][][20lp:n][][20lp:n][][20lp:n][]", "[]2lp[]2lp[]2lp[]"));
        this.chckbxTitle = new JCheckBox(BUNDLE.getString("metatag.title"));
        this.add((Component)this.chckbxTitle, "cell 0 0");
        this.chckbxOriginalTitle = new JCheckBox(BUNDLE.getString("metatag.originaltitle"));
        this.add((Component)this.chckbxOriginalTitle, "cell 2 0");
        this.chckbxYear = new JCheckBox(BUNDLE.getString("metatag.year"));
        this.add((Component)this.chckbxYear, "cell 4 0");
        this.chckbxTagline = new JCheckBox(BUNDLE.getString("metatag.tagline"));
        this.add((Component)this.chckbxTagline, "cell 6 0");
        this.chckbxPlot = new JCheckBox(BUNDLE.getString("metatag.plot"));
        this.add((Component)this.chckbxPlot, "cell 8 0");
        this.chckbxRating = new JCheckBox(BUNDLE.getString("metatag.rating"));
        this.add((Component)this.chckbxRating, "cell 0 1");
        this.chckbxRuntime = new JCheckBox(BUNDLE.getString("metatag.runtime"));
        this.add((Component)this.chckbxRuntime, "cell 2 1");
        this.chckbxCertification = new JCheckBox(BUNDLE.getString("metatag.certification"));
        this.add((Component)this.chckbxCertification, "cell 4 1");
        this.chckbxGenres = new JCheckBox(BUNDLE.getString("metatag.genre"));
        this.add((Component)this.chckbxGenres, "cell 6 1");
        this.chckbxTags = new JCheckBox(BUNDLE.getString("metatag.tags"));
        this.add((Component)this.chckbxTags, "cell 8 1");
        this.chckbxCast = new JCheckBox(BUNDLE.getString("metatag.cast"));
        this.add((Component)this.chckbxCast, "cell 0 2");
        this.chckbxArtwork = new JCheckBox(BUNDLE.getString("metatag.artwork"));
        this.add((Component)this.chckbxArtwork, "cell 2 2");
        this.chckbxTrailer = new JCheckBox(BUNDLE.getString("metatag.trailer"));
        this.add((Component)this.chckbxTrailer, "cell 4 2");
        this.chckbxCollection = new JCheckBox(BUNDLE.getString("metatag.movieset"));
        this.add((Component)this.chckbxCollection, "flowx,cell 6 2");
        this.lblMovieSetHint = new JLabel(IconManager.HINT);
        this.add((Component)this.lblMovieSetHint, "cell 6 2");
        this.lblMovieSetHint.setToolTipText(BUNDLE.getString("Settings.movieset.scraper.hint"));
        this.chckbxCountry = new JCheckBox(BUNDLE.getString("metatag.country"));
        this.add((Component)this.chckbxCountry, "cell 8 2");
        this.chckbxStudio = new JCheckBox(BUNDLE.getString("metatag.studio"));
        this.add((Component)this.chckbxStudio, "cell 0 3");
        JButton btnSelectAll = new JButton(IconManager.CHECK_ALL);
        this.add((Component)btnSelectAll, "flowx,cell 0 4 3 1");
        btnSelectAll.setToolTipText(BUNDLE.getString("Button.select.all"));
        btnSelectAll.addActionListener(e -> this.setCheckBoxState(true));
        JButton btnDeSelectAll = new JButton(IconManager.CLEAR_ALL);
        this.add((Component)btnDeSelectAll, "cell 0 4 3 1");
        btnDeSelectAll.setToolTipText(BUNDLE.getString("Button.select.none"));
        btnDeSelectAll.addActionListener(e -> this.setCheckBoxState(false));
        this.initDataBindings();
    }

    private void setCheckBoxState(boolean state) {
        for (JCheckBox checkBox : this.getAllCheckBoxes(this)) {
            checkBox.setSelected(state);
        }
    }

    private List<JCheckBox> getAllCheckBoxes(Container container) {
        Component[] comps = container.getComponents();
        ArrayList<JCheckBox> compList = new ArrayList<JCheckBox>();
        for (Component comp : comps) {
            if (comp instanceof JCheckBox) {
                compList.add((JCheckBox)comp);
            }
            if (!(comp instanceof Container)) continue;
            compList.addAll(this.getAllCheckBoxes((Container)comp));
        }
        return compList;
    }

    protected void initDataBindings() {
        BeanProperty scraperMetadataConfigBeanProperty = BeanProperty.create((String)"title");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)scraperMetadataConfigBeanProperty, (Object)this.chckbxTitle, (Property)jCheckBoxBeanProperty);
        autoBinding.bind();
        BeanProperty scraperMetadataConfigBeanProperty_1 = BeanProperty.create((String)"originalTitle");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)scraperMetadataConfigBeanProperty_1, (Object)this.chckbxOriginalTitle, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty scraperMetadataConfigBeanProperty_2 = BeanProperty.create((String)"tagline");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)scraperMetadataConfigBeanProperty_2, (Object)this.chckbxTagline, (Property)jCheckBoxBeanProperty);
        autoBinding_2.bind();
        BeanProperty scraperMetadataConfigBeanProperty_3 = BeanProperty.create((String)"plot");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)scraperMetadataConfigBeanProperty_3, (Object)this.chckbxPlot, (Property)jCheckBoxBeanProperty);
        autoBinding_3.bind();
        BeanProperty scraperMetadataConfigBeanProperty_4 = BeanProperty.create((String)"rating");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)scraperMetadataConfigBeanProperty_4, (Object)this.chckbxRating, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty scraperMetadataConfigBeanProperty_5 = BeanProperty.create((String)"runtime");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)scraperMetadataConfigBeanProperty_5, (Object)this.chckbxRuntime, (Property)jCheckBoxBeanProperty);
        autoBinding_5.bind();
        BeanProperty scraperMetadataConfigBeanProperty_6 = BeanProperty.create((String)"year");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)scraperMetadataConfigBeanProperty_6, (Object)this.chckbxYear, (Property)jCheckBoxBeanProperty);
        autoBinding_6.bind();
        BeanProperty scraperMetadataConfigBeanProperty_7 = BeanProperty.create((String)"certification");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)scraperMetadataConfigBeanProperty_7, (Object)this.chckbxCertification, (Property)jCheckBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty scraperMetadataConfigBeanProperty_8 = BeanProperty.create((String)"cast");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)scraperMetadataConfigBeanProperty_8, (Object)this.chckbxCast, (Property)jCheckBoxBeanProperty);
        autoBinding_8.bind();
        BeanProperty scraperMetadataConfigBeanProperty_9 = BeanProperty.create((String)"genres");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)scraperMetadataConfigBeanProperty_9, (Object)this.chckbxGenres, (Property)jCheckBoxBeanProperty);
        autoBinding_9.bind();
        BeanProperty scraperMetadataConfigBeanProperty_10 = BeanProperty.create((String)"artwork");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)scraperMetadataConfigBeanProperty_10, (Object)this.chckbxArtwork, (Property)jCheckBoxBeanProperty);
        autoBinding_10.bind();
        BeanProperty scraperMetadataConfigBeanProperty_11 = BeanProperty.create((String)"trailer");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)scraperMetadataConfigBeanProperty_11, (Object)this.chckbxTrailer, (Property)jCheckBoxBeanProperty);
        autoBinding_11.bind();
        BeanProperty scraperMetadataConfigBeanProperty_12 = BeanProperty.create((String)"collection");
        AutoBinding autoBinding_12 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)scraperMetadataConfigBeanProperty_12, (Object)this.chckbxCollection, (Property)jCheckBoxBeanProperty);
        autoBinding_12.bind();
        BeanProperty movieScraperMetadataConfigBeanProperty = BeanProperty.create((String)"tags");
        AutoBinding autoBinding_13 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)movieScraperMetadataConfigBeanProperty, (Object)this.chckbxTags, (Property)jCheckBoxBeanProperty);
        autoBinding_13.bind();
        BeanProperty scraperMetadataConfigBeanProperty_14 = BeanProperty.create((String)"country");
        AutoBinding autoBinding_14 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)scraperMetadataConfigBeanProperty_14, (Object)this.chckbxCountry, (Property)jCheckBoxBeanProperty);
        autoBinding_14.bind();
        BeanProperty scraperMetadataConfigBeanProperty_15 = BeanProperty.create((String)"studio");
        AutoBinding autoBinding_15 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.config, (Property)scraperMetadataConfigBeanProperty_15, (Object)this.chckbxStudio, (Property)jCheckBoxBeanProperty);
        autoBinding_15.bind();
    }
}

