/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.settings;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.ui.ScraperInTable;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.SettingsPanelFactory;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.panels.MediaScraperConfigurationPanel;
import org.tinymediamanager.ui.panels.ScrollablePanel;

class MovieImageSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 7312645402037806284L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private MovieSettings settings = MovieModuleManager.SETTINGS;
    private List<ScraperInTable> scrapers = ObservableCollections.observableList(new ArrayList());
    private JComboBox cbImagePosterSize;
    private JComboBox cbImageFanartSize;
    private TmmTable tableScraper;
    private JTextPane tpScraperDescription;
    private JPanel panelScraperOptions;
    private JComboBox<MediaLanguages> cbScraperLanguage;

    MovieImageSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        List<String> enabledArtworkProviders = this.settings.getArtworkScrapers();
        int selectedIndex = -1;
        int counter = 0;
        for (MediaScraper scraper : MovieList.getInstance().getAvailableArtworkScrapers()) {
            ScraperInTable artworkScraper = new ScraperInTable(scraper);
            if (enabledArtworkProviders.contains(artworkScraper.getScraperId())) {
                artworkScraper.setActive(true);
                if (selectedIndex < 0) {
                    selectedIndex = counter;
                }
            }
            this.scrapers.add(artworkScraper);
            ++counter;
        }
        TableColumnResizer.setMaxWidthForColumn(this.tableScraper, 0, 2);
        TableColumnResizer.setMaxWidthForColumn(this.tableScraper, 1, 2);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableScraper, 5);
        this.tableScraper.getModel().addTableModelListener(arg0 -> {
            if (arg0.getColumn() == 0) {
                int row = arg0.getFirstRow();
                ScraperInTable changedScraper = this.scrapers.get(row);
                if (changedScraper.getActive().booleanValue()) {
                    this.settings.addMovieArtworkScraper(changedScraper.getScraperId());
                } else {
                    this.settings.removeMovieArtworkScraper(changedScraper.getScraperId());
                }
            }
        });
        this.tableScraper.getSelectionModel().addListSelectionListener(e -> {
            int index = this.tableScraper.convertRowIndexToModel(this.tableScraper.getSelectedRow());
            if (index > -1) {
                this.panelScraperOptions.removeAll();
                if (this.scrapers.get(index).getMediaProvider().getProviderInfo().getConfig().hasConfig()) {
                    this.panelScraperOptions.add(new MediaScraperConfigurationPanel(this.scrapers.get(index).getMediaProvider()));
                }
                this.panelScraperOptions.revalidate();
            }
        });
        Font font = UIManager.getFont("Label.font");
        Color color = UIManager.getColor("Label.foreground");
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; color: rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "); }";
        this.tpScraperDescription.setEditorKit(new HTMLEditorKit());
        ((HTMLDocument)this.tpScraperDescription.getDocument()).getStyleSheet().addRule(bodyRule);
        if (selectedIndex < 0) {
            selectedIndex = 0;
        }
        if (counter > 0) {
            this.tableScraper.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[400lp,grow]", "[][15lp!][]"));
        JPanel panelScraper = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][grow]", "[][shrink 0][]"));
        TmmLabel lblScraperT = new TmmLabel(BUNDLE.getString("scraper.artwork"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelScraper, lblScraperT, true);
        this.add((Component)collapsiblePanel, "cell 0 0,wmin 0,grow");
        this.tableScraper = new TmmTable();
        this.tableScraper.setRowHeight(29);
        this.tableScraper.setShowGrid(true);
        panelScraper.add((Component)this.tableScraper, "cell 1 0,grow");
        JSeparator separator = new JSeparator();
        panelScraper.add((Component)separator, "cell 1 1,growx");
        ScrollablePanel panelScraperDetails = new ScrollablePanel();
        panelScraper.add((Component)panelScraperDetails, "cell 1 2,grow");
        panelScraperDetails.setLayout((LayoutManager)new MigLayout("insets 0", "[grow]", "[][grow]"));
        this.tpScraperDescription = new JTextPane();
        this.tpScraperDescription.setOpaque(false);
        this.tpScraperDescription.setEditorKit(new HTMLEditorKit());
        panelScraperDetails.add((Component)this.tpScraperDescription, "cell 0 0,grow");
        this.panelScraperOptions = new JPanel();
        this.panelScraperOptions.setLayout(new FlowLayout(0));
        panelScraperDetails.add((Component)this.panelScraperOptions, "cell 0 1,grow");
        JPanel panelOptions = SettingsPanelFactory.createSettingsPanel();
        TmmLabel lblOptionsT = new TmmLabel(BUNDLE.getString("Settings.advancedoptions"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelOptions, lblOptionsT, true);
        this.add((Component)collapsiblePanel, "cell 0 2,growx, wmin 0");
        JLabel lblScraperLanguage = new JLabel(BUNDLE.getString("Settings.preferredLanguage"));
        panelOptions.add((Component)lblScraperLanguage, "cell 1 0 2 1");
        this.cbScraperLanguage = new JComboBox<MediaLanguages>(MediaLanguages.valuesSorted());
        panelOptions.add(this.cbScraperLanguage, "cell 1 0");
        JLabel lblImageTmdbPosterSize = new JLabel(BUNDLE.getString("image.poster.size"));
        panelOptions.add((Component)lblImageTmdbPosterSize, "cell 1 1 2 1");
        this.cbImagePosterSize = new JComboBox<MediaArtwork.PosterSizes>(MediaArtwork.PosterSizes.values());
        panelOptions.add((Component)this.cbImagePosterSize, "cell 1 1");
        JLabel lblImageTmdbFanartSize = new JLabel(BUNDLE.getString("image.fanart.size"));
        panelOptions.add((Component)lblImageTmdbFanartSize, "cell 1 2 2 1");
        this.cbImageFanartSize = new JComboBox<MediaArtwork.FanartSizes>(MediaArtwork.FanartSizes.values());
        panelOptions.add((Component)this.cbImageFanartSize, "cell 1 2");
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_5 = BeanProperty.create((String)"imagePosterSize");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_5, (Object)this.cbImagePosterSize, (Property)jComboBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty settingsBeanProperty_6 = BeanProperty.create((String)"imageFanartSize");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_6, (Object)this.cbImageFanartSize, (Property)jComboBoxBeanProperty);
        autoBinding_5.bind();
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.scrapers, (JTable)this.tableScraper);
        BeanProperty artworkScraperBeanProperty = BeanProperty.create((String)"active");
        jTableBinding.addColumnBinding((Property)artworkScraperBeanProperty).setColumnName("Active").setColumnClass(Boolean.class);
        BeanProperty artworkScraperBeanProperty_1 = BeanProperty.create((String)"scraperLogo");
        jTableBinding.addColumnBinding((Property)artworkScraperBeanProperty_1).setColumnName("Logo").setEditable(false).setColumnClass(ImageIcon.class);
        BeanProperty artworkScraperBeanProperty_2 = BeanProperty.create((String)"scraperName");
        jTableBinding.addColumnBinding((Property)artworkScraperBeanProperty_2).setColumnName("Name").setEditable(false).setColumnClass(String.class);
        jTableBinding.bind();
        BeanProperty jTableBeanProperty = BeanProperty.create((String)"selectedElement.scraperDescription");
        BeanProperty jTextPaneBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_23 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tableScraper, (Property)jTableBeanProperty, (Object)this.tpScraperDescription, (Property)jTextPaneBeanProperty);
        autoBinding_23.bind();
        BeanProperty movieSettingsBeanProperty = BeanProperty.create((String)"imageScraperLanguage");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty, this.cbScraperLanguage, (Property)jComboBoxBeanProperty);
        autoBinding.bind();
    }
}

