/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.settings;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.movies.MovieScraper;
import org.tinymediamanager.ui.panels.MediaScraperConfigurationPanel;
import org.tinymediamanager.ui.panels.ScrollablePanel;

class MovieScraperSettingsPanel
extends JPanel {
    private static final long serialVersionUID = -299825914193235308L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private MovieSettings settings = MovieModuleManager.SETTINGS;
    private List<MovieScraper> scrapers = ObservableCollections.observableList(new ArrayList());
    private JPanel panelScraperOptions;
    private JTextPane tpScraperDescription;
    private TmmTable tableScraper;

    MovieScraperSettingsPanel() {
        MediaScraper defaultMediaScraper = MovieList.getInstance().getDefaultMediaScraper();
        int selectedIndex = 0;
        for (MediaScraper mediaScraper : MovieList.getInstance().getAvailableMediaScrapers()) {
            MovieScraper movieScraper = new MovieScraper(mediaScraper);
            this.scrapers.add(movieScraper);
        }
        Collections.sort(this.scrapers);
        for (int i = 0; i < this.scrapers.size(); ++i) {
            MovieScraper movieScraper = this.scrapers.get(i);
            if (!movieScraper.getMediaScraper().equals(defaultMediaScraper)) continue;
            movieScraper.setDefaultScraper(true);
            selectedIndex = i;
            break;
        }
        this.initComponents();
        this.initDataBindings();
        Font font = UIManager.getFont("Label.font");
        Color color = UIManager.getColor("Label.foreground");
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; color: rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "); }";
        ((HTMLDocument)this.tpScraperDescription.getDocument()).getStyleSheet().addRule(bodyRule);
        TableColumnResizer.setMaxWidthForColumn(this.tableScraper, 0, 2);
        TableColumnResizer.setMaxWidthForColumn(this.tableScraper, 1, 2);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableScraper, 5);
        this.tableScraper.getModel().addTableModelListener(arg0 -> {
            int row;
            MovieScraper changedScraper;
            if (arg0.getColumn() == 0 && (changedScraper = this.scrapers.get(row = arg0.getFirstRow())).getDefaultScraper().booleanValue()) {
                this.settings.setMovieScraper(changedScraper.getScraperId());
                for (MovieScraper scraper : this.scrapers) {
                    if (scraper == changedScraper) continue;
                    scraper.setDefaultScraper(Boolean.FALSE);
                }
            }
        });
        this.tableScraper.getSelectionModel().addListSelectionListener(e -> {
            int index = this.tableScraper.convertRowIndexToModel(this.tableScraper.getSelectedRow());
            if (index > -1) {
                this.panelScraperOptions.removeAll();
                if (this.scrapers.get(index).getMediaProvider().getProviderInfo().getConfig().hasConfig()) {
                    this.panelScraperOptions.add(new MediaScraperConfigurationPanel(this.scrapers.get(index).getMediaProvider()));
                }
                this.panelScraperOptions.revalidate();
            }
        });
        if (!this.scrapers.isEmpty()) {
            this.tableScraper.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[400lp,grow]", "[400lp,grow]"));
        JPanel panelScraper = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][grow]", "[][shrink 0][150lp:600lp,grow]"));
        TmmLabel lblScraper = new TmmLabel(BUNDLE.getString("scraper.metadata"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelScraper, lblScraper, true);
        this.add((Component)collapsiblePanel, "cell 0 0,wmin 0,grow");
        this.tableScraper = new TmmTable();
        this.tableScraper.setRowHeight(29);
        this.tableScraper.setShowGrid(true);
        panelScraper.add((Component)this.tableScraper, "cell 1 0,grow");
        JSeparator separator = new JSeparator();
        panelScraper.add((Component)separator, "cell 1 1,growx");
        JScrollPane scrollPaneScraperDetails = new JScrollPane();
        panelScraper.add((Component)scrollPaneScraperDetails, "cell 1 2,grow");
        scrollPaneScraperDetails.setHorizontalScrollBarPolicy(31);
        scrollPaneScraperDetails.setVerticalScrollBarPolicy(20);
        scrollPaneScraperDetails.setBorder(null);
        ScrollablePanel panelScraperDetails = new ScrollablePanel();
        scrollPaneScraperDetails.setViewportView(panelScraperDetails);
        panelScraperDetails.setLayout((LayoutManager)new MigLayout("insets 0", "[grow]", "[][grow]"));
        this.tpScraperDescription = new JTextPane();
        this.tpScraperDescription.setOpaque(false);
        this.tpScraperDescription.setEditorKit(new HTMLEditorKit());
        panelScraperDetails.add((Component)this.tpScraperDescription, "cell 0 0,grow");
        this.panelScraperOptions = new JPanel();
        this.panelScraperOptions.setLayout(new FlowLayout(0));
        panelScraperDetails.add((Component)this.panelScraperOptions, "cell 0 1,grow");
    }

    protected void initDataBindings() {
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.scrapers, (JTable)this.tableScraper);
        BeanProperty movieScraperBeanProperty = BeanProperty.create((String)"defaultScraper");
        jTableBinding.addColumnBinding((Property)movieScraperBeanProperty).setColumnName("Default").setColumnClass(Boolean.class);
        BeanProperty movieScraperBeanProperty_1 = BeanProperty.create((String)"scraperLogo");
        jTableBinding.addColumnBinding((Property)movieScraperBeanProperty_1).setColumnName("Logo").setColumnClass(Icon.class);
        BeanProperty movieScraperBeanProperty_2 = BeanProperty.create((String)"scraperName");
        jTableBinding.addColumnBinding((Property)movieScraperBeanProperty_2).setColumnName("Name").setEditable(false);
        jTableBinding.bind();
        BeanProperty jTableBeanProperty = BeanProperty.create((String)"selectedElement.scraperDescription");
        BeanProperty jTextPaneBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_12 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tableScraper, (Property)jTableBeanProperty, (Object)this.tpScraperDescription, (Property)jTextPaneBeanProperty);
        autoBinding_12.bind();
    }
}

