/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.dialogs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.exceptions.UnsupportedMediaTypeException;
import org.tinymediamanager.scraper.mediaprovider.IMovieSetMetadataProvider;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.MainTabbedPane;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.dialogs.ImageChooserDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class MovieSetEditorDialog
extends TmmDialog {
    private static final long serialVersionUID = -4446433759280691976L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSetEditorDialog.class);
    private static final String ORIGINAL_IMAGE_SIZE = "originalImageSize";
    private MovieList movieList = MovieList.getInstance();
    private MovieSet movieSetToEdit;
    private List<Movie> moviesInSet = ObservableCollections.observableList(new ArrayList());
    private List<Movie> removedMovies = new ArrayList<Movie>();
    private List<MediaScraper> artworkScrapers = new ArrayList<MediaScraper>();
    private boolean continueQueue = true;
    private boolean navigateBack = false;
    private int queueIndex;
    private int queueSize;
    private JTextField tfName;
    private JTable tableMovies;
    private ImageLabel lblPoster;
    private ImageLabel lblFanart;
    private JTextPane tpOverview;
    private JTextField tfTmdbId;
    private ImageLabel lblLogo;
    private ImageLabel lblClearlogo;
    private ImageLabel lblBanner;
    private ImageLabel lblClearart;
    private LinkLabel lblLogoSize = new LinkLabel();
    private LinkLabel lblClearlogoSize = new LinkLabel();
    private LinkLabel lblBannerSize = new LinkLabel();
    private LinkLabel lblClearartSize = new LinkLabel();
    private LinkLabel lblPosterSize = new LinkLabel();
    private LinkLabel lblFanartSize = new LinkLabel();

    public MovieSetEditorDialog(MovieSet movieSet, int queueIndex, int queueSize) {
        super(BUNDLE.getString("movieset.edit") + (queueSize > 1 ? " " + (queueIndex + 1) + "/" + queueSize : ""), "movieSetEditor");
        this.movieSetToEdit = movieSet;
        this.queueIndex = queueIndex;
        this.queueSize = queueSize;
        try {
            ArrayList<String> enabledScrapers = new ArrayList<String>();
            if (MovieModuleManager.SETTINGS.getArtworkScrapers().contains("tmdb")) {
                enabledScrapers.add("tmdb");
            }
            if (MovieModuleManager.SETTINGS.getArtworkScrapers().contains("fanarttv")) {
                enabledScrapers.add("fanarttv");
            }
            this.artworkScrapers.addAll(this.movieList.getArtworkScrapers(enabledScrapers));
        }
        catch (Exception e2) {
            LOGGER.warn("error getting IMediaArtworkProvider - {}", (Object)e2.getMessage());
        }
        MainTabbedPane tabbedPane = new MainTabbedPane(){
            private static final long serialVersionUID = 71548865608767532L;

            @Override
            public void updateUI() {
                this.putClientProperty("bottomBorder", Boolean.FALSE);
                super.updateUI();
            }
        };
        this.getContentPane().add((Component)tabbedPane, "Center");
        JPanel panelContent = new JPanel();
        tabbedPane.addTab(BUNDLE.getString("metatag.details"), panelContent);
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][400lp,grow 200][150lp:200lp,grow 50]", "[][][150lp:200lp,grow][20lp:n][][][100lp:150lp,grow]"));
        TmmLabel lblName = new TmmLabel(BUNDLE.getString("movieset.title"));
        panelContent.add((Component)lblName, "cell 0 0,alignx right");
        this.tfName = new JTextField();
        panelContent.add((Component)this.tfName, "cell 1 0,growx,aligny top");
        this.tfName.setColumns(10);
        this.lblPoster = new ImageLabel();
        this.lblPoster.setCursor(Cursor.getPredefinedCursor(12));
        this.lblPoster.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int tmdbId = 0;
                try {
                    tmdbId = Integer.parseInt(MovieSetEditorDialog.this.tfTmdbId.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                HashMap<String, Object> ids = new HashMap<String, Object>(MovieSetEditorDialog.this.movieSetToEdit.getIds());
                ids.put("tmdb", tmdbId);
                ImageChooserDialog dialog = new ImageChooserDialog(MovieSetEditorDialog.this, ids, ImageChooserDialog.ImageType.POSTER, MovieSetEditorDialog.this.artworkScrapers, MovieSetEditorDialog.this.lblPoster, null, null, MediaType.MOVIE_SET);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        panelContent.add((Component)new TmmLabel(BUNDLE.getString("mediafiletype.poster")), "cell 2 0");
        panelContent.add((Component)this.lblPosterSize, "cell 2 0");
        panelContent.add((Component)this.lblPoster, "cell 2 1 1 4,grow");
        this.lblPoster.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(this.lblPosterSize, this.lblPoster, MediaFileType.POSTER));
        TmmLabel lblTmdbid = new TmmLabel(BUNDLE.getString("metatag.tmdb"));
        panelContent.add((Component)lblTmdbid, "cell 0 1,alignx right");
        this.tfTmdbId = new JTextField();
        panelContent.add((Component)this.tfTmdbId, "flowx,cell 1 1,aligny center");
        this.tfTmdbId.setColumns(10);
        TmmLabel lblOverview = new TmmLabel(BUNDLE.getString("metatag.plot"));
        panelContent.add((Component)lblOverview, "cell 0 2,alignx right,aligny top");
        JScrollPane scrollPaneOverview = new JScrollPane();
        panelContent.add((Component)scrollPaneOverview, "cell 1 2,grow");
        this.tpOverview = new JTextPane();
        this.tpOverview.setForeground(UIManager.getColor("TextField.foreground"));
        scrollPaneOverview.setViewportView(this.tpOverview);
        TmmLabel lblMovies = new TmmLabel(BUNDLE.getString("tmm.movies"));
        panelContent.add((Component)lblMovies, "flowy,cell 0 4,alignx right,aligny top");
        JScrollPane scrollPaneMovies = new JScrollPane();
        panelContent.add((Component)scrollPaneMovies, "cell 1 4 1 3,grow");
        this.tableMovies = new TmmTable();
        scrollPaneMovies.setViewportView(this.tableMovies);
        this.lblFanart = new ImageLabel();
        this.lblFanart.setCursor(Cursor.getPredefinedCursor(12));
        this.lblFanart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int tmdbId = 0;
                try {
                    tmdbId = Integer.parseInt(MovieSetEditorDialog.this.tfTmdbId.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                HashMap<String, Object> ids = new HashMap<String, Object>(MovieSetEditorDialog.this.movieSetToEdit.getIds());
                ids.put("tmdb", tmdbId);
                ImageChooserDialog dialog = new ImageChooserDialog(MovieSetEditorDialog.this, ids, ImageChooserDialog.ImageType.FANART, MovieSetEditorDialog.this.artworkScrapers, MovieSetEditorDialog.this.lblFanart, null, null, MediaType.MOVIE_SET);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        panelContent.add((Component)new TmmLabel(BUNDLE.getString("mediafiletype.fanart")), "cell 2 5");
        panelContent.add((Component)this.lblFanartSize, "cell 2 5");
        panelContent.add((Component)this.lblFanart, "cell 2 6,grow");
        this.lblFanart.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(this.lblFanartSize, this.lblFanart, MediaFileType.FANART));
        JButton btnSearchTmdbId = new JButton("");
        btnSearchTmdbId.setAction(new SearchIdAction());
        panelContent.add((Component)btnSearchTmdbId, "cell 1 1");
        JButton btnRemoveMovie = new JButton("");
        btnRemoveMovie.setAction(new RemoveMovieAction());
        panelContent.add((Component)btnRemoveMovie, "cell 0 4,alignx right,aligny top");
        JPanel artworkPanel = new JPanel();
        tabbedPane.addTab(BUNDLE.getString("metatag.extraartwork"), null, artworkPanel, null);
        artworkPanel.setLayout((LayoutManager)new MigLayout("", "[200lp:300lp,grow][200lp:300lp,grow]", "[][100lp:125lp,grow][20lp:n][][100lp:125lp,grow][20lp:n][][100lp:150lp,grow]"));
        TmmLabel lblLogoT = new TmmLabel(BUNDLE.getString("mediafiletype.logo"));
        artworkPanel.add((Component)lblLogoT, "cell 0 0");
        artworkPanel.add((Component)this.lblLogoSize, "cell 0 0");
        this.lblLogo = new ImageLabel();
        this.lblLogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieSetEditorDialog.this, new HashMap<String, Object>(MovieSetEditorDialog.this.movieSetToEdit.getIds()), ImageChooserDialog.ImageType.LOGO, MovieSetEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieSetEditorDialog.this.lblLogo, null, null, MediaType.MOVIE);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        TmmLabel lblClearlogoT = new TmmLabel(BUNDLE.getString("mediafiletype.clearlogo"));
        artworkPanel.add((Component)lblClearlogoT, "cell 1 0");
        artworkPanel.add((Component)this.lblClearlogoSize, "cell 1 0");
        this.lblLogo.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblLogo, "cell 0 1,grow");
        this.lblLogo.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(this.lblLogoSize, this.lblLogo, MediaFileType.LOGO));
        this.lblClearlogo = new ImageLabel();
        this.lblClearlogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieSetEditorDialog.this, new HashMap<String, Object>(MovieSetEditorDialog.this.movieSetToEdit.getIds()), ImageChooserDialog.ImageType.CLEARLOGO, MovieSetEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieSetEditorDialog.this.lblClearlogo, null, null, MediaType.MOVIE);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        this.lblClearlogo.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblClearlogo, "cell 1 1,grow");
        this.lblClearlogo.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(this.lblClearlogoSize, this.lblClearlogo, MediaFileType.CLEARLOGO));
        TmmLabel lblBannerT = new TmmLabel(BUNDLE.getString("mediafiletype.banner"));
        artworkPanel.add((Component)lblBannerT, "cell 0 3");
        artworkPanel.add((Component)this.lblBannerSize, "cell 0 3");
        this.lblBanner = new ImageLabel();
        this.lblBanner.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieSetEditorDialog.this, new HashMap<String, Object>(MovieSetEditorDialog.this.movieSetToEdit.getIds()), ImageChooserDialog.ImageType.BANNER, MovieSetEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieSetEditorDialog.this.lblBanner, null, null, MediaType.MOVIE);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        this.lblBanner.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblBanner, "cell 0 4 2 1,grow");
        this.lblBanner.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(this.lblBannerSize, this.lblBanner, MediaFileType.BANNER));
        this.lblBanner.setImagePath(this.movieSetToEdit.getArtworkFilename(MediaFileType.BANNER));
        TmmLabel lblClearartT = new TmmLabel(BUNDLE.getString("mediafiletype.clearart"));
        artworkPanel.add((Component)lblClearartT, "cell 0 6");
        artworkPanel.add((Component)this.lblClearartSize, "cell 0 6");
        this.lblClearart = new ImageLabel();
        this.lblClearart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieSetEditorDialog.this, new HashMap<String, Object>(MovieSetEditorDialog.this.movieSetToEdit.getIds()), ImageChooserDialog.ImageType.CLEARART, MovieSetEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieSetEditorDialog.this.lblClearart, null, null, MediaType.MOVIE);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        this.lblClearart.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblClearart, "cell 0 7,grow");
        this.lblClearart.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(this.lblClearartSize, this.lblClearart, MediaFileType.CLEARART));
        if (queueSize > 1) {
            JButton btnAbort = new JButton(new AbortAction());
            this.addButton(btnAbort);
            if (queueIndex > 0) {
                JButton backButton = new JButton(new NavigateBackAction());
                this.addButton(backButton);
            }
        }
        JButton btnCancel = new JButton(new CancelAction());
        this.addButton(btnCancel);
        JButton btnOk = new JButton(new OkAction());
        this.addDefaultButton(btnOk);
        this.tfName.setText(this.movieSetToEdit.getTitle());
        this.tfTmdbId.setText(String.valueOf(this.movieSetToEdit.getTmdbId()));
        this.tpOverview.setText(this.movieSetToEdit.getPlot());
        this.moviesInSet.addAll(this.movieSetToEdit.getMovies());
        if (StringUtils.isNotBlank((CharSequence)this.movieSetToEdit.getArtworkFilename(MediaFileType.POSTER))) {
            this.lblPoster.setImagePath(this.movieSetToEdit.getArtworkFilename(MediaFileType.POSTER));
        } else {
            this.lblPoster.setImageUrl(this.movieSetToEdit.getArtworkUrl(MediaFileType.POSTER));
        }
        if (StringUtils.isNotBlank((CharSequence)this.movieSetToEdit.getArtworkFilename(MediaFileType.FANART))) {
            this.lblFanart.setImagePath(this.movieSetToEdit.getArtworkFilename(MediaFileType.FANART));
        } else {
            this.lblFanart.setImageUrl(this.movieSetToEdit.getArtworkUrl(MediaFileType.FANART));
        }
        this.lblLogo.setImagePath(this.movieSetToEdit.getArtworkFilename(MediaFileType.LOGO));
        this.lblClearlogo.setImagePath(this.movieSetToEdit.getArtworkFilename(MediaFileType.CLEARLOGO));
        this.lblClearart.setImagePath(this.movieSetToEdit.getArtworkFilename(MediaFileType.CLEARART));
        this.bindingGroup = this.initDataBindings();
        this.tableMovies.getTableHeader().getColumnModel().getColumn(0).setHeaderValue(BUNDLE.getString("metatag.name"));
        int width = this.tableMovies.getFontMetrics(this.tableMovies.getFont()).stringWidth(" 2000");
        int titleWidth = this.tableMovies.getFontMetrics(this.tableMovies.getFont()).stringWidth(BUNDLE.getString("metatag.year"));
        if (titleWidth > width) {
            width = titleWidth;
        }
        this.tableMovies.getTableHeader().getColumnModel().getColumn(1).setPreferredWidth(width);
        this.tableMovies.getTableHeader().getColumnModel().getColumn(1).setMinWidth(width);
        this.tableMovies.getTableHeader().getColumnModel().getColumn(1).setMaxWidth((int)((double)width * 1.5));
        this.tableMovies.getTableHeader().getColumnModel().getColumn(1).setHeaderValue(BUNDLE.getString("metatag.year"));
        this.tableMovies.getTableHeader().getColumnModel().getColumn(2).setPreferredWidth(70);
        this.tableMovies.getTableHeader().getColumnModel().getColumn(2).setMinWidth(70);
        this.tableMovies.getTableHeader().getColumnModel().getColumn(2).setMaxWidth(85);
        this.tableMovies.getTableHeader().getColumnModel().getColumn(2).setHeaderValue(BUNDLE.getString("metatag.watched"));
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.continueQueue;
    }

    public boolean isContinueQueue() {
        return this.continueQueue;
    }

    public boolean isNavigateBack() {
        return this.navigateBack;
    }

    protected BindingGroup initDataBindings() {
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.moviesInSet, (JTable)this.tableMovies);
        BeanProperty movieBeanProperty = BeanProperty.create((String)"title");
        jTableBinding.addColumnBinding((Property)movieBeanProperty).setEditable(false);
        BeanProperty movieBeanProperty_1 = BeanProperty.create((String)"year");
        jTableBinding.addColumnBinding((Property)movieBeanProperty_1).setEditable(false);
        BeanProperty movieBeanProperty_2 = BeanProperty.create((String)"watched");
        jTableBinding.addColumnBinding((Property)movieBeanProperty_2).setEditable(false).setColumnClass(Boolean.class);
        jTableBinding.setEditable(false);
        jTableBinding.bind();
        BindingGroup bindingGroup = new BindingGroup();
        bindingGroup.addBinding((Binding)jTableBinding);
        return bindingGroup;
    }

    private void setImageSizeAndCreateLink(LinkLabel lblSize, ImageLabel imageLabel, MediaFileType type) {
        TmmUIHelper.createLinkForImage(lblSize, imageLabel);
        Dimension dimension = this.movieSetToEdit.getArtworkDimension(type);
        if (dimension.width == 0 && dimension.height == 0) {
            lblSize.setText(imageLabel.getOriginalImageSize().width + "x" + imageLabel.getOriginalImageSize().height);
        } else {
            lblSize.setText(dimension.width + "x" + dimension.height);
        }
    }

    private class SearchIdAction
    extends AbstractAction {
        private static final long serialVersionUID = -8980803676368394987L;

        SearchIdAction() {
            this.putValue("Name", BUNDLE.getString("movieset.tmdb.find"));
            this.putValue("ShortDescription", BUNDLE.getString("movieset.tmdb.desc"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block7: {
                try {
                    List<MediaScraper> sets = MediaScraper.getMediaScrapers(ScraperType.MOVIE_SET);
                    if (sets == null || sets.size() <= 0) break block7;
                    MediaScraper first = sets.get(0);
                    IMovieSetMetadataProvider mp = (IMovieSetMetadataProvider)first.getMediaProvider();
                    for (Movie movie : MovieSetEditorDialog.this.moviesInSet) {
                        MediaScrapeOptions options = new MediaScrapeOptions(MediaType.MOVIE);
                        if (!Utils.isValidImdbId(movie.getImdbId()) && movie.getTmdbId() <= 0) continue;
                        options.setTmdbId(movie.getTmdbId());
                        options.setImdbId(movie.getImdbId());
                        options.setLanguage(MovieModuleManager.SETTINGS.getScraperLanguage().toLocale());
                        options.setCountry(MovieModuleManager.SETTINGS.getCertificationCountry());
                        try {
                            MediaMetadata md = mp.getMetadata(options);
                            if ((Integer)md.getId("tmdbSet") <= 0) continue;
                            MovieSetEditorDialog.this.tfTmdbId.setText(String.valueOf(md.getId("tmdbSet")));
                            break;
                        }
                        catch (ScrapeException ex) {
                            LOGGER.error("getMetadata", (Throwable)ex);
                            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"MovieSetChooser", "message.scrape.metadatamoviesetfailed", new String[]{":", ex.getLocalizedMessage()}));
                        }
                        catch (MissingIdException ex) {
                            LOGGER.warn("missing id for scrape");
                            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "MovieSetChooser", "scraper.error.missingid"));
                        }
                        catch (UnsupportedMediaTypeException ignored) {
                            LOGGER.warn("unsupported media type: " + mp.getProviderInfo().getId());
                        }
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, BUNDLE.getString("movieset.tmdb.error"));
                }
            }
        }
    }

    private class NavigateBackAction
    extends AbstractAction {
        private static final long serialVersionUID = -1652218154720642310L;

        public NavigateBackAction() {
            this.putValue("Name", BUNDLE.getString("Button.back"));
            this.putValue("SmallIcon", IconManager.BACK_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieSetEditorDialog.this.navigateBack = true;
            MovieSetEditorDialog.this.setVisible(false);
        }
    }

    private class AbortAction
    extends AbstractAction {
        private static final long serialVersionUID = 1215596133205394653L;

        AbortAction() {
            this.putValue("Name", BUNDLE.getString("Button.abortqueue"));
            this.putValue("ShortDescription", BUNDLE.getString("Button.abortqueue"));
            this.putValue("SmallIcon", IconManager.STOP_INV);
            this.putValue("SwingLargeIconKey", IconManager.STOP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieSetEditorDialog.this.continueQueue = false;
            MovieSetEditorDialog.this.setVisible(false);
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = -6214112833170817002L;

        CancelAction() {
            this.putValue("Name", BUNDLE.getString("Button.cancel"));
            this.putValue("ShortDescription", BUNDLE.getString("edit.discard"));
            this.putValue("SmallIcon", IconManager.CANCEL_INV);
            this.putValue("SwingLargeIconKey", IconManager.CANCEL_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieSetEditorDialog.this.setVisible(false);
        }
    }

    private class OkAction
    extends AbstractAction {
        private static final long serialVersionUID = -7322270015667230646L;

        OkAction() {
            this.putValue("Name", BUNDLE.getString("Button.save"));
            this.putValue("ShortDescription", BUNDLE.getString("Button.save"));
            this.putValue("SmallIcon", IconManager.APPLY_INV);
            this.putValue("SwingLargeIconKey", IconManager.APPLY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieSetEditorDialog.this.movieSetToEdit.setTitle(MovieSetEditorDialog.this.tfName.getText());
            MovieSetEditorDialog.this.movieSetToEdit.setPlot(MovieSetEditorDialog.this.tpOverview.getText());
            if (StringUtils.isNotEmpty((CharSequence)MovieSetEditorDialog.this.lblPoster.getImageUrl()) && !MovieSetEditorDialog.this.lblPoster.getImageUrl().equals(MovieSetEditorDialog.this.movieSetToEdit.getArtworkUrl(MediaFileType.POSTER))) {
                MovieSetEditorDialog.this.movieSetToEdit.setArtworkUrl(MovieSetEditorDialog.this.lblPoster.getImageUrl(), MediaFileType.POSTER);
            }
            if (StringUtils.isNotEmpty((CharSequence)MovieSetEditorDialog.this.lblFanart.getImageUrl()) && !MovieSetEditorDialog.this.lblFanart.getImageUrl().equals(MovieSetEditorDialog.this.movieSetToEdit.getArtworkUrl(MediaFileType.FANART))) {
                MovieSetEditorDialog.this.movieSetToEdit.setArtworkUrl(MovieSetEditorDialog.this.lblFanart.getImageUrl(), MediaFileType.FANART);
            }
            if (!StringUtils.isEmpty((CharSequence)MovieSetEditorDialog.this.lblLogo.getImageUrl()) && !MovieSetEditorDialog.this.lblLogo.getImageUrl().equals(MovieSetEditorDialog.this.movieSetToEdit.getArtworkUrl(MediaFileType.LOGO))) {
                MovieSetEditorDialog.this.movieSetToEdit.setArtworkUrl(MovieSetEditorDialog.this.lblLogo.getImageUrl(), MediaFileType.LOGO);
            }
            if (!StringUtils.isEmpty((CharSequence)MovieSetEditorDialog.this.lblClearlogo.getImageUrl()) && !MovieSetEditorDialog.this.lblClearlogo.getImageUrl().equals(MovieSetEditorDialog.this.movieSetToEdit.getArtworkUrl(MediaFileType.CLEARLOGO))) {
                MovieSetEditorDialog.this.movieSetToEdit.setArtworkUrl(MovieSetEditorDialog.this.lblClearlogo.getImageUrl(), MediaFileType.CLEARLOGO);
            }
            if (!StringUtils.isEmpty((CharSequence)MovieSetEditorDialog.this.lblBanner.getImageUrl()) && !MovieSetEditorDialog.this.lblBanner.getImageUrl().equals(MovieSetEditorDialog.this.movieSetToEdit.getArtworkUrl(MediaFileType.BANNER))) {
                MovieSetEditorDialog.this.movieSetToEdit.setArtworkUrl(MovieSetEditorDialog.this.lblBanner.getImageUrl(), MediaFileType.BANNER);
            }
            if (!StringUtils.isEmpty((CharSequence)MovieSetEditorDialog.this.lblClearart.getImageUrl()) && !MovieSetEditorDialog.this.lblClearart.getImageUrl().equals(MovieSetEditorDialog.this.movieSetToEdit.getArtworkUrl(MediaFileType.CLEARART))) {
                MovieSetEditorDialog.this.movieSetToEdit.setArtworkUrl(MovieSetEditorDialog.this.lblClearart.getImageUrl(), MediaFileType.CLEARART);
            }
            for (int i = MovieSetEditorDialog.this.movieSetToEdit.getMovies().size() - 1; i >= 0; --i) {
                Movie movie = MovieSetEditorDialog.this.movieSetToEdit.getMovies().get(i);
                if (MovieSetEditorDialog.this.moviesInSet.contains(movie)) continue;
                movie.setMovieSet(null);
                movie.writeNFO();
                movie.saveToDb();
                MovieSetEditorDialog.this.movieSetToEdit.removeMovie(movie, true);
            }
            for (Movie movie : MovieSetEditorDialog.this.moviesInSet) {
                movie.saveToDb();
            }
            for (Movie movie : MovieSetEditorDialog.this.removedMovies) {
                movie.removeFromMovieSet();
                movie.saveToDb();
                movie.writeNFO();
                MovieSetEditorDialog.this.movieSetToEdit.removeMovie(movie, true);
            }
            MovieList.getInstance().sortMoviesInMovieSet(MovieSetEditorDialog.this.movieSetToEdit);
            for (Movie movie : MovieSetEditorDialog.this.moviesInSet) {
                movie.writeNFO();
            }
            int tmdbId = 0;
            try {
                tmdbId = Integer.parseInt(MovieSetEditorDialog.this.tfTmdbId.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            MovieSetEditorDialog.this.movieSetToEdit.setTmdbId(tmdbId);
            MovieSetEditorDialog.this.movieSetToEdit.saveToDb();
            MovieSetEditorDialog.this.setVisible(false);
        }
    }

    private class RemoveMovieAction
    extends AbstractAction {
        private static final long serialVersionUID = 8013039811395731218L;

        RemoveMovieAction() {
            this.putValue("SwingLargeIconKey", IconManager.REMOVE_INV);
            this.putValue("ShortDescription", BUNDLE.getString("movieset.movie.remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MovieSetEditorDialog.this.moviesInSet.isEmpty()) {
                return;
            }
            int row = MovieSetEditorDialog.this.tableMovies.getSelectedRow();
            if (row > -1) {
                Movie movie = (Movie)MovieSetEditorDialog.this.moviesInSet.get(row);
                MovieSetEditorDialog.this.moviesInSet.remove(row);
                MovieSetEditorDialog.this.removedMovies.add(movie);
            }
        }
    }
}

