/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.Globals;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmWindowSaver;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.MainTabbedPane;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.components.treetable.TmmTreeTable;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.moviesets.filters.IMovieSetUIFilter;
import org.tinymediamanager.ui.moviesets.filters.MovieSetDatasourceFilter;
import org.tinymediamanager.ui.moviesets.filters.MovieSetNewMoviesFilter;
import org.tinymediamanager.ui.moviesets.filters.MovieSetWithMoreThanOneMovieFilter;

public class MovieSetFilterDialog
extends TmmDialog {
    private static final long serialVersionUID = 5003714573168481816L;
    protected static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final float FONT_SIZE = Math.round((double)Globals.settings.getFontSize() * 0.916);
    private final TmmTreeTable treeTable;
    private final Map<JPanel, Set<IMovieSetUIFilter>> filterMap;
    private JTabbedPane tabbedPane;

    public MovieSetFilterDialog(TmmTreeTable treeTable) {
        super(BUNDLE.getString("movieextendedsearch.options"), "movieSetFilter");
        this.setModalityType(Dialog.ModalityType.MODELESS);
        this.treeTable = treeTable;
        this.filterMap = new HashMap<JPanel, Set<IMovieSetUIFilter>>();
        this.treeTable.addPropertyChangeListener("filterChanged", evt -> this.filterChanged());
        this.tabbedPane = new MainTabbedPane(){
            private static final long serialVersionUID = 9041548865608767661L;

            @Override
            public void updateUI() {
                this.putClientProperty("leftBorder", "half");
                this.putClientProperty("rightBorder", "half");
                this.putClientProperty("bottomBorder", Boolean.FALSE);
                super.updateUI();
            }
        };
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        JPanel panelMain = new JPanel((LayoutManager)new MigLayout("", "[][][100lp:n,grow]", "[]"));
        JScrollPane scrollPaneMain = new JScrollPane(panelMain);
        scrollPaneMain.setHorizontalScrollBarPolicy(31);
        this.tabbedPane.addTab(BUNDLE.getString("metatag.details"), scrollPaneMain);
        panelMain.add((Component)new TmmLabel(BUNDLE.getString("movieextendedsearch.filterby")), "cell 0 0 3 1, growx, aligny top, wrap");
        this.addFilter(new MovieSetNewMoviesFilter(), panelMain);
        this.addFilter(new MovieSetWithMoreThanOneMovieFilter(), panelMain);
        this.addFilter(new MovieSetDatasourceFilter(), panelMain);
    }

    private void addFilter(IMovieSetUIFilter<TmmTreeNode> filter, JPanel panel) {
        panel.add((Component)filter.getCheckBox(), "");
        panel.add((Component)filter.getLabel(), "right");
        if (filter.getFilterComponent() != null) {
            panel.add((Component)filter.getFilterComponent(), "wmin 100, grow, wrap");
        } else {
            panel.add(Box.createGlue(), "wrap");
        }
        Set filters = this.filterMap.computeIfAbsent(panel, k -> new HashSet());
        filters.add(filter);
        this.treeTable.addFilter(filter);
    }

    private void filterChanged() {
        block3: for (Map.Entry<JPanel, Set<IMovieSetUIFilter>> entry : this.filterMap.entrySet()) {
            boolean active = false;
            for (IMovieSetUIFilter filter : entry.getValue()) {
                switch (filter.getFilterState()) {
                    case ACTIVE: 
                    case ACTIVE_NEGATIVE: {
                        active = true;
                        break;
                    }
                }
                if (!active) continue;
                break;
            }
            for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                if (!SwingUtilities.isDescendingFrom(entry.getKey(), this.tabbedPane.getComponentAt(i))) continue;
                if (active) {
                    this.tabbedPane.setIconAt(i, IconManager.FILTER_ACTIVE);
                    continue block3;
                }
                this.tabbedPane.setIconAt(i, null);
                continue block3;
            }
        }
    }

    @Override
    protected void initBottomPanel() {
    }

    @Override
    public void dispose() {
        TmmWindowSaver.getInstance().saveSettings(this);
    }
}

