/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.nio.file.Path;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.ImageUtils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.WrapLayout;

public class ImagePanel
extends JPanel
implements HierarchyListener {
    private static final long serialVersionUID = -5344085698387374260L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ImagePanel.class);
    protected int maxWidth = 300;
    protected int maxHeight = 100;
    private List<MediaFile> mediaFiles = null;
    private ImageLoader activeWorker = null;
    private JPanel panelImages;
    private JScrollPane scrollPane;

    public ImagePanel(List<MediaFile> mediaFiles) {
        this.mediaFiles = mediaFiles;
        this.setLayout((LayoutManager)new MigLayout("", "[400lp,grow]", "[300lp,grow]"));
        this.scrollPane = new JScrollPane();
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.add((Component)this.scrollPane, "cell 0 0,grow");
        this.panelImages = new JPanel();
        this.panelImages.setLayout(new WrapLayout(0));
        this.scrollPane.setViewportView(this.panelImages);
    }

    public void rebuildPanel() {
        if (this.activeWorker != null && !this.activeWorker.isDone()) {
            this.activeWorker.cancel(true);
        }
        this.panelImages.removeAll();
        this.panelImages.revalidate();
        this.scrollPane.repaint();
        this.activeWorker = new ImageLoader(this.mediaFiles);
        this.activeWorker.execute();
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    @Override
    public void hierarchyChanged(HierarchyEvent arg0) {
        if (this.isShowing() && this.panelImages.getComponents().length == 0 && this.mediaFiles.size() > 0) {
            this.rebuildPanel();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addHierarchyListener(this);
    }

    @Override
    public void removeNotify() {
        this.removeHierarchyListener(this);
        super.removeNotify();
    }

    private class ImageLabelClickListener
    implements MouseListener {
        private String pathToFile;

        private ImageLabelClickListener(String path) {
            this.pathToFile = path;
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (StringUtils.isNotBlank((CharSequence)this.pathToFile)) {
                MainWindow.getActiveInstance().createLightbox(this.pathToFile, "");
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    protected class ImageChunk {
        private String pathToImage;
        private BufferedImage image;

        private ImageChunk(String path, BufferedImage image) {
            this.pathToImage = path;
            this.image = image;
        }
    }

    protected class ImageLoader
    extends SwingWorker<Void, ImageChunk> {
        private List<MediaFile> mediaFiles;

        private ImageLoader(List<MediaFile> mediaFiles) {
            this.mediaFiles = mediaFiles;
        }

        @Override
        protected Void doInBackground() {
            for (MediaFile mediaFile : this.mediaFiles) {
                if (!ImagePanel.this.isShowing()) continue;
                if (this.isCancelled()) {
                    return null;
                }
                try {
                    Path file = ImageCache.getCachedFile(mediaFile);
                    if (file == null) {
                        file = mediaFile.getFileAsPath();
                    }
                    BufferedImage bufferedImage = ImageUtils.createImage(file);
                    Point size = ImageUtils.calculateSize(ImagePanel.this.maxWidth, ImagePanel.this.maxHeight, bufferedImage.getWidth(), bufferedImage.getHeight(), true);
                    BufferedImage img = Scalr.resize((BufferedImage)bufferedImage, (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)size.x, (int)size.y, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
                    bufferedImage = null;
                    if (this.isCancelled()) {
                        return null;
                    }
                    this.publish(new ImageChunk(mediaFile.getFileAsPath().toString(), img));
                    img = null;
                }
                catch (Exception e) {
                    LOGGER.trace("scaling image failed: {}", (Object)e.getMessage());
                }
            }
            return null;
        }

        @Override
        protected void process(List<ImageChunk> chunks) {
            for (ImageChunk chunk : chunks) {
                try {
                    if (this.isCancelled()) {
                        return;
                    }
                    JLabel lblImageJLabel = new JLabel(new ImageIcon(chunk.image));
                    lblImageJLabel.addMouseListener(new ImageLabelClickListener(chunk.pathToImage));
                    ImagePanel.this.panelImages.add(lblImageJLabel);
                    ImagePanel.this.panelImages.revalidate();
                    ImagePanel.this.scrollPane.repaint();
                }
                catch (Exception exception) {}
            }
        }
    }
}

