/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Comparator;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.table.TmmTable;

public abstract class MediaFilesPanel
extends JPanel {
    private static final long serialVersionUID = -4929581173434859034L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaFilesPanel.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private TmmTable tableFiles;
    private EventList<MediaFile> mediaFileEventList;

    public MediaFilesPanel(EventList<MediaFile> mediaFiles) {
        this.mediaFileEventList = mediaFiles;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("insets 0", "[450lp,grow]", "[300lp,grow]"));
        this.tableFiles = new TmmTable((TableModel)new DefaultEventTableModel((EventList)GlazedListsSwing.swingThreadProxyList(this.mediaFileEventList), (TableFormat)new MediaTableFormat()));
        this.tableFiles.setAutoResizeMode(0);
        LinkListener linkListener = new LinkListener();
        this.tableFiles.addMouseListener(linkListener);
        this.tableFiles.addMouseMotionListener(linkListener);
        JScrollPane scrollPaneFiles = new JScrollPane(this.tableFiles);
        this.tableFiles.configureScrollPane(scrollPaneFiles);
        this.add((Component)scrollPaneFiles, "cell 0 0,grow");
        scrollPaneFiles.setViewportView(this.tableFiles);
    }

    public void adjustColumns() {
        try {
            TableColumnResizer.adjustColumnPreferredWidths(this.tableFiles, 6);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract MediaEntity getMediaEntity();

    private class LinkListener
    implements MouseListener,
    MouseMotionListener {
        private LinkListener() {
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            int col = MediaFilesPanel.this.tableFiles.columnAtPoint(arg0.getPoint());
            if (col == 0) {
                int row = MediaFilesPanel.this.tableFiles.rowAtPoint(arg0.getPoint());
                row = MediaFilesPanel.this.tableFiles.convertRowIndexToModel(row);
                MediaFile mf = (MediaFile)MediaFilesPanel.this.mediaFileEventList.get(row);
                if (mf.isVideo()) {
                    try {
                        TmmUIHelper.openFile(mf.getFileAsPath());
                    }
                    catch (Exception e) {
                        LOGGER.error("open file", (Throwable)e);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)mf, "message.erroropenfile", new String[]{":", e.getLocalizedMessage()}));
                    }
                }
                if (mf.isGraphic()) {
                    MainWindow.getActiveInstance().createLightbox(mf.getFileAsPath().toString(), "");
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col == 0) {
                table.setCursor(new Cursor(12));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col != 0) {
                table.setCursor(new Cursor(0));
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col != 0 && table.getCursor().getType() == 12) {
                table.setCursor(new Cursor(0));
            }
            if (col == 0 && table.getCursor().getType() == 0) {
                table.setCursor(new Cursor(12));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent arg0) {
        }
    }

    private static class MediaTableFormat
    implements AdvancedTableFormat<MediaFile> {
        private MediaTableFormat() {
        }

        public int getColumnCount() {
            return 8;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "";
                }
                case 1: {
                    return BUNDLE.getString("metatag.filename");
                }
                case 2: {
                    return BUNDLE.getString("metatag.size");
                }
                case 3: {
                    return BUNDLE.getString("metatag.mediafiletype");
                }
                case 4: {
                    return BUNDLE.getString("metatag.codec");
                }
                case 5: {
                    return BUNDLE.getString("metatag.resolution");
                }
                case 6: {
                    return BUNDLE.getString("metatag.runtime");
                }
                case 7: {
                    return BUNDLE.getString("metatag.subtitle");
                }
            }
            throw new IllegalStateException();
        }

        public Object getColumnValue(MediaFile mediaFile, int column) {
            switch (column) {
                case 0: {
                    if (mediaFile.isVideo()) {
                        return IconManager.PLAY;
                    }
                    if (mediaFile.isGraphic()) {
                        return IconManager.SEARCH;
                    }
                    return null;
                }
                case 1: {
                    return mediaFile.getFilename();
                }
                case 2: {
                    return mediaFile.getFilesizeInMegabytes();
                }
                case 3: {
                    return this.getMediaFileTypeLocalized(mediaFile.getType());
                }
                case 4: {
                    return mediaFile.getCombinedCodecs();
                }
                case 5: {
                    return mediaFile.getVideoResolution();
                }
                case 6: {
                    return mediaFile.getDurationHMS();
                }
                case 7: {
                    return mediaFile.getSubtitlesAsString();
                }
            }
            throw new IllegalStateException();
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return ImageIcon.class;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return String.class;
                }
            }
            throw new IllegalStateException();
        }

        public Comparator getColumnComparator(int arg0) {
            return null;
        }

        private String getMediaFileTypeLocalized(MediaFileType type) {
            String prop = "mediafiletype." + type.name().toLowerCase(Locale.ROOT);
            return BUNDLE.getString(prop);
        }
    }
}

