/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.panels.MediaFilesPanel;

public abstract class MediaInformationPanel
extends JPanel {
    private static final long serialVersionUID = 2513029074142934502L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaInformationPanel.class);
    protected EventList<MediaFile> mediaFileEventList = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(MediaFile.class));
    protected EventList<AudioStreamContainer> audioStreamEventList = GlazedLists.threadSafeList((EventList)new BasicEventList());
    protected EventList<SubtitleContainer> subtitleEventList = GlazedLists.threadSafeList((EventList)new BasicEventList());
    protected JLabel lblRuntime;
    protected JCheckBox chckbxWatched;
    protected JLabel lblVideoCodec;
    protected JLabel lblVideoResolution;
    protected JLabel lblVideoBitrate;
    protected JLabel lblVideoBitDepth;
    protected JLabel lblFrameRate;
    protected JLabel lblSource;
    protected LinkLabel lblPath;
    protected JLabel lblDateAdded;
    protected MediaFilesPanel panelMediaFiles;

    public MediaInformationPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[][][100lp][20lp][][grow]", "[][][][][][][][][5lp!][50lp:75lp,grow][5lp!][50lp:75lp,grow][][][200lp,grow 300]"));
        TmmLabel lblMoviePathT = new TmmLabel(BUNDLE.getString("metatag.path"));
        this.add((Component)lblMoviePathT, "cell 0 0");
        this.lblPath = new LinkLabel("");
        this.lblPath.addActionListener(new LinkLabelListener());
        this.add((Component)this.lblPath, "cell 1 0 5 1,growx,wmin 0");
        TmmLabel lblDateAddedT = new TmmLabel(BUNDLE.getString("metatag.dateadded"));
        this.add((Component)lblDateAddedT, "cell 0 1");
        this.lblDateAdded = new JLabel("");
        this.add((Component)this.lblDateAdded, "cell 1 1");
        TmmLabel lblWatchedT = new TmmLabel(BUNDLE.getString("metatag.watched"));
        this.add((Component)lblWatchedT, "flowx,cell 4 1 2 1");
        this.chckbxWatched = new JCheckBox("");
        this.chckbxWatched.setEnabled(false);
        this.add((Component)this.chckbxWatched, "cell 4 1 2 1");
        this.add((Component)new JSeparator(), "cell 0 2 6 1,growx");
        TmmLabel lblVideoT = new TmmLabel(BUNDLE.getString("metatag.video"));
        this.add((Component)lblVideoT, "cell 0 3");
        TmmLabel lblSourceT = new TmmLabel(BUNDLE.getString("metatag.source"));
        this.add((Component)lblSourceT, "cell 1 3");
        this.lblSource = new JLabel("");
        this.add((Component)this.lblSource, "cell 2 3 3 1");
        TmmLabel lblRuntimeT = new TmmLabel(BUNDLE.getString("metatag.runtime"));
        this.add((Component)lblRuntimeT, "cell 1 4");
        this.lblRuntime = new JLabel("");
        this.add((Component)this.lblRuntime, "cell 2 4");
        TmmLabel lblCodecT = new TmmLabel(BUNDLE.getString("metatag.videocodec"));
        this.add((Component)lblCodecT, "cell 1 5");
        this.lblVideoCodec = new JLabel("");
        this.add((Component)this.lblVideoCodec, "cell 2 5");
        TmmLabel lblFrameRateT = new TmmLabel(BUNDLE.getString("metatag.framerate"));
        this.add((Component)lblFrameRateT, "cell 4 5");
        this.lblFrameRate = new JLabel("");
        this.add((Component)this.lblFrameRate, "cell 5 5");
        TmmLabel lblResolutionT = new TmmLabel(BUNDLE.getString("metatag.resolution"));
        this.add((Component)lblResolutionT, "cell 1 6");
        this.lblVideoResolution = new JLabel("");
        this.add((Component)this.lblVideoResolution, "cell 2 6");
        TmmLabel lblVideoBitrateT = new TmmLabel(BUNDLE.getString("metatag.videobitrate"));
        this.add((Component)lblVideoBitrateT, "cell 4 6");
        this.lblVideoBitrate = new JLabel("");
        this.add((Component)this.lblVideoBitrate, "cell 5 6");
        TmmLabel lblVideoBitDepthT = new TmmLabel(BUNDLE.getString("metatag.videobitdepth"));
        this.add((Component)lblVideoBitDepthT, "cell 1 7");
        this.lblVideoBitDepth = new JLabel("");
        this.add((Component)this.lblVideoBitDepth, "cell 2 7");
        TmmLabel lblAudioT = new TmmLabel(BUNDLE.getString("metatag.audio"));
        this.add((Component)lblAudioT, "cell 0 9,aligny top");
        TmmTable tableAudioStreams = new TmmTable((TableModel)new DefaultEventTableModel((EventList)GlazedListsSwing.swingThreadProxyList(this.audioStreamEventList), (TableFormat)new AudioStreamTableFormat()));
        tableAudioStreams.setAutoResizeMode(0);
        JScrollPane scrollPane = new JScrollPane(tableAudioStreams);
        tableAudioStreams.configureScrollPane(scrollPane);
        scrollPane.setVerticalScrollBarPolicy(20);
        this.add((Component)scrollPane, "cell 1 9 5 1,growx");
        TmmLabel lblSubtitle = new TmmLabel(BUNDLE.getString("metatag.subtitles"));
        this.add((Component)lblSubtitle, "cell 0 11,aligny top");
        TmmTable tableSubtitles = new TmmTable((TableModel)new DefaultEventTableModel((EventList)GlazedListsSwing.swingThreadProxyList(this.subtitleEventList), (TableFormat)new SubtitleTableFormat()));
        tableSubtitles.setAutoResizeMode(0);
        scrollPane = new JScrollPane(tableSubtitles);
        tableSubtitles.configureScrollPane(scrollPane);
        scrollPane.setVerticalScrollBarPolicy(20);
        this.add((Component)scrollPane, "cell 1 11 5 1,growx");
        this.add((Component)new JSeparator(), "cell 0 12 6 1,growx");
        TmmLabel lblMediaFilesT = new TmmLabel(BUNDLE.getString("metatag.mediafiles"));
        this.add((Component)lblMediaFilesT, "cell 0 13 2 1");
        this.panelMediaFiles = new MediaFilesPanel(this.mediaFileEventList){
            private static final long serialVersionUID = -8712860341504013403L;

            @Override
            public MediaEntity getMediaEntity() {
                return MediaInformationPanel.this.getMediaEntity();
            }
        };
        this.add((Component)this.panelMediaFiles, "cell 0 14 6 1,grow");
    }

    protected abstract MediaEntity getMediaEntity();

    protected abstract void fillVideoStreamDetails();

    protected abstract void buildAudioStreamDetails();

    protected abstract void buildSubtitleStreamDetails();

    protected static class SubtitleTableFormat
    extends TmmTableFormat<SubtitleContainer> {
        SubtitleTableFormat() {
            TmmTableFormat.StringComparator stringComparator = new TmmTableFormat.StringComparator();
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, BUNDLE.getString("metatag.source"), "source", container -> container.source, String.class);
            col.setColumnComparator(stringComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, BUNDLE.getString("metatag.language"), "language", container -> {
                String language = container.subtitle.getLanguage();
                if (container.subtitle.isForced()) {
                    language = language + " forced";
                }
                if (StringUtils.isNotBlank((CharSequence)container.subtitle.getCodec())) {
                    language = language + " (" + container.subtitle.getCodec() + ")";
                }
                return language;
            }, String.class);
            col.setColumnComparator(stringComparator);
            this.addColumn(col);
        }
    }

    protected static class SubtitleContainer {
        public String source;
        public MediaFileSubtitle subtitle;
    }

    protected static class AudioStreamTableFormat
    extends TmmTableFormat<AudioStreamContainer> {
        AudioStreamTableFormat() {
            TmmTableFormat.StringComparator stringComparator = new TmmTableFormat.StringComparator();
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, BUNDLE.getString("metatag.source"), "source", container -> container.source, String.class);
            col.setColumnComparator(stringComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, BUNDLE.getString("metatag.codec"), "codec", container -> container.audioStream.getCodec(), String.class);
            col.setColumnComparator(stringComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, BUNDLE.getString("metatag.channels"), "channels", container -> {
                int channels = container.audioStream.getAudioChannels();
                if (channels > 0) {
                    return channels + "ch";
                }
                return "";
            }, String.class);
            col.setColumnComparator(stringComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, BUNDLE.getString("metatag.bitrate"), "bitrate", container -> container.audioStream.getBitrateInKbps(), String.class);
            col.setColumnComparator(stringComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, BUNDLE.getString("metatag.language"), "language", container -> container.audioStream.getLanguage(), String.class);
            col.setColumnComparator(stringComparator);
            this.addColumn(col);
        }
    }

    protected static class AudioStreamContainer {
        public String source;
        public MediaFileAudioStream audioStream;
    }

    protected class LinkLabelListener
    implements ActionListener {
        protected LinkLabelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (StringUtils.isNotBlank((CharSequence)MediaInformationPanel.this.lblPath.getText())) {
                Path path = Paths.get(MediaInformationPanel.this.lblPath.getText(), new String[0]);
                try {
                    if (Files.exists(path, new LinkOption[0])) {
                        TmmUIHelper.openFile(path);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("open filemanager", (Throwable)ex);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)path, "message.erroropenfolder", new String[]{":", ex.getLocalizedMessage()}));
                }
            }
        }
    }
}

