/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskListener;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIMessageCollector;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.FlatButton;
import org.tinymediamanager.ui.dialogs.MessageHistoryDialog;
import org.tinymediamanager.ui.dialogs.TaskListDialog;

public class StatusBarPanel
extends JPanel
implements TmmTaskListener {
    private static final long serialVersionUID = -6375900257553323558L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private Set<TmmTaskHandle> taskSet;
    private TmmTaskHandle activeTask;
    private JButton btnNotifications;
    private JLabel lblMemory;
    private JLabel taskLabel;
    private JProgressBar taskProgressBar;
    private JButton taskStopButton;
    private Component spacer;

    public StatusBarPanel() {
        this.initComponents();
        this.taskSet = new HashSet<TmmTaskHandle>();
        this.taskLabel.setText("");
        TmmTaskManager.getInstance().addTaskListener(this);
        Settings settings = Settings.getInstance();
        Timer m = new Timer(1000, null);
        m.addActionListener(evt -> this.lblMemory.setText(this.getMemory()));
        if (settings.isShowMemory()) {
            m.start();
        }
        settings.addPropertyChangeListener(evt -> {
            if (settings.isShowMemory()) {
                m.start();
            } else {
                this.lblMemory.setText("");
                m.stop();
            }
        });
        this.btnNotifications.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                StatusBarPanel.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                StatusBarPanel.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        this.btnNotifications.addActionListener(e -> {
            MessageHistoryDialog dialog = MessageHistoryDialog.getInstance();
            dialog.setVisible(true);
        });
        TmmUIMessageCollector.instance.addPropertyChangeListener(evt -> {
            if ("messages".equals(evt.getPropertyName())) {
                if (TmmUIMessageCollector.instance.getNewMessagesCount() > 0) {
                    this.spacer.setVisible(true);
                    this.btnNotifications.setVisible(true);
                    this.btnNotifications.setEnabled(true);
                    this.btnNotifications.setText("" + TmmUIMessageCollector.instance.getNewMessagesCount());
                } else {
                    this.spacer.setVisible(false);
                    this.btnNotifications.setVisible(false);
                    this.btnNotifications.setEnabled(false);
                }
                this.btnNotifications.repaint();
            }
        });
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("insets 0 n 0 n, hidemode 2", "[][50lp:n][grow][100lp][][15lp:n][]", "[]"));
        this.setOpaque(false);
        this.lblMemory = new JLabel("");
        this.add((Component)this.lblMemory, "cell 0 0");
        this.taskLabel = new JLabel("XYZ");
        this.add((Component)this.taskLabel, "cell 2 0,alignx right, wmin 0");
        this.taskProgressBar = new JProgressBar();
        this.taskProgressBar.setBackground(UIManager.getColor("Panel.background"));
        this.taskProgressBar.addMouseListener(new MListener());
        this.add((Component)this.taskProgressBar, "cell 3 0");
        this.taskStopButton = new FlatButton(IconManager.CANCEL);
        this.taskStopButton.addActionListener(e -> {
            if (this.activeTask instanceof TmmTask) {
                this.activeTask.cancel();
            }
        });
        this.add((Component)this.taskStopButton, "cell 4 0");
        this.spacer = Box.createVerticalStrut(Math.max(this.taskLabel.getPreferredSize().height, this.taskStopButton.getPreferredSize().height));
        this.spacer.setVisible(false);
        this.add(this.spacer, "cell 5 0");
        this.btnNotifications = new FlatButton(IconManager.WARN_INTENSIFIED);
        this.btnNotifications.setVisible(false);
        this.btnNotifications.setEnabled(false);
        this.btnNotifications.setForeground(Color.RED);
        this.btnNotifications.setToolTipText(BUNDLE.getString("notifications.new"));
        this.add((Component)this.btnNotifications, "cell 6 0");
    }

    private String getMemory() {
        Runtime rt = Runtime.getRuntime();
        long totalMem = rt.totalMemory();
        long maxMem = rt.maxMemory();
        long freeMem = rt.freeMemory();
        long megs = 0x100000L;
        long used = totalMem - freeMem;
        long free = maxMem - used;
        String phys = "";
        return BUNDLE.getString("tmm.memoryused") + " " + used / megs + " MiB  /  " + BUNDLE.getString("tmm.memoryfree") + " " + free / megs + " MiB  /  " + BUNDLE.getString("tmm.memorymax") + " " + maxMem / megs + " MiB" + phys;
    }

    @Override
    public synchronized void processTaskEvent(TmmTaskHandle task) {
        SwingUtilities.invokeLater(() -> {
            if (task.getState() == TmmTaskHandle.TaskState.CREATED || task.getState() == TmmTaskHandle.TaskState.QUEUED) {
                this.taskSet.add(task);
            } else if (task.getState() == TmmTaskHandle.TaskState.STARTED) {
                this.taskSet.add(task);
            } else if (task.getState() == TmmTaskHandle.TaskState.CANCELLED || task.getState() == TmmTaskHandle.TaskState.FINISHED) {
                this.taskSet.remove(task);
            }
            if (this.activeTask == null || this.activeTask.getState() == TmmTaskHandle.TaskState.FINISHED || this.activeTask.getState() == TmmTaskHandle.TaskState.CANCELLED) {
                this.activeTask = null;
                for (TmmTaskHandle handle : this.taskSet) {
                    if (handle.getType() != TmmTaskHandle.TaskType.MAIN_TASK || handle.getState() != TmmTaskHandle.TaskState.STARTED) continue;
                    this.activeTask = handle;
                    break;
                }
                if (this.activeTask == null) {
                    for (TmmTaskHandle handle : this.taskSet) {
                        if (handle.getState() != TmmTaskHandle.TaskState.STARTED) continue;
                        this.activeTask = handle;
                        break;
                    }
                }
            }
            if (this.activeTask == null) {
                this.taskLabel.setVisible(false);
                this.taskStopButton.setVisible(false);
                this.taskProgressBar.setVisible(false);
            } else {
                this.taskLabel.setVisible(true);
                this.taskProgressBar.setVisible(true);
                if (this.activeTask.getType() == TmmTaskHandle.TaskType.MAIN_TASK) {
                    this.taskStopButton.setVisible(true);
                } else {
                    this.taskStopButton.setVisible(false);
                }
                this.taskLabel.setText(this.activeTask.getTaskName());
                if (this.activeTask.getWorkUnits() > 0) {
                    this.taskProgressBar.setIndeterminate(false);
                    this.taskProgressBar.setMaximum(this.activeTask.getWorkUnits());
                    this.taskProgressBar.setValue(this.activeTask.getProgressDone());
                } else {
                    this.taskProgressBar.setIndeterminate(true);
                }
            }
        });
    }

    private class MListener
    extends MouseAdapter {
        private MListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TaskListDialog.getInstance().setVisible(true);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            StatusBarPanel.this.setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            StatusBarPanel.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

