/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.WolDevice;
import org.tinymediamanager.jsonrpc.config.HostConfig;
import org.tinymediamanager.jsonrpc.io.ApiException;
import org.tinymediamanager.thirdparty.KodiRPC;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.SettingsPanelFactory;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.dialogs.WolDeviceDialog;

class ExternalDevicesSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 8176824801347872222L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalDevicesSettingsPanel.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private Settings settings = Settings.getInstance();
    private JTable tableWolDevices;
    private JTextField tfKodiHost;
    private JTextField tfKodiTcpPort;
    private JTextField tfKodiHttpPort;
    private JTextField tfKodiUsername;
    private JPasswordField tfKodiPassword;
    private JButton btnRemoveWolDevice;
    private JButton btnAddWolDevice;
    private JButton btnEditWolDevice;
    private JCheckBox chckbxUpnpShareLibrary;
    private JCheckBox chckbxUpnpRemotePlay;

    ExternalDevicesSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        this.btnAddWolDevice.addActionListener(arg0 -> {
            WolDeviceDialog dialog = new WolDeviceDialog();
            dialog.pack();
            dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
            dialog.setVisible(true);
        });
        this.btnRemoveWolDevice.addActionListener(e -> {
            int row = this.tableWolDevices.getSelectedRow();
            if ((row = this.tableWolDevices.convertRowIndexToModel(row)) != -1) {
                WolDevice device = Globals.settings.getWolDevices().get(row);
                Globals.settings.removeWolDevice(device);
            }
        });
        this.btnEditWolDevice.addActionListener(e -> {
            WolDevice device;
            int row = this.tableWolDevices.getSelectedRow();
            if ((row = this.tableWolDevices.convertRowIndexToModel(row)) != -1 && (device = Globals.settings.getWolDevices().get(row)) != null) {
                WolDeviceDialog dialog = new WolDeviceDialog();
                dialog.setDevice(device);
                dialog.pack();
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        this.tableWolDevices.getColumnModel().getColumn(0).setHeaderValue(BUNDLE.getString("Settings.devicename"));
        this.tableWolDevices.getColumnModel().getColumn(1).setHeaderValue(BUNDLE.getString("Settings.macaddress"));
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][15lp!][][15lp!][]"));
        JPanel panelWol = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][400lp][]", "[100lp]"));
        TmmLabel lblWolT = new TmmLabel(BUNDLE.getString("tmm.wakeonlan"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelWol, lblWolT, true);
        this.add((Component)collapsiblePanel, "growx,wmin 0");
        JScrollPane spWolDevices = new JScrollPane();
        panelWol.add((Component)spWolDevices, "cell 1 0,grow");
        this.tableWolDevices = new TmmTable();
        spWolDevices.setViewportView(this.tableWolDevices);
        this.btnAddWolDevice = new JButton(BUNDLE.getString("Button.add"));
        panelWol.add((Component)this.btnAddWolDevice, "flowy,cell 2 0,growx,aligny top");
        this.btnEditWolDevice = new JButton(BUNDLE.getString("Button.edit"));
        panelWol.add((Component)this.btnEditWolDevice, "cell 2 0,growx");
        this.btnRemoveWolDevice = new JButton(BUNDLE.getString("Button.remove"));
        panelWol.add((Component)this.btnRemoveWolDevice, "cell 2 0,growx");
        JPanel panelKodi = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][15lp][][]", "[]"));
        TmmLabel lblKodiT = new TmmLabel("Kodi / XBMC", TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelKodi, lblKodiT, true);
        this.add((Component)collapsiblePanel, "cell 0 2,growx,wmin 0");
        JLabel lblKodiHostT = new JLabel(BUNDLE.getString("Settings.kodi.host"));
        panelKodi.add((Component)lblKodiHostT, "cell 1 0");
        this.tfKodiHost = new JTextField();
        panelKodi.add((Component)this.tfKodiHost, "cell 2 0");
        this.tfKodiHost.setColumns(20);
        JButton btnKodiConnect = new JButton(BUNDLE.getString("Settings.kodi.connect"));
        btnKodiConnect.addActionListener(e -> {
            HostConfig c = new HostConfig(this.tfKodiHost.getText(), this.tfKodiHttpPort.getText(), this.tfKodiTcpPort.getText(), this.tfKodiUsername.getText(), new String(this.tfKodiPassword.getPassword()));
            try {
                KodiRPC.getInstance().connect(c);
            }
            catch (ApiException cex) {
                LOGGER.error("Error connecting to Kodi instance! {}", (Object)cex.getMessage());
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "KodiRPC", "Could not connect to Kodi: " + cex.getMessage()));
            }
        });
        panelKodi.add((Component)btnKodiConnect, "cell 3 0,growx");
        JLabel lblKodiHttpPortT = new JLabel(BUNDLE.getString("Settings.kodi.httpport"));
        panelKodi.add((Component)lblKodiHttpPortT, "cell 1 1");
        this.tfKodiHttpPort = new JTextField();
        panelKodi.add((Component)this.tfKodiHttpPort, "cell 2 1");
        this.tfKodiHttpPort.setColumns(20);
        JButton btnKodiDisconnect = new JButton(BUNDLE.getString("Settings.kodi.disconnect"));
        btnKodiDisconnect.addActionListener(e -> KodiRPC.getInstance().disconnect());
        panelKodi.add((Component)btnKodiDisconnect, "cell 3 1,growx");
        JLabel lblKodiTcpPortT = new JLabel(BUNDLE.getString("Settings.kodi.tcpport"));
        panelKodi.add((Component)lblKodiTcpPortT, "cell 1 2");
        this.tfKodiTcpPort = new JTextField();
        panelKodi.add((Component)this.tfKodiTcpPort, "cell 2 2");
        this.tfKodiTcpPort.setColumns(20);
        JLabel lblKodiUsernameT = new JLabel(BUNDLE.getString("Settings.kodi.user"));
        panelKodi.add((Component)lblKodiUsernameT, "cell 1 3");
        this.tfKodiUsername = new JTextField();
        panelKodi.add((Component)this.tfKodiUsername, "cell 2 3");
        this.tfKodiUsername.setColumns(20);
        JLabel lblKodiPasswordT = new JLabel(BUNDLE.getString("Settings.kodi.pass"));
        panelKodi.add((Component)lblKodiPasswordT, "cell 1 4");
        this.tfKodiPassword = new JPasswordField();
        panelKodi.add((Component)this.tfKodiPassword, "cell 2 4");
        this.tfKodiPassword.setColumns(20);
        JPanel panelUpnp = SettingsPanelFactory.createSettingsPanel();
        TmmLabel lblUpnp = new TmmLabel("UPnP", TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelUpnp, lblUpnp, true);
        this.add((Component)collapsiblePanel, "cell 0 4,growx,wmin 0");
        this.chckbxUpnpShareLibrary = new JCheckBox(BUNDLE.getString("Settings.upnp.share"));
        panelUpnp.add((Component)this.chckbxUpnpShareLibrary, "cell 1 0 2 1");
        this.chckbxUpnpRemotePlay = new JCheckBox(BUNDLE.getString("Settings.upnp.play"));
        panelUpnp.add((Component)this.chckbxUpnpRemotePlay, "cell 1 1 2 1");
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty = BeanProperty.create((String)"wolDevices");
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty, (JTable)this.tableWolDevices);
        BeanProperty wolBeanProperty_1 = BeanProperty.create((String)"name");
        jTableBinding.addColumnBinding((Property)wolBeanProperty_1);
        BeanProperty wolBeanProperty_2 = BeanProperty.create((String)"macAddress");
        jTableBinding.addColumnBinding((Property)wolBeanProperty_2);
        jTableBinding.setEditable(false);
        jTableBinding.bind();
        BeanProperty settingsBeanProperty_2 = BeanProperty.create((String)"kodiUsername");
        BeanProperty jTextFieldBeanProperty_1 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_2, (Object)this.tfKodiUsername, (Property)jTextFieldBeanProperty_1);
        autoBinding_1.bind();
        BeanProperty settingsBeanProperty_3 = BeanProperty.create((String)"kodiPassword");
        BeanProperty jPasswordFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_3, (Object)this.tfKodiPassword, (Property)jPasswordFieldBeanProperty);
        autoBinding_2.bind();
        BeanProperty settingsBeanProperty_4 = BeanProperty.create((String)"upnpRemotePlay");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_4, (Object)this.chckbxUpnpRemotePlay, (Property)jCheckBoxBeanProperty);
        autoBinding_3.bind();
        BeanProperty settingsBeanProperty_5 = BeanProperty.create((String)"upnpShareLibrary");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_5, (Object)this.chckbxUpnpShareLibrary, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty settingsBeanProperty_1 = BeanProperty.create((String)"kodiHost");
        BeanProperty jTextFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_1, (Object)this.tfKodiHost, (Property)jTextFieldBeanProperty);
        autoBinding.bind();
        BeanProperty settingsBeanProperty_6 = BeanProperty.create((String)"kodiHttpPort");
        BeanProperty jTextFieldBeanProperty_2 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_6, (Object)this.tfKodiHttpPort, (Property)jTextFieldBeanProperty_2);
        autoBinding_5.bind();
        BeanProperty settingsBeanProperty_7 = BeanProperty.create((String)"kodiTcpPort");
        BeanProperty jTextFieldBeanProperty_3 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_7, (Object)this.tfKodiTcpPort, (Property)jTextFieldBeanProperty_3);
        autoBinding_6.bind();
    }
}

