/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.TmmLabel;

class FileTypesSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 9136097757447080369L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private Settings settings = Settings.getInstance();
    private JTextField tfVideoFiletype;
    private JList<String> listVideoFiletypes;
    private JTextField tfSubtitleFiletype;
    private JList<String> listSubtitleFiletypes;
    private JTextField tfAudioFiletype;
    private JList<String> listAudioFiletypes;
    private JTextField tfCleanupFiletype;
    private JList<String> listCleanupFiletypes;
    private JButton btnAddAudioFiletype;
    private JButton btnAddSubtitleFiletype;
    private JButton btnAddVideoFiletype;
    private JButton btnAddCleanupFiletype;
    private JButton btnRemoveCleanupFiletype;
    private JButton btnRemoveAudioFiletype;
    private JButton btnRemoveSubtitleFiletype;
    private JButton btnRemoveVideoFiletype;

    FileTypesSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        this.btnAddVideoFiletype.addActionListener(e -> {
            if (StringUtils.isNotEmpty((CharSequence)this.tfVideoFiletype.getText())) {
                Globals.settings.addVideoFileType(this.tfVideoFiletype.getText());
                this.tfVideoFiletype.setText("");
            }
        });
        this.btnRemoveVideoFiletype.addActionListener(arg0 -> {
            int row = this.listVideoFiletypes.getSelectedIndex();
            if (row != -1) {
                String prefix = Globals.settings.getVideoFileType().get(row);
                Globals.settings.removeVideoFileType(prefix);
            }
        });
        this.btnAddSubtitleFiletype.addActionListener(e -> {
            if (StringUtils.isNotEmpty((CharSequence)this.tfSubtitleFiletype.getText())) {
                Globals.settings.addSubtitleFileType(this.tfSubtitleFiletype.getText());
                this.tfSubtitleFiletype.setText("");
            }
        });
        this.btnRemoveSubtitleFiletype.addActionListener(arg0 -> {
            int row = this.listSubtitleFiletypes.getSelectedIndex();
            if (row != -1) {
                String prefix = Globals.settings.getSubtitleFileType().get(row);
                Globals.settings.removeSubtitleFileType(prefix);
            }
        });
        this.btnAddAudioFiletype.addActionListener(e -> {
            if (StringUtils.isNotEmpty((CharSequence)this.tfAudioFiletype.getText())) {
                Globals.settings.addAudioFileType(this.tfAudioFiletype.getText());
                this.tfAudioFiletype.setText("");
            }
        });
        this.btnRemoveAudioFiletype.addActionListener(arg0 -> {
            int row = this.listAudioFiletypes.getSelectedIndex();
            if (row != -1) {
                String prefix = Globals.settings.getAudioFileType().get(row);
                Globals.settings.removeAudioFileType(prefix);
            }
        });
        this.btnAddCleanupFiletype.addActionListener(e -> {
            if (StringUtils.isNotEmpty((CharSequence)this.tfCleanupFiletype.getText())) {
                try {
                    Pattern.compile(this.tfCleanupFiletype.getText());
                }
                catch (PatternSyntaxException ex) {
                    JOptionPane.showMessageDialog(null, BUNDLE.getString("message.regex.error"));
                    return;
                }
                Globals.settings.addCleanupFileType(this.tfCleanupFiletype.getText());
                this.tfCleanupFiletype.setText("");
            }
        });
        this.btnRemoveCleanupFiletype.addActionListener(arg0 -> {
            int row = this.listCleanupFiletypes.getSelectedIndex();
            if (row != -1) {
                String prefix = Globals.settings.getCleanupFileType().get(row);
                Globals.settings.removeCleanupFileType(prefix);
            }
        });
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][15lp!][][15lp!][][15lp!][]"));
        JPanel panelVideoFiletypes = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][100lp][][grow]", "[]"));
        TmmLabel lblVideoFiletypesT = new TmmLabel(BUNDLE.getString("Settings.videofiletypes"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelVideoFiletypes, lblVideoFiletypesT, true);
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        JScrollPane scrollPaneVideoFiletypes = new JScrollPane();
        panelVideoFiletypes.add((Component)scrollPaneVideoFiletypes, "cell 1 0,grow");
        this.listVideoFiletypes = new JList();
        scrollPaneVideoFiletypes.setViewportView(this.listVideoFiletypes);
        this.btnRemoveVideoFiletype = new JButton(IconManager.REMOVE_INV);
        panelVideoFiletypes.add((Component)this.btnRemoveVideoFiletype, "cell 2 0,aligny bottom, growx");
        this.btnRemoveVideoFiletype.setToolTipText(BUNDLE.getString("Button.remove"));
        this.tfVideoFiletype = new JTextField();
        panelVideoFiletypes.add((Component)this.tfVideoFiletype, "cell 1 1,growx");
        this.btnAddVideoFiletype = new JButton(IconManager.ADD_INV);
        panelVideoFiletypes.add((Component)this.btnAddVideoFiletype, "cell 2 1,growx");
        this.btnAddVideoFiletype.setToolTipText(BUNDLE.getString("Button.add"));
        JPanel panelSubtitleFiletypes = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][100lp][][grow]", "[]"));
        TmmLabel lblSubtitleFiletypesT = new TmmLabel(BUNDLE.getString("Settings.extrafiletypes"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelSubtitleFiletypes, lblSubtitleFiletypesT, true);
        this.add((Component)collapsiblePanel, "cell 0 2,growx,wmin 0");
        JScrollPane scrollPaneSubtitleFiletypes = new JScrollPane();
        panelSubtitleFiletypes.add((Component)scrollPaneSubtitleFiletypes, "cell 1 0,grow");
        this.listSubtitleFiletypes = new JList();
        scrollPaneSubtitleFiletypes.setViewportView(this.listSubtitleFiletypes);
        this.btnRemoveSubtitleFiletype = new JButton(IconManager.REMOVE_INV);
        panelSubtitleFiletypes.add((Component)this.btnRemoveSubtitleFiletype, "cell 2 0,aligny bottom, growx");
        this.btnRemoveSubtitleFiletype.setToolTipText(BUNDLE.getString("Button.remove"));
        this.tfSubtitleFiletype = new JTextField();
        panelSubtitleFiletypes.add((Component)this.tfSubtitleFiletype, "cell 1 1,growx");
        this.btnAddSubtitleFiletype = new JButton(IconManager.ADD_INV);
        panelSubtitleFiletypes.add((Component)this.btnAddSubtitleFiletype, "cell 2 1");
        this.btnAddSubtitleFiletype.setToolTipText(BUNDLE.getString("Button.add"));
        JPanel panelAudioFiletypes = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][100lp][][grow]", "[]"));
        TmmLabel lblAudioFiletypesT = new TmmLabel(BUNDLE.getString("Settings.audiofiletypes"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelAudioFiletypes, lblAudioFiletypesT, true);
        this.add((Component)collapsiblePanel, "cell 0 4,growx,wmin 0");
        JScrollPane scrollPaneAudioFiletypes = new JScrollPane();
        panelAudioFiletypes.add((Component)scrollPaneAudioFiletypes, "cell 1 0,grow");
        this.listAudioFiletypes = new JList();
        scrollPaneAudioFiletypes.setViewportView(this.listAudioFiletypes);
        this.btnRemoveAudioFiletype = new JButton(IconManager.REMOVE_INV);
        panelAudioFiletypes.add((Component)this.btnRemoveAudioFiletype, "cell 2 0,aligny bottom, growx");
        this.btnRemoveAudioFiletype.setToolTipText(BUNDLE.getString("Button.remove"));
        this.tfAudioFiletype = new JTextField();
        panelAudioFiletypes.add((Component)this.tfAudioFiletype, "cell 1 1,growx");
        this.btnAddAudioFiletype = new JButton(IconManager.ADD_INV);
        panelAudioFiletypes.add((Component)this.btnAddAudioFiletype, "cell 2 1, growx");
        this.btnAddAudioFiletype.setToolTipText(BUNDLE.getString("Button.add"));
        JPanel panelCleanupFiletypes = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][300lp][][grow]", "[]"));
        TmmLabel lblCleanupFiletypesT = new TmmLabel(BUNDLE.getString("Settings.unwantedfiletypes"), TmmFontHelper.H3);
        TmmLabel lblCleanupFiletypesHelpT = new TmmLabel(BUNDLE.getString("Settings.cleanupfiles.help"));
        CollapsiblePanel collapsiblePanel2 = new CollapsiblePanel((JComponent)panelCleanupFiletypes, lblCleanupFiletypesT, true);
        this.add((Component)collapsiblePanel2, "cell 0 6,growx,wmin 0");
        JScrollPane scrollPaneCleanupFiletypes = new JScrollPane();
        panelCleanupFiletypes.add((Component)scrollPaneCleanupFiletypes, "cell 1 0,grow");
        this.listCleanupFiletypes = new JList();
        scrollPaneCleanupFiletypes.setViewportView(this.listCleanupFiletypes);
        this.btnRemoveCleanupFiletype = new JButton(IconManager.REMOVE_INV);
        panelCleanupFiletypes.add((Component)this.btnRemoveCleanupFiletype, "cell 2 0,aligny bottom, growx");
        this.btnRemoveCleanupFiletype.setToolTipText(BUNDLE.getString("Button.remove"));
        this.tfCleanupFiletype = new JTextField();
        panelCleanupFiletypes.add((Component)this.tfCleanupFiletype, "cell 1 1,growx");
        this.btnAddCleanupFiletype = new JButton(IconManager.ADD_INV);
        panelCleanupFiletypes.add((Component)this.btnAddCleanupFiletype, "cell 2 1, growx");
        this.btnAddCleanupFiletype.setToolTipText(BUNDLE.getString("Button.add"));
        panelCleanupFiletypes.add((Component)lblCleanupFiletypesHelpT, "cell 1 2");
        JButton btnHelp = new JButton(BUNDLE.getString("tmm.help"));
        btnHelp.addActionListener(e -> {
            String url = StringEscapeUtils.unescapeHtml4((String)"https://gitlab.com/tinyMediaManager/tinyMediaManager/wikis/General-Settings#file-types");
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception e1) {
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e1.getLocalizedMessage()}));
            }
        });
        panelCleanupFiletypes.add((Component)btnHelp, "cell 1 2");
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_5 = BeanProperty.create((String)"videoFileType");
        JListBinding jListBinding_1 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_5, this.listVideoFiletypes);
        jListBinding_1.bind();
        BeanProperty settingsBeanProperty_6 = BeanProperty.create((String)"subtitleFileType");
        JListBinding jListBinding_2 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_6, this.listSubtitleFiletypes);
        jListBinding_2.bind();
        BeanProperty settingsBeanProperty_11 = BeanProperty.create((String)"audioFileType");
        JListBinding jListBinding_3 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_11, this.listAudioFiletypes);
        jListBinding_3.bind();
        BeanProperty settingsBeanProperty_12 = BeanProperty.create((String)"cleanupFileType");
        JListBinding jListBinding_4 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_12, this.listCleanupFiletypes);
        jListBinding_4.bind();
    }
}

