/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.settings;

import com.sun.jna.Platform;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSlider;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.SettingsPanelFactory;
import org.tinymediamanager.ui.components.TmmLabel;

class SystemSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 500841588272296493L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Pattern MEMORY_PATTERN = Pattern.compile("-Xmx([0-9]*)(.)");
    private Settings settings = Settings.getInstance();
    private JTextField tfProxyHost;
    private JTextField tfProxyPort;
    private JTextField tfProxyUsername;
    private JPasswordField tfProxyPassword;
    private JTextField tfMediaPlayer;
    private JButton btnSearchMediaPlayer;
    private JSlider sliderMemory;
    private JLabel lblMemory;
    private JCheckBox chckbxIgnoreSSLProblems;

    SystemSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        this.initMemorySlider();
        this.btnSearchMediaPlayer.addActionListener(arg0 -> {
            String path = TmmProperties.getInstance().getProperty("chooseplayer.path");
            Path file = TmmUIHelper.selectFile(BUNDLE.getString("Button.chooseplayer"), path);
            if (file != null && Utils.isRegularFile(file) || Platform.isMac()) {
                this.tfMediaPlayer.setText(file.toAbsolutePath().toString());
            }
        });
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][15lp!][][15lp!][][15lp!][]"));
        JPanel panelMediaPlayer = SettingsPanelFactory.createSettingsPanel();
        TmmLabel lblLanguageT = new TmmLabel(BUNDLE.getString("Settings.mediaplayer"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelMediaPlayer, lblLanguageT, true);
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        this.tfMediaPlayer = new JTextField();
        panelMediaPlayer.add((Component)this.tfMediaPlayer, "cell 1 0 2 1");
        this.tfMediaPlayer.setColumns(35);
        this.btnSearchMediaPlayer = new JButton(BUNDLE.getString("Button.chooseplayer"));
        panelMediaPlayer.add((Component)this.btnSearchMediaPlayer, "cell 1 0");
        ReadOnlyTextArea tpMediaPlayer = new ReadOnlyTextArea(BUNDLE.getString("Settings.mediaplayer.hint"));
        panelMediaPlayer.add((Component)tpMediaPlayer, "cell 1 1 2 1,growx");
        TmmFontHelper.changeFont((JComponent)tpMediaPlayer, TmmFontHelper.L2);
        JPanel panelMemory = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][][300lp][grow]", ""));
        JLabel lblMemoryT = new TmmLabel(BUNDLE.getString("Settings.memoryborder"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelMemory, lblMemoryT, true);
        this.add((Component)collapsiblePanel, "cell 0 2,growx,wmin 0");
        lblMemoryT = new JLabel(BUNDLE.getString("Settings.memory"));
        panelMemory.add((Component)lblMemoryT, "cell 1 0,aligny top");
        this.sliderMemory = new JSlider();
        this.sliderMemory.setPaintLabels(true);
        this.sliderMemory.setPaintTicks(true);
        this.sliderMemory.setSnapToTicks(true);
        this.sliderMemory.setMajorTickSpacing(512);
        this.sliderMemory.setMinorTickSpacing(128);
        this.sliderMemory.setMinimum(256);
        if (Platform.is64Bit()) {
            this.sliderMemory.setMaximum(2560);
        } else {
            this.sliderMemory.setMaximum(1536);
        }
        this.sliderMemory.setValue(512);
        panelMemory.add((Component)this.sliderMemory, "cell 2 0,growx,aligny top");
        this.lblMemory = new JLabel("512");
        panelMemory.add((Component)this.lblMemory, "cell 3 0,aligny top");
        JLabel lblMb = new JLabel("MB");
        panelMemory.add((Component)lblMb, "cell 3 0,aligny top");
        ReadOnlyTextArea tpMemoryHint = new ReadOnlyTextArea(BUNDLE.getString("Settings.memory.hint"));
        panelMemory.add((Component)tpMemoryHint, "cell 1 1 3 1,growx");
        TmmFontHelper.changeFont((JComponent)tpMemoryHint, TmmFontHelper.L2);
        JPanel panelProxy = SettingsPanelFactory.createSettingsPanel();
        TmmLabel lblProxyT = new TmmLabel(BUNDLE.getString("Settings.proxy"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelProxy, lblProxyT, true);
        this.add((Component)collapsiblePanel, "cell 0 4,growx,wmin 0");
        JLabel lblProxyHostT = new JLabel(BUNDLE.getString("Settings.proxyhost"));
        panelProxy.add((Component)lblProxyHostT, "cell 1 0,alignx right");
        this.tfProxyHost = new JTextField();
        panelProxy.add((Component)this.tfProxyHost, "cell 2 0");
        this.tfProxyHost.setColumns(20);
        lblProxyHostT.setLabelFor(this.tfProxyHost);
        JLabel lblProxyPortT = new JLabel(BUNDLE.getString("Settings.proxyport"));
        panelProxy.add((Component)lblProxyPortT, "cell 1 1,alignx right");
        lblProxyPortT.setLabelFor(this.tfProxyPort);
        this.tfProxyPort = new JTextField();
        panelProxy.add((Component)this.tfProxyPort, "cell 2 1");
        this.tfProxyPort.setColumns(20);
        JLabel lblProxyUserT = new JLabel(BUNDLE.getString("Settings.proxyuser"));
        panelProxy.add((Component)lblProxyUserT, "cell 1 2,alignx right");
        lblProxyUserT.setLabelFor(this.tfProxyUsername);
        this.tfProxyUsername = new JTextField();
        panelProxy.add((Component)this.tfProxyUsername, "cell 2 2");
        this.tfProxyUsername.setColumns(20);
        JLabel lblProxyPasswordT = new JLabel(BUNDLE.getString("Settings.proxypass"));
        panelProxy.add((Component)lblProxyPasswordT, "cell 1 3,alignx right");
        lblProxyPasswordT.setLabelFor(this.tfProxyPassword);
        this.tfProxyPassword = new JPasswordField();
        this.tfProxyPassword.setColumns(20);
        panelProxy.add((Component)this.tfProxyPassword, "cell 2 3");
        JPanel panelMisc = SettingsPanelFactory.createSettingsPanel();
        TmmLabel lblMiscT = new TmmLabel(BUNDLE.getString("Settings.misc"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelMisc, lblMiscT, true);
        this.add((Component)collapsiblePanel, "cell 0 6,growx,wmin 0");
        this.chckbxIgnoreSSLProblems = new JCheckBox(BUNDLE.getString("Settings.ignoressl"));
        panelMisc.add((Component)this.chckbxIgnoreSSLProblems, "cell 1 0 2 1");
    }

    private void initMemorySlider() {
        Path file = Paths.get("extra.txt", new String[0]);
        int maxMemory = 512;
        if (Files.exists(file, new LinkOption[0])) {
            try {
                String extraTxt = Utils.readFileToString(file);
                Matcher matcher = MEMORY_PATTERN.matcher(extraTxt);
                if (matcher.find()) {
                    maxMemory = Integer.parseInt(matcher.group(1));
                    String dimension = matcher.group(2);
                    if ("k".equalsIgnoreCase(dimension)) {
                        maxMemory /= 1024;
                    }
                    if ("g".equalsIgnoreCase(dimension)) {
                        maxMemory *= 1024;
                    }
                }
            }
            catch (Exception e) {
                maxMemory = 512;
            }
        }
        this.sliderMemory.setValue(maxMemory);
        this.addHierarchyListener(new HierarchyListener(){
            private boolean oldState = false;

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (this.oldState != SystemSettingsPanel.this.isShowing()) {
                    this.oldState = SystemSettingsPanel.this.isShowing();
                    if (!SystemSettingsPanel.this.isShowing()) {
                        SystemSettingsPanel.this.writeMemorySettings();
                    }
                }
            }
        });
    }

    private void writeMemorySettings() {
        int memoryAmount = this.sliderMemory.getValue();
        String jvmArg = "-Xmx" + memoryAmount + "m";
        if (memoryAmount == 512) {
            jvmArg = "";
        }
        Path file = Paths.get("extra.txt", new String[0]);
        if (memoryAmount != 512 && !Files.exists(file, new LinkOption[0])) {
            try {
                Utils.writeStringToFile(file, jvmArg);
            }
            catch (IOException iOException) {}
        } else if (Files.exists(file, new LinkOption[0])) {
            try {
                String extraTxt = Utils.readFileToString(file);
                Matcher matcher = MEMORY_PATTERN.matcher(extraTxt);
                extraTxt = matcher.find() ? extraTxt.replace(matcher.group(0), jvmArg) : extraTxt + "\r\n" + jvmArg;
                if (StringUtils.isBlank((CharSequence)extraTxt)) {
                    Utils.deleteFileSafely(file);
                } else {
                    Utils.writeStringToFile(file, extraTxt);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty = BeanProperty.create((String)"proxyHost");
        BeanProperty jTextFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty, (Object)this.tfProxyHost, (Property)jTextFieldBeanProperty);
        autoBinding.bind();
        BeanProperty settingsBeanProperty_1 = BeanProperty.create((String)"proxyPort");
        BeanProperty jTextFieldBeanProperty_1 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_1, (Object)this.tfProxyPort, (Property)jTextFieldBeanProperty_1);
        autoBinding_1.bind();
        BeanProperty settingsBeanProperty_2 = BeanProperty.create((String)"proxyUsername");
        BeanProperty jTextFieldBeanProperty_2 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_2, (Object)this.tfProxyUsername, (Property)jTextFieldBeanProperty_2);
        autoBinding_2.bind();
        BeanProperty settingsBeanProperty_3 = BeanProperty.create((String)"proxyPassword");
        BeanProperty jPasswordFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_3, (Object)this.tfProxyPassword, (Property)jPasswordFieldBeanProperty);
        autoBinding_3.bind();
        BeanProperty settingsBeanProperty_6 = BeanProperty.create((String)"mediaPlayer");
        BeanProperty jTextFieldBeanProperty_3 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_6, (Object)this.tfMediaPlayer, (Property)jTextFieldBeanProperty_3);
        autoBinding_9.bind();
        BeanProperty jSliderBeanProperty = BeanProperty.create((String)"value");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.sliderMemory, (Property)jSliderBeanProperty, (Object)this.lblMemory, (Property)jLabelBeanProperty);
        autoBinding_11.bind();
        BeanProperty settingsBeanProperty_4 = BeanProperty.create((String)"ignoreSSLProblems");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_4, (Object)this.chckbxIgnoreSSLProblems, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
    }
}

