/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.exceptions.UnsupportedMediaTypeException;
import org.tinymediamanager.scraper.mediaprovider.ITvShowArtworkProvider;
import org.tinymediamanager.scraper.mediaprovider.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.ui.UTF8Control;

public class TvShowChooserModel
extends AbstractModelObject {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowChooserModel.class);
    public static final TvShowChooserModel emptyResult = new TvShowChooserModel();
    private MediaScraper mediaScraper = null;
    private List<MediaScraper> artworkScrapers = null;
    private MediaLanguages language = null;
    private MediaSearchResult result = null;
    private MediaMetadata metadata = null;
    private float score = 0.0f;
    private String title = "";
    private String originalTitle = "";
    private String overview = "";
    private String year = "";
    private String combinedName = "";
    private String posterUrl = "";
    private boolean scraped = false;

    public TvShowChooserModel(MediaScraper mediaScraper, List<MediaScraper> artworkScrapers, MediaSearchResult result, MediaLanguages language) {
        this.mediaScraper = mediaScraper;
        this.artworkScrapers = artworkScrapers;
        this.result = result;
        this.language = language;
        this.setTitle(result.getTitle());
        this.setOriginalTitle(result.getOriginalTitle());
        if (result.getYear() != 0) {
            this.setYear(Integer.toString(result.getYear()));
        } else {
            this.setYear("");
        }
        this.setCombinedName();
        this.score = result.getScore();
    }

    private TvShowChooserModel() {
        this.setTitle(BUNDLE.getString("chooser.nothingfound"));
        this.combinedName = this.title;
    }

    public float getScore() {
        return this.score;
    }

    public void setTitle(String title) {
        String oldValue = this.title;
        this.title = StrgUtils.getNonNullString((String)title);
        this.firePropertyChange("title", oldValue, this.title);
    }

    public void setOriginalTitle(String originalTitle) {
        String oldValue = this.originalTitle;
        this.originalTitle = StrgUtils.getNonNullString((String)originalTitle);
        this.firePropertyChange("originalTitle", oldValue, this.originalTitle);
    }

    public void setOverview(String overview) {
        String oldValue = this.overview;
        this.overview = StrgUtils.getNonNullString((String)overview);
        this.firePropertyChange("overview", oldValue, this.overview);
    }

    public String getTitle() {
        return this.title;
    }

    public String getOriginalTitle() {
        return this.originalTitle;
    }

    public String getOverview() {
        return this.overview;
    }

    public String getPosterUrl() {
        return this.posterUrl;
    }

    public void setPosterUrl(String newValue) {
        String oldValue = this.posterUrl;
        this.posterUrl = StrgUtils.getNonNullString((String)newValue);
        this.firePropertyChange("posterUrl", oldValue, newValue);
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        String oldValue = this.year;
        this.year = year;
        this.firePropertyChange("year", oldValue, this.year);
    }

    public void setCombinedName() {
        String oldValue = this.combinedName;
        this.combinedName = StringUtils.isNotBlank((CharSequence)this.getYear()) ? this.getTitle() + " (" + this.getYear() + ")" : this.getTitle();
        this.firePropertyChange("combinedName", oldValue, this.combinedName);
    }

    public String getCombinedName() {
        return this.combinedName;
    }

    public void scrapeMetaData() {
        try {
            this.setPosterUrl(this.result.getPosterUrl());
            MediaScrapeOptions options = new MediaScrapeOptions(MediaType.TV_SHOW);
            options.setResult(this.result);
            options.setLanguage(this.language.toLocale());
            options.setCountry(TvShowModuleManager.SETTINGS.getCertificationCountry());
            LOGGER.info("=====================================================");
            LOGGER.info("Scraper metadata with scraper: " + this.mediaScraper.getMediaProvider().getProviderInfo().getId());
            LOGGER.info(options.toString());
            LOGGER.info("=====================================================");
            this.metadata = ((ITvShowMetadataProvider)this.mediaScraper.getMediaProvider()).getMetadata(options);
            this.setOverview(this.metadata.getPlot());
            if (StringUtils.isBlank((CharSequence)this.posterUrl) && !this.metadata.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).isEmpty()) {
                this.setPosterUrl(((MediaArtwork)this.metadata.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).get(0)).getPreviewUrl());
            }
            this.setScraped(true);
        }
        catch (ScrapeException e) {
            LOGGER.error("getMetadata", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"TvShowChooser", "message.scrape.metadatatvshowfailed", new String[]{":", e.getLocalizedMessage()}));
        }
        catch (MissingIdException e) {
            LOGGER.warn("missing id for scrape");
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "TvShowChooser", "scraper.error.missingid"));
        }
        catch (NothingFoundException | UnsupportedMediaTypeException throwable) {
            // empty catch block
        }
    }

    public List<TvShowEpisode> getEpisodesForDisplay() {
        ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>();
        if (!this.scraped) {
            return episodes;
        }
        MediaScrapeOptions options = new MediaScrapeOptions(MediaType.TV_EPISODE);
        options.setLanguage(this.language.toLocale());
        options.setCountry(TvShowModuleManager.SETTINGS.getCertificationCountry());
        for (Map.Entry entry : this.metadata.getIds().entrySet()) {
            options.setId((String)entry.getKey(), entry.getValue().toString());
        }
        try {
            List mediaEpisodes = ((ITvShowMetadataProvider)this.mediaScraper.getMediaProvider()).getEpisodeList(options);
            for (MediaMetadata me : mediaEpisodes) {
                TvShowEpisode ep = new TvShowEpisode();
                ep.setEpisode(me.getEpisodeNumber());
                ep.setSeason(me.getSeasonNumber());
                ep.setDvdEpisode(me.getDvdEpisodeNumber());
                ep.setDvdSeason(me.getDvdSeasonNumber());
                ep.setTitle(me.getTitle());
                ep.setOriginalTitle(me.getOriginalTitle());
                ep.setPlot(me.getPlot());
                episodes.add(ep);
            }
        }
        catch (ScrapeException e) {
            LOGGER.error("getEpisodeList", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"TvShowChooser", "message.scrape.episodelistfailed", new String[]{":", e.getLocalizedMessage()}));
        }
        catch (MissingIdException e) {
            LOGGER.warn("missing id for scrape");
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "TvShowChooser", "scraper.error.missingid"));
        }
        catch (UnsupportedMediaTypeException unsupportedMediaTypeException) {
            // empty catch block
        }
        return episodes;
    }

    public MediaMetadata getMetadata() {
        return this.metadata;
    }

    private void setScraped(boolean newvalue) {
        boolean oldValue = this.scraped;
        this.scraped = newvalue;
        this.firePropertyChange("scraped", oldValue, newvalue);
    }

    public boolean isScraped() {
        return this.scraped;
    }

    public MediaLanguages getLanguage() {
        return this.language;
    }

    public void startArtworkScrapeTask(TvShow tvShow, TvShowScraperMetadataConfig config) {
        TmmTaskManager.getInstance().addUnnamedTask(new ArtworkScrapeTask(tvShow, config));
    }

    private class ArtworkScrapeTask
    extends TmmTask {
        private TvShow tvShowToScrape;
        private TvShowScraperMetadataConfig config;

        public ArtworkScrapeTask(TvShow tvShow, TvShowScraperMetadataConfig config) {
            super(BUNDLE.getString("message.scrape.artwork") + " " + tvShow.getTitle(), 0, TmmTaskHandle.TaskType.BACKGROUND_TASK);
            this.tvShowToScrape = tvShow;
            this.config = config;
        }

        @Override
        protected void doInBackground() {
            if (!TvShowChooserModel.this.scraped) {
                return;
            }
            ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
            MediaScrapeOptions options = new MediaScrapeOptions(MediaType.TV_SHOW);
            options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
            options.setMetadata(TvShowChooserModel.this.metadata);
            for (Map.Entry<String, Object> entry : this.tvShowToScrape.getIds().entrySet()) {
                options.setId(entry.getKey(), entry.getValue().toString());
            }
            options.setLanguage(TvShowChooserModel.this.language.toLocale());
            options.setCountry(TvShowModuleManager.SETTINGS.getCertificationCountry());
            for (MediaScraper artworkScraper : TvShowChooserModel.this.artworkScrapers) {
                ITvShowArtworkProvider artworkProvider = (ITvShowArtworkProvider)artworkScraper.getMediaProvider();
                try {
                    artwork.addAll(artworkProvider.getArtwork(options));
                }
                catch (ScrapeException e) {
                    LOGGER.error("getArtwork", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.tvShowToScrape, "message.scrape.tvshowartworkfailed", new String[]{":", e.getLocalizedMessage()}));
                }
                catch (MissingIdException missingIdException) {}
            }
            if (StringUtils.isNotBlank((CharSequence)TvShowChooserModel.this.getPosterUrl())) {
                MediaArtwork ma = new MediaArtwork(TvShowChooserModel.this.result.getProviderId(), MediaArtwork.MediaArtworkType.POSTER);
                ma.setDefaultUrl(TvShowChooserModel.this.getPosterUrl());
                ma.setPreviewUrl(TvShowChooserModel.this.getPosterUrl());
                artwork.add(ma);
            }
            this.tvShowToScrape.setArtwork(artwork, this.config);
        }
    }
}

