/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.util.ResourceBundle;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.ui.UTF8Control;

public class TvShowEpisodeChooserModel
extends AbstractModelObject {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    public static final TvShowEpisodeChooserModel emptyResult = new TvShowEpisodeChooserModel();
    private MediaScraper mediaScraper;
    private MediaMetadata mediaMetadata;
    private String title = "";
    private String overview = "";
    private int season = -1;
    private int episode = -1;

    public TvShowEpisodeChooserModel(MediaScraper mediaScraper, MediaMetadata episode) {
        this.mediaScraper = mediaScraper;
        this.mediaMetadata = episode;
        this.setTitle(episode.getTitle());
        this.setOverview(this.mediaMetadata.getPlot());
        this.setSeason(this.mediaMetadata.getSeasonNumber());
        this.setEpisode(this.mediaMetadata.getEpisodeNumber());
    }

    private TvShowEpisodeChooserModel() {
        this.setTitle(BUNDLE.getString("chooser.nothingfound"));
    }

    public void setTitle(String title) {
        String oldValue = this.title;
        this.title = title;
        this.firePropertyChange("title", oldValue, title);
    }

    public void setOverview(String overview) {
        String oldValue = this.overview;
        this.overview = overview;
        this.firePropertyChange("overview", oldValue, overview);
    }

    public void setSeason(int season) {
        int oldValue = this.season;
        this.season = season;
        this.firePropertyChange("season", oldValue, season);
    }

    public void setEpisode(int episode) {
        int oldValue = this.episode;
        this.episode = episode;
        this.firePropertyChange("episode", oldValue, episode);
    }

    public String getTitle() {
        return this.title;
    }

    public String getOverview() {
        return this.overview;
    }

    public int getSeason() {
        return this.season;
    }

    public int getEpisode() {
        return this.episode;
    }

    public MediaMetadata getMediaMetadata() {
        return this.mediaMetadata;
    }
}

