/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.AbstractTmmUIModule;
import org.tinymediamanager.ui.components.MainTabbedPane;
import org.tinymediamanager.ui.components.PopupMenuScroller;
import org.tinymediamanager.ui.settings.TmmSettingsNode;
import org.tinymediamanager.ui.thirdparty.KodiRPCMenu;
import org.tinymediamanager.ui.tvshows.TvShowEpisodeSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowSeasonSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.actions.DebugDumpShowAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowBulkEditAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowChangeDatasourceAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowChangeSeasonArtworkAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowChangeToAiredOrderAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowChangeToDvdOrderAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowCleanUpFilesAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowClearImageCacheAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowDeleteAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowDownloadMissingArtworkAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowEditAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowExportAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowMediaInformationAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowMissingEpisodeListAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowReadEpisodeNfoAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowReadNfoAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowRemoveAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowRenameAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowRewriteEpisodeNfoAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowRewriteNfoAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowScrapeEpisodesAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowScrapeEpisodesWoArtworkAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowScrapeMissingEpisodesAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowScrapeNewItemsAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowSelectedScrapeAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowSingleScrapeAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowSubtitleDownloadAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowSubtitleSearchAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowSyncSelectedTraktTvAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowSyncTraktTvAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowSyncWatchedTraktTvAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowToggleWatchedFlagAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowUpdateAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowUpdateDatasourcesAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowUpdateSingleDatasourceAction;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowFilterDialog;
import org.tinymediamanager.ui.tvshows.panels.TvShowTreePanel;
import org.tinymediamanager.ui.tvshows.panels.episode.TvShowEpisodeCastPanel;
import org.tinymediamanager.ui.tvshows.panels.episode.TvShowEpisodeInformationPanel;
import org.tinymediamanager.ui.tvshows.panels.episode.TvShowEpisodeMediaInformationPanel;
import org.tinymediamanager.ui.tvshows.panels.season.TvShowSeasonInformationPanel;
import org.tinymediamanager.ui.tvshows.panels.season.TvShowSeasonMediaFilesPanel;
import org.tinymediamanager.ui.tvshows.panels.tvshow.TvShowArtworkPanel;
import org.tinymediamanager.ui.tvshows.panels.tvshow.TvShowCastPanel;
import org.tinymediamanager.ui.tvshows.panels.tvshow.TvShowInformationPanel;
import org.tinymediamanager.ui.tvshows.panels.tvshow.TvShowMediaInformationPanel;
import org.tinymediamanager.ui.tvshows.settings.TvShowSettingsNode;

public class TvShowUIModule
extends AbstractTmmUIModule {
    private static final String ID = "tvShows";
    private static TvShowUIModule instance = null;
    final TvShowSelectionModel tvShowSelectionModel = new TvShowSelectionModel();
    final TvShowSeasonSelectionModel tvShowSeasonSelectionModel = new TvShowSeasonSelectionModel();
    final TvShowEpisodeSelectionModel tvShowEpisodeSelectionModel = new TvShowEpisodeSelectionModel();
    private final TvShowTreePanel listPanel = new TvShowTreePanel(this.tvShowSelectionModel);
    private final JPanel dataPanel;
    private final TvShowFilterDialog tvShowFilterDialog;
    private TmmSettingsNode settingsNode;

    private TvShowUIModule() {
        ((AbstractTmmUIModule)this).listPanel = this.listPanel;
        this.detailPanel = new JPanel();
        this.detailPanel.setOpaque(false);
        this.detailPanel.setLayout((LayoutManager)new MigLayout("insets 0", "[grow]", "[grow]"));
        this.dataPanel = new JPanel();
        this.dataPanel.setOpaque(false);
        this.dataPanel.setLayout(new CardLayout());
        this.detailPanel.add((Component)this.dataPanel, "cell 0 0, grow");
        MainTabbedPane tvShowDetailPanel = new MainTabbedPane(){
            private static final long serialVersionUID = 3344548865608767661L;

            @Override
            public void updateUI() {
                this.putClientProperty("leftBorder", "half");
                this.putClientProperty("bottomBorder", Boolean.FALSE);
                super.updateUI();
            }
        };
        tvShowDetailPanel.add(BUNDLE.getString("metatag.details"), new TvShowInformationPanel(this.tvShowSelectionModel));
        tvShowDetailPanel.add(BUNDLE.getString("metatag.cast"), new TvShowCastPanel(this.tvShowSelectionModel));
        tvShowDetailPanel.add(BUNDLE.getString("metatag.mediafiles"), new TvShowMediaInformationPanel(this.tvShowSelectionModel));
        tvShowDetailPanel.add(BUNDLE.getString("metatag.artwork"), new TvShowArtworkPanel(this.tvShowSelectionModel));
        this.dataPanel.add((Component)tvShowDetailPanel, "tvShow");
        MainTabbedPane tvShowSeasonDetailPanel = new MainTabbedPane(){
            private static final long serialVersionUID = 3134567895608767661L;

            @Override
            public void updateUI() {
                this.putClientProperty("leftBorder", "half");
                this.putClientProperty("bottomBorder", Boolean.FALSE);
                super.updateUI();
            }
        };
        tvShowSeasonDetailPanel.add(BUNDLE.getString("metatag.details"), new TvShowSeasonInformationPanel(this.tvShowSeasonSelectionModel));
        tvShowSeasonDetailPanel.add(BUNDLE.getString("metatag.mediafiles"), new TvShowSeasonMediaFilesPanel(this.tvShowSeasonSelectionModel));
        this.dataPanel.add((Component)tvShowSeasonDetailPanel, "tvShowSeason");
        MainTabbedPane tvShowEpisodeDetailPanel = new MainTabbedPane(){
            private static final long serialVersionUID = 3344548905108767661L;

            @Override
            public void updateUI() {
                this.putClientProperty("leftBorder", "half");
                this.putClientProperty("bottomBorder", Boolean.FALSE);
                super.updateUI();
            }
        };
        tvShowEpisodeDetailPanel.add(BUNDLE.getString("metatag.details"), new TvShowEpisodeInformationPanel(this.tvShowEpisodeSelectionModel));
        tvShowEpisodeDetailPanel.add(BUNDLE.getString("metatag.cast"), new TvShowEpisodeCastPanel(this.tvShowEpisodeSelectionModel));
        tvShowEpisodeDetailPanel.add(BUNDLE.getString("metatag.mediafiles"), new TvShowEpisodeMediaInformationPanel(this.tvShowEpisodeSelectionModel));
        this.dataPanel.add((Component)tvShowEpisodeDetailPanel, "tvShowEpisode");
        this.tvShowFilterDialog = new TvShowFilterDialog(this.listPanel.getTreeTable());
        this.createActions();
        this.createPopupMenu();
        this.registerAccelerators();
        this.settingsNode = new TvShowSettingsNode();
        this.init();
    }

    private void init() {
        if (TvShowModuleManager.SETTINGS.isStoreUiFilters()) {
            SwingUtilities.invokeLater(() -> this.listPanel.getTreeTable().setFilterValues(TvShowModuleManager.SETTINGS.getUiFilters()));
        }
    }

    public static TvShowUIModule getInstance() {
        if (instance == null) {
            instance = new TvShowUIModule();
        }
        return instance;
    }

    public void setFilterDialogVisible(boolean selected) {
        this.tvShowFilterDialog.setVisible(selected);
    }

    @Override
    public String getModuleId() {
        return ID;
    }

    @Override
    public JPanel getTabPanel() {
        return this.listPanel;
    }

    @Override
    public String getTabTitle() {
        return BUNDLE.getString("tmm.tvshows");
    }

    public TvShowSelectionModel getSelectionModel() {
        return this.tvShowSelectionModel;
    }

    @Override
    public TmmSettingsNode getSettingsNode() {
        return this.settingsNode;
    }

    private void createActions() {
        this.searchAction = this.createAndRegisterAction(TvShowSingleScrapeAction.class);
        this.editAction = this.createAndRegisterAction(TvShowEditAction.class);
        this.updateAction = this.createAndRegisterAction(TvShowUpdateDatasourcesAction.class);
        this.renameAction = this.createAndRegisterAction(TvShowRenameAction.class);
    }

    private void createPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.createAndRegisterAction(TvShowSingleScrapeAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowSelectedScrapeAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowScrapeEpisodesAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowScrapeEpisodesWoArtworkAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowScrapeNewItemsAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowScrapeMissingEpisodesAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowMissingEpisodeListAction.class));
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.createAndRegisterAction(TvShowUpdateAction.class));
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.createAndRegisterAction(TvShowEditAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowBulkEditAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowChangeDatasourceAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowChangeSeasonArtworkAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowToggleWatchedFlagAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowRewriteNfoAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowReadNfoAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowRewriteEpisodeNfoAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowReadEpisodeNfoAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowRenameAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowMediaInformationAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowExportAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowCleanUpFilesAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowClearImageCacheAction.class));
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.createAndRegisterAction(TvShowDownloadMissingArtworkAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowSubtitleDownloadAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowSubtitleSearchAction.class));
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.createAndRegisterAction(TvShowSyncTraktTvAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowSyncWatchedTraktTvAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowSyncSelectedTraktTvAction.class));
        JMenu kodiRPCMenu = KodiRPCMenu.KodiMenuRightClickTvShows();
        this.popupMenu.add(kodiRPCMenu);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.createAndRegisterAction(TvShowRemoveAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowDeleteAction.class));
        if (Globals.isDebug()) {
            JMenu debugMenu = new JMenu("Debug");
            debugMenu.add(new DebugDumpShowAction());
            this.popupMenu.addSeparator();
            this.popupMenu.add(debugMenu);
        }
        this.listPanel.setPopupMenu(this.popupMenu);
        this.updatePopupMenu = new JPopupMenu();
        PopupMenuScroller.setScrollerFor(this.updatePopupMenu, 20, 25, 2, 2);
        this.updatePopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                TvShowUIModule.this.updatePopupMenu.removeAll();
                TvShowUIModule.this.updatePopupMenu.add(TvShowUIModule.this.createAndRegisterAction(TvShowUpdateDatasourcesAction.class));
                TvShowUIModule.this.updatePopupMenu.addSeparator();
                for (String ds : TvShowModuleManager.SETTINGS.getTvShowDataSource()) {
                    TvShowUIModule.this.updatePopupMenu.add(new TvShowUpdateSingleDatasourceAction(ds));
                }
                TvShowUIModule.this.updatePopupMenu.addSeparator();
                TvShowUIModule.this.updatePopupMenu.add(new TvShowUpdateAction());
                TvShowUIModule.this.updatePopupMenu.pack();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.searchPopupMenu = new JPopupMenu();
        this.searchPopupMenu.add(this.createAndRegisterAction(TvShowSingleScrapeAction.class));
        this.searchPopupMenu.add(this.createAndRegisterAction(TvShowSelectedScrapeAction.class));
        this.searchPopupMenu.add(this.createAndRegisterAction(TvShowScrapeEpisodesAction.class));
        this.searchPopupMenu.add(this.createAndRegisterAction(TvShowScrapeEpisodesWoArtworkAction.class));
        this.searchPopupMenu.add(this.createAndRegisterAction(TvShowScrapeNewItemsAction.class));
        this.searchPopupMenu.add(this.createAndRegisterAction(TvShowScrapeMissingEpisodesAction.class));
        this.editPopupMenu = new JPopupMenu();
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowEditAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowBulkEditAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowChangeDatasourceAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowChangeSeasonArtworkAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowToggleWatchedFlagAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowRewriteNfoAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowReadNfoAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowRewriteEpisodeNfoAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowReadEpisodeNfoAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowChangeToDvdOrderAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowChangeToAiredOrderAction.class));
        this.editPopupMenu.addSeparator();
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowExportAction.class));
        this.editPopupMenu.addSeparator();
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowCleanUpFilesAction.class));
    }

    public void setSelectedTvShow(TvShow tvShow) {
        this.tvShowSelectionModel.setSelectedTvShow(tvShow);
        CardLayout cl = (CardLayout)this.dataPanel.getLayout();
        cl.show(this.dataPanel, "tvShow");
    }

    public void setSelectedTvShowSeason(TvShowSeason tvShowSeason) {
        this.tvShowSeasonSelectionModel.setSelectedTvShowSeason(tvShowSeason);
        CardLayout cl = (CardLayout)this.dataPanel.getLayout();
        cl.show(this.dataPanel, "tvShowSeason");
    }

    public void setSelectedTvShowEpisode(TvShowEpisode tvShowEpisode) {
        this.tvShowEpisodeSelectionModel.setSelectedTvShowEpisode(tvShowEpisode);
        CardLayout cl = (CardLayout)this.dataPanel.getLayout();
        cl.show(this.dataPanel, "tvShowEpisode");
    }
}

