/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class DebugDumpShowAction
extends TmmAction {
    private static final long serialVersionUID = -8473181347332963044L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public DebugDumpShowAction() {
        this.putValue("Name", BUNDLE.getString("debug.entity.dump"));
        this.putValue("ShortDescription", BUNDLE.getString("debug.entity.dump.desc"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Object> selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        if (selectedObjects.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        HashSet<TvShow> shows = new HashSet<TvShow>();
        for (Object obj : selectedObjects) {
            if (obj instanceof TvShow) {
                TvShow tvShow = (TvShow)obj;
                shows.add(tvShow);
                continue;
            }
            if (obj instanceof TvShowSeason) {
                TvShowSeason season = (TvShowSeason)obj;
                shows.add(season.getTvShow());
                continue;
            }
            if (!(obj instanceof TvShowEpisode)) continue;
            TvShowEpisode tvShowEpisode = (TvShowEpisode)obj;
            shows.add(tvShowEpisode.getTvShow());
        }
        for (TvShow tvShow : shows) {
            TvShowModuleManager.getInstance().dump(tvShow);
        }
    }
}

