/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowBulkEditorDialog;

public class TvShowBulkEditAction
extends TmmAction {
    private static final long serialVersionUID = -1193886444149690516L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowBulkEditAction() {
        this.putValue("Name", BUNDLE.getString("tvshow.bulkedit"));
        this.putValue("ShortDescription", BUNDLE.getString("tvshow.bulkedit.desc"));
        this.putValue("SwingLargeIconKey", IconManager.EDIT);
        this.putValue("SmallIcon", IconManager.EDIT);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(66, 3));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Object> selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        ArrayList<TvShow> selectedTvShows = new ArrayList<TvShow>();
        ArrayList<TvShowEpisode> selectedEpisodes = new ArrayList<TvShowEpisode>();
        for (Object obj : selectedObjects) {
            if (obj instanceof TvShow) {
                TvShow tvShow = (TvShow)obj;
                selectedTvShows.add(tvShow);
            }
            if (!(obj instanceof TvShowEpisode)) continue;
            TvShowEpisode tvShowEpisode = (TvShowEpisode)obj;
            selectedEpisodes.add(tvShowEpisode);
        }
        if (selectedTvShows.isEmpty() && selectedEpisodes.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        TvShowBulkEditorDialog dialog = new TvShowBulkEditorDialog(selectedTvShows, selectedEpisodes);
        dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
        dialog.setVisible(true);
    }
}

