/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tasks.ImageCacheTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowRebuildImageCacheAction
extends TmmAction {
    private static final long serialVersionUID = 3452373237085274937L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowRebuildImageCacheAction() {
        this.putValue("Name", BUNDLE.getString("tvshow.rebuildimagecache"));
        this.putValue("ShortDescription", BUNDLE.getString("tvshow.rebuildimagecache"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        if (!Globals.settings.isImageCache()) {
            JOptionPane.showMessageDialog(null, BUNDLE.getString("tmm.imagecache.notactivated"));
            return;
        }
        List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShows();
        ArrayList<TvShowEpisode> selectedEpisodes = new ArrayList<TvShowEpisode>();
        for (Object object : TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects()) {
            TvShowEpisode episode;
            if (!(object instanceof TvShowEpisode) || selectedTvShows.contains((episode = (TvShowEpisode)object).getTvShow())) continue;
            selectedEpisodes.add(episode);
        }
        if (selectedEpisodes.isEmpty() && selectedTvShows.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        ArrayList<MediaFile> imageFiles = new ArrayList<MediaFile>();
        for (TvShow tvShow : selectedTvShows) {
            imageFiles.addAll(tvShow.getImagesToCache());
        }
        for (TvShowEpisode episode : selectedEpisodes) {
            imageFiles.addAll(episode.getImagesToCache());
        }
        ImageCacheTask imageCacheTask = new ImageCacheTask(imageFiles.stream().distinct().collect(Collectors.toList()));
        TmmTaskManager.getInstance().addUnnamedTask(imageCacheTask);
    }
}

