/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.tasks.TvShowEpisodeScrapeTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowChooserDialog;

public class TvShowScrapeNewItemsAction
extends TmmAction {
    private static final long serialVersionUID = -3365542777082781952L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowScrapeNewItemsAction() {
        this.putValue("Name", BUNDLE.getString("tvshow.scrape.newitems"));
        this.putValue("SwingLargeIconKey", IconManager.SEARCH);
        this.putValue("SmallIcon", IconManager.SEARCH);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 3));
    }

    @Override
    protected void processAction(ActionEvent e) {
        ArrayList<TvShow> newTvShows = new ArrayList<TvShow>();
        ArrayList<TvShowEpisode> newEpisodes = new ArrayList<TvShowEpisode>();
        for (TvShow tvShow : new ArrayList<TvShow>(TvShowList.getInstance().getTvShows())) {
            if (tvShow.isNewlyAdded() && !tvShow.isScraped()) {
                newTvShows.add(tvShow);
                continue;
            }
            for (TvShowEpisode episode : tvShow.getEpisodes()) {
                if (!episode.isNewlyAdded() || episode.isScraped()) continue;
                newEpisodes.add(episode);
            }
        }
        TvShowEpisodeScrapeTask task = new TvShowEpisodeScrapeTask(newEpisodes, TvShowList.getInstance().getDefaultMediaScraper(), TvShowModuleManager.SETTINGS.getScraperMetadataConfig());
        TmmTaskManager.getInstance().addUnnamedTask(task);
        if (newTvShows.size() > 0) {
            int count = newTvShows.size();
            int index = 0;
            do {
                TvShow tvShow = (TvShow)newTvShows.get(index);
                TvShowChooserDialog chooser = new TvShowChooserDialog(tvShow, index, count);
                chooser.setVisible(true);
                if (!chooser.isContinueQueue()) break;
                if (chooser.isNavigateBack()) {
                    --index;
                    continue;
                }
                ++index;
            } while (index < count);
        }
    }
}

