/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowChooserDialog;

public class TvShowSingleScrapeAction
extends TmmAction {
    private static final long serialVersionUID = 641704453374845709L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowSingleScrapeAction() {
        this.putValue("Name", BUNDLE.getString("tvshow.scrape.selected"));
        this.putValue("SwingLargeIconKey", IconManager.SEARCH);
        this.putValue("SmallIcon", IconManager.SEARCH);
        this.putValue("ShortDescription", BUNDLE.getString("tvshow.scrape.selected"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 3));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShows();
        int count = selectedTvShows.size();
        if (count == 0) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        int index = 0;
        do {
            TvShow tvShow = selectedTvShows.get(index);
            TvShowChooserDialog chooser = new TvShowChooserDialog(tvShow, index, count);
            chooser.setVisible(true);
            if (!chooser.isContinueQueue()) break;
            if (chooser.isNavigateBack()) {
                --index;
                continue;
            }
            ++index;
        } while (index < count);
    }
}

