/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.tasks.TvShowSubtitleSearchAndDownloadTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowDownloadSubtitleDialog;

public class TvShowSubtitleDownloadAction
extends TmmAction {
    private static final long serialVersionUID = -6002932119900795735L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowSubtitleDownloadAction() {
        this.putValue("Name", BUNDLE.getString("tvshow.download.subtitle"));
        this.putValue("SmallIcon", IconManager.SUBTITLE);
        this.putValue("SwingLargeIconKey", IconManager.SUBTITLE);
        this.putValue("ShortDescription", BUNDLE.getString("tvshow.download.subtitle"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<TvShowEpisode> episodes = TvShowUIModule.getInstance().getSelectionModel().getSelectedEpisodes();
        if (episodes.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        TvShowDownloadSubtitleDialog dialog = new TvShowDownloadSubtitleDialog(BUNDLE.getString("tvshow.download.subtitle"));
        dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
        dialog.setVisible(true);
        if (dialog.shouldStartDownload()) {
            TvShowSubtitleSearchAndDownloadTask task = new TvShowSubtitleSearchAndDownloadTask(episodes, dialog.getSubtitleScrapers(), dialog.getLanguage());
            TmmTaskManager.getInstance().addMainTask(task);
        }
    }
}

