/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.combobox.MediaScraperCheckComboBox;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class TvShowDownloadSubtitleDialog
extends TmmDialog {
    private static final long serialVersionUID = 3826984454317879241L;
    private final TvShowList tvShowList = TvShowList.getInstance();
    private MediaScraperCheckComboBox cbSubtitleScraper;
    private JComboBox<MediaLanguages> cbLanguage;
    private boolean startDownload = false;

    public TvShowDownloadSubtitleDialog(String title) {
        super(title, "downloadSubtitle");
        JPanel panelCenter = new JPanel();
        this.getContentPane().add((Component)panelCenter, "Center");
        panelCenter.setLayout((LayoutManager)new MigLayout("", "[][300lp]", "[][][20lp:n][]"));
        TmmLabel lblScraper = new TmmLabel(BUNDLE.getString("scraper"));
        panelCenter.add((Component)lblScraper, "cell 0 0");
        this.cbSubtitleScraper = new MediaScraperCheckComboBox(this.tvShowList.getAvailableSubtitleScrapers());
        panelCenter.add((Component)this.cbSubtitleScraper, "cell 1 0,growx");
        TmmLabel lblLanguage = new TmmLabel(BUNDLE.getString("metatag.language"));
        panelCenter.add((Component)lblLanguage, "cell 0 1");
        this.cbLanguage = new JComboBox<MediaLanguages>(MediaLanguages.valuesSorted());
        panelCenter.add(this.cbLanguage, "cell 1 1,growx");
        this.cbLanguage.setSelectedItem(TvShowModuleManager.SETTINGS.getSubtitleScraperLanguage());
        ReadOnlyTextArea taHint = new ReadOnlyTextArea(BUNDLE.getString("tvshow.download.subtitles.hint"));
        taHint.setOpaque(false);
        panelCenter.add((Component)taHint, "cell 0 3 2 1,growx");
        JButton btnCancel = new JButton(BUNDLE.getString("Button.cancel"));
        btnCancel.setIcon(IconManager.CANCEL_INV);
        btnCancel.addActionListener(e -> {
            this.startDownload = false;
            this.setVisible(false);
        });
        this.addButton(btnCancel);
        JButton btnStart = new JButton(BUNDLE.getString("scraper.start"));
        btnStart.setIcon(IconManager.APPLY_INV);
        btnStart.addActionListener(e -> {
            this.startDownload = true;
            this.setVisible(false);
        });
        this.addDefaultButton(btnStart);
        ArrayList<MediaScraper> selectedSubtitleScrapers = new ArrayList<MediaScraper>();
        for (MediaScraper subtitleScraper : this.tvShowList.getAvailableSubtitleScrapers()) {
            if (!TvShowModuleManager.SETTINGS.getSubtitleScrapers().contains(subtitleScraper.getId())) continue;
            selectedSubtitleScrapers.add(subtitleScraper);
        }
        if (!selectedSubtitleScrapers.isEmpty()) {
            this.cbSubtitleScraper.setSelectedItems(selectedSubtitleScrapers);
        }
    }

    public List<MediaScraper> getSubtitleScrapers() {
        return new ArrayList<MediaScraper>(this.cbSubtitleScraper.getSelectedItems());
    }

    public MediaLanguages getLanguage() {
        return (MediaLanguages)this.cbLanguage.getSelectedItem();
    }

    public boolean shouldStartDownload() {
        return this.startDownload;
    }
}

