/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.entities.Rating;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.exceptions.UnsupportedMediaTypeException;
import org.tinymediamanager.scraper.mediaprovider.ITvShowMetadataProvider;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.ShadowLayerUI;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UIConstants;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.MainTabbedPane;
import org.tinymediamanager.ui.components.MediaRatingTable;
import org.tinymediamanager.ui.components.PersonTable;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.combobox.AutocompleteComboBox;
import org.tinymediamanager.ui.components.combobox.MediaScraperComboBox;
import org.tinymediamanager.ui.components.datepicker.DatePicker;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.dialogs.PersonEditorDialog;
import org.tinymediamanager.ui.dialogs.RatingEditorDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.panels.MediaFileEditorPanel;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowEpisodeChooserDialog;

public class TvShowEpisodeEditorDialog
extends TmmDialog {
    private static final long serialVersionUID = 7702248909791283043L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowEpisodeEditorDialog.class);
    private static final Insets BUTTON_MARGIN = UIConstants.SMALL_BUTTON_MARGIN;
    private static final String DIALOG_ID = "tvShowEpisodeEditor";
    private TvShowList tvShowList = TvShowList.getInstance();
    private TvShowEpisode episodeToEdit;
    private List<String> tags = ObservableCollections.observableList(new ArrayList());
    private List<MediaFile> mediaFiles = new ArrayList<MediaFile>();
    private Rating userRating;
    private boolean continueQueue = true;
    private boolean navigateBack = false;
    private int queueIndex;
    private int queueSize;
    private EventList<MediaRatingTable.MediaRating> ratings = new BasicEventList();
    private EventList<Person> guests = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(Person.class));
    private EventList<Person> directors = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(Person.class));
    private EventList<Person> writers = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(Person.class));
    private JTextField tfTitle;
    private JSpinner spEpisode;
    private JSpinner spSeason;
    private JSpinner spRating;
    private JSpinner spDvdSeason;
    private JSpinner spDvdEpisode;
    private JCheckBox cbDvdOrder;
    private JSpinner spDisplaySeason;
    private JSpinner spDisplayEpisode;
    private DatePicker dpFirstAired;
    private JSpinner spDateAdded;
    private JCheckBox chckbxWatched;
    private ImageLabel lblThumb;
    private JTextArea taPlot;
    private AutocompleteComboBox<String> cbTags;
    private AutoCompleteSupport<String> cbTagsAutoCompleteSupport;
    private JList<String> listTags;
    private AutocompleteComboBox<MediaSource> cbMediaSource;
    private MediaFileEditorPanel mediaFilesPanel;
    private MediaScraperComboBox cbScraper;
    private TmmTable tableRatings;
    private TmmTable tableGuests;
    private TmmTable tableDirectors;
    private TmmTable tableWriters;
    private JTextField tfOriginalTitle;
    private JTextField tfThumb;
    private JTextField tfNote;

    public TvShowEpisodeEditorDialog(TvShowEpisode episode, int queueIndex, int queueSize) {
        super(BUNDLE.getString("tvshowepisode.edit") + "  < " + episode.getMainVideoFile().getFilename() + " >", DIALOG_ID);
        for (MediaFile mf : episode.getMediaFiles()) {
            this.mediaFiles.add(new MediaFile(mf));
        }
        this.episodeToEdit = episode;
        this.queueIndex = queueIndex;
        this.queueSize = queueSize;
        this.ratings = MediaRatingTable.convertRatingMapToEventList(episode.getRatings(), false);
        this.userRating = this.episodeToEdit.getRating("user");
        this.initComponents();
        this.bindingGroup = this.initDataBindings();
        this.tfTitle.setText(this.episodeToEdit.getTitle());
        this.tfOriginalTitle.setText(this.episodeToEdit.getOriginalTitle());
        this.cbDvdOrder.setSelected(this.episodeToEdit.isDvdOrder());
        this.spSeason.setModel(new SpinnerNumberModel(this.episodeToEdit.getAiredSeason(), -1, 9999, 1));
        this.spEpisode.setModel(new SpinnerNumberModel(this.episodeToEdit.getAiredEpisode(), -1, 9999, 1));
        this.spDvdSeason.setModel(new SpinnerNumberModel(this.episodeToEdit.getDvdSeason(), -1, 9999, 1));
        this.spDvdEpisode.setModel(new SpinnerNumberModel(this.episodeToEdit.getDvdEpisode(), -1, 9999, 1));
        this.spDisplaySeason.setModel(new SpinnerNumberModel(this.episodeToEdit.getDisplaySeason(), -1, 9999, 1));
        this.spDisplayEpisode.setModel(new SpinnerNumberModel(this.episodeToEdit.getDisplayEpisode(), -1, 9999, 1));
        this.spDateAdded.setValue(this.episodeToEdit.getDateAdded());
        this.spRating.setModel(new SpinnerNumberModel(this.userRating.getRating(), 0.0, 10.0, 0.1));
        this.lblThumb.setImagePath(this.episodeToEdit.getArtworkFilename(MediaFileType.THUMB));
        this.tfThumb.setText(this.episodeToEdit.getArtworkUrl(MediaFileType.THUMB));
        this.chckbxWatched.setSelected(this.episodeToEdit.isWatched());
        this.taPlot.setText(this.episodeToEdit.getPlot());
        this.taPlot.setCaretPosition(0);
        this.cbMediaSource.setSelectedItem((Object)this.episodeToEdit.getMediaSource());
        this.tfNote.setText(this.episodeToEdit.getNote());
        for (Person origCast : this.episodeToEdit.getGuests()) {
            this.guests.add((Object)new Person(origCast));
        }
        for (Person director : this.episodeToEdit.getDirectors()) {
            this.directors.add((Object)new Person(director));
        }
        for (Person writer : this.episodeToEdit.getWriters()) {
            this.writers.add((Object)new Person(writer));
        }
        this.tags.addAll(this.episodeToEdit.getTags());
    }

    private void initComponents() {
        MainTabbedPane tabbedPane = new MainTabbedPane(){
            private static final long serialVersionUID = 71548865608767532L;

            @Override
            public void updateUI() {
                this.putClientProperty("bottomBorder", Boolean.FALSE);
                super.updateUI();
            }
        };
        JLayer<JComponent> rootLayer = new JLayer<JComponent>(tabbedPane, new ShadowLayerUI());
        this.getContentPane().add(rootLayer, "Center");
        JPanel detailsPanel = new JPanel();
        tabbedPane.addTab(BUNDLE.getString("metatag.details"), detailsPanel);
        detailsPanel.setLayout((LayoutManager)new MigLayout("", "[][20lp:75lp,grow][50lp:75lp][][60lp:75lp][50lp:75lp][20lp:n][][25lp:n][200lp:250lp,grow]", "[][][][][][][100lp:125lp,grow][][][][100lp][pref:pref:pref][]"));
        TmmLabel lblTitle = new TmmLabel(BUNDLE.getString("metatag.title"));
        detailsPanel.add((Component)lblTitle, "cell 0 0,alignx right");
        this.tfTitle = new JTextField();
        detailsPanel.add((Component)this.tfTitle, "flowx,cell 1 0 7 1,growx");
        JButton btnPlay = new JButton(IconManager.PLAY_INV);
        btnPlay.setFocusable(false);
        btnPlay.addActionListener(e -> {
            MediaFile mf = this.episodeToEdit.getMainVideoFile();
            try {
                TmmUIHelper.openFile(mf.getFileAsPath());
            }
            catch (Exception ex) {
                LOGGER.error("open file - {}", (Object)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)mf, "message.erroropenfile", new String[]{":", ex.getLocalizedMessage()}));
            }
        });
        detailsPanel.add((Component)btnPlay, "cell 1 0 7 1");
        TmmLabel lblOriginalTitleT = new TmmLabel(BUNDLE.getString("metatag.originaltitle"));
        detailsPanel.add((Component)lblOriginalTitleT, "cell 0 1,alignx trailing");
        this.tfOriginalTitle = new JTextField();
        detailsPanel.add((Component)this.tfOriginalTitle, "cell 1 1 7 1,growx");
        TmmLabel lblSeason = new TmmLabel(BUNDLE.getString("metatag.season"));
        detailsPanel.add((Component)lblSeason, "cell 0 2,alignx right");
        this.spSeason = new JSpinner();
        detailsPanel.add((Component)this.spSeason, "cell 1 2,growx");
        TmmLabel lblEpisode = new TmmLabel(BUNDLE.getString("metatag.episode"));
        detailsPanel.add((Component)lblEpisode, "cell 3 2,alignx right");
        this.spEpisode = new JSpinner();
        detailsPanel.add((Component)this.spEpisode, "cell 4 2,growx");
        TmmLabel lblFirstAired = new TmmLabel(BUNDLE.getString("metatag.aired"));
        detailsPanel.add((Component)lblFirstAired, "cell 0 3,alignx right");
        this.dpFirstAired = new DatePicker(this.episodeToEdit.getFirstAired());
        detailsPanel.add((Component)this.dpFirstAired, "cell 1 3 2 1,growx");
        TmmLabel lblDvdSeason = new TmmLabel(BUNDLE.getString("metatag.dvdseason"));
        detailsPanel.add((Component)lblDvdSeason, "cell 0 4,alignx right,aligny center");
        this.spDvdSeason = new JSpinner();
        detailsPanel.add((Component)this.spDvdSeason, "cell 1 4,growx");
        TmmLabel lblDvdEpisode = new TmmLabel(BUNDLE.getString("metatag.dvdepisode"));
        detailsPanel.add((Component)lblDvdEpisode, "cell 3 4,alignx right");
        this.spDvdEpisode = new JSpinner();
        detailsPanel.add((Component)this.spDvdEpisode, "cell 4 4,growx");
        TmmLabel lblDvdOrder = new TmmLabel(BUNDLE.getString("metatag.dvdorder"));
        detailsPanel.add((Component)lblDvdOrder, "flowx,cell 6 4 2 1");
        this.cbDvdOrder = new JCheckBox("");
        detailsPanel.add((Component)this.cbDvdOrder, "cell 6 4 2 1");
        TmmLabel lblDisplaySeason = new TmmLabel(BUNDLE.getString("metatag.displayseason"));
        detailsPanel.add((Component)lblDisplaySeason, "cell 0 5,alignx right");
        this.spDisplaySeason = new JSpinner();
        detailsPanel.add((Component)this.spDisplaySeason, "cell 1 5,growx");
        TmmLabel lblDisplayEpisode = new TmmLabel(BUNDLE.getString("metatag.displayepisode"));
        detailsPanel.add((Component)lblDisplayEpisode, "cell 3 5,alignx right");
        this.spDisplayEpisode = new JSpinner();
        detailsPanel.add((Component)this.spDisplayEpisode, "cell 4 5,growx");
        TmmLabel lblPlot = new TmmLabel(BUNDLE.getString("metatag.plot"));
        detailsPanel.add((Component)lblPlot, "cell 0 6,alignx right,aligny top");
        JScrollPane scrollPane = new JScrollPane();
        detailsPanel.add((Component)scrollPane, "cell 1 6 7 1,grow");
        this.taPlot = new JTextArea();
        this.taPlot.setLineWrap(true);
        this.taPlot.setWrapStyleWord(true);
        scrollPane.setViewportView(this.taPlot);
        this.lblThumb = new ImageLabel();
        this.lblThumb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String path = TmmProperties.getInstance().getProperty("tvShowEpisodeEditor.path");
                Path file = TmmUIHelper.selectFile(BUNDLE.getString("image.choose"), path);
                if (file != null && Utils.isRegularFile(file)) {
                    String fileName = file.toAbsolutePath().toString();
                    TmmProperties.getInstance().putProperty("tvShowEpisodeEditor.path", fileName);
                    TvShowEpisodeEditorDialog.this.lblThumb.setImageUrl("file:/" + fileName);
                    TvShowEpisodeEditorDialog.this.tfThumb.setText(TvShowEpisodeEditorDialog.this.lblThumb.getImageUrl());
                }
            }
        });
        this.lblThumb.setCursor(Cursor.getPredefinedCursor(12));
        detailsPanel.add((Component)this.lblThumb, "cell 9 0 1 7,grow");
        TmmLabel lblRating = new TmmLabel(BUNDLE.getString("metatag.userrating"));
        detailsPanel.add((Component)lblRating, "cell 0 9,alignx right");
        this.spRating = new JSpinner();
        detailsPanel.add((Component)this.spRating, "cell 1 9,growx");
        TmmLabel lblRatingsT = new TmmLabel(BUNDLE.getString("metatag.ratings"));
        detailsPanel.add((Component)lblRatingsT, "flowy,cell 0 10,alignx right,aligny top");
        JScrollPane scrollPaneRatings = new JScrollPane();
        detailsPanel.add((Component)scrollPaneRatings, "cell 1 10 5 2,grow");
        this.tableRatings = new MediaRatingTable(this.ratings);
        this.tableRatings.configureScrollPane(scrollPaneRatings);
        scrollPaneRatings.setViewportView(this.tableRatings);
        JButton btnAddRating = new JButton(new AddRatingAction());
        btnAddRating.setMargin(BUTTON_MARGIN);
        detailsPanel.add((Component)btnAddRating, "cell 0 10,alignx right,aligny top");
        JButton btnRemoveRating = new JButton(new RemoveRatingAction());
        btnRemoveRating.setMargin(BUTTON_MARGIN);
        detailsPanel.add((Component)btnRemoveRating, "cell 0 10,alignx right,aligny top");
        TmmLabel lblNoteT = new TmmLabel(BUNDLE.getString("metatag.note"));
        detailsPanel.add((Component)lblNoteT, "cell 0 12,alignx trailing");
        this.tfNote = new JTextField();
        detailsPanel.add((Component)this.tfNote, "cell 1 12 7 1,growx");
        JPanel details2Panel = new JPanel();
        tabbedPane.addTab(BUNDLE.getString("metatag.details2"), details2Panel);
        details2Panel.setLayout((LayoutManager)new MigLayout("", "[][][100lp:150lp][20lp:50lp,grow]", "[][][][20lp:n][][20lp:n][100lp:150lp,grow][][grow 200]"));
        TmmLabel lblDateAdded = new TmmLabel(BUNDLE.getString("metatag.dateadded"));
        details2Panel.add((Component)lblDateAdded, "cell 0 0,alignx right");
        this.spDateAdded = new JSpinner(new SpinnerDateModel());
        details2Panel.add((Component)this.spDateAdded, "cell 1 0,growx");
        TmmLabel lblWatched = new TmmLabel(BUNDLE.getString("metatag.watched"));
        details2Panel.add((Component)lblWatched, "cell 0 1,alignx right");
        this.chckbxWatched = new JCheckBox("");
        details2Panel.add((Component)this.chckbxWatched, "cell 1 1");
        TmmLabel lblMediasource = new TmmLabel(BUNDLE.getString("metatag.source"));
        details2Panel.add((Component)lblMediasource, "cell 0 2,alignx right");
        this.cbMediaSource = new AutocompleteComboBox<MediaSource>(MediaSource.values());
        details2Panel.add(this.cbMediaSource, "cell 1 2,growx");
        TmmLabel lblThumbT = new TmmLabel(BUNDLE.getString("mediafiletype.thumb"));
        details2Panel.add((Component)lblThumbT, "cell 0 4,alignx right");
        this.tfThumb = new JTextField();
        details2Panel.add((Component)this.tfThumb, "cell 1 4 3 1,growx");
        this.tfThumb.setColumns(10);
        TmmLabel lblTags = new TmmLabel(BUNDLE.getString("metatag.tags"));
        details2Panel.add((Component)lblTags, "flowy,cell 0 6,alignx right,aligny top");
        JScrollPane scrollPaneTags = new JScrollPane();
        details2Panel.add((Component)scrollPaneTags, "cell 1 6 2 1,grow");
        this.listTags = new JList();
        scrollPaneTags.setViewportView(this.listTags);
        JButton btnAddTag = new JButton(new AddTagAction());
        btnAddTag.setMargin(BUTTON_MARGIN);
        details2Panel.add((Component)btnAddTag, "cell 0 6 1 3,alignx right,aligny top");
        JButton btnRemoveTag = new JButton(new RemoveTagAction());
        btnRemoveTag.setMargin(BUTTON_MARGIN);
        details2Panel.add((Component)btnRemoveTag, "cell 0 6 1 3,alignx right,aligny top");
        JButton btnMoveTagUp = new JButton(new MoveTagUpAction());
        btnMoveTagUp.setMargin(BUTTON_MARGIN);
        details2Panel.add((Component)btnMoveTagUp, "cell 0 6 1 3,alignx right,aligny top");
        JButton btnMoveTagDown = new JButton(new MoveTagDownAction());
        btnMoveTagDown.setMargin(BUTTON_MARGIN);
        details2Panel.add((Component)btnMoveTagDown, "cell 0 6 1 3,alignx right,aligny top");
        this.cbTags = new AutocompleteComboBox<String>(this.tvShowList.getTagsInEpisodes());
        this.cbTags.setEditable(true);
        this.cbTagsAutoCompleteSupport = this.cbTags.getAutoCompleteSupport();
        InputMap im = this.cbTags.getInputMap(1);
        Object enterAction = im.get(KeyStroke.getKeyStroke(10, 0));
        this.cbTags.getActionMap().put(enterAction, new AddTagAction());
        details2Panel.add(this.cbTags, "cell 1 7 2 1,growx");
        JPanel crewPanel = new JPanel();
        tabbedPane.addTab(BUNDLE.getString("movie.edit.castandcrew"), null, crewPanel, null);
        crewPanel.setLayout((LayoutManager)new MigLayout("", "[][150lp:300lp,grow][20lp:n][][150lp:300lp,grow]", "[100lp:250lp][20lp:n][100lp:200lp]"));
        TmmLabel lblGuests = new TmmLabel(BUNDLE.getString("metatag.guests"));
        crewPanel.add((Component)lblGuests, "flowy,cell 0 0,alignx right,aligny top");
        scrollPane = new JScrollPane();
        crewPanel.add((Component)scrollPane, "cell 1 0,grow");
        this.tableGuests = new PersonTable(this.guests, true);
        this.tableGuests.configureScrollPane(scrollPane);
        TmmLabel lblDirectorsT = new TmmLabel(BUNDLE.getString("metatag.directors"));
        crewPanel.add((Component)lblDirectorsT, "flowy,cell 0 2,alignx right,aligny top");
        scrollPane = new JScrollPane();
        crewPanel.add((Component)scrollPane, "cell 1 2,grow");
        this.tableDirectors = new PersonTable(this.directors, true);
        this.tableDirectors.configureScrollPane(scrollPane);
        TmmLabel lblWritersT = new TmmLabel(BUNDLE.getString("metatag.writers"));
        crewPanel.add((Component)lblWritersT, "flowy,cell 3 2,alignx right,aligny top");
        scrollPane = new JScrollPane();
        crewPanel.add((Component)scrollPane, "cell 4 2,grow");
        this.tableWriters = new PersonTable(this.writers, true);
        this.tableWriters.configureScrollPane(scrollPane);
        JButton btnAddGuest = new JButton(new AddGuestAction());
        btnAddGuest.setMargin(BUTTON_MARGIN);
        crewPanel.add((Component)btnAddGuest, "cell 0 0,alignx right");
        JButton btnRemoveGuest = new JButton(new RemoveGuestAction());
        btnRemoveGuest.setMargin(BUTTON_MARGIN);
        crewPanel.add((Component)btnRemoveGuest, "cell 0 0,alignx right");
        JButton btnMoveGuestUp = new JButton(new MoveGuestUpAction());
        btnMoveGuestUp.setMargin(BUTTON_MARGIN);
        crewPanel.add((Component)btnMoveGuestUp, "cell 0 0,alignx right");
        JButton btnMoveGuestDown = new JButton(new MoveGuestDownAction());
        btnMoveGuestDown.setMargin(BUTTON_MARGIN);
        crewPanel.add((Component)btnMoveGuestDown, "cell 0 0,alignx right,aligny top");
        JButton btnAddDirector = new JButton(new AddDirectorAction());
        btnAddDirector.setMargin(BUTTON_MARGIN);
        crewPanel.add((Component)btnAddDirector, "cell 0 2,alignx right");
        JButton btnRemoveDirector = new JButton(new RemoveDirectorAction());
        btnRemoveDirector.setMargin(BUTTON_MARGIN);
        crewPanel.add((Component)btnRemoveDirector, "cell 0 2,alignx right");
        JButton btnMoveDirectorUp = new JButton(new MoveDirectorUpAction());
        btnMoveDirectorUp.setMargin(BUTTON_MARGIN);
        crewPanel.add((Component)btnMoveDirectorUp, "cell 0 2,alignx right");
        JButton btnMoveDirectorDown = new JButton(new MoveDirectorDownAction());
        btnMoveDirectorDown.setMargin(BUTTON_MARGIN);
        crewPanel.add((Component)btnMoveDirectorDown, "cell 0 2,alignx right,aligny top");
        JButton btnAddWriter = new JButton(new AddWriterAction());
        btnAddWriter.setMargin(BUTTON_MARGIN);
        crewPanel.add((Component)btnAddWriter, "cell 3 2,alignx right");
        JButton btnRemoveWriter = new JButton(new RemoveWriterAction());
        btnRemoveWriter.setMargin(BUTTON_MARGIN);
        crewPanel.add((Component)btnRemoveWriter, "cell 3 2,alignx right");
        JButton btnMoveWriterUp = new JButton(new MoveWriterUpAction());
        btnMoveWriterUp.setMargin(BUTTON_MARGIN);
        crewPanel.add((Component)btnMoveWriterUp, "cell 3 2,alignx right");
        JButton btnMoveWriterDown = new JButton(new MoveWriterDownAction());
        btnMoveWriterDown.setMargin(BUTTON_MARGIN);
        crewPanel.add((Component)btnMoveWriterDown, "cell 3 2,alignx right,aligny top");
        this.mediaFilesPanel = new MediaFileEditorPanel(this.mediaFiles);
        tabbedPane.addTab(BUNDLE.getString("metatag.mediafiles"), null, this.mediaFilesPanel, null);
        JPanel scrapePanel = new JPanel();
        scrapePanel.setOpaque(false);
        this.cbScraper = new MediaScraperComboBox(this.tvShowList.getAvailableMediaScrapers());
        MediaScraper defaultScraper = this.tvShowList.getDefaultMediaScraper();
        scrapePanel.setLayout((LayoutManager)new MigLayout("", "[][][][grow]", "[]"));
        this.cbScraper.setSelectedItem(defaultScraper);
        scrapePanel.add((Component)this.cbScraper, "cell 0 0");
        JButton btnScrape = new JButton(new ScrapeAction());
        scrapePanel.add((Component)btnScrape, "cell 1 0");
        JButton btnSearch = new JButton(new SearchAction());
        scrapePanel.add((Component)btnSearch, "cell 2 0");
        this.setBottomInformationPanel(scrapePanel);
        if (this.queueSize > 1) {
            JButton abortButton = new JButton(new AbortQueueAction());
            this.addButton(abortButton);
            if (this.queueIndex > 0) {
                JButton backButton = new JButton(new NavigateBackAction());
                this.addButton(backButton);
            }
        }
        JButton cancelButton = new JButton(new DiscardAction());
        this.addButton(cancelButton);
        JButton okButton = new JButton(new ChangeEpisodeAction());
        this.addDefaultButton(okButton);
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.continueQueue;
    }

    protected BindingGroup initDataBindings() {
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.tags, this.listTags);
        jListBinding.bind();
        BindingGroup bindingGroup = new BindingGroup();
        bindingGroup.addBinding((Binding)jListBinding);
        return bindingGroup;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mediaFilesPanel.unbindBindings();
        this.dpFirstAired.cleanup();
    }

    public boolean isContinueQueue() {
        return this.continueQueue;
    }

    public boolean isNavigateBack() {
        return this.navigateBack;
    }

    private class NavigateBackAction
    extends AbstractAction {
        private static final long serialVersionUID = -1652218154720642310L;

        public NavigateBackAction() {
            this.putValue("Name", BUNDLE.getString("Button.back"));
            this.putValue("SmallIcon", IconManager.BACK_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEpisodeEditorDialog.this.navigateBack = true;
            TvShowEpisodeEditorDialog.this.setVisible(false);
        }
    }

    private class MoveWriterDownAction
    extends AbstractAction {
        private static final long serialVersionUID = -6564146895819191932L;

        MoveWriterDownAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.movewriterdown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableWriters.getSelectedRow();
            if (row < TvShowEpisodeEditorDialog.this.writers.size() - 1) {
                Collections.rotate(TvShowEpisodeEditorDialog.this.writers.subList(row, row + 2), -1);
                TvShowEpisodeEditorDialog.this.tableWriters.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class MoveWriterUpAction
    extends AbstractAction {
        private static final long serialVersionUID = 5775423424097844658L;

        MoveWriterUpAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.movewriterup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableWriters.getSelectedRow();
            if (row > 0) {
                Collections.rotate(TvShowEpisodeEditorDialog.this.writers.subList(row - 1, row + 1), 1);
                TvShowEpisodeEditorDialog.this.tableWriters.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class RemoveWriterAction
    extends AbstractAction {
        private static final long serialVersionUID = -7079826920821356196L;

        RemoveWriterAction() {
            this.putValue("ShortDescription", BUNDLE.getString("cast.writer.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableWriters.getSelectedRow();
            if (row > -1) {
                row = TvShowEpisodeEditorDialog.this.tableWriters.convertRowIndexToModel(row);
                TvShowEpisodeEditorDialog.this.writers.remove(row);
            }
        }
    }

    private class AddWriterAction
    extends AbstractAction {
        private static final long serialVersionUID = -8929331442958057771L;

        AddWriterAction() {
            this.putValue("ShortDescription", BUNDLE.getString("cast.writer.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Person person = new Person(Person.Type.DIRECTOR, BUNDLE.getString("writer.name.unknown"), "Writer");
            PersonEditorDialog dialog = new PersonEditorDialog(SwingUtilities.getWindowAncestor(TvShowEpisodeEditorDialog.this.tableWriters), BUNDLE.getString("cast.writer.add"), person);
            dialog.setVisible(true);
            if (StringUtils.isNotBlank((CharSequence)person.getName()) && !person.getName().equals(BUNDLE.getString("writer.name.unknown"))) {
                TvShowEpisodeEditorDialog.this.writers.add(0, (Object)person);
            }
        }
    }

    private class MoveDirectorDownAction
    extends AbstractAction {
        private static final long serialVersionUID = -6564146895819191932L;

        MoveDirectorDownAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.movedirectordown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableDirectors.getSelectedRow();
            if (row < TvShowEpisodeEditorDialog.this.directors.size() - 1) {
                Collections.rotate(TvShowEpisodeEditorDialog.this.directors.subList(row, row + 2), -1);
                TvShowEpisodeEditorDialog.this.tableDirectors.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class MoveDirectorUpAction
    extends AbstractAction {
        private static final long serialVersionUID = 5775423424097844658L;

        MoveDirectorUpAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.movedirectorup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableDirectors.getSelectedRow();
            if (row > 0) {
                Collections.rotate(TvShowEpisodeEditorDialog.this.directors.subList(row - 1, row + 1), 1);
                TvShowEpisodeEditorDialog.this.tableDirectors.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class RemoveDirectorAction
    extends AbstractAction {
        private static final long serialVersionUID = -7079826920821356196L;

        RemoveDirectorAction() {
            this.putValue("ShortDescription", BUNDLE.getString("cast.director.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableDirectors.getSelectedRow();
            if (row > -1) {
                row = TvShowEpisodeEditorDialog.this.tableDirectors.convertRowIndexToModel(row);
                TvShowEpisodeEditorDialog.this.directors.remove(row);
            }
        }
    }

    private class AddDirectorAction
    extends AbstractAction {
        private static final long serialVersionUID = -8929331442958057771L;

        AddDirectorAction() {
            this.putValue("ShortDescription", BUNDLE.getString("cast.director.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Person person = new Person(Person.Type.DIRECTOR, BUNDLE.getString("director.name.unknown"), "Director");
            PersonEditorDialog dialog = new PersonEditorDialog(SwingUtilities.getWindowAncestor(TvShowEpisodeEditorDialog.this.tableDirectors), BUNDLE.getString("cast.director.add"), person);
            dialog.setVisible(true);
            if (StringUtils.isNotBlank((CharSequence)person.getName()) && !person.getName().equals(BUNDLE.getString("director.name.unknown"))) {
                TvShowEpisodeEditorDialog.this.directors.add(0, (Object)person);
            }
        }
    }

    private class MoveGuestDownAction
    extends AbstractAction {
        private static final long serialVersionUID = -6564146895819191932L;

        MoveGuestDownAction() {
            this.putValue("ShortDescription", BUNDLE.getString("cast.guest.movedown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableGuests.getSelectedRow();
            if (row < TvShowEpisodeEditorDialog.this.guests.size() - 1) {
                Collections.rotate(TvShowEpisodeEditorDialog.this.guests.subList(row, row + 2), -1);
                TvShowEpisodeEditorDialog.this.tableGuests.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class MoveGuestUpAction
    extends AbstractAction {
        private static final long serialVersionUID = 5775423424097844658L;

        MoveGuestUpAction() {
            this.putValue("ShortDescription", BUNDLE.getString("cast.guest.moveup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableGuests.getSelectedRow();
            if (row > 0) {
                Collections.rotate(TvShowEpisodeEditorDialog.this.guests.subList(row - 1, row + 1), 1);
                TvShowEpisodeEditorDialog.this.tableGuests.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class RemoveGuestAction
    extends AbstractAction {
        private static final long serialVersionUID = 6970920169867315771L;

        RemoveGuestAction() {
            this.putValue("ShortDescription", BUNDLE.getString("cast.guest.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableGuests.getSelectedRow();
            if (row > -1) {
                row = TvShowEpisodeEditorDialog.this.tableGuests.convertRowIndexToModel(row);
                TvShowEpisodeEditorDialog.this.guests.remove(row);
            }
        }
    }

    private class AddGuestAction
    extends AbstractAction {
        private static final long serialVersionUID = -5879601617842300526L;

        AddGuestAction() {
            this.putValue("ShortDescription", BUNDLE.getString("cast.guest.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Person actor = new Person(Person.Type.ACTOR, BUNDLE.getString("cast.actor.unknown"), BUNDLE.getString("cast.role.unknown"));
            PersonEditorDialog dialog = new PersonEditorDialog(SwingUtilities.getWindowAncestor(TvShowEpisodeEditorDialog.this.tableGuests), BUNDLE.getString("cast.guest.add"), actor);
            dialog.setVisible(true);
            if (StringUtils.isNotBlank((CharSequence)actor.getName()) && !actor.getName().equals(BUNDLE.getString("cast.actor.unknown"))) {
                TvShowEpisodeEditorDialog.this.guests.add(0, (Object)actor);
            }
        }
    }

    private class MoveTagDownAction
    extends AbstractAction {
        private static final long serialVersionUID = -1135108943010008069L;

        MoveTagDownAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.movetagdown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.listTags.getSelectedIndex();
            if (row < TvShowEpisodeEditorDialog.this.tags.size() - 1) {
                Collections.rotate(TvShowEpisodeEditorDialog.this.tags.subList(row, row + 2), -1);
                TvShowEpisodeEditorDialog.this.listTags.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class MoveTagUpAction
    extends AbstractAction {
        private static final long serialVersionUID = -6855661707692602266L;

        MoveTagUpAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.movetagup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.listTags.getSelectedIndex();
            if (row > 0) {
                Collections.rotate(TvShowEpisodeEditorDialog.this.tags.subList(row - 1, row + 1), 1);
                TvShowEpisodeEditorDialog.this.listTags.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class RemoveTagAction
    extends AbstractAction {
        private static final long serialVersionUID = -4799506776650330500L;

        RemoveTagAction() {
            this.putValue("ShortDescription", BUNDLE.getString("tag.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List selectedTags = TvShowEpisodeEditorDialog.this.listTags.getSelectedValuesList();
            for (String tag : selectedTags) {
                TvShowEpisodeEditorDialog.this.tags.remove(tag);
            }
        }
    }

    private class AddTagAction
    extends AbstractAction {
        private static final long serialVersionUID = 5968029647764173330L;

        AddTagAction() {
            this.putValue("ShortDescription", BUNDLE.getString("tag.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField tf;
            String selectedText;
            String newTag = (String)TvShowEpisodeEditorDialog.this.cbTags.getSelectedItem();
            if (StringUtils.isBlank((CharSequence)newTag)) {
                return;
            }
            Component editorComponent = TvShowEpisodeEditorDialog.this.cbTags.getEditor().getEditorComponent();
            if (editorComponent instanceof JTextField && (selectedText = (tf = (JTextField)editorComponent).getSelectedText()) != null) {
                tf.setSelectionStart(0);
                tf.setSelectionEnd(0);
                tf.setCaretPosition(tf.getText().length());
                return;
            }
            boolean tagFound = false;
            for (String tag : TvShowEpisodeEditorDialog.this.tags) {
                if (!tag.equals(newTag)) continue;
                tagFound = true;
                break;
            }
            if (!tagFound) {
                TvShowEpisodeEditorDialog.this.tags.add(newTag);
                if (editorComponent instanceof JTextField) {
                    TvShowEpisodeEditorDialog.this.cbTagsAutoCompleteSupport.setFirstItem((Object)"");
                    TvShowEpisodeEditorDialog.this.cbTags.setSelectedIndex(0);
                    TvShowEpisodeEditorDialog.this.cbTagsAutoCompleteSupport.removeFirstItem();
                }
            }
        }
    }

    private class RemoveRatingAction
    extends AbstractAction {
        private static final long serialVersionUID = -7079821950827356996L;

        RemoveRatingAction() {
            this.putValue("ShortDescription", BUNDLE.getString("rating.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableRatings.getSelectedRow();
            if (row > -1) {
                row = TvShowEpisodeEditorDialog.this.tableRatings.convertRowIndexToModel(row);
                TvShowEpisodeEditorDialog.this.ratings.remove(row);
            }
        }
    }

    private class AddRatingAction
    extends AbstractAction {
        private static final long serialVersionUID = 2903255414533349267L;

        AddRatingAction() {
            this.putValue("ShortDescription", BUNDLE.getString("rating.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaRatingTable.MediaRating mediaRating = new MediaRatingTable.MediaRating("");
            mediaRating.maxValue = 10;
            mediaRating.votes = 1;
            RatingEditorDialog dialog = new RatingEditorDialog(SwingUtilities.getWindowAncestor(TvShowEpisodeEditorDialog.this.tableRatings), BUNDLE.getString("rating.add"), mediaRating);
            dialog.setVisible(true);
            if (StringUtils.isNotBlank((CharSequence)mediaRating.key) && mediaRating.value > 0.0f && mediaRating.maxValue > 0 && mediaRating.votes > 0) {
                TvShowEpisodeEditorDialog.this.ratings.add((Object)mediaRating);
            }
        }
    }

    private class ScrapeTask
    extends SwingWorker<Void, Void> {
        MediaScraper mediaScraper;

        ScrapeTask(MediaScraper mediaScraper) {
            this.mediaScraper = mediaScraper;
        }

        @Override
        protected Void doInBackground() {
            TvShowEpisodeEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
            MediaScrapeOptions options = new MediaScrapeOptions(MediaType.TV_EPISODE);
            options.setLanguage(TvShowModuleManager.SETTINGS.getScraperLanguage().toLocale());
            options.setCountry(TvShowModuleManager.SETTINGS.getCertificationCountry());
            for (Map.Entry<String, Object> entry : TvShowEpisodeEditorDialog.this.episodeToEdit.getTvShow().getIds().entrySet()) {
                options.setId(entry.getKey(), entry.getValue().toString());
            }
            options.setId("seasonNr", TvShowEpisodeEditorDialog.this.spSeason.getValue().toString());
            options.setId("episodeNr", TvShowEpisodeEditorDialog.this.spEpisode.getValue().toString());
            options.setId("dvdSeasonNr", TvShowEpisodeEditorDialog.this.spDvdSeason.getValue().toString());
            options.setId("dvdEpisodeNr", TvShowEpisodeEditorDialog.this.spDvdEpisode.getValue().toString());
            try {
                LOGGER.info("=====================================================");
                LOGGER.info("Scraper metadata with scraper: " + this.mediaScraper.getMediaProvider().getProviderInfo().getId() + ", " + this.mediaScraper.getMediaProvider().getProviderInfo().getVersion());
                LOGGER.info(options.toString());
                LOGGER.info("=====================================================");
                MediaMetadata metadata = ((ITvShowMetadataProvider)this.mediaScraper.getMediaProvider()).getMetadata(options);
                if (metadata == null || StringUtils.isBlank((CharSequence)metadata.getTitle())) {
                    JOptionPane.showMessageDialog(TvShowEpisodeEditorDialog.this, BUNDLE.getString("message.scrape.tvshowepisodefailed"));
                } else {
                    TvShowEpisodeEditorDialog.this.tfTitle.setText(metadata.getTitle());
                    TvShowEpisodeEditorDialog.this.taPlot.setText(metadata.getPlot());
                    TvShowEpisodeEditorDialog.this.dpFirstAired.setDate(metadata.getReleaseDate());
                    TvShowEpisodeEditorDialog.this.spSeason.setValue(metadata.getSeasonNumber());
                    TvShowEpisodeEditorDialog.this.spEpisode.setValue(metadata.getEpisodeNumber());
                    TvShowEpisodeEditorDialog.this.spDvdSeason.setValue(metadata.getDvdSeasonNumber());
                    TvShowEpisodeEditorDialog.this.spDvdEpisode.setValue(metadata.getDvdEpisodeNumber());
                    TvShowEpisodeEditorDialog.this.spDisplayEpisode.setValue(metadata.getDisplayEpisodeNumber());
                    TvShowEpisodeEditorDialog.this.spDisplaySeason.setValue(metadata.getDisplaySeasonNumber());
                    TvShowEpisodeEditorDialog.this.guests.clear();
                    TvShowEpisodeEditorDialog.this.directors.clear();
                    TvShowEpisodeEditorDialog.this.writers.clear();
                    for (MediaCastMember member : metadata.getCastMembers()) {
                        switch (member.getType()) {
                            case ACTOR: {
                                TvShowEpisodeEditorDialog.this.guests.add((Object)new Person(member));
                                break;
                            }
                            case DIRECTOR: {
                                TvShowEpisodeEditorDialog.this.directors.add((Object)new Person(member));
                                break;
                            }
                            case WRITER: {
                                TvShowEpisodeEditorDialog.this.writers.add((Object)new Person(member));
                                break;
                            }
                        }
                    }
                    MediaArtwork mediaArtwork = metadata.getMediaArt(MediaArtwork.MediaArtworkType.THUMB).stream().findFirst().orElse(null);
                    if (mediaArtwork != null) {
                        TvShowEpisodeEditorDialog.this.lblThumb.setImageUrl(mediaArtwork.getDefaultUrl());
                        TvShowEpisodeEditorDialog.this.tfThumb.setText(mediaArtwork.getDefaultUrl());
                    }
                }
            }
            catch (ScrapeException e) {
                LOGGER.error("getMetadata", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)TvShowEpisodeEditorDialog.this.episodeToEdit, "message.scrape.metadataepisodefailed", new String[]{":", e.getLocalizedMessage()}));
            }
            catch (MissingIdException e) {
                LOGGER.warn("missing id for scrape");
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, TvShowEpisodeEditorDialog.this.episodeToEdit, "scraper.error.missingid"));
            }
            catch (NothingFoundException | UnsupportedMediaTypeException throwable) {
                // empty catch block
            }
            TvShowEpisodeEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
    }

    private class AbortQueueAction
    extends AbstractAction {
        private static final long serialVersionUID = -7652218354710642510L;

        AbortQueueAction() {
            this.putValue("Name", BUNDLE.getString("Button.abortqueue"));
            this.putValue("ShortDescription", BUNDLE.getString("tvshow.edit.abortqueue.desc"));
            this.putValue("SmallIcon", IconManager.STOP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEpisodeEditorDialog.this.continueQueue = false;
            TvShowEpisodeEditorDialog.this.setVisible(false);
        }
    }

    private class DiscardAction
    extends AbstractAction {
        private static final long serialVersionUID = -5581329896797961536L;

        DiscardAction() {
            this.putValue("Name", BUNDLE.getString("Button.cancel"));
            this.putValue("ShortDescription", BUNDLE.getString("edit.discard"));
            this.putValue("SmallIcon", IconManager.CANCEL_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEpisodeEditorDialog.this.setVisible(false);
        }
    }

    private class ChangeEpisodeAction
    extends AbstractAction {
        private static final long serialVersionUID = -4799506776650330500L;

        ChangeEpisodeAction() {
            this.putValue("Name", BUNDLE.getString("Button.ok"));
            this.putValue("ShortDescription", BUNDLE.getString("tvshow.change"));
            this.putValue("SmallIcon", IconManager.APPLY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEpisodeEditorDialog.this.episodeToEdit.setTitle(TvShowEpisodeEditorDialog.this.tfTitle.getText());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setOriginalTitle(TvShowEpisodeEditorDialog.this.tfOriginalTitle.getText());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setDvdOrder(TvShowEpisodeEditorDialog.this.cbDvdOrder.isSelected());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setAiredSeason((Integer)TvShowEpisodeEditorDialog.this.spSeason.getValue());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setAiredEpisode((Integer)TvShowEpisodeEditorDialog.this.spEpisode.getValue());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setDvdSeason((Integer)TvShowEpisodeEditorDialog.this.spDvdSeason.getValue());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setDvdEpisode((Integer)TvShowEpisodeEditorDialog.this.spDvdEpisode.getValue());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setDisplaySeason((Integer)TvShowEpisodeEditorDialog.this.spDisplaySeason.getValue());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setDisplayEpisode((Integer)TvShowEpisodeEditorDialog.this.spDisplayEpisode.getValue());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setPlot(TvShowEpisodeEditorDialog.this.taPlot.getText());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setNote(TvShowEpisodeEditorDialog.this.tfNote.getText());
            Object mediaSource = TvShowEpisodeEditorDialog.this.cbMediaSource.getSelectedItem();
            if (mediaSource instanceof MediaSource) {
                TvShowEpisodeEditorDialog.this.episodeToEdit.setMediaSource((MediaSource)((Object)mediaSource));
            } else if (mediaSource instanceof String) {
                TvShowEpisodeEditorDialog.this.episodeToEdit.setMediaSource(MediaSource.getMediaSource((String)mediaSource));
            } else {
                TvShowEpisodeEditorDialog.this.episodeToEdit.setMediaSource(MediaSource.UNKNOWN);
            }
            MediaFileEditorPanel.syncMediaFiles(TvShowEpisodeEditorDialog.this.mediaFiles, TvShowEpisodeEditorDialog.this.episodeToEdit.getMediaFiles());
            TvShowEpisodeEditorDialog.this.episodeToEdit.fireEventForChangedMediaInformation();
            HashMap<String, Rating> ratings = new HashMap<String, Rating>();
            if ((Double)TvShowEpisodeEditorDialog.this.spRating.getValue() > 0.0) {
                ratings.put("user", new Rating("user", (Double)TvShowEpisodeEditorDialog.this.spRating.getValue(), 1, 10));
            }
            for (MediaRatingTable.MediaRating mediaRating : TvShowEpisodeEditorDialog.this.ratings) {
                if (!StringUtils.isNotBlank((CharSequence)mediaRating.key) || !(mediaRating.value > 0.0f) || mediaRating.votes <= 0) continue;
                Rating rating = new Rating(mediaRating.key, mediaRating.value, mediaRating.votes, mediaRating.maxValue);
                ratings.put(mediaRating.key, rating);
            }
            TvShowEpisodeEditorDialog.this.episodeToEdit.setRatings(ratings);
            TvShowEpisodeEditorDialog.this.episodeToEdit.setDateAdded((Date)TvShowEpisodeEditorDialog.this.spDateAdded.getValue());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setFirstAired(TvShowEpisodeEditorDialog.this.dpFirstAired.getDate());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setWatched(TvShowEpisodeEditorDialog.this.chckbxWatched.isSelected());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setActors((List<Person>)TvShowEpisodeEditorDialog.this.guests);
            TvShowEpisodeEditorDialog.this.episodeToEdit.setDirectors((List<Person>)TvShowEpisodeEditorDialog.this.directors);
            TvShowEpisodeEditorDialog.this.episodeToEdit.setWriters((List<Person>)TvShowEpisodeEditorDialog.this.writers);
            if (StringUtils.isNotEmpty((CharSequence)TvShowEpisodeEditorDialog.this.tfThumb.getText()) && (!TvShowEpisodeEditorDialog.this.tfThumb.getText().equals(TvShowEpisodeEditorDialog.this.episodeToEdit.getArtworkUrl(MediaFileType.THUMB)) || StringUtils.isBlank((CharSequence)TvShowEpisodeEditorDialog.this.episodeToEdit.getArtworkUrl(MediaFileType.THUMB)))) {
                TvShowEpisodeEditorDialog.this.episodeToEdit.setArtworkUrl(TvShowEpisodeEditorDialog.this.tfThumb.getText(), MediaFileType.THUMB);
                TvShowEpisodeEditorDialog.this.episodeToEdit.writeThumbImage();
            } else if (StringUtils.isBlank((CharSequence)TvShowEpisodeEditorDialog.this.tfThumb.getText())) {
                TvShowEpisodeEditorDialog.this.episodeToEdit.removeArtworkUrl(MediaFileType.THUMB);
            }
            TvShowEpisodeEditorDialog.this.episodeToEdit.setTags(TvShowEpisodeEditorDialog.this.tags);
            TvShowEpisodeEditorDialog.this.episodeToEdit.writeNFO();
            TvShowEpisodeEditorDialog.this.episodeToEdit.saveToDb();
            TvShowEpisodeEditorDialog.this.setVisible(false);
        }
    }

    private class SearchAction
    extends AbstractAction {
        private static final long serialVersionUID = -4799506776650330500L;

        SearchAction() {
            this.putValue("Name", BUNDLE.getString("tvshowepisodechooser.search"));
            this.putValue("SmallIcon", IconManager.SEARCH_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaScraper scraper = (MediaScraper)TvShowEpisodeEditorDialog.this.cbScraper.getSelectedItem();
            TvShowEpisodeChooserDialog dialog = new TvShowEpisodeChooserDialog(TvShowEpisodeEditorDialog.this.episodeToEdit, scraper);
            dialog.setLocationRelativeTo(TvShowEpisodeEditorDialog.this);
            dialog.setVisible(true);
            MediaMetadata metadata = dialog.getMetadata();
            if (metadata != null && metadata.getSeasonNumber() > 0 && metadata.getEpisodeNumber() > 0) {
                TvShowEpisodeEditorDialog.this.tfTitle.setText(metadata.getTitle());
                TvShowEpisodeEditorDialog.this.tfOriginalTitle.setText(metadata.getOriginalTitle());
                TvShowEpisodeEditorDialog.this.taPlot.setText(metadata.getPlot());
                TvShowEpisodeEditorDialog.this.spEpisode.setValue(metadata.getEpisodeNumber());
                TvShowEpisodeEditorDialog.this.spSeason.setValue(metadata.getSeasonNumber());
                TvShowEpisodeEditorDialog.this.spDvdEpisode.setValue(metadata.getDvdEpisodeNumber());
                TvShowEpisodeEditorDialog.this.spDvdSeason.setValue(metadata.getDvdSeasonNumber());
                TvShowEpisodeEditorDialog.this.guests.clear();
                TvShowEpisodeEditorDialog.this.writers.clear();
                TvShowEpisodeEditorDialog.this.directors.clear();
                for (MediaCastMember member : metadata.getCastMembers()) {
                    switch (member.getType()) {
                        case ACTOR: {
                            TvShowEpisodeEditorDialog.this.guests.add((Object)new Person(member));
                            break;
                        }
                        case DIRECTOR: {
                            TvShowEpisodeEditorDialog.this.directors.add((Object)new Person(member));
                            break;
                        }
                        case WRITER: {
                            TvShowEpisodeEditorDialog.this.writers.add((Object)new Person(member));
                            break;
                        }
                    }
                }
                MediaArtwork ma = metadata.getMediaArt(MediaArtwork.MediaArtworkType.THUMB).stream().findFirst().orElse(null);
                if (ma != null) {
                    TvShowEpisodeEditorDialog.this.tfThumb.setText(ma.getDefaultUrl());
                    TvShowEpisodeEditorDialog.this.lblThumb.setImageUrl(ma.getDefaultUrl());
                }
            }
        }
    }

    private class ScrapeAction
    extends AbstractAction {
        private static final long serialVersionUID = -4799506776650330500L;

        ScrapeAction() {
            this.putValue("Name", BUNDLE.getString("Button.scrape"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaScraper scraper = (MediaScraper)TvShowEpisodeEditorDialog.this.cbScraper.getSelectedItem();
            ScrapeTask task = new ScrapeTask(scraper);
            task.execute();
        }
    }
}

