/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.ShadowLayerUI;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.MainTabbedPane;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.dialogs.ImageChooserDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class TvShowSeasonEditorDialog
extends TmmDialog {
    private static final long serialVersionUID = 3270218410302989845L;
    private static final String ORIGINAL_IMAGE_SIZE = "originalImageSize";
    private TvShowSeason tvShowSeasonToEdit;
    private TvShowList tvShowList = TvShowList.getInstance();
    private boolean continueQueue = true;
    private boolean navigateBack = false;
    private int queueIndex;
    private int queueSize;
    private ImageLabel lblPoster;
    private ImageLabel lblBanner;
    private ImageLabel lblThumb;
    private JTextField tfPoster;
    private JTextField tfBanner;
    private JTextField tfThumb;
    private LinkLabel lblPosterSize = new LinkLabel();
    private LinkLabel lblBannerSize = new LinkLabel();
    private LinkLabel lblThumbSize = new LinkLabel();

    public TvShowSeasonEditorDialog(TvShowSeason tvShowSeason, int queueIndex, int queueSize) {
        super(BUNDLE.getString("tvshowseason.edit") + (queueSize > 1 ? " " + (queueIndex + 1) + "/" + queueSize : ""), "tvShowSeasonEditor");
        this.tvShowSeasonToEdit = tvShowSeason;
        this.queueIndex = queueIndex;
        this.queueSize = queueSize;
        this.initComponents();
        this.lblPoster.setImagePath(tvShowSeason.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_POSTER));
        this.lblThumb.setImagePath(tvShowSeason.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_THUMB));
        this.lblBanner.setImagePath(tvShowSeason.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_BANNER));
        this.tfPoster.setText(tvShowSeason.getArtworkUrl(MediaArtwork.MediaArtworkType.SEASON_POSTER));
        this.tfThumb.setText(tvShowSeason.getArtworkUrl(MediaArtwork.MediaArtworkType.SEASON_THUMB));
        this.tfBanner.setText(tvShowSeason.getArtworkUrl(MediaArtwork.MediaArtworkType.SEASON_BANNER));
    }

    private void initComponents() {
        MainTabbedPane tabbedPane = new MainTabbedPane(){
            private static final long serialVersionUID = 71548865608767532L;

            @Override
            public void updateUI() {
                this.putClientProperty("bottomBorder", Boolean.FALSE);
                super.updateUI();
            }
        };
        JLayer<JComponent> rootLayer = new JLayer<JComponent>(tabbedPane, new ShadowLayerUI());
        this.getContentPane().add(rootLayer, "Center");
        JPanel artworkPanel = new JPanel();
        tabbedPane.addTab(BUNDLE.getString("metatag.extraartwork"), null, artworkPanel, null);
        artworkPanel.setLayout((LayoutManager)new MigLayout("", "[200lp:300lp,grow][20lp:n][200lp:300lp,grow]", "[][100lp:125lp,grow][20lp:n][][100lp:125lp,grow]"));
        TmmLabel lblPosterT = new TmmLabel(BUNDLE.getString("mediafiletype.poster"));
        artworkPanel.add((Component)lblPosterT, "cell 0 0");
        artworkPanel.add((Component)this.lblPosterSize, "cell 0 0");
        this.lblPoster = new ImageLabel();
        this.lblPoster.setCursor(Cursor.getPredefinedCursor(12));
        this.lblPoster.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HashMap<String, Object> ids = new HashMap<String, Object>(TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.getTvShow().getIds());
                ids.put("tvShowSeason", TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.getSeason());
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowSeasonEditorDialog.this, ids, ImageChooserDialog.ImageType.SEASON_POSTER, TvShowSeasonEditorDialog.this.tvShowList.getAvailableArtworkScrapers(), TvShowSeasonEditorDialog.this.lblPoster, null, null, MediaType.TV_SHOW);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                TvShowSeasonEditorDialog.this.updateArtworkUrl(TvShowSeasonEditorDialog.this.lblPoster, TvShowSeasonEditorDialog.this.tfPoster);
            }
        });
        artworkPanel.add((Component)this.lblPoster, "cell 0 1,grow");
        this.lblPoster.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(this.lblPosterSize, this.lblPoster, MediaArtwork.MediaArtworkType.POSTER));
        JLabel lblThumbT = new JLabel(BUNDLE.getString("mediafiletype.thumb"));
        artworkPanel.add((Component)lblThumbT, "cell 2 0");
        artworkPanel.add((Component)this.lblThumbSize, "cell 2 0");
        this.lblThumb = new ImageLabel();
        this.lblThumb.setCursor(Cursor.getPredefinedCursor(12));
        this.lblThumb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HashMap<String, Object> ids = new HashMap<String, Object>(TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.getTvShow().getIds());
                ids.put("tvShowSeason", TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.getSeason());
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowSeasonEditorDialog.this, ids, ImageChooserDialog.ImageType.SEASON_THUMB, TvShowSeasonEditorDialog.this.tvShowList.getAvailableArtworkScrapers(), TvShowSeasonEditorDialog.this.lblThumb, null, null, MediaType.TV_SHOW);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                TvShowSeasonEditorDialog.this.updateArtworkUrl(TvShowSeasonEditorDialog.this.lblThumb, TvShowSeasonEditorDialog.this.tfThumb);
            }
        });
        artworkPanel.add((Component)this.lblThumb, "cell 2 1,grow");
        this.lblThumb.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(this.lblThumbSize, this.lblThumb, MediaArtwork.MediaArtworkType.THUMB));
        TmmLabel lblBannerT = new TmmLabel(BUNDLE.getString("mediafiletype.banner"));
        artworkPanel.add((Component)lblBannerT, "cell 0 3");
        artworkPanel.add((Component)this.lblBannerSize, "cell 0 3");
        this.lblBanner = new ImageLabel();
        this.lblBanner.setCursor(Cursor.getPredefinedCursor(12));
        this.lblBanner.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HashMap<String, Object> ids = new HashMap<String, Object>(TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.getTvShow().getIds());
                ids.put("tvShowSeason", TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.getSeason());
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowSeasonEditorDialog.this, ids, ImageChooserDialog.ImageType.SEASON_BANNER, TvShowSeasonEditorDialog.this.tvShowList.getAvailableArtworkScrapers(), TvShowSeasonEditorDialog.this.lblBanner, null, null, MediaType.TV_SHOW);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                TvShowSeasonEditorDialog.this.updateArtworkUrl(TvShowSeasonEditorDialog.this.lblBanner, TvShowSeasonEditorDialog.this.tfBanner);
            }
        });
        artworkPanel.add((Component)this.lblBanner, "cell 0 4 3 1,grow");
        this.lblBanner.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(this.lblBannerSize, this.lblBanner, MediaArtwork.MediaArtworkType.BANNER));
        artworkPanel = new JPanel();
        tabbedPane.addTab(BUNDLE.getString("edit.artwork"), null, artworkPanel, null);
        artworkPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][]"));
        lblPosterT = new TmmLabel(BUNDLE.getString("mediafiletype.poster"));
        artworkPanel.add((Component)lblPosterT, "cell 0 0,alignx right");
        this.tfPoster = new JTextField();
        artworkPanel.add((Component)this.tfPoster, "cell 1 0,growx");
        lblBannerT = new TmmLabel(BUNDLE.getString("mediafiletype.banner"));
        artworkPanel.add((Component)lblBannerT, "cell 0 1,alignx right");
        this.tfBanner = new JTextField();
        artworkPanel.add((Component)this.tfBanner, "cell 1 1,growx");
        lblThumbT = new TmmLabel(BUNDLE.getString("mediafiletype.thumb"));
        artworkPanel.add((Component)lblThumbT, "cell 0 2,alignx right");
        this.tfThumb = new JTextField();
        artworkPanel.add((Component)this.tfThumb, "cell 1 2,growx");
        if (this.queueSize > 1) {
            JButton btnAbort = new JButton(new AbortAction());
            this.addButton(btnAbort);
            if (this.queueIndex > 0) {
                JButton backButton = new JButton(new NavigateBackAction());
                this.addButton(backButton);
            }
        }
        JButton cancelButton = new JButton(new CancelAction());
        this.addButton(cancelButton);
        JButton okButton = new JButton(new OKAction());
        this.addDefaultButton(okButton);
    }

    private void updateArtworkUrl(ImageLabel imageLabel, JTextField textField) {
        if (StringUtils.isNotBlank((CharSequence)imageLabel.getImageUrl())) {
            textField.setText(imageLabel.getImageUrl());
        }
    }

    private void setImageSizeAndCreateLink(LinkLabel lblSize, ImageLabel imageLabel, MediaArtwork.MediaArtworkType type) {
        TmmUIHelper.createLinkForImage(lblSize, imageLabel);
        Dimension dimension = this.tvShowSeasonToEdit.getArtworkSize(type);
        if (dimension.width == 0 && dimension.height == 0) {
            lblSize.setText(imageLabel.getOriginalImageSize().width + "x" + imageLabel.getOriginalImageSize().height);
        } else {
            lblSize.setText(dimension.width + "x" + dimension.height);
        }
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.continueQueue;
    }

    public boolean isContinueQueue() {
        return this.continueQueue;
    }

    public boolean isNavigateBack() {
        return this.navigateBack;
    }

    private class AbortAction
    extends AbstractAction {
        private static final long serialVersionUID = -7652218354710642510L;

        AbortAction() {
            this.putValue("Name", BUNDLE.getString("Button.abortqueue"));
            this.putValue("ShortDescription", BUNDLE.getString("tvshow.edit.abortqueue.desc"));
            this.putValue("SmallIcon", IconManager.STOP_INV);
            this.putValue("SwingLargeIconKey", IconManager.STOP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowSeasonEditorDialog.this.continueQueue = false;
            TvShowSeasonEditorDialog.this.setVisible(false);
        }
    }

    private class NavigateBackAction
    extends AbstractAction {
        private static final long serialVersionUID = -1652218154720642310L;

        public NavigateBackAction() {
            this.putValue("Name", BUNDLE.getString("Button.back"));
            this.putValue("SmallIcon", IconManager.BACK_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowSeasonEditorDialog.this.navigateBack = true;
            TvShowSeasonEditorDialog.this.setVisible(false);
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = -4617793684152607277L;

        CancelAction() {
            this.putValue("Name", BUNDLE.getString("Button.cancel"));
            this.putValue("ShortDescription", BUNDLE.getString("edit.discard"));
            this.putValue("SmallIcon", IconManager.CANCEL_INV);
            this.putValue("SwingLargeIconKey", IconManager.CANCEL_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowSeasonEditorDialog.this.setVisible(false);
        }
    }

    private class OKAction
    extends AbstractAction {
        private static final long serialVersionUID = 6699599213348390696L;

        OKAction() {
            this.putValue("Name", BUNDLE.getString("Button.ok"));
            this.putValue("ShortDescription", BUNDLE.getString("tvshow.change"));
            this.putValue("SmallIcon", IconManager.APPLY_INV);
            this.putValue("SwingLargeIconKey", IconManager.APPLY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StringUtils.isNotEmpty((CharSequence)TvShowSeasonEditorDialog.this.tfPoster.getText()) && !TvShowSeasonEditorDialog.this.tfPoster.getText().equals(TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.getArtworkUrl(MediaArtwork.MediaArtworkType.SEASON_POSTER))) {
                TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.setArtworkUrl(TvShowSeasonEditorDialog.this.tfPoster.getText(), MediaArtwork.MediaArtworkType.SEASON_POSTER);
                TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.downloadArtwork(MediaArtwork.MediaArtworkType.SEASON_POSTER);
            } else if (StringUtils.isEmpty((CharSequence)TvShowSeasonEditorDialog.this.tfPoster.getText())) {
                TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.removeArtworkUrl(MediaArtwork.MediaArtworkType.SEASON_POSTER);
            }
            if (StringUtils.isNotEmpty((CharSequence)TvShowSeasonEditorDialog.this.tfBanner.getText()) && !TvShowSeasonEditorDialog.this.tfBanner.getText().equals(TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.getArtworkUrl(MediaArtwork.MediaArtworkType.SEASON_BANNER))) {
                TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.setArtworkUrl(TvShowSeasonEditorDialog.this.tfBanner.getText(), MediaArtwork.MediaArtworkType.SEASON_BANNER);
                TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.downloadArtwork(MediaArtwork.MediaArtworkType.SEASON_BANNER);
            } else if (StringUtils.isBlank((CharSequence)TvShowSeasonEditorDialog.this.tfBanner.getText())) {
                TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.removeArtworkUrl(MediaArtwork.MediaArtworkType.SEASON_BANNER);
            }
            if (StringUtils.isNotEmpty((CharSequence)TvShowSeasonEditorDialog.this.tfThumb.getText()) && !TvShowSeasonEditorDialog.this.tfThumb.getText().equals(TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.getArtworkUrl(MediaArtwork.MediaArtworkType.SEASON_THUMB))) {
                TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.setArtworkUrl(TvShowSeasonEditorDialog.this.tfThumb.getText(), MediaArtwork.MediaArtworkType.SEASON_THUMB);
                TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.downloadArtwork(MediaArtwork.MediaArtworkType.SEASON_THUMB);
            } else if (StringUtils.isBlank((CharSequence)TvShowSeasonEditorDialog.this.tfThumb.getText())) {
                TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.removeArtworkUrl(MediaArtwork.MediaArtworkType.SEASON_THUMB);
            }
            TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.getTvShow().saveToDb();
            TvShowSeasonEditorDialog.this.setVisible(false);
        }
    }
}

