/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowGenreFilter
extends AbstractCheckComboBoxTvShowUIFilter<MediaGenres> {
    public TvShowGenreFilter() {
        this.buildAndInstallMediaGenres();
        MediaGenres.addListener(evt -> SwingUtilities.invokeLater(this::buildAndInstallMediaGenres));
    }

    @Override
    public String getId() {
        return "tvShowGenre";
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        if (invert ^ (selectedItems.isEmpty() && tvShow.getGenres().isEmpty())) {
            return true;
        }
        for (MediaGenres genre : selectedItems) {
            if (!(invert ^ tvShow.getGenres().contains(genre))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("metatag.genre"));
    }

    private void buildAndInstallMediaGenres() {
        this.setValues(MediaGenres.values());
    }

    @Override
    protected String parseTypeToString(MediaGenres type) throws Exception {
        return type.name();
    }

    @Override
    protected MediaGenres parseStringToType(String string) throws Exception {
        return MediaGenres.getGenre((String)string);
    }
}

