/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowVideoCodecFilter
extends AbstractCheckComboBoxTvShowUIFilter<String> {
    private TvShowList tvShowList = TvShowList.getInstance();

    public TvShowVideoCodecFilter() {
        this.buildAndInstallCodecArray();
        PropertyChangeListener propertyChangeListener = evt -> this.buildAndInstallCodecArray();
        this.tvShowList.addPropertyChangeListener("videoCodec", propertyChangeListener);
    }

    @Override
    public String getId() {
        return "tvShowVideoCodec";
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List codecs = this.checkComboBox.getSelectedItems();
        for (TvShowEpisode episode : episodes) {
            List<MediaFile> mfs = episode.getMediaFiles(MediaFileType.VIDEO);
            for (MediaFile mf : mfs) {
                if (!(invert ^ codecs.contains(mf.getVideoCodec()))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("metatag.videocodec"));
    }

    private void buildAndInstallCodecArray() {
        ArrayList<String> codecs = new ArrayList<String>(this.tvShowList.getVideoCodecsInEpisodes());
        Collections.sort(codecs);
        this.setValues(codecs);
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

