/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.panels.episode;

import java.awt.Component;
import java.awt.LayoutManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.tvshows.TvShowEpisodeSelectionModel;

public class TvShowEpisodeDetailsPanel
extends JPanel {
    private static final long serialVersionUID = -5598009673335010850L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowEpisodeDetailsPanel.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private final TvShowEpisodeSelectionModel selectionModel;
    private LinkLabel lblPath;
    private JLabel lblSeason;
    private JLabel lblEpisode;
    private JLabel lblAired;
    private JLabel lblTags;
    private JLabel lblDateAdded;
    private JLabel lblNote;

    public TvShowEpisodeDetailsPanel(TvShowEpisodeSelectionModel model) {
        this.selectionModel = model;
        this.initComponents();
        this.initDataBindings();
        this.lblPath.addActionListener(arg0 -> {
            if (!StringUtils.isEmpty((CharSequence)this.lblPath.getText())) {
                Path path = Paths.get(this.lblPath.getText(), new String[0]);
                try {
                    if (Files.exists(path, new LinkOption[0])) {
                        TmmUIHelper.openFile(path);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("open filemanager", (Throwable)ex);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)path, "message.erroropenfolder", new String[]{":", ex.getLocalizedMessage()}));
                }
            }
        });
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("insets 0", "[][10lp][grow]", "[]2lp[]2lp[]2lp[]2lp[]2lp[]2lp[]"));
        JLabel lblSeasonT = new JLabel(BUNDLE.getString("metatag.season"));
        TmmFontHelper.changeFont(lblSeasonT, 1.166, 1);
        this.add((Component)lblSeasonT, "cell 0 0");
        this.lblSeason = new JLabel("");
        TmmFontHelper.changeFont((JComponent)this.lblSeason, 1.166);
        this.add((Component)this.lblSeason, "cell 2 0");
        JLabel lblEpisodeT = new JLabel(BUNDLE.getString("metatag.episode"));
        TmmFontHelper.changeFont(lblEpisodeT, 1.166, 1);
        this.add((Component)lblEpisodeT, "cell 0 1");
        this.lblEpisode = new JLabel("");
        TmmFontHelper.changeFont((JComponent)this.lblEpisode, 1.166);
        this.add((Component)this.lblEpisode, "cell 2 1");
        TmmLabel lblAiredT = new TmmLabel(BUNDLE.getString("metatag.aired"));
        this.add((Component)lblAiredT, "cell 0 2");
        this.lblAired = new JLabel("");
        this.add((Component)this.lblAired, "cell 2 2");
        TmmLabel lblTagsT = new TmmLabel(BUNDLE.getString("metatag.tags"));
        this.add((Component)lblTagsT, "cell 0 3");
        this.lblTags = new JLabel("");
        this.add((Component)this.lblTags, "cell 2 3");
        TmmLabel lblDateAddedT = new TmmLabel(BUNDLE.getString("metatag.dateadded"));
        this.add((Component)lblDateAddedT, "cell 0 4");
        this.lblDateAdded = new JLabel("");
        this.add((Component)this.lblDateAdded, "cell 2 4");
        TmmLabel lblPathT = new TmmLabel(BUNDLE.getString("metatag.path"));
        this.add((Component)lblPathT, "cell 0 5");
        this.lblPath = new LinkLabel("");
        this.add((Component)this.lblPath, "cell 2 5, growx, wmin 0");
        TmmLabel lblNoteT = new TmmLabel(BUNDLE.getString("metatag.note"));
        this.add((Component)lblNoteT, "cell 0 6");
        this.lblNote = new JLabel("");
        this.add((Component)this.lblNote, "cell 2 6,,growx,wmin 0");
    }

    protected void initDataBindings() {
        BeanProperty tvShowEpisodeSelectionModelBeanProperty = BeanProperty.create((String)"selectedTvShowEpisode.path");
        BeanProperty linkLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty, (Object)this.lblPath, (Property)linkLabelBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedTvShowEpisode.season");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_1, (Object)this.lblSeason, (Property)jLabelBeanProperty);
        autoBinding_1.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_2 = BeanProperty.create((String)"selectedTvShowEpisode.episode");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_2, (Object)this.lblEpisode, (Property)jLabelBeanProperty);
        autoBinding_2.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_3 = BeanProperty.create((String)"selectedTvShowEpisode.firstAiredAsString");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_3, (Object)this.lblAired, (Property)jLabelBeanProperty);
        autoBinding_3.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_4 = BeanProperty.create((String)"selectedTvShowEpisode.tagsAsString");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_4, (Object)this.lblTags, (Property)jLabelBeanProperty);
        autoBinding_4.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_5 = BeanProperty.create((String)"selectedTvShowEpisode.dateAddedAsString");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_5, (Object)this.lblDateAdded, (Property)jLabelBeanProperty);
        autoBinding_5.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_6 = BeanProperty.create((String)"selectedTvShowEpisode.note");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_6, (Object)this.lblNote, (Property)jLabelBeanProperty);
        autoBinding_6.bind();
    }
}

