/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.panels.episode;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.ui.ColumnLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.FlatButton;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.StarRater;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.converter.RatingConverter;
import org.tinymediamanager.ui.converter.VoteCountConverter;
import org.tinymediamanager.ui.panels.MediaInformationLogosPanel;
import org.tinymediamanager.ui.tvshows.TvShowEpisodeSelectionModel;
import org.tinymediamanager.ui.tvshows.panels.episode.TvShowEpisodeDetailsPanel;

public class TvShowEpisodeInformationPanel
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowEpisodeInformationPanel.class);
    private static final long serialVersionUID = 2032708149757390567L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private TvShowSettings settings = TvShowModuleManager.SETTINGS;
    private TvShowEpisodeSelectionModel tvShowEpisodeSelectionModel;
    private StarRater panelRatingStars;
    private JLabel lblTvShowName;
    private JLabel lblRating;
    private JLabel lblVoteCount;
    private JLabel lblEpisodeTitle;
    private ImageLabel lblEpisodeThumb;
    private ImageLabel lblSeasonPoster;
    private JTextArea taOverview;
    private MediaInformationLogosPanel panelLogos;
    private JSeparator sepLogos;
    private JLabel lblSeasonPosterSize;
    private JLabel lblEpisodeThumbSize;
    private JLabel lblOriginalTitle;
    private JButton btnPlay;

    public TvShowEpisodeInformationPanel(TvShowEpisodeSelectionModel tvShowEpisodeSelectionModel) {
        this.tvShowEpisodeSelectionModel = tvShowEpisodeSelectionModel;
        this.initComponents();
        this.initDataBindings();
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            TvShowEpisode episode;
            String property = propertyChangeEvent.getPropertyName();
            Object source = propertyChangeEvent.getSource();
            if (source instanceof TvShowEpisodeSelectionModel) {
                TvShowEpisodeSelectionModel model = (TvShowEpisodeSelectionModel)source;
                this.setSeasonPoster(model.getSelectedTvShowEpisode());
                this.setEpisodeThumb(model.getSelectedTvShowEpisode());
                this.panelLogos.setMediaInformationSource(model.getSelectedTvShowEpisode());
            }
            if ((source instanceof TvShowEpisode || source instanceof MediaFile) && (episode = tvShowEpisodeSelectionModel.getSelectedTvShowEpisode()) != null) {
                this.panelLogos.setMediaInformationSource(episode);
            }
            if (source instanceof TvShowEpisode && "thumb".equals(property)) {
                episode = (TvShowEpisode)source;
                this.setEpisodeThumb(episode);
            }
            if (source instanceof TvShowEpisode && "seasonPoster".equals(property)) {
                episode = (TvShowEpisode)source;
                this.setSeasonPoster(episode);
            }
        };
        this.tvShowEpisodeSelectionModel.addPropertyChangeListener(propertyChangeListener);
        this.btnPlay.addActionListener(e -> {
            MediaFile mf = this.tvShowEpisodeSelectionModel.getSelectedTvShowEpisode().getMainVideoFile();
            if (StringUtils.isNotBlank((CharSequence)mf.getFilename())) {
                try {
                    TmmUIHelper.openFile(mf.getFileAsPath());
                }
                catch (Exception ex) {
                    LOGGER.error("open file", (Object)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)mf, "message.erroropenfile", new String[]{":", ex.getLocalizedMessage()}));
                }
            }
        });
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[100lp:100lp,grow][300lp:300lp,grow 250]", "[grow]"));
        JPanel panelLeft = new JPanel();
        panelLeft.setLayout(new ColumnLayout());
        this.add((Component)panelLeft, "cell 0 0,grow");
        this.lblSeasonPoster = new ImageLabel(false, false, true);
        this.lblSeasonPoster.setDesiredAspectRatio(0.6666667f);
        panelLeft.add(this.lblSeasonPoster);
        this.lblSeasonPoster.enableLightbox();
        this.lblSeasonPosterSize = new JLabel(BUNDLE.getString("mediafiletype.season_poster"));
        panelLeft.add(this.lblSeasonPosterSize);
        panelLeft.add(Box.createVerticalStrut(20));
        this.lblEpisodeThumb = new ImageLabel(false, false, true);
        this.lblEpisodeThumb.setDesiredAspectRatio(1.7777778f);
        panelLeft.add(this.lblEpisodeThumb);
        this.lblEpisodeThumb.enableLightbox();
        this.lblEpisodeThumbSize = new JLabel(BUNDLE.getString("mediafiletype.thumb"));
        panelLeft.add(this.lblEpisodeThumbSize);
        JPanel panelRight = new JPanel();
        panelRight.setLayout((LayoutManager)new MigLayout("insets 0 n n n, hidemode 2", "[grow][][]", "[][][][shrink 0][][shrink 0][][shrink 0][][shrink 0][][]"));
        this.add((Component)panelRight, "cell 1 0,grow");
        this.lblTvShowName = new TmmLabel("", 1.33);
        panelRight.add((Component)this.lblTvShowName, "flowx,cell 0 0,growx,wmin 0");
        this.btnPlay = new FlatButton(IconManager.PLAY_LARGE);
        panelRight.add((Component)this.btnPlay, "cell 1 0 1 4,aligny top");
        this.lblEpisodeTitle = new TmmLabel("", 1.16);
        panelRight.add((Component)this.lblEpisodeTitle, "cell 0 1,growx, wmin 0");
        this.lblOriginalTitle = new JLabel("");
        panelRight.add((Component)this.lblOriginalTitle, "cell 0 2,growx, wmin 0");
        panelRight.add((Component)new JSeparator(), "cell 0 3 2 1,growx,wmin 0");
        TvShowEpisodeDetailsPanel panelDetails = new TvShowEpisodeDetailsPanel(this.tvShowEpisodeSelectionModel);
        panelRight.add((Component)panelDetails, "cell 0 4 2 1,growx");
        panelRight.add((Component)new JSeparator(), "cell 0 5 2 1,growx");
        this.panelRatingStars = new StarRater(10, 1);
        panelRight.add((Component)this.panelRatingStars, "flowx,cell 0 6 2 1,aligny center");
        this.panelRatingStars.setEnabled(false);
        this.lblRating = new JLabel("");
        panelRight.add((Component)this.lblRating, "cell 0 6 2 1,aligny center");
        this.lblVoteCount = new JLabel("");
        panelRight.add((Component)this.lblVoteCount, "cell 0 6 2 1,aligny center");
        this.sepLogos = new JSeparator();
        panelRight.add((Component)this.sepLogos, "cell 0 7 2 1,growx");
        this.panelLogos = new MediaInformationLogosPanel();
        panelRight.add((Component)this.panelLogos, "cell 0 8 2 1,wmin 0");
        panelRight.add((Component)new JSeparator(), "cell 0 9 2 1,growx");
        TmmLabel lblPlot = new TmmLabel(BUNDLE.getString("metatag.plot"));
        panelRight.add((Component)lblPlot, "cell 0 10 2 1");
        JScrollPane scrollPanePlot = new JScrollPane();
        scrollPanePlot.setBorder(null);
        this.taOverview = new ReadOnlyTextArea();
        this.taOverview.setBorder(null);
        scrollPanePlot.setViewportView(this.taOverview);
        panelRight.add((Component)scrollPanePlot, "cell 0 11 2 1,grow");
    }

    private void setSeasonPoster(TvShowEpisode tvShowEpisode) {
        this.lblSeasonPoster.clearImage();
        this.lblSeasonPoster.setImagePath(tvShowEpisode.getTvShowSeason().getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_POSTER));
        Dimension posterSize = tvShowEpisode.getTvShowSeason().getArtworkSize(MediaArtwork.MediaArtworkType.SEASON_POSTER);
        if (posterSize.width > 0 && posterSize.height > 0) {
            this.lblSeasonPosterSize.setText(BUNDLE.getString("mediafiletype.season_poster") + " - " + posterSize.width + "x" + posterSize.height);
        } else {
            this.lblSeasonPosterSize.setText(BUNDLE.getString("mediafiletype.season_poster"));
        }
    }

    private void setEpisodeThumb(TvShowEpisode tvShowEpisode) {
        this.lblEpisodeThumb.clearImage();
        this.lblEpisodeThumb.setImagePath(tvShowEpisode.getArtworkFilename(MediaFileType.THUMB));
        Dimension thumbSize = tvShowEpisode.getArtworkDimension(MediaFileType.THUMB);
        if (thumbSize.width > 0 && thumbSize.height > 0) {
            this.lblEpisodeThumbSize.setText(BUNDLE.getString("mediafiletype.thumb") + " - " + thumbSize.width + "x" + thumbSize.height);
        } else {
            this.lblEpisodeThumbSize.setText(BUNDLE.getString("mediafiletype.thumb"));
        }
    }

    protected void initDataBindings() {
        BeanProperty tvShowEpisodeSelectionModelBeanProperty = BeanProperty.create((String)"selectedTvShowEpisode.tvShow.title");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty, (Object)this.lblTvShowName, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedTvShowEpisode.titleForUi");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_1, (Object)this.lblEpisodeTitle, (Property)jLabelBeanProperty);
        autoBinding_1.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_3 = BeanProperty.create((String)"selectedTvShowEpisode.plot");
        BeanProperty JTextAreaBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_3, (Object)this.taOverview, (Property)JTextAreaBeanProperty);
        autoBinding_3.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_4 = BeanProperty.create((String)"selectedTvShowEpisode.rating.ratingNormalized");
        BeanProperty starRaterBeanProperty = BeanProperty.create((String)"rating");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_4, (Object)this.panelRatingStars, (Property)starRaterBeanProperty);
        autoBinding_4.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_6 = BeanProperty.create((String)"selectedTvShowEpisode.rating");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_6, (Object)this.lblRating, (Property)jLabelBeanProperty);
        autoBinding_5.setConverter((Converter)new RatingConverter());
        autoBinding_5.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_2 = BeanProperty.create((String)"selectedTvShowEpisode.originalTitle");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_2, (Object)this.lblOriginalTitle, (Property)jLabelBeanProperty);
        autoBinding_2.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_5 = BeanProperty.create((String)"selectedTvShowEpisode.rating.votes");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_5, (Object)this.lblVoteCount, (Property)jLabelBeanProperty);
        autoBinding_6.setConverter((Converter)new VoteCountConverter());
        autoBinding_6.bind();
        BeanProperty tvShowSettingsBeanProperty = BeanProperty.create((String)"showLogosPanel");
        BeanProperty jSeparatorBeanProperty = BeanProperty.create((String)"visible");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.settings, (Property)tvShowSettingsBeanProperty, (Object)this.sepLogos, (Property)jSeparatorBeanProperty);
        autoBinding_7.bind();
        BeanProperty mediaInformationLogosPanelBeanProperty = BeanProperty.create((String)"visible");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.settings, (Property)tvShowSettingsBeanProperty, (Object)this.panelLogos, (Property)mediaInformationLogosPanelBeanProperty);
        autoBinding_8.bind();
    }
}

