/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.panels.season;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.ui.ColumnLayout;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.tvshows.TvShowSeasonSelectionModel;

public class TvShowSeasonInformationPanel
extends JPanel {
    private static final long serialVersionUID = 1911808562993073590L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private EventList<TvShowEpisode> episodeEventList;
    private DefaultEventTableModel<TvShowEpisode> episodeTableModel;
    private TvShowSeasonSelectionModel tvShowSeasonSelectionModel;
    private ImageLabel lblTvShowPoster;
    private JLabel lblPosterSize;
    private ImageLabel lblTvShowBanner;
    private JLabel lblBannerSize;
    private ImageLabel lblTvShowThumb;
    private JLabel lblThumbSize;
    private JLabel lblTvshowTitle;
    private JLabel lblSeason;
    private TmmTable tableEpisodes;

    public TvShowSeasonInformationPanel(TvShowSeasonSelectionModel tvShowSeasonSelectionModel) {
        this.tvShowSeasonSelectionModel = tvShowSeasonSelectionModel;
        this.episodeEventList = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(TvShowEpisode.class));
        this.episodeTableModel = new DefaultEventTableModel((EventList)GlazedListsSwing.swingThreadProxyList(this.episodeEventList), (TableFormat)new EpisodeTableFormat());
        this.initComponents();
        this.initDataBindings();
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            TvShowSeason season;
            String property = propertyChangeEvent.getPropertyName();
            Object source = propertyChangeEvent.getSource();
            if (source instanceof TvShowSeasonSelectionModel || source instanceof TvShowSeason && ("mediaFiles".equals(propertyChangeEvent.getPropertyName()) || "addedEpisode".equals(propertyChangeEvent.getPropertyName()) || "removedEpisode".equals(propertyChangeEvent.getPropertyName()))) {
                TvShowSeason selectedSeason;
                if (source instanceof TvShowSeasonSelectionModel) {
                    TvShowSeasonSelectionModel model = (TvShowSeasonSelectionModel)source;
                    selectedSeason = model.getSelectedTvShowSeason();
                } else {
                    selectedSeason = (TvShowSeason)source;
                }
                this.setPoster(selectedSeason);
                this.setBanner(selectedSeason);
                this.setThumb(selectedSeason);
                try {
                    this.episodeEventList.getReadWriteLock().writeLock().lock();
                    this.episodeEventList.clear();
                    this.episodeEventList.addAll(selectedSeason.getEpisodes());
                    this.tableEpisodes.adjustColumnPreferredWidths(6);
                }
                catch (Exception exception) {
                }
                finally {
                    this.episodeEventList.getReadWriteLock().writeLock().unlock();
                }
            }
            if (source instanceof TvShowSeason && "poster".equals(property)) {
                season = (TvShowSeason)source;
                this.setPoster(season);
            }
            if (source instanceof TvShowSeason && "banner".equals(property)) {
                season = (TvShowSeason)source;
                this.setBanner(season);
            }
            if (source instanceof TvShowSeason && "thumb".equals(property)) {
                season = (TvShowSeason)source;
                this.setThumb(season);
            }
        };
        tvShowSeasonSelectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[100lp:100lp,grow][300lp:300lp,grow 250]", "[grow]"));
        JPanel panelLeft = new JPanel();
        this.add((Component)panelLeft, "cell 0 0,grow");
        panelLeft.setLayout(new ColumnLayout());
        this.lblTvShowPoster = new ImageLabel(false, false, true);
        this.lblTvShowPoster.setDesiredAspectRatio(0.6666667f);
        this.lblTvShowPoster.setCursor(Cursor.getPredefinedCursor(12));
        panelLeft.add(this.lblTvShowPoster);
        this.lblTvShowPoster.enableLightbox();
        this.lblPosterSize = new JLabel(BUNDLE.getString("mediafiletype.poster"));
        panelLeft.add(this.lblPosterSize);
        panelLeft.add(Box.createVerticalStrut(20));
        this.lblTvShowThumb = new ImageLabel(false, false, true);
        this.lblTvShowThumb.setDesiredAspectRatio(1.7777778f);
        this.lblTvShowThumb.setCursor(Cursor.getPredefinedCursor(12));
        panelLeft.add(this.lblTvShowThumb);
        this.lblTvShowThumb.enableLightbox();
        this.lblThumbSize = new JLabel(BUNDLE.getString("mediafiletype.thumb"));
        panelLeft.add(this.lblThumbSize);
        panelLeft.add(Box.createVerticalStrut(20));
        this.lblTvShowBanner = new ImageLabel(false, false, true);
        this.lblTvShowBanner.setDesiredAspectRatio(3.125f);
        this.lblTvShowBanner.setCursor(Cursor.getPredefinedCursor(12));
        panelLeft.add(this.lblTvShowBanner);
        this.lblTvShowBanner.enableLightbox();
        this.lblBannerSize = new JLabel(BUNDLE.getString("mediafiletype.banner"));
        panelLeft.add(this.lblBannerSize);
        JPanel panelRight = new JPanel();
        this.add((Component)panelRight, "cell 1 0,grow");
        panelRight.setLayout((LayoutManager)new MigLayout("insets 0 n n n, hidemode 2", "[][323px,grow]", "[][][shrink 0][][286px,grow]"));
        this.lblTvshowTitle = new TmmLabel("", 1.33);
        panelRight.add((Component)this.lblTvshowTitle, "cell 0 0 2 1");
        TmmLabel lblSeasonT = new TmmLabel(BUNDLE.getString("metatag.season"));
        panelRight.add((Component)lblSeasonT, "cell 0 1");
        TmmFontHelper.changeFont(lblSeasonT, 1.166, 1);
        this.lblSeason = new JLabel("");
        panelRight.add((Component)this.lblSeason, "cell 1 1");
        TmmFontHelper.changeFont(this.lblSeason, 1.166, 1);
        panelRight.add((Component)new JSeparator(), "cell 0 2 2 1,growx");
        TmmLabel lblEpisodelistT = new TmmLabel(BUNDLE.getString("metatag.episodes"));
        panelRight.add((Component)lblEpisodelistT, "cell 0 3 2 1");
        this.tableEpisodes = new TmmTable((TableModel)this.episodeTableModel);
        JScrollPane scrollPaneEpisodes = new JScrollPane(this.tableEpisodes);
        panelRight.add((Component)scrollPaneEpisodes, "cell 0 4 2 1,grow");
        this.tableEpisodes.configureScrollPane(scrollPaneEpisodes);
        scrollPaneEpisodes.setViewportView(this.tableEpisodes);
    }

    private void setPoster(TvShowSeason season) {
        this.lblTvShowPoster.clearImage();
        this.lblTvShowPoster.setImagePath(season.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_POSTER));
        Dimension posterSize = season.getArtworkSize(MediaArtwork.MediaArtworkType.SEASON_POSTER);
        if (posterSize.width > 0 && posterSize.height > 0) {
            this.lblPosterSize.setText(BUNDLE.getString("mediafiletype.poster") + " - " + posterSize.width + "x" + posterSize.height);
        } else {
            this.lblPosterSize.setText(BUNDLE.getString("mediafiletype.poster"));
        }
    }

    private void setBanner(TvShowSeason season) {
        this.lblTvShowBanner.clearImage();
        this.lblTvShowBanner.setImagePath(season.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_BANNER));
        Dimension bannerSize = season.getArtworkSize(MediaArtwork.MediaArtworkType.SEASON_BANNER);
        if (bannerSize.width > 0 && bannerSize.height > 0) {
            this.lblBannerSize.setText(BUNDLE.getString("mediafiletype.banner") + " - " + bannerSize.width + "x" + bannerSize.height);
        } else {
            this.lblBannerSize.setText(BUNDLE.getString("mediafiletype.banner"));
        }
    }

    private void setThumb(TvShowSeason season) {
        this.lblTvShowThumb.clearImage();
        this.lblTvShowThumb.setImagePath(season.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_THUMB));
        Dimension thumbSize = season.getArtworkSize(MediaArtwork.MediaArtworkType.SEASON_THUMB);
        if (thumbSize.width > 0 && thumbSize.height > 0) {
            this.lblThumbSize.setText(BUNDLE.getString("mediafiletype.thumb") + " - " + thumbSize.width + "x" + thumbSize.height);
        } else {
            this.lblThumbSize.setText(BUNDLE.getString("mediafiletype.thumb"));
        }
    }

    protected void initDataBindings() {
        BeanProperty tvShowSeasonSelectionModelBeanProperty = BeanProperty.create((String)"selectedTvShowSeason.tvShow.title");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSeasonSelectionModel, (Property)tvShowSeasonSelectionModelBeanProperty, (Object)this.lblTvshowTitle, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowSeasonSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedTvShowSeason.season");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSeasonSelectionModel, (Property)tvShowSeasonSelectionModelBeanProperty_1, (Object)this.lblSeason, (Property)jLabelBeanProperty);
        autoBinding_1.bind();
    }

    private static class EpisodeTableFormat
    implements AdvancedTableFormat<TvShowEpisode> {
        private EpisodeTableFormat() {
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return BUNDLE.getString("metatag.episode");
                }
                case 1: {
                    return BUNDLE.getString("metatag.title");
                }
                case 2: {
                    return BUNDLE.getString("metatag.aired");
                }
            }
            throw new IllegalStateException();
        }

        public Object getColumnValue(TvShowEpisode episode, int column) {
            switch (column) {
                case 0: {
                    return episode.getEpisode();
                }
                case 1: {
                    return episode.getTitle();
                }
                case 2: {
                    return episode.getFirstAiredAsString();
                }
            }
            throw new IllegalStateException();
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: 
                case 1: 
                case 2: {
                    return String.class;
                }
            }
            throw new IllegalStateException();
        }

        public Comparator getColumnComparator(int arg0) {
            return null;
        }
    }
}

