/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.panels.tvshow;

import java.awt.Component;
import java.awt.LayoutManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.converter.RuntimeConverter;
import org.tinymediamanager.ui.tvshows.TvShowOtherIdsConverter;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;

public class TvShowDetailsPanel
extends JPanel {
    private static final long serialVersionUID = -1569492065407109019L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowDetailsPanel.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private final TvShowSelectionModel selectionModel;
    private JLabel lblGenres;
    private JLabel lblCertification;
    private LinkLabel lblThetvdbId;
    private LinkLabel lblImdbId;
    private LinkLabel lblPath;
    private JLabel lblPremiered;
    private JLabel lblStudio;
    private JLabel lblStatus;
    private JLabel lblYear;
    private JLabel lblTags;
    private JLabel lblOtherIds;
    private JLabel lblCountryT;
    private JLabel lblCountry;
    private JLabel lblRuntime;
    private JLabel lblNoteT;
    private JLabel lblNote;

    public TvShowDetailsPanel(TvShowSelectionModel selectionModel) {
        this.selectionModel = selectionModel;
        this.initComponents();
        this.initDataBindings();
        this.lblImdbId.addActionListener(arg0 -> {
            String url = "http://www.imdb.com/title/" + this.lblImdbId.getText();
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception e) {
                LOGGER.error("browse to imdbid", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
            }
        });
        this.lblThetvdbId.addActionListener(arg0 -> {
            String url = "http://thetvdb.com/?tab=series&id=" + this.lblThetvdbId.getText();
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception e) {
                LOGGER.error("browse to thetvdb", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
            }
        });
        this.lblPath.addActionListener(arg0 -> {
            if (StringUtils.isNotBlank((CharSequence)this.lblPath.getText())) {
                Path path = Paths.get(this.lblPath.getText(), new String[0]);
                try {
                    if (Files.exists(path, new LinkOption[0])) {
                        TmmUIHelper.openFile(path);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("open filemanager", (Throwable)ex);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)path, "message.erroropenfolder", new String[]{":", ex.getLocalizedMessage()}));
                }
            }
        });
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("insets 0", "[][grow][][grow 200]", "[]2lp[]2lp[]2lp[]2lp[]2lp[]2lp[]2lp[]2lp[]2lp[]"));
        TmmLabel lblPremieredT = new TmmLabel(BUNDLE.getString("metatag.premiered"));
        this.add((Component)lblPremieredT, "cell 0 0");
        this.lblPremiered = new JLabel("");
        this.add((Component)this.lblPremiered, "cell 1 0");
        TmmLabel lblYearT = new TmmLabel(BUNDLE.getString("metatag.year"));
        this.add((Component)lblYearT, "cell 2 0");
        this.lblYear = new JLabel("");
        this.add((Component)this.lblYear, "cell 3 0");
        TmmLabel lblCertificationT = new TmmLabel(BUNDLE.getString("metatag.certification"));
        this.add((Component)lblCertificationT, "cell 0 1");
        this.lblCertification = new JLabel("");
        this.add((Component)this.lblCertification, "cell 1 1");
        TmmLabel lblImdbIdT = new TmmLabel("IMDB Id");
        this.add((Component)lblImdbIdT, "cell 2 1");
        this.lblImdbId = new LinkLabel("");
        this.add((Component)this.lblImdbId, "cell 3 1");
        TmmLabel lblStatusT = new TmmLabel(BUNDLE.getString("metatag.status"));
        this.add((Component)lblStatusT, "cell 0 2");
        this.lblStatus = new JLabel("");
        this.add((Component)this.lblStatus, "cell 1 2");
        TmmLabel lblThetvdbIdT = new TmmLabel("TheTVDB Id");
        this.add((Component)lblThetvdbIdT, "cell 2 2");
        this.lblThetvdbId = new LinkLabel("");
        this.add((Component)this.lblThetvdbId, "cell 3 2");
        TmmLabel lblRuntimeT = new TmmLabel(BUNDLE.getString("metatag.runtime"));
        this.add((Component)lblRuntimeT, "cell 0 3");
        this.lblRuntime = new JLabel("");
        this.add((Component)this.lblRuntime, "cell 1 3");
        TmmLabel lblOtherIdsT = new TmmLabel(BUNDLE.getString("metatag.otherids"));
        this.add((Component)lblOtherIdsT, "cell 2 3");
        this.lblOtherIds = new JLabel("");
        this.add((Component)this.lblOtherIds, "cell 3 3, wmin 0");
        TmmLabel lblStudioT = new TmmLabel(BUNDLE.getString("metatag.studio"));
        this.add((Component)lblStudioT, "cell 0 4");
        this.lblStudio = new JLabel("");
        this.add((Component)this.lblStudio, "cell 1 4 3 1,wmin 0");
        this.lblCountryT = new TmmLabel(BUNDLE.getString("metatag.country"));
        this.add((Component)this.lblCountryT, "cell 0 5");
        this.lblCountry = new JLabel("");
        this.add((Component)this.lblCountry, "cell 1 5 3 1,wmin 0");
        TmmLabel lblGenresT = new TmmLabel(BUNDLE.getString("metatag.genre"));
        this.add((Component)lblGenresT, "cell 0 6");
        this.lblGenres = new JLabel("");
        this.add((Component)this.lblGenres, "cell 1 6 3 1,growx,wmin 0");
        TmmLabel lblTagsT = new TmmLabel(BUNDLE.getString("metatag.tags"));
        this.add((Component)lblTagsT, "cell 0 7");
        this.lblTags = new JLabel("");
        this.add((Component)this.lblTags, "cell 1 7 3 1,growx,wmin 0");
        TmmLabel lblPathT = new TmmLabel(BUNDLE.getString("metatag.path"));
        this.add((Component)lblPathT, "cell 0 8");
        this.lblPath = new LinkLabel("");
        this.add((Component)this.lblPath, "cell 1 8 3 1,growx,wmin 0");
        this.lblNoteT = new TmmLabel(BUNDLE.getString("metatag.note"));
        this.add((Component)this.lblNoteT, "cell 0 9");
        this.lblNote = new JLabel("");
        this.add((Component)this.lblNote, "cell 1 9 3 1,growx,wmin 0");
    }

    protected void initDataBindings() {
        BeanProperty tvShowSelectionModelBeanProperty_2 = BeanProperty.create((String)"selectedTvShow.tvdbId");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_2, (Object)this.lblThetvdbId, (Property)jLabelBeanProperty);
        autoBinding_2.bind();
        BeanProperty tvShowSelectionModelBeanProperty_3 = BeanProperty.create((String)"selectedTvShow.imdbId");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_3, (Object)this.lblImdbId, (Property)jLabelBeanProperty);
        autoBinding_3.bind();
        BeanProperty tvShowSelectionModelBeanProperty_4 = BeanProperty.create((String)"selectedTvShow.path");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_4, (Object)this.lblPath, (Property)jLabelBeanProperty);
        autoBinding_4.bind();
        BeanProperty tvShowSelectionModelBeanProperty = BeanProperty.create((String)"selectedTvShow.certification.name");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty, (Object)this.lblCertification, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedTvShow.genresAsString");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_1, (Object)this.lblGenres, (Property)jLabelBeanProperty);
        autoBinding_1.bind();
        BeanProperty tvShowSelectionModelBeanProperty_6 = BeanProperty.create((String)"selectedTvShow.productionCompany");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_6, (Object)this.lblStudio, (Property)jLabelBeanProperty);
        autoBinding_6.bind();
        BeanProperty tvShowSelectionModelBeanProperty_7 = BeanProperty.create((String)"selectedTvShow.firstAiredAsString");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_7, (Object)this.lblPremiered, (Property)jLabelBeanProperty);
        autoBinding_7.bind();
        BeanProperty tvShowSelectionModelBeanProperty_5 = BeanProperty.create((String)"selectedTvShow.status.name");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_5, (Object)this.lblStatus, (Property)jLabelBeanProperty);
        autoBinding_5.bind();
        BeanProperty tvShowSelectionModelBeanProperty_8 = BeanProperty.create((String)"selectedTvShow.year");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_8, (Object)this.lblYear, (Property)jLabelBeanProperty);
        autoBinding_8.bind();
        BeanProperty tvShowSelectionModelBeanProperty_9 = BeanProperty.create((String)"selectedTvShow.tagsAsString");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_9, (Object)this.lblTags, (Property)jLabelBeanProperty);
        autoBinding_9.bind();
        BeanProperty tvShowSelectionModelBeanProperty_11 = BeanProperty.create((String)"selectedTvShow.country");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_11, (Object)this.lblCountry, (Property)jLabelBeanProperty);
        autoBinding_11.bind();
        BeanProperty tvShowSelectionModelBeanProperty_12 = BeanProperty.create((String)"selectedTvShow.runtime");
        AutoBinding autoBinding_12 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_12, (Object)this.lblRuntime, (Property)jLabelBeanProperty);
        autoBinding_12.setConverter((Converter)new RuntimeConverter());
        autoBinding_12.bind();
        BeanProperty tvShowSelectionModelBeanProperty_10 = BeanProperty.create((String)"selectedTvShow.ids");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_10, (Object)this.lblOtherIds, (Property)jLabelBeanProperty);
        autoBinding_10.setConverter((Converter)new TvShowOtherIdsConverter());
        autoBinding_10.bind();
        BeanProperty tvShowSelectionModelBeanProperty_13 = BeanProperty.create((String)"selectedTvShow.note");
        AutoBinding autoBinding_13 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_13, (Object)this.lblNote, (Property)jLabelBeanProperty);
        autoBinding_13.bind();
    }
}

