/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.panels.tvshow;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.ui.ColumnLayout;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.StarRater;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.converter.RatingConverter;
import org.tinymediamanager.ui.converter.VoteCountConverter;
import org.tinymediamanager.ui.panels.MediaInformationLogosPanel;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.panels.tvshow.TvShowDetailsPanel;

public class TvShowInformationPanel
extends JPanel {
    private static final long serialVersionUID = 1911808562993073590L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private StarRater panelRatingStars;
    private JLabel lblTvShowName;
    private JLabel lblRating;
    private JLabel lblVoteCount;
    private ImageLabel lblTvShowBackground;
    private JLabel lblFanartSize;
    private ImageLabel lblTvShowPoster;
    private JLabel lblPosterSize;
    private ImageLabel lblTvShowBanner;
    private JLabel lblBannerSize;
    private JTextArea tpOverview;
    private JSeparator sepLogos;
    private MediaInformationLogosPanel panelLogos;
    private TvShowSettings settings = TvShowModuleManager.SETTINGS;
    private TvShowSelectionModel tvShowSelectionModel;
    private JLabel lblOriginalTitle;

    public TvShowInformationPanel(TvShowSelectionModel tvShowSelectionModel) {
        this.tvShowSelectionModel = tvShowSelectionModel;
        this.initComponents();
        this.initDataBindings();
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            TvShow tvShow;
            String property = propertyChangeEvent.getPropertyName();
            Object source = propertyChangeEvent.getSource();
            if (source instanceof TvShowSelectionModel) {
                TvShowSelectionModel model = (TvShowSelectionModel)source;
                this.setFanart(model.getSelectedTvShow());
                this.setPoster(model.getSelectedTvShow());
                this.setBanner(model.getSelectedTvShow());
                this.panelLogos.setMediaInformationSource(model.getSelectedTvShow());
            }
            if ((source instanceof TvShow || source instanceof MediaFile) && (tvShow = tvShowSelectionModel.getSelectedTvShow()) != null) {
                this.panelLogos.setMediaInformationSource(tvShow);
            }
            if (source instanceof TvShow && "fanart".equals(property)) {
                tvShow = (TvShow)source;
                this.setFanart(tvShow);
            }
            if (source instanceof TvShow && "poster".equals(property)) {
                tvShow = (TvShow)source;
                this.setPoster(tvShow);
            }
            if (source instanceof TvShow && "banner".equals(property)) {
                tvShow = (TvShow)source;
                this.setBanner(tvShow);
            }
        };
        tvShowSelectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[100lp:100lp,grow][300lp:300lp,grow 250]", "[grow]"));
        JPanel panelLeft = new JPanel();
        panelLeft.setLayout(new ColumnLayout());
        this.add((Component)panelLeft, "cell 0 0,grow");
        this.lblTvShowPoster = new ImageLabel(false, false, true);
        this.lblTvShowPoster.setDesiredAspectRatio(0.6666667f);
        this.lblTvShowPoster.setCursor(Cursor.getPredefinedCursor(12));
        panelLeft.add(this.lblTvShowPoster);
        this.lblTvShowPoster.enableLightbox();
        this.lblPosterSize = new JLabel(BUNDLE.getString("mediafiletype.poster"));
        panelLeft.add(this.lblPosterSize);
        panelLeft.add(Box.createVerticalStrut(20));
        this.lblTvShowBackground = new ImageLabel(false, false, true);
        this.lblTvShowBackground.setDesiredAspectRatio(1.7777778f);
        this.lblTvShowBackground.setCursor(Cursor.getPredefinedCursor(12));
        panelLeft.add(this.lblTvShowBackground);
        this.lblTvShowBackground.enableLightbox();
        this.lblFanartSize = new JLabel(BUNDLE.getString("mediafiletype.fanart"));
        panelLeft.add(this.lblFanartSize);
        panelLeft.add(Box.createVerticalStrut(20));
        this.lblTvShowBanner = new ImageLabel(false, false, true);
        this.lblTvShowBanner.setDesiredAspectRatio(3.125f);
        this.lblTvShowBanner.setCursor(Cursor.getPredefinedCursor(12));
        panelLeft.add(this.lblTvShowBanner);
        this.lblTvShowBanner.enableLightbox();
        this.lblBannerSize = new JLabel(BUNDLE.getString("mediafiletype.banner"));
        panelLeft.add(this.lblBannerSize);
        JPanel panelRight = new JPanel();
        this.add((Component)panelRight, "cell 1 0,grow");
        panelRight.setLayout((LayoutManager)new MigLayout("insets 0 n n n, hidemode 2", "[450lp,grow]", "[][][shrink 0][][shrink 0][][shrink 0][][shrink 0][][]"));
        this.lblTvShowName = new TmmLabel("", 1.33);
        panelRight.add((Component)this.lblTvShowName, "cell 0 0,growx,wmin 0");
        this.lblOriginalTitle = new JLabel("");
        panelRight.add((Component)this.lblOriginalTitle, "cell 0 1,growx,wmin 0");
        panelRight.add((Component)new JSeparator(), "cell 0 2,growx");
        TvShowDetailsPanel panelDetails = new TvShowDetailsPanel(this.tvShowSelectionModel);
        panelRight.add((Component)panelDetails, "cell 0 3,growx");
        panelRight.add((Component)new JSeparator(), "cell 0 4,growx");
        this.panelRatingStars = new StarRater(10, 1);
        panelRight.add((Component)this.panelRatingStars, "flowx,cell 0 5,aligny center");
        this.panelRatingStars.setEnabled(false);
        this.lblRating = new JLabel("");
        panelRight.add((Component)this.lblRating, "cell 0 5,aligny center");
        this.lblVoteCount = new JLabel("");
        panelRight.add((Component)this.lblVoteCount, "cell 0 5,aligny center");
        this.sepLogos = new JSeparator();
        panelRight.add((Component)this.sepLogos, "cell 0 6,growx");
        this.panelLogos = new MediaInformationLogosPanel();
        panelRight.add((Component)this.panelLogos, "cell 0 7,wmin 0");
        panelRight.add((Component)new JSeparator(), "cell 0 8,growx");
        TmmLabel lblPlot = new TmmLabel(BUNDLE.getString("metatag.plot"));
        panelRight.add((Component)lblPlot, "cell 0 9");
        TmmFontHelper.changeFont((JComponent)lblPlot, 1);
        JScrollPane scrollPaneOverview = new JScrollPane();
        panelRight.add((Component)scrollPaneOverview, "cell 0 10,grow");
        this.tpOverview = new ReadOnlyTextArea();
        this.tpOverview.setBorder(null);
        scrollPaneOverview.setViewportView(this.tpOverview);
    }

    private void setPoster(TvShow tvShow) {
        this.lblTvShowPoster.clearImage();
        this.lblTvShowPoster.setImagePath(tvShow.getArtworkFilename(MediaFileType.POSTER));
        Dimension posterSize = tvShow.getArtworkDimension(MediaFileType.POSTER);
        if (posterSize.width > 0 && posterSize.height > 0) {
            this.lblPosterSize.setText(BUNDLE.getString("mediafiletype.poster") + " - " + posterSize.width + "x" + posterSize.height);
        } else {
            this.lblPosterSize.setText(BUNDLE.getString("mediafiletype.poster"));
        }
    }

    private void setFanart(TvShow tvShow) {
        this.lblTvShowBackground.clearImage();
        this.lblTvShowBackground.setImagePath(tvShow.getArtworkFilename(MediaFileType.FANART));
        Dimension fanartSize = tvShow.getArtworkDimension(MediaFileType.FANART);
        if (fanartSize.width > 0 && fanartSize.height > 0) {
            this.lblFanartSize.setText(BUNDLE.getString("mediafiletype.fanart") + " - " + fanartSize.width + "x" + fanartSize.height);
        } else {
            this.lblFanartSize.setText(BUNDLE.getString("mediafiletype.fanart"));
        }
    }

    private void setBanner(TvShow tvShow) {
        this.lblTvShowBanner.clearImage();
        this.lblTvShowBanner.setImagePath(tvShow.getArtworkFilename(MediaFileType.BANNER));
        Dimension bannerSize = tvShow.getArtworkDimension(MediaFileType.BANNER);
        if (bannerSize.width > 0 && bannerSize.height > 0) {
            this.lblBannerSize.setText(BUNDLE.getString("mediafiletype.banner") + " - " + bannerSize.width + "x" + bannerSize.height);
        } else {
            this.lblBannerSize.setText(BUNDLE.getString("mediafiletype.banner"));
        }
    }

    protected void initDataBindings() {
        BeanProperty tvShowSelectionModelBeanProperty = BeanProperty.create((String)"selectedTvShow.title");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty, (Object)this.lblTvShowName, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedTvShow.plot");
        BeanProperty JTextAreaBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty_1, (Object)this.tpOverview, (Property)JTextAreaBeanProperty);
        autoBinding_1.bind();
        BeanProperty tvShowSelectionModelBeanProperty_2 = BeanProperty.create((String)"selectedTvShow.rating.ratingNormalized");
        BeanProperty starRaterBeanProperty = BeanProperty.create((String)"rating");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty_2, (Object)this.panelRatingStars, (Property)starRaterBeanProperty);
        autoBinding_2.bind();
        BeanProperty tvShowSelectionModelBeanProperty_5 = BeanProperty.create((String)"selectedTvShow.rating");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty_5, (Object)this.lblRating, (Property)jLabelBeanProperty);
        autoBinding_3.setConverter((Converter)new RatingConverter());
        autoBinding_3.bind();
        BeanProperty tvShowSelectionModelBeanProperty_3 = BeanProperty.create((String)"selectedTvShow.rating.votes");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty_3, (Object)this.lblVoteCount, (Property)jLabelBeanProperty);
        autoBinding_4.setConverter((Converter)new VoteCountConverter());
        autoBinding_4.bind();
        BeanProperty tvShowSelectionModelBeanProperty_4 = BeanProperty.create((String)"selectedTvShow.originalTitle");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowSelectionModel, (Property)tvShowSelectionModelBeanProperty_4, (Object)this.lblOriginalTitle, (Property)jLabelBeanProperty);
        autoBinding_5.bind();
        BeanProperty tvShowSettingsBeanProperty = BeanProperty.create((String)"showLogosPanel");
        BeanProperty jSeparatorBeanProperty = BeanProperty.create((String)"visible");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.settings, (Property)tvShowSettingsBeanProperty, (Object)this.sepLogos, (Property)jSeparatorBeanProperty);
        autoBinding_6.bind();
        BeanProperty mediaInformationLogosPanelBeanProperty = BeanProperty.create((String)"visible");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.settings, (Property)tvShowSettingsBeanProperty, (Object)this.panelLogos, (Property)mediaInformationLogosPanelBeanProperty);
        autoBinding_7.bind();
    }
}

