/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.CertificationStyle;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.connector.TvShowConnectors;
import org.tinymediamanager.core.tvshow.filenaming.TvShowEpisodeNfoNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowNfoNaming;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.SettingsPanelFactory;
import org.tinymediamanager.ui.components.TmmLabel;

class TvShowScraperNfoSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 4999827736720726395L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private TvShowSettings settings = TvShowModuleManager.SETTINGS;
    private JComboBox<TvShowConnectors> cbNfoFormat;
    private JComboBox<CertificationStyleWrapper> cbCertificationStyle;
    private JCheckBox chckbxWriteCleanNfo;
    private JComboBox<MediaLanguages> cbNfoLanguage;
    private JCheckBox chckbxEpisodeNfo1;
    private JCheckBox chckbxTvShowNfo1;
    private ItemListener checkBoxListener = e -> this.checkChanges();
    private ItemListener comboBoxListener = e -> this.checkChanges();

    TvShowScraperNfoSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        this.settings.addPropertyChangeListener(evt -> {
            if ("preset".equals(evt.getPropertyName())) {
                this.buildComboBoxes();
            }
        });
        this.buildCheckBoxes();
        this.buildComboBoxes();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[]"));
        JPanel panelNfo = SettingsPanelFactory.createSettingsPanel();
        TmmLabel lblNfoT = new TmmLabel(BUNDLE.getString("Settings.nfo"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelNfo, lblNfoT, true);
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        JLabel lblNfoFormatT = new JLabel(BUNDLE.getString("Settings.nfoFormat"));
        panelNfo.add((Component)lblNfoFormatT, "cell 1 0 2 1");
        this.cbNfoFormat = new JComboBox<TvShowConnectors>(TvShowConnectors.values());
        panelNfo.add(this.cbNfoFormat, "cell 1 0");
        JLabel lblNfoFileNaming = new JLabel(BUNDLE.getString("Settings.nofFileNaming"));
        panelNfo.add((Component)lblNfoFileNaming, "cell 1 1 2 1");
        JPanel panel = new JPanel();
        panelNfo.add((Component)panel, "cell 2 2");
        panel.setLayout((LayoutManager)new MigLayout("insets 0", "[][]", ""));
        JLabel lblTvShow = new JLabel(BUNDLE.getString("metatag.tvshow"));
        panel.add((Component)lblTvShow, "cell 0 0");
        this.chckbxTvShowNfo1 = new JCheckBox("tvshow.nfo");
        panel.add((Component)this.chckbxTvShowNfo1, "cell 1 0");
        JLabel lblEpisode = new JLabel(BUNDLE.getString("metatag.episode"));
        panel.add((Component)lblEpisode, "cell 0 1");
        this.chckbxEpisodeNfo1 = new JCheckBox(BUNDLE.getString("Settings.tvshow.episodename") + ".nfo");
        panel.add((Component)this.chckbxEpisodeNfo1, "cell 1 1");
        JLabel lblNfoLanguage = new JLabel(BUNDLE.getString("Settings.nfolanguage"));
        panelNfo.add((Component)lblNfoLanguage, "cell 1 4 2 1");
        this.cbNfoLanguage = new JComboBox<MediaLanguages>(MediaLanguages.valuesSorted());
        panelNfo.add(this.cbNfoLanguage, "cell 1 4");
        JLabel lblNfoLanguageDesc = new JLabel(BUNDLE.getString("Settings.nfolanguage.desc"));
        panelNfo.add((Component)lblNfoLanguageDesc, "cell 2 5");
        JLabel lblCertificationFormatT = new JLabel(BUNDLE.getString("Settings.certificationformat"));
        panelNfo.add((Component)lblCertificationFormatT, "cell 1 7 2 1");
        this.cbCertificationStyle = new JComboBox();
        panelNfo.add(this.cbCertificationStyle, "cell 1 7");
        this.chckbxWriteCleanNfo = new JCheckBox(BUNDLE.getString("Settings.writecleannfo"));
        panelNfo.add((Component)this.chckbxWriteCleanNfo, "cell 1 9 2 1");
    }

    private void checkChanges() {
        CertificationStyleWrapper wrapper = (CertificationStyleWrapper)this.cbCertificationStyle.getSelectedItem();
        if (wrapper != null && this.settings.getCertificationStyle() != wrapper.style) {
            this.settings.setCertificationStyle(wrapper.style);
        }
        this.settings.clearNfoFilenames();
        if (this.chckbxTvShowNfo1.isSelected()) {
            this.settings.addNfoFilename(TvShowNfoNaming.TV_SHOW);
        }
        this.settings.clearEpisodeNfoFilenames();
        if (this.chckbxEpisodeNfo1.isSelected()) {
            this.settings.addEpisodeNfoFilename(TvShowEpisodeNfoNaming.FILENAME);
        }
    }

    private void buildComboBoxes() {
        this.cbCertificationStyle.removeItemListener(this.comboBoxListener);
        this.cbCertificationStyle.removeAllItems();
        for (CertificationStyle style : CertificationStyle.values()) {
            CertificationStyleWrapper wrapper = new CertificationStyleWrapper();
            wrapper.style = style;
            this.cbCertificationStyle.addItem(wrapper);
            if (style != this.settings.getCertificationStyle()) continue;
            this.cbCertificationStyle.setSelectedItem(wrapper);
        }
        this.cbCertificationStyle.addItemListener(this.comboBoxListener);
    }

    private void buildCheckBoxes() {
        List<TvShowEpisodeNfoNaming> TvShowEpisodeNfoNamings;
        this.chckbxTvShowNfo1.removeItemListener(this.checkBoxListener);
        this.chckbxEpisodeNfo1.removeItemListener(this.checkBoxListener);
        this.clearSelection(this.chckbxTvShowNfo1, this.chckbxEpisodeNfo1);
        List<TvShowNfoNaming> tvShowNfoNamings = this.settings.getNfoFilenames();
        if (tvShowNfoNamings.contains(TvShowNfoNaming.TV_SHOW)) {
            this.chckbxTvShowNfo1.setSelected(true);
        }
        if ((TvShowEpisodeNfoNamings = this.settings.getEpisodeNfoFilenames()).contains(TvShowEpisodeNfoNaming.FILENAME)) {
            this.chckbxEpisodeNfo1.setSelected(true);
        }
        this.chckbxTvShowNfo1.addItemListener(this.checkBoxListener);
        this.chckbxEpisodeNfo1.addItemListener(this.checkBoxListener);
    }

    private void clearSelection(JCheckBox ... checkBoxes) {
        for (JCheckBox checkBox : checkBoxes) {
            checkBox.setSelected(false);
        }
    }

    protected void initDataBindings() {
        BeanProperty tvShowSettingsBeanProperty = BeanProperty.create((String)"tvShowConnector");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty, this.cbNfoFormat, (Property)jComboBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty tvShowSettingsBeanProperty_1 = BeanProperty.create((String)"writeCleanNfo");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_1, (Object)this.chckbxWriteCleanNfo, (Property)jCheckBoxBeanProperty);
        autoBinding_2.bind();
        BeanProperty tvShowSettingsBeanProperty_2 = BeanProperty.create((String)"nfoLanguage");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_2, this.cbNfoLanguage, (Property)jComboBoxBeanProperty);
        autoBinding_4.bind();
    }

    private class CertificationStyleWrapper {
        private CertificationStyle style;

        private CertificationStyleWrapper() {
        }

        public String toString() {
            String bundleTag = BUNDLE.getString("Settings.certification." + this.style.name().toLowerCase(Locale.ROOT));
            return bundleTag.replace("{}", CertificationStyle.formatCertification(Certification.DE_FSK16, this.style));
        }
    }
}

