/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.imdb;

import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaRating;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.http.InMemoryCachedUrl;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.scraper.imdb.ImdbMetadataProvider;
import org.tinymediamanager.scraper.imdb.ImdbSiteDefinition;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.UrlUtil;

public abstract class ImdbParser {
    protected static final Pattern IMDB_ID_PATTERN = Pattern.compile("/title/(tt[0-9]{7})/");
    protected static final Pattern PERSON_ID_PATTERN = Pattern.compile("/name/(nm[0-9]{7})/");
    protected final MediaType type;
    protected SimpleDateFormat sdf1 = new SimpleDateFormat("d MMMM yyyy", Locale.US);
    protected SimpleDateFormat sdf2 = new SimpleDateFormat("MMMM yyyy", Locale.US);
    protected SimpleDateFormat sdf3 = new SimpleDateFormat("d MMM. yyyy", Locale.US);
    protected SimpleDateFormat sdf4 = new SimpleDateFormat("d MMM yyyy", Locale.US);

    protected ImdbParser(MediaType type) {
        this.type = type;
    }

    protected abstract Pattern getUnwantedSearchResultPattern();

    protected abstract Logger getLogger();

    protected abstract ImdbSiteDefinition getImdbSite();

    protected abstract MediaMetadata getMetadata(MediaScrapeOptions var1) throws ScrapeException, MissingIdException, NothingFoundException;

    protected abstract String getSearchCategory();

    protected boolean isUseTmdbForMovies() {
        return ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("useTmdbForMovies");
    }

    protected boolean isUseTmdbForTvShows() {
        return ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("useTmdbForTvShows");
    }

    protected boolean isScrapeCollectionInfo() {
        return ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("scrapeCollectionInfo");
    }

    protected List<MediaSearchResult> search(MediaSearchOptions query) throws ScrapeException {
        MediaSearchResult sr;
        Url url;
        ArrayList<MediaSearchResult> result = new ArrayList<MediaSearchResult>();
        String searchTerm = "";
        if (StringUtils.isNotEmpty((CharSequence)query.getImdbId())) {
            searchTerm = query.getImdbId();
        }
        if (StringUtils.isEmpty((CharSequence)searchTerm)) {
            searchTerm = query.getQuery();
        }
        if (StringUtils.isEmpty((CharSequence)searchTerm)) {
            return result;
        }
        String language = query.getLanguage().getLanguage();
        int myear = query.getYear();
        String country = query.getCountry().getAlpha2();
        searchTerm = MetadataUtil.removeNonSearchCharacters((String)searchTerm);
        StringBuilder sb = new StringBuilder(this.getImdbSite().getSite());
        sb.append("find?q=");
        try {
            sb.append(URLEncoder.encode(searchTerm, "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            this.getLogger().debug("Failed to encode search term: " + searchTerm);
            sb.append(searchTerm);
        }
        sb.append(this.getSearchCategory());
        this.getLogger().debug("========= BEGIN IMDB Scraper Search for: " + sb.toString());
        Document doc = null;
        try {
            url = new Url(sb.toString());
            url.addHeader("Accept-Language", ImdbParser.getAcceptLanguage(language, country));
        }
        catch (Exception e) {
            this.getLogger().debug("tried to fetch search response", (Throwable)e);
            throw new ScrapeException((Throwable)e);
        }
        try {
            InputStream is = url.getInputStream();
            Object object = null;
            try {
                doc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"");
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (object != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.getLogger().debug("tried to fetch search response", (Throwable)e);
            throw new ScrapeException((Throwable)e);
        }
        Elements elements = doc.getElementsByAttributeValue("rel", "canonical");
        for (Element element : elements) {
            MediaMetadata md = null;
            String movieName = null;
            String movieId = null;
            String href = element.attr("href");
            Matcher matcher = IMDB_ID_PATTERN.matcher(href);
            while (matcher.find()) {
                if (matcher.group(1) == null) continue;
                movieId = matcher.group(1);
            }
            if (!StringUtils.isEmpty(movieId)) {
                MediaScrapeOptions options = new MediaScrapeOptions(this.type);
                options.setImdbId(movieId);
                options.setLanguage(query.getLanguage());
                options.setCountry(CountryCode.valueOf((String)country));
                try {
                    md = this.getMetadata(options);
                    if (!StringUtils.isEmpty((CharSequence)md.getTitle())) {
                        movieName = md.getTitle();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!StringUtils.isNotEmpty(movieName) || !StringUtils.isNotEmpty((CharSequence)movieId)) continue;
            sr = new MediaSearchResult(ImdbMetadataProvider.providerInfo.getId(), query.getMediaType());
            sr.setTitle(movieName);
            sr.setIMDBId(movieId);
            sr.setYear(md.getYear());
            sr.setMetadata(md);
            sr.setScore(1.0f);
            String posterUrl = "";
            Elements posters = doc.getElementsByClass("poster");
            if (posters != null && !posters.isEmpty()) {
                Elements imgs = ((Element)posters.get(0)).getElementsByTag("img");
                for (Element img : imgs) {
                    posterUrl = img.attr("src");
                    posterUrl = posterUrl.replaceAll("UX[0-9]{2,4}_", "");
                    posterUrl = posterUrl.replaceAll("UY[0-9]{2,4}_", "");
                    posterUrl = posterUrl.replaceAll("CR[0-9]{1,3},[0-9]{1,3},[0-9]{1,3},[0-9]{1,3}_", "");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)posterUrl)) {
                sr.setPosterUrl(posterUrl);
            }
            result.add(sr);
            return result;
        }
        elements = doc.getElementsByClass("findResult");
        for (Element tr : elements) {
            Object element2;
            if (!"tr".equalsIgnoreCase(tr.tagName())) continue;
            String movieName = "";
            String movieId = "";
            int year = 0;
            Elements tds = tr.getElementsByClass("result_text");
            block24: for (Object element2 : tds) {
                Matcher matcher;
                Pattern unwantedSearchResultPattern;
                if (!"td".equalsIgnoreCase(element2.tagName()) || (unwantedSearchResultPattern = this.getUnwantedSearchResultPattern()) != null && (matcher = unwantedSearchResultPattern.matcher(element2.text())).find()) continue;
                String localizedName = "";
                Elements italics = element2.getElementsByTag("i");
                if (italics.size() > 0) {
                    localizedName = italics.text().replace("\"", "");
                }
                Elements anchors = element2.getElementsByTag("a");
                for (Element a : anchors) {
                    if (!StringUtils.isNotEmpty((CharSequence)a.text())) continue;
                    movieName = StringUtils.isNotBlank((CharSequence)localizedName) && !language.equals("en") ? localizedName : a.text();
                    String href = a.attr("href");
                    Matcher matcher2 = IMDB_ID_PATTERN.matcher(href);
                    while (matcher2.find()) {
                        if (matcher2.group(1) == null) continue;
                        movieId = matcher2.group(1);
                    }
                    Pattern yearPattern = Pattern.compile("\\(([0-9]{4})|/\\)");
                    matcher2 = yearPattern.matcher(element2.text());
                    while (matcher2.find()) {
                        if (matcher2.group(1) == null) continue;
                        try {
                            year = Integer.parseInt(matcher2.group(1));
                            continue block24;
                        }
                        catch (Exception exception) {
                        }
                    }
                    continue block24;
                }
            }
            String posterUrl = "";
            tds = tr.getElementsByClass("primary_photo");
            element2 = tds.iterator();
            while (element2.hasNext()) {
                Element element3 = (Element)element2.next();
                Elements imgs = element3.getElementsByTag("img");
                for (Element img : imgs) {
                    posterUrl = img.attr("src");
                    posterUrl = posterUrl.replaceAll("UX[0-9]{2,4}_", "");
                    posterUrl = posterUrl.replaceAll("UY[0-9]{2,4}_", "");
                    posterUrl = posterUrl.replaceAll("CR[0-9]{1,3},[0-9]{1,3},[0-9]{1,3},[0-9]{1,3}_", "");
                }
            }
            if (StringUtils.isEmpty((CharSequence)movieName) || StringUtils.isEmpty((CharSequence)movieId)) continue;
            sr = new MediaSearchResult(ImdbMetadataProvider.providerInfo.getId(), query.getMediaType());
            sr.setTitle(movieName);
            sr.setIMDBId(movieId);
            sr.setYear(year);
            sr.setPosterUrl(posterUrl);
            if (movieId.equals(query.getImdbId())) {
                sr.setScore(1.0f);
            } else {
                float score = MetadataUtil.calculateScore((String)searchTerm, (String)movieName);
                if (posterUrl.isEmpty() || posterUrl.contains("nopicture")) {
                    this.getLogger().debug("no poster - downgrading score by 0.01");
                    score -= 0.01f;
                }
                if (this.yearDiffers(myear, year)) {
                    float diff = (float)Math.abs(year - myear) / 100.0f;
                    this.getLogger().debug("parsed year does not match search result year - downgrading score by " + diff);
                    score -= diff;
                }
                sr.setScore(score);
            }
            result.add(sr);
            if (result.size() < 40) continue;
            break;
        }
        Collections.sort(result);
        Collections.reverse(result);
        return result;
    }

    protected static String getAcceptLanguage(String language, String country) {
        Locale jreLocale;
        String combined;
        String combined2;
        Locale localeFromLanguage;
        ArrayList<String> languageString = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)language) && StringUtils.isNotBlank((CharSequence)country) && LocaleUtils.isAvailableLocale((Locale)new Locale(language, country))) {
            String combined3 = language + "-" + country;
            languageString.add(combined3.toLowerCase(Locale.ROOT));
        }
        if ((localeFromLanguage = UrlUtil.getLocaleFromLanguage((String)language)) != null && !languageString.contains(combined2 = language + "-" + localeFromLanguage.getCountry().toLowerCase(Locale.ROOT))) {
            languageString.add(combined2);
        }
        if (StringUtils.isNotBlank((CharSequence)language)) {
            languageString.add(language.toLowerCase(Locale.ROOT));
        }
        if (!languageString.contains(combined = ((jreLocale = Locale.getDefault()).getLanguage() + "-" + jreLocale.getCountry()).toLowerCase(Locale.ROOT))) {
            languageString.add(combined);
        }
        if (!languageString.contains(jreLocale.getLanguage().toLowerCase(Locale.ROOT))) {
            languageString.add(jreLocale.getLanguage().toLowerCase(Locale.ROOT));
        }
        if (!languageString.contains("en-us")) {
            languageString.add("en-us");
        }
        if (!languageString.contains("en")) {
            languageString.add("en");
        }
        StringBuilder languages = new StringBuilder();
        float qualifier = 1.0f;
        for (String line : languageString) {
            if (languages.length() > 0) {
                languages.append(",");
            }
            languages.append(line);
            if (qualifier < 1.0f) {
                languages.append(String.format(Locale.US, ";q=%1.1f", Float.valueOf(qualifier)));
            }
            qualifier = (float)((double)qualifier - 0.1);
        }
        return languages.toString().toLowerCase(Locale.ROOT);
    }

    protected void parseReferencePage(Document doc, MediaScrapeOptions options, MediaMetadata md) {
        Element producersElement;
        Element writersElement;
        Element castTableElement;
        Element directorsElement;
        Element releaseDateElement;
        Element topRatedElement;
        Element ratingElement;
        Element poster;
        String content;
        int startOfYear;
        Element originalTitleYear;
        String movieTitle;
        int yearStart;
        Element title = doc.getElementsByAttributeValue("name", "title").first();
        if (title != null && (yearStart = (movieTitle = ImdbMetadataProvider.cleanString(title.attr("content"))).lastIndexOf("(")) > 0) {
            movieTitle = movieTitle.substring(0, yearStart - 1).trim();
            md.setTitle(movieTitle);
        }
        if ((originalTitleYear = doc.getElementsByAttributeValue("property", "og:title").first()) != null && (startOfYear = (content = originalTitleYear.attr("content")).lastIndexOf("(")) > 0) {
            String originalTitle = content.substring(0, startOfYear - 1).trim();
            md.setOriginalTitle(originalTitle);
            String yearText = content.substring(startOfYear);
            Pattern yearPattern = Pattern.compile("[1-2][0-9]{3}");
            Matcher matcher = yearPattern.matcher(yearText);
            while (matcher.find()) {
                if (matcher.group(0) == null) continue;
                String movieYear = matcher.group(0);
                try {
                    md.setYear(Integer.parseInt(movieYear));
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        if ((poster = doc.getElementsByAttributeValue("property", "og:image").first()) != null) {
            int startOfExtension;
            int parameterStart;
            String posterUrl = poster.attr("content");
            int fileStart = posterUrl.lastIndexOf("/");
            if (fileStart > 0 && (parameterStart = posterUrl.indexOf("_", fileStart)) > 0 && (startOfExtension = posterUrl.lastIndexOf(".")) > parameterStart) {
                posterUrl = posterUrl.substring(0, parameterStart) + posterUrl.substring(startOfExtension);
            }
            ImdbMetadataProvider.processMediaArt(md, MediaArtwork.MediaArtworkType.POSTER, posterUrl);
        }
        if ((ratingElement = doc.getElementsByClass("ipl-rating-star__rating").first()) != null) {
            String ratingAsString = ratingElement.ownText().replace(",", ".");
            Element votesElement = doc.getElementsByClass("ipl-rating-star__total-votes").first();
            if (votesElement != null) {
                String countAsString = votesElement.ownText().replaceAll("[.,()]", "").trim();
                try {
                    MediaRating rating = new MediaRating("imdb");
                    rating.setRating(Float.valueOf(ratingAsString).floatValue());
                    rating.setVoteCount(MetadataUtil.parseInt((String)countAsString));
                    md.addRating(rating);
                }
                catch (Exception rating) {
                    // empty catch block
                }
            }
        }
        if ((topRatedElement = doc.getElementsByAttributeValue("href", "/chart/top").first()) != null) {
            Pattern topPattern = Pattern.compile("Top Rated Movies: #([0-9]{1,3})");
            Matcher matcher = topPattern.matcher(topRatedElement.ownText());
            while (matcher.find()) {
                if (matcher.group(1) == null) continue;
                try {
                    String top250Text = matcher.group(1);
                    md.setTop250(Integer.parseInt(top250Text));
                }
                catch (Exception top250Text) {}
            }
        }
        if ((releaseDateElement = doc.getElementsByAttributeValue("href", "/title/" + options.getImdbId().toLowerCase(Locale.ROOT) + "/releaseinfo").first()) != null) {
            String releaseDateText = releaseDateElement.ownText();
            int startOfCountry = releaseDateText.indexOf("(");
            if (startOfCountry > 0) {
                releaseDateText = releaseDateText.substring(0, startOfCountry - 1).trim();
            }
            md.setReleaseDate(this.parseDate(releaseDateText));
        }
        Elements elements = doc.getElementsByClass("ipl-zebra-list__label");
        block10: for (Object element : elements) {
            Certification certification;
            String certText;
            Matcher matcher;
            Pattern pattern;
            Element runtimeElement;
            Element nextElement;
            Element taglineElement;
            if (!"td".equals(element.tag().getName())) continue;
            String elementText = element.ownText();
            if (elementText.equals("Taglines") && !this.isUseTmdbForMovies() && (taglineElement = element.nextElementSibling()) != null) {
                String tagline = ImdbMetadataProvider.cleanString(taglineElement.ownText().replaceAll("\u00bb", ""));
                md.setTagline(tagline);
            }
            if (elementText.equals("Genres") && (nextElement = element.nextElementSibling()) != null) {
                Elements genreElements = nextElement.getElementsByAttributeValueStarting("href", "/genre/");
                for (Element genreElement : genreElements) {
                    String genreText = genreElement.ownText();
                    md.addGenre(ImdbMetadataProvider.getTmmGenre(genreText));
                }
            }
            if (elementText.equals("Runtime") && (nextElement = element.nextElementSibling()) != null && (runtimeElement = nextElement.getElementsByClass("ipl-inline-list__item").first()) != null) {
                int runtime;
                block59: {
                    String first = runtimeElement.ownText().split("\\|")[0];
                    String runtimeAsString = ImdbMetadataProvider.cleanString(first.replaceAll("min", ""));
                    runtime = 0;
                    try {
                        runtime = Integer.parseInt(runtimeAsString);
                    }
                    catch (Exception e) {
                        Pattern runtimePattern = Pattern.compile("([0-9]{2,3})");
                        Matcher matcher2 = runtimePattern.matcher(runtimeAsString);
                        if (!matcher2.find()) break block59;
                        runtime = Integer.parseInt(matcher2.group(0));
                    }
                }
                md.setRuntime(runtime);
            }
            if (elementText.equals("Country") && (nextElement = element.nextElementSibling()) != null) {
                Elements countryElements = nextElement.getElementsByAttributeValueStarting("href", "/country/");
                pattern = Pattern.compile("/country/(.*)");
                for (Element countryElement : countryElements) {
                    matcher = pattern.matcher(countryElement.attr("href"));
                    if (!matcher.matches()) continue;
                    if (ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("scrapeLanguageNames").booleanValue()) {
                        md.addCountry(LanguageUtils.getLocalizedCountryForLanguage((String)options.getLanguage().getLanguage(), (String[])new String[]{countryElement.text(), matcher.group(1)}));
                        continue;
                    }
                    md.addCountry(matcher.group(1));
                }
            }
            if (elementText.equals("Language") && (nextElement = element.nextElementSibling()) != null) {
                Elements languageElements = nextElement.getElementsByAttributeValueStarting("href", "/language/");
                pattern = Pattern.compile("/language/(.*)");
                for (Element languageElement : languageElements) {
                    matcher = pattern.matcher(languageElement.attr("href"));
                    if (!matcher.matches()) continue;
                    if (ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("scrapeLanguageNames").booleanValue()) {
                        md.addSpokenLanguage(LanguageUtils.getLocalizedLanguageNameFromLocalizedString((Locale)options.getLanguage(), (String[])new String[]{languageElement.text(), matcher.group(1)}));
                        continue;
                    }
                    md.addSpokenLanguage(matcher.group(1));
                }
            }
            if (!elementText.equals("Certification") || (nextElement = element.nextElementSibling()) == null) continue;
            String languageCode = options.getCountry().getAlpha2();
            Elements certificationElements = nextElement.getElementsByAttributeValueStarting("href", "/search/title?certificates=" + languageCode);
            boolean done = false;
            for (Element certificationElement : certificationElements) {
                certText = certificationElement.ownText();
                int startOfCert = certText.indexOf(":");
                if (startOfCert > 0 && certText.length() > startOfCert + 1) {
                    certText = certText.substring(startOfCert + 1);
                }
                if ((certification = Certification.getCertification((CountryCode)options.getCountry(), (String)certText)) == null) continue;
                md.addCertification(certification);
                done = true;
                break;
            }
            if (done || !languageCode.equals("DE")) continue;
            certificationElements = nextElement.getElementsByAttributeValueStarting("href", "/search/title?certificates=XWG");
            for (Element certificationElement : certificationElements) {
                certText = certificationElement.ownText();
                int startOfCert = certText.indexOf(":");
                if (startOfCert > 0 && certText.length() > startOfCert + 1) {
                    certText = certText.substring(startOfCert + 1);
                }
                if ((certification = Certification.getCertification((CountryCode)options.getCountry(), (String)certText)) == null) continue;
                md.addCertification(certification);
                continue block10;
            }
        }
        for (directorsElement = doc.getElementById("directors"); directorsElement != null && directorsElement.tag().getName() != "header"; directorsElement = directorsElement.parent()) {
        }
        if (directorsElement != null) {
            directorsElement = directorsElement.nextElementSibling();
        }
        if (directorsElement != null) {
            for (Element directorElement : directorsElement.getElementsByClass("name")) {
                Matcher matcher;
                String director = directorElement.text().trim();
                MediaCastMember cm = new MediaCastMember(MediaCastMember.CastType.DIRECTOR);
                cm.setName(director);
                Element anchor = directorElement.getElementsByAttributeValueStarting("href", "/name/").first();
                if (anchor != null && (matcher = PERSON_ID_PATTERN.matcher(anchor.attr("href"))).find()) {
                    if (matcher.group(0) != null) {
                        cm.setProfileUrl("http://www.imdb.com" + matcher.group(0));
                    }
                    if (matcher.group(1) != null) {
                        cm.setId(ImdbMetadataProvider.providerInfo.getId(), (Object)matcher.group(1));
                    }
                }
                md.addCastMember(cm);
            }
        }
        if ((castTableElement = doc.getElementsByClass("cast_list").first()) != null) {
            Elements tr = castTableElement.getElementsByTag("tr");
            for (Object row : tr) {
                MediaCastMember cm = this.parseCastMember((Element)row);
                if (cm == null || !StringUtils.isNotEmpty((CharSequence)cm.getName()) || !StringUtils.isNotEmpty((CharSequence)cm.getCharacter())) continue;
                cm.setType(MediaCastMember.CastType.ACTOR);
                md.addCastMember(cm);
            }
        }
        for (writersElement = doc.getElementById("writers"); writersElement != null && writersElement.tag().getName() != "header"; writersElement = writersElement.parent()) {
        }
        if (writersElement != null) {
            writersElement = writersElement.nextElementSibling();
        }
        if (writersElement != null) {
            Elements writersElements = writersElement.getElementsByAttributeValueStarting("href", "/name/");
            for (Object writerElement : writersElements) {
                Matcher matcher;
                String writer = ImdbMetadataProvider.cleanString(writerElement.ownText());
                MediaCastMember cm = new MediaCastMember(MediaCastMember.CastType.WRITER);
                cm.setName(writer);
                Element anchor = writerElement.getElementsByAttributeValueStarting("href", "/name/").first();
                if (anchor != null && (matcher = PERSON_ID_PATTERN.matcher(anchor.attr("href"))).find()) {
                    if (matcher.group(0) != null) {
                        cm.setProfileUrl("http://www.imdb.com" + matcher.group(0));
                    }
                    if (matcher.group(1) != null) {
                        cm.setId(ImdbMetadataProvider.providerInfo.getId(), (Object)matcher.group(1));
                    }
                }
                md.addCastMember(cm);
            }
        }
        for (producersElement = doc.getElementById("producers"); producersElement != null && producersElement.tag().getName() != "header"; producersElement = producersElement.parent()) {
        }
        if (producersElement != null) {
            producersElement = producersElement.nextElementSibling();
        }
        if (producersElement != null) {
            Elements producersElements = producersElement.getElementsByAttributeValueStarting("href", "/name/");
            for (Element producerElement : producersElements) {
                String producer = ImdbMetadataProvider.cleanString(producerElement.ownText());
                MediaCastMember cm = new MediaCastMember(MediaCastMember.CastType.PRODUCER);
                cm.setName(producer);
                md.addCastMember(cm);
            }
        }
        Elements prodCompHeaderElements = doc.getElementsByClass("ipl-list-title");
        Element prodCompHeaderElement = null;
        for (Element possibleProdCompHeaderEl : prodCompHeaderElements) {
            if (!possibleProdCompHeaderEl.ownText().equals("Production Companies")) continue;
            prodCompHeaderElement = possibleProdCompHeaderEl;
            break;
        }
        while (prodCompHeaderElement != null && prodCompHeaderElement.tag().getName() != "header") {
            prodCompHeaderElement = prodCompHeaderElement.parent();
        }
        if (prodCompHeaderElement != null) {
            prodCompHeaderElement = prodCompHeaderElement.nextElementSibling();
        }
        if (prodCompHeaderElement != null) {
            Elements prodCompElements = prodCompHeaderElement.getElementsByAttributeValueStarting("href", "/company/");
            for (Element prodCompElement : prodCompElements) {
                String prodComp = prodCompElement.ownText();
                md.addProductionCompany(prodComp);
            }
        }
    }

    protected void parsePlotsummaryPage(Document doc, MediaScrapeOptions options, MediaMetadata md) {
        if (this.getImdbSite() == ImdbSiteDefinition.IMDB_COM) {
            Elements p;
            Element zebraList = doc.getElementById("plot-summaries-content");
            if (zebraList != null && !(p = zebraList.getElementsByClass("ipl-zebra-list__item")).isEmpty()) {
                Element em = (Element)p.get(0);
                Elements authors = em.getElementsByClass("author-container");
                if (!authors.isEmpty()) {
                    ((Element)authors.get(0)).remove();
                }
                if (!"no-summary-content".equals(em.id())) {
                    String plot = ImdbMetadataProvider.cleanString(em.text());
                    md.setPlot(plot);
                }
            }
        } else {
            Element wiki = doc.getElementById("swiki.2.1");
            if (wiki != null) {
                String plot = ImdbMetadataProvider.cleanString(wiki.ownText());
                md.setPlot(plot);
            }
        }
    }

    protected MediaCastMember parseCastMember(Element row) {
        Matcher matcher;
        String imageSrc;
        Element nameElement = row.getElementsByAttributeValueStarting("itemprop", "name").first();
        if (nameElement == null) {
            return null;
        }
        String name = ImdbMetadataProvider.cleanString(nameElement.ownText());
        String characterName = "";
        Element characterElement = row.getElementsByClass("character").first();
        if (characterElement != null) {
            characterName = ImdbMetadataProvider.cleanString(characterElement.text());
            characterName = characterName.replaceAll("\\(.*?\\)$", "").trim();
        }
        String image = "";
        Element imageElement = row.getElementsByTag("img").first();
        if (imageElement != null && !StringUtils.isEmpty((CharSequence)(imageSrc = imageElement.attr("loadlate")))) {
            int startOfExtension;
            int parameterStart;
            int fileStart = imageSrc.lastIndexOf("/");
            if (fileStart > 0 && (parameterStart = imageSrc.indexOf("._", fileStart)) > 0 && (startOfExtension = imageSrc.lastIndexOf(".")) > parameterStart) {
                imageSrc = imageSrc.substring(0, parameterStart) + "._UY632" + imageSrc.substring(startOfExtension);
            }
            image = imageSrc;
        }
        String profilePath = "";
        String id = "";
        Element anchor = row.getElementsByAttributeValueStarting("href", "/name/").first();
        if (anchor != null && (matcher = PERSON_ID_PATTERN.matcher(anchor.attr("href"))).find()) {
            if (matcher.group(0) != null) {
                profilePath = "http://www.imdb.com" + matcher.group(0);
            }
            if (matcher.group(1) != null) {
                id = matcher.group(1);
            }
        }
        MediaCastMember cm = new MediaCastMember();
        cm.setId(ImdbMetadataProvider.providerInfo.getId(), (Object)id);
        cm.setCharacter(characterName);
        cm.setName(name);
        cm.setImageUrl(image);
        cm.setProfileUrl(profilePath);
        return cm;
    }

    private boolean yearDiffers(int i1, int i2) {
        return i1 > 0 && i2 > 0 && i1 != i2;
    }

    protected Date parseDate(String dateAsSting) {
        try {
            return this.sdf1.parse(dateAsSting);
        }
        catch (ParseException parseException) {
            try {
                return this.sdf2.parse(dateAsSting);
            }
            catch (ParseException parseException2) {
                try {
                    return this.sdf3.parse(dateAsSting);
                }
                catch (ParseException parseException3) {
                    try {
                        return this.sdf4.parse(dateAsSting);
                    }
                    catch (ParseException parseException4) {
                        return null;
                    }
                }
            }
        }
    }

    protected class ImdbWorker
    implements Callable<Document> {
        private String url;
        private String language;
        private String country;
        private ImdbSiteDefinition imdbSite;
        private Document doc = null;
        private boolean useCachedUrl;

        ImdbWorker(String url, String language, String country, ImdbSiteDefinition imdbSite) {
            this(url, language, country, imdbSite, false);
        }

        ImdbWorker(String url, String language, String country, ImdbSiteDefinition imdbSite, boolean useCachedUrl) {
            this.url = url;
            this.language = language;
            this.country = country;
            this.imdbSite = imdbSite;
            this.useCachedUrl = useCachedUrl;
        }

        @Override
        public Document call() throws Exception {
            Object url;
            this.doc = null;
            try {
                url = this.useCachedUrl ? new InMemoryCachedUrl(this.url) : new Url(this.url);
                url.addHeader("Accept-Language", ImdbParser.getAcceptLanguage(this.language, this.country));
            }
            catch (Exception e) {
                ImdbParser.this.getLogger().debug("tried to fetch imdb page {} - {}", (Object)this.url, (Object)e);
                throw new ScrapeException((Throwable)e);
            }
            try (InputStream is = url.getInputStream();){
                this.doc = Jsoup.parse((InputStream)is, (String)this.imdbSite.getCharset().displayName(), (String)"");
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                ImdbParser.this.getLogger().debug("tried to fetch imdb page {} - {}", (Object)this.url, (Object)e);
                throw e;
            }
            return this.doc;
        }
    }
}

