/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.JsonSerializable;

public abstract class AbstractModel
implements JsonSerializable {
    protected static final ObjectMapper OM = new ObjectMapper();
    protected String mType;

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static int parseInt(JsonNode node, String key) {
        return node.has(key) ? node.get(key).getIntValue() : -1;
    }

    public static String parseString(JsonNode node, String key) {
        return node.has(key) ? node.get(key).getTextValue() : null;
    }

    public static Boolean parseBoolean(JsonNode node, String key) {
        boolean hasKey = node.has(key);
        if (hasKey) {
            return node.get(key).getBooleanValue();
        }
        return null;
    }

    public static Double parseDouble(JsonNode node, String key) {
        return node.has(key) ? Double.valueOf(node.get(key).getDoubleValue()) : null;
    }

    public static ArrayList<String> getStringArray(JsonNode node, String key) {
        if (node.has(key)) {
            ArrayNode a = (ArrayNode)node.get(key);
            ArrayList<String> l = new ArrayList<String>(a.size());
            for (int i = 0; i < a.size(); ++i) {
                l.add(a.get(i).getTextValue());
            }
            return l;
        }
        return new ArrayList<String>(0);
    }

    public static ArrayList<Integer> getIntegerArray(JsonNode node, String key) {
        if (node.has(key)) {
            ArrayNode a = (ArrayNode)node.get(key);
            ArrayList<Integer> l = new ArrayList<Integer>(a.size());
            for (int i = 0; i < a.size(); ++i) {
                l.add(a.get(i).getIntValue());
            }
            return l;
        }
        return new ArrayList<Integer>(0);
    }

    public static HashMap<String, String> getStringMap(JsonNode node, String key) {
        if (node.has(key)) {
            ObjectNode n = (ObjectNode)node.get(key);
            HashMap<String, String> m = new HashMap<String, String>();
            Iterator it = n.getFieldNames();
            while (it.hasNext()) {
                String fieldName = (String)it.next();
                m.put(fieldName, n.get(fieldName).getValueAsText());
            }
            return m;
        }
        return new HashMap<String, String>();
    }
}

