/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.call;

import org.codehaus.jackson.JsonNode;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.ApplicationModel;
import org.tinymediamanager.jsonrpc.api.model.GlobalModel;

public final class Application {

    public static class SetVolume
    extends AbstractCall<Integer> {
        public static final String API_TYPE = "Application.SetVolume";

        public SetVolume(Integer volume) {
            this.addParameter("volume", volume);
        }

        public SetVolume(String volume) {
            this.addParameter("volume", volume);
        }

        @Override
        protected Integer parseOne(JsonNode node) {
            return node.getIntValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class SetMute
    extends AbstractCall<Boolean> {
        public static final String API_TYPE = "Application.SetMute";

        public SetMute(GlobalModel.Toggle mute) {
            this.addParameter("mute", (AbstractModel)mute);
        }

        @Override
        protected Boolean parseOne(JsonNode node) {
            return node.getBooleanValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class Quit
    extends AbstractCall<String> {
        public static final String API_TYPE = "Application.Quit";

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetProperties
    extends AbstractCall<ApplicationModel.PropertyValue> {
        public static final String API_TYPE = "Application.GetProperties";

        public GetProperties(String ... properties) {
            this.addParameter("properties", properties);
        }

        @Override
        protected ApplicationModel.PropertyValue parseOne(JsonNode node) {
            return new ApplicationModel.PropertyValue(node);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }
}

