/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.call;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.ListModel;

public final class Files {

    public static class PrepareDownload
    extends AbstractCall<PrepareDownloadResult> {
        public static final String API_TYPE = "Files.PrepareDownload";

        public PrepareDownload(String path) {
            this.addParameter("path", path);
        }

        @Override
        protected PrepareDownloadResult parseOne(JsonNode node) {
            return new PrepareDownloadResult(node);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static class PrepareDownloadResult
        extends AbstractModel {
            public static final String DETAILS = "details";
            public static final String MODE = "mode";
            public static final String PROTOCOL = "protocol";
            public final String details;
            public final String mode;
            public final String protocol;

            public PrepareDownloadResult(String details, String mode, String protocol) {
                this.details = details;
                this.mode = mode;
                this.protocol = protocol;
            }

            public PrepareDownloadResult(JsonNode node) {
                this.details = node.get(DETAILS).getTextValue();
                this.mode = PrepareDownloadResult.parseString(node, MODE);
                this.protocol = PrepareDownloadResult.parseString(node, PROTOCOL);
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(DETAILS, this.details);
                node.put(MODE, this.mode);
                node.put(PROTOCOL, this.protocol);
                return node;
            }

            static List<PrepareDownloadResult> getFilesPrepareDownloadResultList(JsonNode node, String key) {
                if (node.has(key)) {
                    ArrayNode a = (ArrayNode)node.get(key);
                    ArrayList<PrepareDownloadResult> l = new ArrayList<PrepareDownloadResult>(a.size());
                    for (int i = 0; i < a.size(); ++i) {
                        l.add(new PrepareDownloadResult(a.get(i)));
                    }
                    return l;
                }
                return new ArrayList<PrepareDownloadResult>(0);
            }

            public static interface Mode {
                public static final String REDIRECT = "redirect";
                public static final String DIRECT = "direct";
                public static final Set<String> values = new HashSet<String>(Arrays.asList("redirect", "direct"));
            }

            public static interface Protocol {
                public static final String HTTP = "http";
                public static final Set<String> values = new HashSet<String>(Arrays.asList("http"));
            }
        }
    }

    public static class GetSources
    extends AbstractCall<ListModel.SourceItem> {
        public static final String API_TYPE = "Files.GetSources";
        public static final String RESULT = "sources";

        public GetSources(String media, ListModel.Limits limits, ListModel.Sort sort) {
            this.addParameter("media", media);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
        }

        public GetSources(String media) {
            this.addParameter("media", media);
        }

        public GetSources(String media, ListModel.Limits limits) {
            this.addParameter("media", media);
            this.addParameter("limits", (AbstractModel)limits);
        }

        @Override
        protected ArrayList<ListModel.SourceItem> parseMany(JsonNode node) {
            ArrayNode sources = this.parseResults(node, RESULT);
            if (sources != null) {
                ArrayList<ListModel.SourceItem> ret = new ArrayList<ListModel.SourceItem>(sources.size());
                for (int i = 0; i < sources.size(); ++i) {
                    ObjectNode item = (ObjectNode)sources.get(i);
                    ret.add(new ListModel.SourceItem((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<ListModel.SourceItem>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class GetFileDetails
    extends AbstractCall<ListModel.FileItem> {
        public static final String API_TYPE = "Files.GetFileDetails";
        public static final String RESULT = "filedetails";

        public GetFileDetails(String file, String media, String ... properties) {
            this.addParameter("file", file);
            this.addParameter("media", media);
            this.addParameter("properties", properties);
        }

        public GetFileDetails(String file, String ... properties) {
            this.addParameter("file", file);
            this.addParameter("properties", properties);
        }

        @Override
        protected ListModel.FileItem parseOne(JsonNode node) {
            return new ListModel.FileItem((JsonNode)((ObjectNode)node.get(RESULT)));
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetDirectory
    extends AbstractCall<ListModel.FileItem> {
        public static final String API_TYPE = "Files.GetDirectory";
        public static final String RESULT = "files";

        public GetDirectory(String directory, String media, ListModel.Sort sort, ListModel.Limits limits, String ... properties) {
            this.addParameter("directory", directory);
            this.addParameter("media", media);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        public GetDirectory(String directory, String ... properties) {
            this.addParameter("directory", directory);
            this.addParameter("properties", properties);
        }

        public GetDirectory(String directory, String media, String ... properties) {
            this.addParameter("directory", directory);
            this.addParameter("media", media);
            this.addParameter("properties", properties);
        }

        public GetDirectory(String directory, ListModel.Sort sort, String ... properties) {
            this.addParameter("directory", directory);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetDirectory(String directory, String media, ListModel.Sort sort, String ... properties) {
            this.addParameter("directory", directory);
            this.addParameter("media", media);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetDirectory(String directory, ListModel.Limits limits, String ... properties) {
            this.addParameter("directory", directory);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        public GetDirectory(String directory, ListModel.Sort sort, ListModel.Limits limits, String ... properties) {
            this.addParameter("directory", directory);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<ListModel.FileItem> parseMany(JsonNode node) {
            ArrayNode files = this.parseResults(node, RESULT);
            if (files != null) {
                ArrayList<ListModel.FileItem> ret = new ArrayList<ListModel.FileItem>(files.size());
                for (int i = 0; i < files.size(); ++i) {
                    ObjectNode item = (ObjectNode)files.get(i);
                    ret.add(new ListModel.FileItem((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<ListModel.FileItem>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }
}

