/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.call;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.api.AbstractModel;

public final class JSONRPC {

    public static class Version
    extends AbstractCall<VersionResult> {
        public static final String API_TYPE = "JSONRPC.Version";

        @Override
        protected VersionResult parseOne(JsonNode node) {
            return new VersionResult(node);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static class VersionResult
        extends AbstractModel {
            public static final String MAJOR = "major";
            public static final String MINOR = "minor";
            public static final String PATCH = "patch";
            public static final HashMap<String, String> CODENAME = new HashMap();
            public final Integer major;
            public final Integer minor;
            public final Integer patch;

            public VersionResult(Integer major, Integer minor, Integer patch) {
                this.major = major;
                this.minor = minor;
                this.patch = patch;
            }

            @Override
            public String toString() {
                return this.major + "." + this.minor + "." + this.patch;
            }

            public String getKodiVersion() {
                String cn = CODENAME.get(this.toString());
                if (cn == null) {
                    if (this.major == 8) {
                        cn = "Kodi 17 (Krypton)";
                        if (this.minor > 3) {
                            cn = "Kodi 18 (Leia)";
                        }
                    }
                    if (this.major >= 9) {
                        cn = "Kodi 18 (Leia)";
                    }
                    if (cn == null) {
                        cn = "Unknown";
                    }
                }
                return cn;
            }

            public int toInt() {
                return this.patch + this.minor * 10000 + this.major * 10000000;
            }

            public VersionResult(JsonNode node) {
                this.major = node.findValue(MAJOR).getIntValue();
                this.minor = node.findValue(MINOR).getIntValue();
                this.patch = node.findValue(PATCH).getIntValue();
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(MAJOR, this.major);
                node.put(MINOR, this.minor);
                node.put(PATCH, this.patch);
                return node;
            }

            static List<VersionResult> getJSONRPCVersionResultList(JsonNode node, String key) {
                if (node.has(key)) {
                    ArrayNode a = (ArrayNode)node.get(key);
                    ArrayList<VersionResult> l = new ArrayList<VersionResult>(a.size());
                    for (int i = 0; i < a.size(); ++i) {
                        l.add(new VersionResult(a.get(i)));
                    }
                    return l;
                }
                return new ArrayList<VersionResult>(0);
            }

            static {
                CODENAME.put("8.3.0", "Kodi 18 (Leia)");
                CODENAME.put("8.0.0", "Kodi 17 (Krypton)");
                CODENAME.put("6.32.5", "Kodi 16.1 (Jarvis)");
                CODENAME.put("6.32.4", "Kodi 16.0 (Jarvis)");
                CODENAME.put("6.25.2", "Kodi 15 (Isengard)");
                CODENAME.put("6.21.2", "Kodi 14 (Helix)");
                CODENAME.put("6.14.3", "XBMC 13 (Gotham)");
            }
        }
    }

    public static class Ping
    extends AbstractCall<String> {
        public static final String API_TYPE = "JSONRPC.Ping";

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class Permission
    extends AbstractCall<PermissionResult> {
        public static final String API_TYPE = "JSONRPC.Permission";

        @Override
        protected PermissionResult parseOne(JsonNode node) {
            return new PermissionResult(node);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static class PermissionResult
        extends AbstractModel {
            public static final String CONTROLGUI = "controlgui";
            public static final String CONTROLNOTIFY = "controlnotify";
            public static final String CONTROLPLAYBACK = "controlplayback";
            public static final String CONTROLPOWER = "controlpower";
            public static final String CONTROLPVR = "controlpvr";
            public static final String CONTROLSYSTEM = "controlsystem";
            public static final String EXECUTEADDON = "executeaddon";
            public static final String MANAGEADDON = "manageaddon";
            public static final String NAVIGATE = "navigate";
            public static final String READDATA = "readdata";
            public static final String REMOVEDATA = "removedata";
            public static final String UPDATEDATA = "updatedata";
            public static final String WRITEFILE = "writefile";
            public final Boolean controlgui;
            public final Boolean controlnotify;
            public final Boolean controlplayback;
            public final Boolean controlpower;
            public final Boolean controlpvr;
            public final Boolean controlsystem;
            public final Boolean executeaddon;
            public final Boolean manageaddon;
            public final Boolean navigate;
            public final Boolean readdata;
            public final Boolean removedata;
            public final Boolean updatedata;
            public final Boolean writefile;

            public PermissionResult(Boolean controlgui, Boolean controlnotify, Boolean controlplayback, Boolean controlpower, Boolean controlpvr, Boolean controlsystem, Boolean executeaddon, Boolean manageaddon, Boolean navigate, Boolean readdata, Boolean removedata, Boolean updatedata, Boolean writefile) {
                this.controlgui = controlgui;
                this.controlnotify = controlnotify;
                this.controlplayback = controlplayback;
                this.controlpower = controlpower;
                this.controlpvr = controlpvr;
                this.controlsystem = controlsystem;
                this.executeaddon = executeaddon;
                this.manageaddon = manageaddon;
                this.navigate = navigate;
                this.readdata = readdata;
                this.removedata = removedata;
                this.updatedata = updatedata;
                this.writefile = writefile;
            }

            public PermissionResult(JsonNode node) {
                this.controlgui = node.get(CONTROLGUI).getBooleanValue();
                this.controlnotify = node.get(CONTROLNOTIFY).getBooleanValue();
                this.controlplayback = node.get(CONTROLPLAYBACK).getBooleanValue();
                this.controlpower = node.get(CONTROLPOWER).getBooleanValue();
                this.controlpvr = node.get(CONTROLPVR).getBooleanValue();
                this.controlsystem = node.get(CONTROLSYSTEM).getBooleanValue();
                this.executeaddon = node.get(EXECUTEADDON).getBooleanValue();
                this.manageaddon = node.get(MANAGEADDON).getBooleanValue();
                this.navigate = node.get(NAVIGATE).getBooleanValue();
                this.readdata = node.get(READDATA).getBooleanValue();
                this.removedata = node.get(REMOVEDATA).getBooleanValue();
                this.updatedata = node.get(UPDATEDATA).getBooleanValue();
                this.writefile = node.get(WRITEFILE).getBooleanValue();
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(CONTROLGUI, this.controlgui);
                node.put(CONTROLNOTIFY, this.controlnotify);
                node.put(CONTROLPLAYBACK, this.controlplayback);
                node.put(CONTROLPOWER, this.controlpower);
                node.put(CONTROLPVR, this.controlpvr);
                node.put(CONTROLSYSTEM, this.controlsystem);
                node.put(EXECUTEADDON, this.executeaddon);
                node.put(MANAGEADDON, this.manageaddon);
                node.put(NAVIGATE, this.navigate);
                node.put(READDATA, this.readdata);
                node.put(REMOVEDATA, this.removedata);
                node.put(UPDATEDATA, this.updatedata);
                node.put(WRITEFILE, this.writefile);
                return node;
            }

            static List<PermissionResult> getJSONRPCPermissionResultList(JsonNode node, String key) {
                if (node.has(key)) {
                    ArrayNode a = (ArrayNode)node.get(key);
                    ArrayList<PermissionResult> l = new ArrayList<PermissionResult>(a.size());
                    for (int i = 0; i < a.size(); ++i) {
                        l.add(new PermissionResult(a.get(i)));
                    }
                    return l;
                }
                return new ArrayList<PermissionResult>(0);
            }
        }
    }

    public static class NotifyAll
    extends AbstractCall<String> {
        public static final String API_TYPE = "JSONRPC.NotifyAll";

        public NotifyAll(String sender, String message, String data) {
            this.addParameter("sender", sender);
            this.addParameter("message", message);
            this.addParameter("data", data);
        }

        public NotifyAll(String sender, String message) {
            this.addParameter("sender", sender);
            this.addParameter("message", message);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }
}

