/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.call;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.BooleanNode;
import org.codehaus.jackson.node.DoubleNode;
import org.codehaus.jackson.node.IntNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.GlobalModel;
import org.tinymediamanager.jsonrpc.api.model.ListModel;
import org.tinymediamanager.jsonrpc.api.model.PlayerModel;
import org.tinymediamanager.jsonrpc.api.model.PlaylistModel;

public final class Player {

    public static class Zoom
    extends AbstractCall<String> {
        public static final String API_TYPE = "Player.Zoom";

        public Zoom(Integer playerid, String zoom) {
            this.addParameter("playerid", playerid);
            this.addParameter("zoom", zoom);
        }

        public Zoom(Integer playerid, Integer zoom) {
            this.addParameter("playerid", playerid);
            this.addParameter("zoom", zoom);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static interface ZoomValue {
            public static final String IN = "in";
            public static final String OUT = "out";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("in", "out"));
        }
    }

    public static class Stop
    extends AbstractCall<String> {
        public static final String API_TYPE = "Player.Stop";

        public Stop(Integer playerid) {
            this.addParameter("playerid", playerid);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class SetSubtitle
    extends AbstractCall<String> {
        public static final String API_TYPE = "Player.SetSubtitle";

        public SetSubtitle(Integer playerid, String subtitle, Boolean enable) {
            this.addParameter("playerid", playerid);
            this.addParameter("subtitle", subtitle);
            this.addParameter("enable", enable);
        }

        public SetSubtitle(Integer playerid, Integer subtitle, Boolean enable) {
            this.addParameter("playerid", playerid);
            this.addParameter("subtitle", subtitle);
            this.addParameter("enable", enable);
        }

        public SetSubtitle(Integer playerid, String subtitle) {
            this.addParameter("playerid", playerid);
            this.addParameter("subtitle", subtitle);
        }

        public SetSubtitle(Integer playerid, Integer subtitle) {
            this.addParameter("playerid", playerid);
            this.addParameter("subtitle", subtitle);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static interface Subtitle {
            public static final String PREVIOUS = "previous";
            public static final String NEXT = "next";
            public static final String OFF = "off";
            public static final String ON = "on";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("previous", "next", "off", "on"));
        }
    }

    public static class SetSpeed
    extends AbstractCall<PlayerModel.Speed> {
        public static final String API_TYPE = "Player.SetSpeed";

        public SetSpeed(Integer playerid, Integer speed) {
            this.addParameter("playerid", playerid);
            this.addParameter("speed", speed);
        }

        @Override
        protected PlayerModel.Speed parseOne(JsonNode node) {
            return new PlayerModel.Speed(node);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static interface Speed {
            public static final Integer MINUS_32 = -32;
            public static final Integer MINUS_16 = -16;
            public static final Integer MINUS_8 = -8;
            public static final Integer MINUS_4 = -4;
            public static final Integer MINUS_2 = -2;
            public static final Integer MINUS_1 = -1;
            public static final Integer ZERO = 0;
            public static final Integer PLUS_1 = 1;
            public static final Integer PLUS_2 = 2;
            public static final Integer PLUS_4 = 4;
            public static final Integer PLUS_8 = 8;
            public static final Integer PLUS_16 = 16;
            public static final Integer PLUS_32 = 32;
            public static final Set<Integer> values = new HashSet<Integer>(Arrays.asList(MINUS_32, MINUS_16, MINUS_8, MINUS_4, MINUS_2, MINUS_1, ZERO, PLUS_1, PLUS_2, PLUS_4, PLUS_8, PLUS_16, PLUS_32));
        }
    }

    public static class SetShuffle
    extends AbstractCall<String> {
        public static final String API_TYPE = "Player.SetShuffle";

        public SetShuffle(Integer playerid, GlobalModel.Toggle shuffle) {
            this.addParameter("playerid", playerid);
            this.addParameter("shuffle", (AbstractModel)shuffle);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class SetRepeat
    extends AbstractCall<String> {
        public static final String API_TYPE = "Player.SetRepeat";

        public SetRepeat(Integer playerid, String repeat) {
            this.addParameter("playerid", playerid);
            this.addParameter("repeat", repeat);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class SetPartymode
    extends AbstractCall<String> {
        public static final String API_TYPE = "Player.SetPartymode";

        public SetPartymode(Integer playerid, GlobalModel.Toggle partymode) {
            this.addParameter("playerid", playerid);
            this.addParameter("partymode", (AbstractModel)partymode);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class SetAudioStream
    extends AbstractCall<String> {
        public static final String API_TYPE = "Player.SetAudioStream";

        public SetAudioStream(Integer playerid, String stream) {
            this.addParameter("playerid", playerid);
            this.addParameter("stream", stream);
        }

        public SetAudioStream(Integer playerid, Integer stream) {
            this.addParameter("playerid", playerid);
            this.addParameter("stream", stream);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static interface Stream {
            public static final String PREVIOUS = "previous";
            public static final String NEXT = "next";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("previous", "next"));
        }
    }

    public static class Seek
    extends AbstractCall<SeekResult> {
        public static final String API_TYPE = "Player.Seek";

        public Seek(Integer playerid, Double value) {
            this.addParameter("playerid", playerid);
            this.addParameter("value", value);
        }

        public Seek(Integer playerid, PlayerModel.PositionTime value) {
            this.addParameter("playerid", playerid);
            this.addParameter("value", (AbstractModel)value);
        }

        public Seek(Integer playerid, String value) {
            this.addParameter("playerid", playerid);
            this.addParameter("value", value);
        }

        public Seek(Integer playerid, ValuePercentage value) {
            this.addParameter("playerid", playerid);
            this.addParameter("value", (AbstractModel)value);
        }

        public Seek(Integer playerid, ValueTime value) {
            this.addParameter("playerid", playerid);
            this.addParameter("value", (AbstractModel)value);
        }

        public Seek(Integer playerid, ValueStep value) {
            this.addParameter("playerid", playerid);
            this.addParameter("value", (AbstractModel)value);
        }

        public Seek(Integer playerid, ValueSecond value) {
            this.addParameter("playerid", playerid);
            this.addParameter("value", (AbstractModel)value);
        }

        @Override
        protected SeekResult parseOne(JsonNode node) {
            return new SeekResult(node);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static interface Value {
            public static final String SMALLFORWARD = "smallforward";
            public static final String SMALLBACKWARD = "smallbackward";
            public static final String BIGFORWARD = "bigforward";
            public static final String BIGBACKWARD = "bigbackward";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("smallforward", "smallbackward", "bigforward", "bigbackward"));
        }

        public static class SeekResult
        extends AbstractModel {
            public static final String PERCENTAGE = "percentage";
            public static final String TIME = "time";
            public static final String TOTALTIME = "totaltime";
            public final Double percentage;
            public final GlobalModel.Time time;
            public final GlobalModel.Time totaltime;

            public SeekResult(Double percentage, GlobalModel.Time time, GlobalModel.Time totaltime) {
                this.percentage = percentage;
                this.time = time;
                this.totaltime = totaltime;
            }

            public SeekResult(JsonNode node) {
                this.percentage = SeekResult.parseDouble(node, PERCENTAGE);
                this.time = node.has(TIME) ? new GlobalModel.Time(node.get(TIME)) : null;
                this.totaltime = node.has(TOTALTIME) ? new GlobalModel.Time(node.get(TOTALTIME)) : null;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(PERCENTAGE, this.percentage);
                node.put(TIME, this.time == null ? null : this.time.toJsonNode());
                node.put(TOTALTIME, this.totaltime == null ? null : this.totaltime.toJsonNode());
                return node;
            }

            static List<SeekResult> getPlayerSeekResultList(JsonNode node, String key) {
                if (node.has(key)) {
                    ArrayNode a = (ArrayNode)node.get(key);
                    ArrayList<SeekResult> l = new ArrayList<SeekResult>(a.size());
                    for (int i = 0; i < a.size(); ++i) {
                        l.add(new SeekResult(a.get(i)));
                    }
                    return l;
                }
                return new ArrayList<SeekResult>(0);
            }
        }

        public static class ValueSecond
        extends AbstractModel {
            public static final String SECONDS = "seconds";
            public final Integer seconds;

            public ValueSecond(Integer seconds) {
                this.seconds = seconds;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(SECONDS, this.seconds);
                return node;
            }
        }

        public static class ValueStep
        extends AbstractModel {
            public static final String STEP = "step";
            public final String step;

            public ValueStep(String step) {
                this.step = step;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(STEP, this.step);
                return node;
            }

            public static interface Step {
                public static final String SMALLFORWARD = "smallforward";
                public static final String SMALLBACKWARD = "smallbackward";
                public static final String BIGFORWARD = "bigforward";
                public static final String BIGBACKWARD = "bigbackward";
                public static final Set<String> values = new HashSet<String>(Arrays.asList("smallforward", "smallbackward", "bigforward", "bigbackward"));
            }
        }

        public static class ValueTime
        extends AbstractModel {
            public static final String TIME = "time";
            public final PlayerModel.PositionTime time;

            public ValueTime(PlayerModel.PositionTime time) {
                this.time = time;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(TIME, this.time == null ? null : this.time.toJsonNode());
                return node;
            }
        }

        public static class ValuePercentage
        extends AbstractModel {
            public static final String PERCENTAGE = "percentage";
            public final Double percentage;

            public ValuePercentage(Double percentage) {
                this.percentage = percentage;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(PERCENTAGE, this.percentage);
                return node;
            }
        }
    }

    public static class Rotate
    extends AbstractCall<String> {
        public static final String API_TYPE = "Player.Rotate";

        public Rotate(Integer playerid, String value) {
            this.addParameter("playerid", playerid);
            this.addParameter("value", value);
        }

        public Rotate(Integer playerid) {
            this.addParameter("playerid", playerid);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static interface Value {
            public static final String CLOCKWISE = "clockwise";
            public static final String COUNTERCLOCKWISE = "counterclockwise";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("clockwise", "counterclockwise"));
        }
    }

    public static class PlayPause
    extends AbstractCall<PlayerModel.Speed> {
        public static final String API_TYPE = "Player.PlayPause";

        public PlayPause(Integer playerid, GlobalModel.Toggle play) {
            this.addParameter("playerid", playerid);
            this.addParameter("play", (AbstractModel)play);
        }

        public PlayPause(Integer playerid) {
            this.addParameter("playerid", playerid);
        }

        @Override
        protected PlayerModel.Speed parseOne(JsonNode node) {
            return new PlayerModel.Speed(node);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class Open
    extends AbstractCall<String> {
        public static final String API_TYPE = "Player.Open";

        public Open(ItemPlaylistIdPosition item, Option options) {
            this.addParameter("item", (AbstractModel)item);
            this.addParameter("options", (AbstractModel)options);
        }

        public Open(PlaylistModel.Item item, Option options) {
            this.addParameter("item", (AbstractModel)item);
            this.addParameter("options", (AbstractModel)options);
        }

        public Open(ItemPathRandomRecursive item, Option options) {
            this.addParameter("item", (AbstractModel)item);
            this.addParameter("options", (AbstractModel)options);
        }

        public Open(ItemPartymode item, Option options) {
            this.addParameter("item", (AbstractModel)item);
            this.addParameter("options", (AbstractModel)options);
        }

        public Open(ItemChannelId item, Option options) {
            this.addParameter("item", (AbstractModel)item);
            this.addParameter("options", (AbstractModel)options);
        }

        public Open(ItemRecordingId item, Option options) {
            this.addParameter("item", (AbstractModel)item);
            this.addParameter("options", (AbstractModel)options);
        }

        public Open() {
        }

        public Open(ItemPlaylistIdPosition item) {
            this.addParameter("item", (AbstractModel)item);
        }

        public Open(PlaylistModel.Item item) {
            this.addParameter("item", (AbstractModel)item);
        }

        public Open(ItemPathRandomRecursive item) {
            this.addParameter("item", (AbstractModel)item);
        }

        public Open(ItemPartymode item) {
            this.addParameter("item", (AbstractModel)item);
        }

        public Open(ItemChannelId item) {
            this.addParameter("item", (AbstractModel)item);
        }

        public Open(ItemRecordingId item) {
            this.addParameter("item", (AbstractModel)item);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static class Option
        extends AbstractModel {
            public static final String PLAYERCOREID = "playercoreid";
            public static final String REPEAT = "repeat";
            public static final String RESUME = "resume";
            public static final String SHUFFLED = "shuffled";
            public final Playercoreid playercoreid;
            public final String repeat;
            public final Resume resume;
            public final Boolean shuffled;

            public Option(Playercoreid playercoreid, String repeat, Resume resume, Boolean shuffled) {
                this.playercoreid = playercoreid;
                this.repeat = repeat;
                this.resume = resume;
                this.shuffled = shuffled;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(PLAYERCOREID, this.playercoreid == null ? null : this.playercoreid.toJsonNode());
                node.put(REPEAT, this.repeat);
                node.put(RESUME, this.resume == null ? null : this.resume.toJsonNode());
                node.put(SHUFFLED, this.shuffled);
                return node;
            }

            public static class Playercoreid
            extends AbstractModel {
                public final Integer integerArg;
                public final String stringArg;

                public Playercoreid(Integer integerArg) {
                    this.integerArg = integerArg;
                    this.stringArg = null;
                }

                public Playercoreid(String stringArg) {
                    this.stringArg = stringArg;
                    this.integerArg = null;
                }

                @Override
                public JsonNode toJsonNode() {
                    if (this.integerArg != null) {
                        return new IntNode(this.integerArg.intValue());
                    }
                    if (this.stringArg != null) {
                        return new TextNode(this.stringArg);
                    }
                    return null;
                }

                public static interface StringArg {
                    public static final String DEFAULT = "default";
                    public static final Set<String> values = new HashSet<String>(Arrays.asList("default"));
                }
            }

            public static class Resume
            extends AbstractModel {
                public final Boolean booleanArg;
                public final Double positionPercentage;
                public final PlayerModel.PositionTime positionTime;

                public Resume(Boolean booleanArg) {
                    this.booleanArg = booleanArg;
                    this.positionPercentage = null;
                    this.positionTime = null;
                }

                public Resume(Double positionPercentage) {
                    this.positionPercentage = positionPercentage;
                    this.booleanArg = null;
                    this.positionTime = null;
                }

                public Resume(PlayerModel.PositionTime positionTime) {
                    this.positionTime = positionTime;
                    this.booleanArg = null;
                    this.positionPercentage = null;
                }

                @Override
                public JsonNode toJsonNode() {
                    if (this.booleanArg != null) {
                        return this.booleanArg != false ? BooleanNode.TRUE : BooleanNode.FALSE;
                    }
                    if (this.positionPercentage != null) {
                        return new DoubleNode(this.positionPercentage.doubleValue());
                    }
                    if (this.positionTime != null) {
                        return this.positionTime.toJsonNode();
                    }
                    return null;
                }
            }
        }

        public static class ItemRecordingId
        extends AbstractModel {
            public static final String RECORDINGID = "recordingid";
            public final Integer recordingid;

            public ItemRecordingId(Integer recordingid) {
                this.recordingid = recordingid;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(RECORDINGID, this.recordingid);
                return node;
            }
        }

        public static class ItemChannelId
        extends AbstractModel {
            public static final String CHANNELID = "channelid";
            public final Integer channelid;

            public ItemChannelId(Integer channelid) {
                this.channelid = channelid;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(CHANNELID, this.channelid);
                return node;
            }
        }

        public static class ItemPartymode
        extends AbstractModel {
            public static final String PARTYMODE = "partymode";
            public final String partymode;

            public ItemPartymode(String partymode) {
                this.partymode = partymode;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(PARTYMODE, this.partymode);
                return node;
            }
        }

        public static class ItemPathRandomRecursive
        extends AbstractModel {
            public static final String PATH = "path";
            public static final String RANDOM = "random";
            public static final String RECURSIVE = "recursive";
            public final String path;
            public final Boolean random;
            public final Boolean recursive;

            public ItemPathRandomRecursive(String path, Boolean random, Boolean recursive) {
                this.path = path;
                this.random = random;
                this.recursive = recursive;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(PATH, this.path);
                node.put(RANDOM, this.random);
                node.put(RECURSIVE, this.recursive);
                return node;
            }
        }

        public static class ItemPlaylistIdPosition
        extends AbstractModel {
            public static final String PLAYLISTID = "playlistid";
            public static final String POSITION = "position";
            public final Integer playlistid;
            public final Integer position;

            public ItemPlaylistIdPosition(Integer playlistid, Integer position) {
                this.playlistid = playlistid;
                this.position = position;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(PLAYLISTID, this.playlistid);
                node.put(POSITION, this.position);
                return node;
            }
        }
    }

    public static class Move
    extends AbstractCall<String> {
        public static final String API_TYPE = "Player.Move";

        public Move(Integer playerid, String direction) {
            this.addParameter("playerid", playerid);
            this.addParameter("direction", direction);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static interface Direction {
            public static final String LEFT = "left";
            public static final String RIGHT = "right";
            public static final String UP = "up";
            public static final String DOWN = "down";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("left", "right", "up", "down"));
        }
    }

    public static class GoTo
    extends AbstractCall<String> {
        public static final String API_TYPE = "Player.GoTo";

        public GoTo(Integer playerid, String to) {
            this.addParameter("playerid", playerid);
            this.addParameter("to", to);
        }

        public GoTo(Integer playerid, Integer to) {
            this.addParameter("playerid", playerid);
            this.addParameter("to", to);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static interface To {
            public static final String PREVIOUS = "previous";
            public static final String NEXT = "next";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("previous", "next"));
        }
    }

    public static class GetProperties
    extends AbstractCall<PlayerModel.PropertyValue> {
        public static final String API_TYPE = "Player.GetProperties";

        public GetProperties(Integer playerid, String ... properties) {
            this.addParameter("playerid", playerid);
            this.addParameter("properties", properties);
        }

        @Override
        protected PlayerModel.PropertyValue parseOne(JsonNode node) {
            return new PlayerModel.PropertyValue(node);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetPlayers
    extends AbstractCall<GetPlayersResult> {
        public static final String API_TYPE = "Player.GetPlayers";

        public GetPlayers(String media) {
            this.addParameter("media", media);
        }

        @Override
        protected ArrayList<GetPlayersResult> parseMany(JsonNode node) {
            ArrayNode results = (ArrayNode)node;
            if (results != null) {
                ArrayList<GetPlayersResult> ret = new ArrayList<GetPlayersResult>(results.size());
                for (int i = 0; i < results.size(); ++i) {
                    ObjectNode item = (ObjectNode)results.get(i);
                    ret.add(new GetPlayersResult((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<GetPlayersResult>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }

        public static interface Media {
            public static final String ALL = "all";
            public static final String VIDEO = "video";
            public static final String AUDIO = "audio";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("all", "video", "audio"));
        }

        public static class GetPlayersResult
        extends AbstractModel {
            public static final String NAME = "name";
            public static final String PLAYERCOREID = "playercoreid";
            public static final String PLAYSAUDIO = "playsaudio";
            public static final String PLAYSVIDEO = "playsvideo";
            public static final String TYPE = "type";
            public final String name;
            public final Integer playercoreid;
            public final Boolean playsaudio;
            public final Boolean playsvideo;
            public final String type;

            public GetPlayersResult(String name, Integer playercoreid, Boolean playsaudio, Boolean playsvideo, String type) {
                this.name = name;
                this.playercoreid = playercoreid;
                this.playsaudio = playsaudio;
                this.playsvideo = playsvideo;
                this.type = type;
            }

            public GetPlayersResult(JsonNode node) {
                this.name = GetPlayersResult.parseString(node, NAME);
                this.playercoreid = node.get(PLAYERCOREID).getIntValue();
                this.playsaudio = node.get(PLAYSAUDIO).getBooleanValue();
                this.playsvideo = node.get(PLAYSVIDEO).getBooleanValue();
                this.type = GetPlayersResult.parseString(node, TYPE);
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(NAME, this.name);
                node.put(PLAYERCOREID, this.playercoreid);
                node.put(PLAYSAUDIO, this.playsaudio);
                node.put(PLAYSVIDEO, this.playsvideo);
                node.put(TYPE, this.type);
                return node;
            }

            static List<GetPlayersResult> getPlayerGetPlayersResultList(JsonNode node, String key) {
                if (node.has(key)) {
                    ArrayNode a = (ArrayNode)node.get(key);
                    ArrayList<GetPlayersResult> l = new ArrayList<GetPlayersResult>(a.size());
                    for (int i = 0; i < a.size(); ++i) {
                        l.add(new GetPlayersResult(a.get(i)));
                    }
                    return l;
                }
                return new ArrayList<GetPlayersResult>(0);
            }

            public static interface Type {
                public static final String INTERNAL = "internal";
                public static final String EXTERNAL = "external";
                public static final String REMOTE = "remote";
                public static final Set<String> values = new HashSet<String>(Arrays.asList("internal", "external", "remote"));
            }
        }
    }

    public static class GetItem
    extends AbstractCall<ListModel.AllItems> {
        public static final String API_TYPE = "Player.GetItem";
        public static final String RESULT = "item";

        public GetItem(Integer playerid, String ... properties) {
            this.addParameter("playerid", playerid);
            this.addParameter("properties", properties);
        }

        @Override
        protected ListModel.AllItems parseOne(JsonNode node) {
            return new ListModel.AllItems((JsonNode)((ObjectNode)node.get(RESULT)));
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetActivePlayers
    extends AbstractCall<GetActivePlayersResult> {
        public static final String API_TYPE = "Player.GetActivePlayers";

        @Override
        protected ArrayList<GetActivePlayersResult> parseMany(JsonNode node) {
            ArrayNode results = (ArrayNode)node;
            if (results != null) {
                ArrayList<GetActivePlayersResult> ret = new ArrayList<GetActivePlayersResult>(results.size());
                for (int i = 0; i < results.size(); ++i) {
                    ObjectNode item = (ObjectNode)results.get(i);
                    ret.add(new GetActivePlayersResult((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<GetActivePlayersResult>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }

        public static class GetActivePlayersResult
        extends AbstractModel {
            public static final String PLAYERID = "playerid";
            public static final String TYPE = "type";
            public final Integer playerid;
            public final String type;

            public GetActivePlayersResult(Integer playerid, String type) {
                this.playerid = playerid;
                this.type = type;
            }

            public GetActivePlayersResult(JsonNode node) {
                this.playerid = GetActivePlayersResult.parseInt(node, PLAYERID);
                this.type = GetActivePlayersResult.parseString(node, TYPE);
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(PLAYERID, this.playerid);
                node.put(TYPE, this.type);
                return node;
            }

            static List<GetActivePlayersResult> getPlayerGetActivePlayersResultList(JsonNode node, String key) {
                if (node.has(key)) {
                    ArrayNode a = (ArrayNode)node.get(key);
                    ArrayList<GetActivePlayersResult> l = new ArrayList<GetActivePlayersResult>(a.size());
                    for (int i = 0; i < a.size(); ++i) {
                        l.add(new GetActivePlayersResult(a.get(i)));
                    }
                    return l;
                }
                return new ArrayList<GetActivePlayersResult>(0);
            }

            public static interface Type {
                public static final String VIDEO = "video";
                public static final String AUDIO = "audio";
                public static final String PICTURE = "picture";
                public static final Set<String> values = new HashSet<String>(Arrays.asList("video", "audio", "picture"));
            }
        }
    }
}

