/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.model.MediaModel;

public final class AudioModel {

    public static interface SongFields {
        public static final String TITLE = "title";
        public static final String ARTIST = "artist";
        public static final String ALBUMARTIST = "albumartist";
        public static final String GENRE = "genre";
        public static final String YEAR = "year";
        public static final String RATING = "rating";
        public static final String ALBUM = "album";
        public static final String TRACK = "track";
        public static final String DURATION = "duration";
        public static final String COMMENT = "comment";
        public static final String LYRICS = "lyrics";
        public static final String MUSICBRAINZTRACKID = "musicbrainztrackid";
        public static final String MUSICBRAINZARTISTID = "musicbrainzartistid";
        public static final String MUSICBRAINZALBUMID = "musicbrainzalbumid";
        public static final String MUSICBRAINZALBUMARTISTID = "musicbrainzalbumartistid";
        public static final String PLAYCOUNT = "playcount";
        public static final String FANART = "fanart";
        public static final String THUMBNAIL = "thumbnail";
        public static final String FILE = "file";
        public static final String ALBUMID = "albumid";
        public static final String LASTPLAYED = "lastplayed";
        public static final String DISC = "disc";
        public static final String GENREID = "genreid";
        public static final String ARTISTID = "artistid";
        public static final String DISPLAYARTIST = "displayartist";
        public static final String ALBUMARTISTID = "albumartistid";
        public static final String ALBUMRELEASETYPE = "albumreleasetype";
        public static final String DATEADDED = "dateadded";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "artist", "albumartist", "genre", "year", "rating", "album", "track", "duration", "comment", "lyrics", "musicbrainztrackid", "musicbrainzartistid", "musicbrainzalbumid", "musicbrainzalbumartistid", "playcount", "fanart", "thumbnail", "file", "albumid", "lastplayed", "disc", "genreid", "artistid", "displayartist", "albumartistid", "albumreleasetype", "dateadded"));
    }

    public static interface ArtistFields {
        public static final String INSTRUMENT = "instrument";
        public static final String STYLE = "style";
        public static final String MOOD = "mood";
        public static final String BORN = "born";
        public static final String FORMED = "formed";
        public static final String DESCRIPTION = "description";
        public static final String GENRE = "genre";
        public static final String DIED = "died";
        public static final String DISBANDED = "disbanded";
        public static final String YEARSACTIVE = "yearsactive";
        public static final String MUSICBRAINZARTISTID = "musicbrainzartistid";
        public static final String FANART = "fanart";
        public static final String THUMBNAIL = "thumbnail";
        public static final String COMPILATIONARTIST = "compilationartist";
        public static final String DATEADDED = "dateadded";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("instrument", "style", "mood", "born", "formed", "description", "genre", "died", "disbanded", "yearsactive", "musicbrainzartistid", "fanart", "thumbnail", "compilationartist", "dateadded"));
    }

    public static interface AlbumFields {
        public static final String TITLE = "title";
        public static final String DESCRIPTION = "description";
        public static final String ARTIST = "artist";
        public static final String GENRE = "genre";
        public static final String THEME = "theme";
        public static final String MOOD = "mood";
        public static final String STYLE = "style";
        public static final String TYPE = "type";
        public static final String ALBUMLABEL = "albumlabel";
        public static final String RATING = "rating";
        public static final String YEAR = "year";
        public static final String MUSICBRAINZALBUMID = "musicbrainzalbumid";
        public static final String MUSICBRAINZALBUMARTISTID = "musicbrainzalbumartistid";
        public static final String FANART = "fanart";
        public static final String THUMBNAIL = "thumbnail";
        public static final String PLAYCOUNT = "playcount";
        public static final String GENREID = "genreid";
        public static final String ARTISTID = "artistid";
        public static final String DISPLAYARTIST = "displayartist";
        public static final String COMPILATION = "compilation";
        public static final String RELEASETYPE = "releasetype";
        public static final String DATEADDED = "dateadded";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "description", "artist", "genre", "theme", "mood", "style", "type", "albumlabel", "rating", "year", "musicbrainzalbumid", "musicbrainzalbumartistid", "fanart", "thumbnail", "playcount", "genreid", "artistid", "displayartist", "compilation", "releasetype", "dateadded"));
    }

    public static class SongDetail
    extends MediaDetail {
        public static final String API_TYPE = "Audio.Details.Song";
        public static final String ALBUM = "album";
        public static final String ALBUMARTIST = "albumartist";
        public static final String ALBUMARTISTID = "albumartistid";
        public static final String ALBUMID = "albumid";
        public static final String ALBUMRELEASETYPE = "albumreleasetype";
        public static final String COMMENT = "comment";
        public static final String DISC = "disc";
        public static final String DURATION = "duration";
        public static final String FILE = "file";
        public static final String LASTPLAYED = "lastplayed";
        public static final String LYRICS = "lyrics";
        public static final String MUSICBRAINZARTISTID = "musicbrainzartistid";
        public static final String MUSICBRAINZTRACKID = "musicbrainztrackid";
        public static final String PLAYCOUNT = "playcount";
        public static final String SONGID = "songid";
        public static final String TRACK = "track";
        public final String album;
        public final List<String> albumartist;
        public final List<Integer> albumartistid;
        public final Integer albumid;
        public final String albumreleasetype;
        public final String comment;
        public final Integer disc;
        public final Integer duration;
        public final String file;
        public final String lastplayed;
        public final String lyrics;
        public final String musicbrainzartistid;
        public final String musicbrainztrackid;
        public final Integer playcount;
        public final Integer songid;
        public final Integer track;

        public SongDetail(JsonNode node) {
            super(node);
            this.album = SongDetail.parseString(node, ALBUM);
            this.albumartist = SongDetail.getStringArray(node, ALBUMARTIST);
            this.albumartistid = SongDetail.getIntegerArray(node, ALBUMARTISTID);
            this.albumid = SongDetail.parseInt(node, ALBUMID);
            this.albumreleasetype = SongDetail.parseString(node, ALBUMRELEASETYPE);
            this.comment = SongDetail.parseString(node, COMMENT);
            this.disc = SongDetail.parseInt(node, DISC);
            this.duration = SongDetail.parseInt(node, DURATION);
            this.file = SongDetail.parseString(node, FILE);
            this.lastplayed = SongDetail.parseString(node, LASTPLAYED);
            this.lyrics = SongDetail.parseString(node, LYRICS);
            this.musicbrainzartistid = SongDetail.parseString(node, MUSICBRAINZARTISTID);
            this.musicbrainztrackid = SongDetail.parseString(node, MUSICBRAINZTRACKID);
            this.playcount = SongDetail.parseInt(node, PLAYCOUNT);
            this.songid = SongDetail.parseInt(node, SONGID);
            this.track = SongDetail.parseInt(node, TRACK);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(ALBUM, this.album);
            ArrayNode albumartistArray = OM.createArrayNode();
            for (String item : this.albumartist) {
                albumartistArray.add(item);
            }
            node.put(ALBUMARTIST, (JsonNode)albumartistArray);
            ArrayNode albumartistidArray = OM.createArrayNode();
            for (Integer item : this.albumartistid) {
                albumartistidArray.add(item);
            }
            node.put(ALBUMARTISTID, (JsonNode)albumartistidArray);
            node.put(ALBUMID, this.albumid);
            node.put(ALBUMRELEASETYPE, this.albumreleasetype);
            node.put(COMMENT, this.comment);
            node.put(DISC, this.disc);
            node.put(DURATION, this.duration);
            node.put(FILE, this.file);
            node.put(LASTPLAYED, this.lastplayed);
            node.put(LYRICS, this.lyrics);
            node.put(MUSICBRAINZARTISTID, this.musicbrainzartistid);
            node.put(MUSICBRAINZTRACKID, this.musicbrainztrackid);
            node.put(PLAYCOUNT, this.playcount);
            node.put(SONGID, this.songid);
            node.put(TRACK, this.track);
            return node;
        }

        static List<SongDetail> getAudioModelSongDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<SongDetail> l = new ArrayList<SongDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new SongDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<SongDetail>(0);
        }
    }

    public static class MediaDetail
    extends BaseDetail {
        public static final String API_TYPE = "Audio.Details.Media";
        public static final String ARTIST = "artist";
        public static final String ARTISTID = "artistid";
        public static final String DISPLAYARTIST = "displayartist";
        public static final String GENREID = "genreid";
        public static final String MUSICBRAINZALBUMARTISTID = "musicbrainzalbumartistid";
        public static final String MUSICBRAINZALBUMID = "musicbrainzalbumid";
        public static final String RATING = "rating";
        public static final String TITLE = "title";
        public static final String YEAR = "year";
        public final List<String> artist;
        public final List<Integer> artistid;
        public final String displayartist;
        public final List<Integer> genreid;
        public final String musicbrainzalbumartistid;
        public final String musicbrainzalbumid;
        public final Integer rating;
        public final String title;
        public final Integer year;

        public MediaDetail(JsonNode node) {
            super(node);
            this.artist = MediaDetail.getStringArray(node, ARTIST);
            this.artistid = MediaDetail.getIntegerArray(node, ARTISTID);
            this.displayartist = MediaDetail.parseString(node, DISPLAYARTIST);
            this.genreid = MediaDetail.getIntegerArray(node, GENREID);
            this.musicbrainzalbumartistid = MediaDetail.parseString(node, MUSICBRAINZALBUMARTISTID);
            this.musicbrainzalbumid = MediaDetail.parseString(node, MUSICBRAINZALBUMID);
            this.rating = MediaDetail.parseInt(node, RATING);
            this.title = MediaDetail.parseString(node, TITLE);
            this.year = MediaDetail.parseInt(node, YEAR);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            ArrayNode artistArray = OM.createArrayNode();
            for (String string : this.artist) {
                artistArray.add(string);
            }
            node.put(ARTIST, (JsonNode)artistArray);
            ArrayNode artistidArray = OM.createArrayNode();
            for (Integer item : this.artistid) {
                artistidArray.add(item);
            }
            node.put(ARTISTID, (JsonNode)artistidArray);
            node.put(DISPLAYARTIST, this.displayartist);
            ArrayNode arrayNode = OM.createArrayNode();
            for (Integer item : this.genreid) {
                arrayNode.add(item);
            }
            node.put(GENREID, (JsonNode)arrayNode);
            node.put(MUSICBRAINZALBUMARTISTID, this.musicbrainzalbumartistid);
            node.put(MUSICBRAINZALBUMID, this.musicbrainzalbumid);
            node.put(RATING, this.rating);
            node.put(TITLE, this.title);
            node.put(YEAR, this.year);
            return node;
        }

        static List<MediaDetail> getAudioModelMediaDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<MediaDetail> l = new ArrayList<MediaDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new MediaDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<MediaDetail>(0);
        }
    }

    public static class BaseDetail
    extends MediaModel.BaseDetail {
        public static final String API_TYPE = "Audio.Details.Base";
        public static final String DATEADDED = "dateadded";
        public static final String GENRE = "genre";
        public final String dateadded;
        public final List<String> genre;

        public BaseDetail(JsonNode node) {
            super(node);
            this.dateadded = BaseDetail.parseString(node, DATEADDED);
            this.genre = BaseDetail.getStringArray(node, GENRE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(DATEADDED, this.dateadded);
            ArrayNode genreArray = OM.createArrayNode();
            for (String item : this.genre) {
                genreArray.add(item);
            }
            node.put(GENRE, (JsonNode)genreArray);
            return node;
        }

        static List<BaseDetail> getAudioModelBaseDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<BaseDetail> l = new ArrayList<BaseDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new BaseDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<BaseDetail>(0);
        }
    }

    public static class ArtistDetail
    extends BaseDetail {
        public static final String API_TYPE = "Audio.Details.Artist";
        public static final String ARTIST = "artist";
        public static final String ARTISTID = "artistid";
        public static final String BORN = "born";
        public static final String COMPILATIONARTIST = "compilationartist";
        public static final String DESCRIPTION = "description";
        public static final String DIED = "died";
        public static final String DISBANDED = "disbanded";
        public static final String FORMED = "formed";
        public static final String INSTRUMENT = "instrument";
        public static final String MOOD = "mood";
        public static final String MUSICBRAINZARTISTID = "musicbrainzartistid";
        public static final String STYLE = "style";
        public static final String YEARSACTIVE = "yearsactive";
        public final String artist;
        public final Integer artistid;
        public final String born;
        public final Boolean compilationartist;
        public final String description;
        public final String died;
        public final String disbanded;
        public final String formed;
        public final List<String> instrument;
        public final List<String> mood;
        public final String musicbrainzartistid;
        public final List<String> style;
        public final List<String> yearsactive;

        public ArtistDetail(JsonNode node) {
            super(node);
            this.artist = node.get(ARTIST).getTextValue();
            this.artistid = ArtistDetail.parseInt(node, ARTISTID);
            this.born = ArtistDetail.parseString(node, BORN);
            this.compilationartist = ArtistDetail.parseBoolean(node, COMPILATIONARTIST);
            this.description = ArtistDetail.parseString(node, DESCRIPTION);
            this.died = ArtistDetail.parseString(node, DIED);
            this.disbanded = ArtistDetail.parseString(node, DISBANDED);
            this.formed = ArtistDetail.parseString(node, FORMED);
            this.instrument = ArtistDetail.getStringArray(node, INSTRUMENT);
            this.mood = ArtistDetail.getStringArray(node, MOOD);
            this.musicbrainzartistid = ArtistDetail.parseString(node, MUSICBRAINZARTISTID);
            this.style = ArtistDetail.getStringArray(node, STYLE);
            this.yearsactive = ArtistDetail.getStringArray(node, YEARSACTIVE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(ARTIST, this.artist);
            node.put(ARTISTID, this.artistid);
            node.put(BORN, this.born);
            node.put(COMPILATIONARTIST, this.compilationartist);
            node.put(DESCRIPTION, this.description);
            node.put(DIED, this.died);
            node.put(DISBANDED, this.disbanded);
            node.put(FORMED, this.formed);
            ArrayNode instrumentArray = OM.createArrayNode();
            for (String string : this.instrument) {
                instrumentArray.add(string);
            }
            node.put(INSTRUMENT, (JsonNode)instrumentArray);
            ArrayNode moodArray = OM.createArrayNode();
            for (String string : this.mood) {
                moodArray.add(string);
            }
            node.put(MOOD, (JsonNode)moodArray);
            node.put(MUSICBRAINZARTISTID, this.musicbrainzartistid);
            ArrayNode arrayNode = OM.createArrayNode();
            for (String item : this.style) {
                arrayNode.add(item);
            }
            node.put(STYLE, (JsonNode)arrayNode);
            ArrayNode arrayNode2 = OM.createArrayNode();
            for (String item : this.yearsactive) {
                arrayNode2.add(item);
            }
            node.put(YEARSACTIVE, (JsonNode)arrayNode2);
            return node;
        }

        static List<ArtistDetail> getAudioModelArtistDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<ArtistDetail> l = new ArrayList<ArtistDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new ArtistDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<ArtistDetail>(0);
        }
    }

    public static class AlbumDetail
    extends MediaDetail {
        public static final String API_TYPE = "Audio.Details.Album";
        public static final String ALBUMID = "albumid";
        public static final String ALBUMLABEL = "albumlabel";
        public static final String COMPILATION = "compilation";
        public static final String DESCRIPTION = "description";
        public static final String MOOD = "mood";
        public static final String PLAYCOUNT = "playcount";
        public static final String RELEASETYPE = "releasetype";
        public static final String STYLE = "style";
        public static final String THEME = "theme";
        public static final String TYPE = "type";
        public final Integer albumid;
        public final String albumlabel;
        public final Boolean compilation;
        public final String description;
        public final List<String> mood;
        public final Integer playcount;
        public final String releasetype;
        public final List<String> style;
        public final List<String> theme;
        public final String type;

        public AlbumDetail(JsonNode node) {
            super(node);
            this.albumid = AlbumDetail.parseInt(node, ALBUMID);
            this.albumlabel = AlbumDetail.parseString(node, ALBUMLABEL);
            this.compilation = AlbumDetail.parseBoolean(node, COMPILATION);
            this.description = AlbumDetail.parseString(node, DESCRIPTION);
            this.mood = AlbumDetail.getStringArray(node, MOOD);
            this.playcount = AlbumDetail.parseInt(node, PLAYCOUNT);
            this.releasetype = AlbumDetail.parseString(node, RELEASETYPE);
            this.style = AlbumDetail.getStringArray(node, STYLE);
            this.theme = AlbumDetail.getStringArray(node, THEME);
            this.type = AlbumDetail.parseString(node, TYPE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(ALBUMID, this.albumid);
            node.put(ALBUMLABEL, this.albumlabel);
            node.put(COMPILATION, this.compilation);
            node.put(DESCRIPTION, this.description);
            ArrayNode moodArray = OM.createArrayNode();
            for (String string : this.mood) {
                moodArray.add(string);
            }
            node.put(MOOD, (JsonNode)moodArray);
            node.put(PLAYCOUNT, this.playcount);
            node.put(RELEASETYPE, this.releasetype);
            ArrayNode styleArray = OM.createArrayNode();
            for (String item : this.style) {
                styleArray.add(item);
            }
            node.put(STYLE, (JsonNode)styleArray);
            ArrayNode arrayNode = OM.createArrayNode();
            for (String item : this.theme) {
                arrayNode.add(item);
            }
            node.put(THEME, (JsonNode)arrayNode);
            node.put(TYPE, this.type);
            return node;
        }

        static List<AlbumDetail> getAudioModelAlbumDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<AlbumDetail> l = new ArrayList<AlbumDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new AlbumDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<AlbumDetail>(0);
        }
    }
}

