/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.BooleanNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;
import org.tinymediamanager.jsonrpc.api.AbstractModel;

public final class GlobalModel {

    public static interface Weekday {
        public static final String MONDAY = "monday";
        public static final String TUESDAY = "tuesday";
        public static final String WEDNESDAY = "wednesday";
        public static final String THURSDAY = "thursday";
        public static final String FRIDAY = "friday";
        public static final String SATURDAY = "saturday";
        public static final String SUNDAY = "sunday";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday"));
    }

    public static interface IncrementDecrement {
        public static final String INCREMENT = "increment";
        public static final String DECREMENT = "decrement";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("increment", "decrement"));
    }

    public static class Toggle
    extends AbstractModel {
        public static final String API_TYPE = "Global.Toggle";
        public final Boolean booleanArg;
        public final String stringArg;

        public Toggle(Boolean booleanArg) {
            this.booleanArg = booleanArg;
            this.stringArg = null;
        }

        public Toggle(String stringArg) {
            this.stringArg = stringArg;
            this.booleanArg = null;
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.booleanArg != null) {
                return this.booleanArg != false ? BooleanNode.TRUE : BooleanNode.FALSE;
            }
            if (this.stringArg != null) {
                return new TextNode(this.stringArg);
            }
            return null;
        }

        public static interface StringArg {
            public static final String TOGGLE = "toggle";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("toggle"));
        }
    }

    public static class Time
    extends AbstractModel {
        public static final String API_TYPE = "Global.Time";
        public static final String HOURS = "hours";
        public static final String MILLISECONDS = "milliseconds";
        public static final String MINUTES = "minutes";
        public static final String SECONDS = "seconds";
        public final Integer hours;
        public final Integer milliseconds;
        public final Integer minutes;
        public final Integer seconds;

        public Time(Integer hours, Integer milliseconds, Integer minutes, Integer seconds) {
            this.hours = hours;
            this.milliseconds = milliseconds;
            this.minutes = minutes;
            this.seconds = seconds;
        }

        public long getMilliseconds() {
            return this.hours * 3600000 + this.minutes * 60000 + this.seconds * 1000 + this.milliseconds;
        }

        public Time(JsonNode node) {
            this.hours = node.get(HOURS).getIntValue();
            this.milliseconds = node.get(MILLISECONDS).getIntValue();
            this.minutes = node.get(MINUTES).getIntValue();
            this.seconds = node.get(SECONDS).getIntValue();
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = OM.createObjectNode();
            node.put(HOURS, this.hours);
            node.put(MILLISECONDS, this.milliseconds);
            node.put(MINUTES, this.minutes);
            node.put(SECONDS, this.seconds);
            return node;
        }

        static List<Time> getGlobalModelTimeList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<Time> l = new ArrayList<Time>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new Time(a.get(i)));
                }
                return l;
            }
            return new ArrayList<Time>(0);
        }
    }
}

