/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.BooleanNode;
import org.codehaus.jackson.node.DoubleNode;
import org.codehaus.jackson.node.IntNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;
import org.tinymediamanager.jsonrpc.api.AbstractModel;

public final class SettingModel {

    public static interface Type {
        public static final String BOOLEAN = "boolean";
        public static final String INTEGER = "integer";
        public static final String NUMBER = "number";
        public static final String STRING = "string";
        public static final String ACTION = "action";
        public static final String LIST = "list";
        public static final String PATH = "path";
        public static final String ADDON = "addon";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("boolean", "integer", "number", "string", "action", "list", "path", "addon"));
    }

    public static interface Level {
        public static final String BASIC = "basic";
        public static final String STANDARD = "standard";
        public static final String ADVANCED = "advanced";
        public static final String EXPERT = "expert";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("basic", "standard", "advanced", "expert"));
    }

    public static class ValueExtended
    extends AbstractModel {
        public static final String API_TYPE = "Setting.Value.Extended";
        public final Boolean booleanArg;
        public final Integer integerArg;
        public final Double numberArg;
        public final String stringArg;
        public final List<Value> valueList;

        public ValueExtended(Boolean booleanArg) {
            this.booleanArg = booleanArg;
            this.integerArg = null;
            this.numberArg = null;
            this.stringArg = null;
            this.valueList = null;
        }

        public ValueExtended(Integer integerArg) {
            this.integerArg = integerArg;
            this.booleanArg = null;
            this.numberArg = null;
            this.stringArg = null;
            this.valueList = null;
        }

        public ValueExtended(Double numberArg) {
            this.numberArg = numberArg;
            this.booleanArg = null;
            this.integerArg = null;
            this.stringArg = null;
            this.valueList = null;
        }

        public ValueExtended(String stringArg) {
            this.stringArg = stringArg;
            this.booleanArg = null;
            this.integerArg = null;
            this.numberArg = null;
            this.valueList = null;
        }

        public ValueExtended(List<Value> valueList) {
            this.valueList = valueList;
            this.booleanArg = null;
            this.integerArg = null;
            this.numberArg = null;
            this.stringArg = null;
        }

        public ValueExtended(JsonNode node) {
            if (node.isBoolean()) {
                this.booleanArg = node.getBooleanValue();
                this.integerArg = null;
                this.numberArg = null;
                this.stringArg = null;
                this.valueList = null;
            } else if (node.isInt()) {
                this.integerArg = node.getIntValue();
                this.booleanArg = null;
                this.numberArg = null;
                this.stringArg = null;
                this.valueList = null;
            } else if (node.isDouble()) {
                this.numberArg = node.getDoubleValue();
                this.booleanArg = null;
                this.integerArg = null;
                this.stringArg = null;
                this.valueList = null;
            } else if (node.isTextual()) {
                this.stringArg = node.getTextValue();
                this.booleanArg = null;
                this.integerArg = null;
                this.numberArg = null;
                this.valueList = null;
            } else if (node.isObject()) {
                this.booleanArg = null;
                this.integerArg = null;
                this.numberArg = null;
                this.stringArg = null;
                this.valueList = null;
            } else {
                throw new RuntimeException("Weird type for \"Value.Extended\", I'm confused!");
            }
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.booleanArg != null) {
                return this.booleanArg != false ? BooleanNode.TRUE : BooleanNode.FALSE;
            }
            if (this.integerArg != null) {
                return new IntNode(this.integerArg.intValue());
            }
            if (this.numberArg != null) {
                return new DoubleNode(this.numberArg.doubleValue());
            }
            if (this.stringArg != null) {
                return new TextNode(this.stringArg);
            }
            if (this.valueList != null) {
                ArrayNode an = OM.createArrayNode();
                for (Value item : this.valueList) {
                    an.add(item.toString());
                }
                return an;
            }
            return null;
        }

        static List<ValueExtended> getSettingModelValueExtendedList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<ValueExtended> l = new ArrayList<ValueExtended>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new ValueExtended(a.get(i)));
                }
                return l;
            }
            return new ArrayList<ValueExtended>(0);
        }
    }

    public static class Value
    extends AbstractModel {
        public static final String API_TYPE = "Setting.Value";
        public final Boolean booleanArg;
        public final Integer integerArg;
        public final Double numberArg;
        public final String stringArg;

        public Value(Boolean booleanArg) {
            this.booleanArg = booleanArg;
            this.integerArg = null;
            this.numberArg = null;
            this.stringArg = null;
        }

        public Value(Integer integerArg) {
            this.integerArg = integerArg;
            this.booleanArg = null;
            this.numberArg = null;
            this.stringArg = null;
        }

        public Value(Double numberArg) {
            this.numberArg = numberArg;
            this.booleanArg = null;
            this.integerArg = null;
            this.stringArg = null;
        }

        public Value(String stringArg) {
            this.stringArg = stringArg;
            this.booleanArg = null;
            this.integerArg = null;
            this.numberArg = null;
        }

        public Value(JsonNode node) {
            if (node.isBoolean()) {
                this.booleanArg = node.getBooleanValue();
                this.integerArg = null;
                this.numberArg = null;
                this.stringArg = null;
            } else if (node.isInt()) {
                this.integerArg = node.getIntValue();
                this.booleanArg = null;
                this.numberArg = null;
                this.stringArg = null;
            } else if (node.isDouble()) {
                this.numberArg = node.getDoubleValue();
                this.booleanArg = null;
                this.integerArg = null;
                this.stringArg = null;
            } else if (node.isTextual()) {
                this.stringArg = node.getTextValue();
                this.booleanArg = null;
                this.integerArg = null;
                this.numberArg = null;
            } else {
                throw new RuntimeException("Weird type for \"Value\", I'm confused!");
            }
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.booleanArg != null) {
                return this.booleanArg != false ? BooleanNode.TRUE : BooleanNode.FALSE;
            }
            if (this.integerArg != null) {
                return new IntNode(this.integerArg.intValue());
            }
            if (this.numberArg != null) {
                return new DoubleNode(this.numberArg.doubleValue());
            }
            if (this.stringArg != null) {
                return new TextNode(this.stringArg);
            }
            return null;
        }

        static List<Value> getSettingModelValueList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<Value> l = new ArrayList<Value>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new Value(a.get(i)));
                }
                return l;
            }
            return new ArrayList<Value>(0);
        }
    }

    public static class SettingStringDetail
    extends SettingBaseDetail {
        public static final String API_TYPE = "Setting.Details.SettingString";
        public static final String ALLOWEMPTY = "allowempty";
        public static final String DEFAULT = "default";
        public static final String OPTIONS = "options";
        public static final String VALUE = "value";
        public final Boolean allowempty;
        public final String defaults;
        public final List<Option> options;
        public final String value;

        public SettingStringDetail(JsonNode node) {
            super(node);
            this.allowempty = node.get(ALLOWEMPTY).getBooleanValue();
            this.defaults = node.get(DEFAULT).getTextValue();
            this.options = Option.getSettingModelOptionList(node, OPTIONS);
            this.value = node.get(VALUE).getTextValue();
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(ALLOWEMPTY, this.allowempty);
            node.put(DEFAULT, this.defaults);
            ArrayNode optionsArray = OM.createArrayNode();
            for (Option item : this.options) {
                optionsArray.add(item.toJsonNode());
            }
            node.put(OPTIONS, (JsonNode)optionsArray);
            node.put(VALUE, this.value);
            return node;
        }

        public static class Option
        extends AbstractModel {
            public static final String LABEL = "label";
            public static final String VALUE = "value";
            public final String label;
            public final String value;

            public Option(String label, String value) {
                this.label = label;
                this.value = value;
            }

            public Option(JsonNode node) {
                this.label = node.get(LABEL).getTextValue();
                this.value = node.get("value").getTextValue();
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(LABEL, this.label);
                node.put("value", this.value);
                return node;
            }

            static List<Option> getSettingModelOptionList(JsonNode node, String key) {
                if (node.has(key)) {
                    ArrayNode a = (ArrayNode)node.get(key);
                    ArrayList<Option> l = new ArrayList<Option>(a.size());
                    for (int i = 0; i < a.size(); ++i) {
                        l.add(new Option(a.get(i)));
                    }
                    return l;
                }
                return new ArrayList<Option>(0);
            }
        }
    }

    public static class SettingPathDetail
    extends SettingStringDetail {
        public static final String API_TYPE = "Setting.Details.SettingPath";
        public static final String SOURCES = "sources";
        public static final String WRITABLE = "writable";
        public final List<String> sources;
        public final Boolean writable;

        public SettingPathDetail(JsonNode node) {
            super(node);
            this.sources = SettingPathDetail.getStringArray(node, SOURCES);
            this.writable = node.get(WRITABLE).getBooleanValue();
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            ArrayNode sourcesArray = OM.createArrayNode();
            for (String item : this.sources) {
                sourcesArray.add(item);
            }
            node.put(SOURCES, (JsonNode)sourcesArray);
            node.put(WRITABLE, this.writable);
            return node;
        }

        static List<SettingPathDetail> getSettingModelSettingPathDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<SettingPathDetail> l = new ArrayList<SettingPathDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new SettingPathDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<SettingPathDetail>(0);
        }
    }

    public static class SettingNumberDetail
    extends SettingBaseDetail {
        public static final String API_TYPE = "Setting.Details.SettingNumber";
        public static final String DEFAULT = "default";
        public static final String MAXIMUM = "maximum";
        public static final String MINIMUM = "minimum";
        public static final String STEP = "step";
        public static final String VALUE = "value";
        public final Double defaultd;
        public final Double maximum;
        public final Double minimum;
        public final Double step;
        public final Double value;

        public SettingNumberDetail(JsonNode node) {
            super(node);
            this.defaultd = node.get(DEFAULT).getDoubleValue();
            this.maximum = node.get(MAXIMUM).getDoubleValue();
            this.minimum = node.get(MINIMUM).getDoubleValue();
            this.step = node.get(STEP).getDoubleValue();
            this.value = node.get(VALUE).getDoubleValue();
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(DEFAULT, this.defaultd);
            node.put(MAXIMUM, this.maximum);
            node.put(MINIMUM, this.minimum);
            node.put(STEP, this.step);
            node.put(VALUE, this.value);
            return node;
        }

        static List<SettingNumberDetail> getSettingModelSettingNumberDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<SettingNumberDetail> l = new ArrayList<SettingNumberDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new SettingNumberDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<SettingNumberDetail>(0);
        }
    }

    public static class SettingListDetail
    extends SettingBaseDetail {
        public static final String API_TYPE = "Setting.Details.SettingList";
        public static final String DEFAULT = "default";
        public static final String DEFINITION = "definition";
        public static final String DELIMITER = "delimiter";
        public static final String ELEMENTTYPE = "elementtype";
        public static final String MAXIMUMITEMS = "maximumitems";
        public static final String MINIMUMITEMS = "minimumitems";
        public static final String VALUE = "value";
        public final List<Value> defaultl;
        public final SettingDetail definition;
        public final String delimiter;
        public final String elementtype;
        public final Integer maximumitems;
        public final Integer minimumitems;
        public final List<Value> value;

        public SettingListDetail(JsonNode node) {
            super(node);
            this.defaultl = Value.getSettingModelValueList(node, DEFAULT);
            this.definition = node.has(DEFINITION) ? new SettingDetail(node.get(DEFINITION)) : null;
            this.delimiter = node.get(DELIMITER).getTextValue();
            this.elementtype = SettingListDetail.parseString(node, ELEMENTTYPE);
            this.maximumitems = SettingListDetail.parseInt(node, MAXIMUMITEMS);
            this.minimumitems = SettingListDetail.parseInt(node, MINIMUMITEMS);
            this.value = Value.getSettingModelValueList(node, VALUE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            ArrayNode defaultArray = OM.createArrayNode();
            for (Value item : this.defaultl) {
                defaultArray.add(item.toJsonNode());
            }
            node.put(DEFAULT, (JsonNode)defaultArray);
            node.put(DEFINITION, this.definition == null ? null : this.definition.toJsonNode());
            node.put(DELIMITER, this.delimiter);
            node.put(ELEMENTTYPE, this.elementtype);
            node.put(MAXIMUMITEMS, this.maximumitems);
            node.put(MINIMUMITEMS, this.minimumitems);
            ArrayNode valueArray = OM.createArrayNode();
            for (Value item : this.value) {
                valueArray.add(item.toJsonNode());
            }
            node.put(VALUE, (JsonNode)valueArray);
            return node;
        }

        static List<SettingListDetail> getSettingModelSettingListDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<SettingListDetail> l = new ArrayList<SettingListDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new SettingListDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<SettingListDetail>(0);
        }

        public static interface Elementtype {
            public static final String BOOLEAN = "boolean";
            public static final String INTEGER = "integer";
            public static final String NUMBER = "number";
            public static final String STRING = "string";
            public static final String ACTION = "action";
            public static final String LIST = "list";
            public static final String PATH = "path";
            public static final String ADDON = "addon";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("boolean", "integer", "number", "string", "action", "list", "path", "addon"));
        }
    }

    public static class SettingIntDetail
    extends SettingBaseDetail {
        public static final String API_TYPE = "Setting.Details.SettingInt";
        public static final String DEFAULT = "default";
        public static final String MAXIMUM = "maximum";
        public static final String MINIMUM = "minimum";
        public static final String OPTIONS = "options";
        public static final String STEP = "step";
        public static final String VALUE = "value";
        public final Integer defaulti;
        public final Integer maximum;
        public final Integer minimum;
        public final List<Option> options;
        public final Integer step;
        public final Integer value;

        public SettingIntDetail(JsonNode node) {
            super(node);
            this.defaulti = node.get(DEFAULT).getIntValue();
            this.maximum = SettingIntDetail.parseInt(node, MAXIMUM);
            this.minimum = SettingIntDetail.parseInt(node, MINIMUM);
            this.options = Option.getSettingModelOptionList(node, OPTIONS);
            this.step = SettingIntDetail.parseInt(node, STEP);
            this.value = node.get(VALUE).getIntValue();
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(DEFAULT, this.defaulti);
            node.put(MAXIMUM, this.maximum);
            node.put(MINIMUM, this.minimum);
            ArrayNode optionsArray = OM.createArrayNode();
            for (Option item : this.options) {
                optionsArray.add(item.toJsonNode());
            }
            node.put(OPTIONS, (JsonNode)optionsArray);
            node.put(STEP, this.step);
            node.put(VALUE, this.value);
            return node;
        }

        static List<SettingIntDetail> getSettingModelSettingIntDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<SettingIntDetail> l = new ArrayList<SettingIntDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new SettingIntDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<SettingIntDetail>(0);
        }

        public static class Option
        extends AbstractModel {
            public static final String LABEL = "label";
            public static final String VALUE = "value";
            public final String label;
            public final Integer value;

            public Option(String label, Integer value) {
                this.label = label;
                this.value = value;
            }

            public Option(JsonNode node) {
                this.label = node.get(LABEL).getTextValue();
                this.value = node.get("value").getIntValue();
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode node = OM.createObjectNode();
                node.put(LABEL, this.label);
                node.put("value", this.value);
                return node;
            }

            static List<Option> getSettingModelOptionList(JsonNode node, String key) {
                if (node.has(key)) {
                    ArrayNode a = (ArrayNode)node.get(key);
                    ArrayList<Option> l = new ArrayList<Option>(a.size());
                    for (int i = 0; i < a.size(); ++i) {
                        l.add(new Option(a.get(i)));
                    }
                    return l;
                }
                return new ArrayList<Option>(0);
            }
        }
    }

    public static class SettingBoolDetail
    extends SettingBaseDetail {
        public static final String API_TYPE = "Setting.Details.SettingBool";
        public static final String DEFAULT = "default";
        public static final String VALUE = "value";
        public final Boolean defaultb;
        public final Boolean value;

        public SettingBoolDetail(JsonNode node) {
            super(node);
            this.defaultb = node.get(DEFAULT).getBooleanValue();
            this.value = node.get(VALUE).getBooleanValue();
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(DEFAULT, this.defaultb);
            node.put(VALUE, this.value);
            return node;
        }

        static List<SettingBoolDetail> getSettingModelSettingBoolDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<SettingBoolDetail> l = new ArrayList<SettingBoolDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new SettingBoolDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<SettingBoolDetail>(0);
        }
    }

    public static class SettingBaseDetail
    extends BaseDetail {
        public static final String API_TYPE = "Setting.Details.SettingBase";
        public static final String CONTROL = "control";
        public static final String ENABLED = "enabled";
        public static final String LEVEL = "level";
        public static final String PARENT = "parent";
        public static final String TYPE = "type";
        public final ControlDetail control;
        public final Boolean enabled;
        public final String level;
        public final String parent;
        public final String type;

        public SettingBaseDetail(JsonNode node) {
            super(node);
            this.control = node.has(CONTROL) ? new ControlDetail(node.get(CONTROL)) : null;
            this.enabled = node.get(ENABLED).getBooleanValue();
            this.level = SettingBaseDetail.parseString(node, LEVEL);
            this.parent = SettingBaseDetail.parseString(node, PARENT);
            this.type = SettingBaseDetail.parseString(node, TYPE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(CONTROL, this.control == null ? null : this.control.toJsonNode());
            node.put(ENABLED, this.enabled);
            node.put(LEVEL, this.level);
            node.put(PARENT, this.parent);
            node.put(TYPE, this.type);
            return node;
        }

        static List<SettingBaseDetail> getSettingModelSettingBaseDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<SettingBaseDetail> l = new ArrayList<SettingBaseDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new SettingBaseDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<SettingBaseDetail>(0);
        }

        public static interface Type {
            public static final String BOOLEAN = "boolean";
            public static final String INTEGER = "integer";
            public static final String NUMBER = "number";
            public static final String STRING = "string";
            public static final String ACTION = "action";
            public static final String LIST = "list";
            public static final String PATH = "path";
            public static final String ADDON = "addon";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("boolean", "integer", "number", "string", "action", "list", "path", "addon"));
        }

        public static interface Level {
            public static final String BASIC = "basic";
            public static final String STANDARD = "standard";
            public static final String ADVANCED = "advanced";
            public static final String EXPERT = "expert";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("basic", "standard", "advanced", "expert"));
        }
    }

    public static class SettingAddonDetail
    extends SettingStringDetail {
        public static final String API_TYPE = "Setting.Details.SettingAddon";
        public static final String ADDONTYPE = "addontype";
        public final String addontype;

        public SettingAddonDetail(JsonNode node) {
            super(node);
            this.addontype = SettingAddonDetail.parseString(node, ADDONTYPE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(ADDONTYPE, this.addontype);
            return node;
        }

        static List<SettingAddonDetail> getSettingModelSettingAddonDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<SettingAddonDetail> l = new ArrayList<SettingAddonDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new SettingAddonDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<SettingAddonDetail>(0);
        }

        public static interface Addontype {
            public static final String UNKNOWN = "unknown";
            public static final String XBMC_PLAYER_MUSICVIZ = "xbmc.player.musicviz";
            public static final String XBMC_GUI_SKIN = "xbmc.gui.skin";
            public static final String XBMC_PVRCLIENT = "xbmc.pvrclient";
            public static final String KODI_ADSP = "kodi.adsp";
            public static final String XBMC_PYTHON_SCRIPT = "xbmc.python.script";
            public static final String XBMC_PYTHON_WEATHER = "xbmc.python.weather";
            public static final String XBMC_SUBTITLE_MODULE = "xbmc.subtitle.module";
            public static final String XBMC_PYTHON_LYRICS = "xbmc.python.lyrics";
            public static final String XBMC_METADATA_SCRAPER_ALBUMS = "xbmc.metadata.scraper.albums";
            public static final String XBMC_METADATA_SCRAPER_ARTISTS = "xbmc.metadata.scraper.artists";
            public static final String XBMC_METADATA_SCRAPER_MOVIES = "xbmc.metadata.scraper.movies";
            public static final String XBMC_METADATA_SCRAPER_MUSICVIDEOS = "xbmc.metadata.scraper.musicvideos";
            public static final String XBMC_METADATA_SCRAPER_TVSHOWS = "xbmc.metadata.scraper.tvshows";
            public static final String XBMC_UI_SCREENSAVER = "xbmc.ui.screensaver";
            public static final String XBMC_PYTHON_PLUGINSOURCE = "xbmc.python.pluginsource";
            public static final String XBMC_ADDON_REPOSITORY = "xbmc.addon.repository";
            public static final String XBMC_WEBINTERFACE = "xbmc.webinterface";
            public static final String XBMC_SERVICE = "xbmc.service";
            public static final String XBMC_AUDIOENCODER = "xbmc.audioencoder";
            public static final String KODI_CONTEXT_ITEM = "kodi.context.item";
            public static final String KODI_AUDIODECODER = "kodi.audiodecoder";
            public static final String KODI_RESOURCE_IMAGES = "kodi.resource.images";
            public static final String KODI_RESOURCE_LANGUAGE = "kodi.resource.language";
            public static final String KODI_RESOURCE_UISOUNDS = "kodi.resource.uisounds";
            public static final String XBMC_ADDON_VIDEO = "xbmc.addon.video";
            public static final String XBMC_ADDON_AUDIO = "xbmc.addon.audio";
            public static final String XBMC_ADDON_IMAGE = "xbmc.addon.image";
            public static final String XBMC_ADDON_EXECUTABLE = "xbmc.addon.executable";
            public static final String VISUALIZATION_LIBRARY = "visualization-library";
            public static final String XBMC_METADATA_SCRAPER_LIBRARY = "xbmc.metadata.scraper.library";
            public static final String XBMC_PYTHON_LIBRARY = "xbmc.python.library";
            public static final String XBMC_PYTHON_MODULE = "xbmc.python.module";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("unknown", "xbmc.player.musicviz", "xbmc.gui.skin", "xbmc.pvrclient", "kodi.adsp", "xbmc.python.script", "xbmc.python.weather", "xbmc.subtitle.module", "xbmc.python.lyrics", "xbmc.metadata.scraper.albums", "xbmc.metadata.scraper.artists", "xbmc.metadata.scraper.movies", "xbmc.metadata.scraper.musicvideos", "xbmc.metadata.scraper.tvshows", "xbmc.ui.screensaver", "xbmc.python.pluginsource", "xbmc.addon.repository", "xbmc.webinterface", "xbmc.service", "xbmc.audioencoder", "kodi.context.item", "kodi.audiodecoder", "kodi.resource.images", "kodi.resource.language", "kodi.resource.uisounds", "xbmc.addon.video", "xbmc.addon.audio", "xbmc.addon.image", "xbmc.addon.executable", "visualization-library", "xbmc.metadata.scraper.library", "xbmc.python.library", "xbmc.python.module"));
        }
    }

    public static class SettingActionDetail
    extends SettingBaseDetail {
        public static final String API_TYPE = "Setting.Details.SettingAction";

        public SettingActionDetail(JsonNode node) {
            super(node);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            return node;
        }

        static List<SettingActionDetail> getSettingModelSettingActionDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<SettingActionDetail> l = new ArrayList<SettingActionDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new SettingActionDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<SettingActionDetail>(0);
        }
    }

    public static class SettingDetail
    extends AbstractModel {
        public static final String API_TYPE = "Setting.Details.Setting";
        public final SettingActionDetail detailsSettingAction;
        public final SettingAddonDetail detailsSettingAddon;
        public final SettingBoolDetail detailsSettingBool;
        public final SettingIntDetail detailsSettingInt;
        public final SettingListDetail detailsSettingList;
        public final SettingNumberDetail detailsSettingNumber;
        public final SettingPathDetail detailsSettingPath;
        public final SettingStringDetail detailsSettingString;

        public SettingDetail(SettingActionDetail detailsSettingAction) {
            this.detailsSettingAction = detailsSettingAction;
            this.detailsSettingAddon = null;
            this.detailsSettingBool = null;
            this.detailsSettingInt = null;
            this.detailsSettingList = null;
            this.detailsSettingNumber = null;
            this.detailsSettingPath = null;
            this.detailsSettingString = null;
        }

        public SettingDetail(SettingAddonDetail detailsSettingAddon) {
            this.detailsSettingAddon = detailsSettingAddon;
            this.detailsSettingAction = null;
            this.detailsSettingBool = null;
            this.detailsSettingInt = null;
            this.detailsSettingList = null;
            this.detailsSettingNumber = null;
            this.detailsSettingPath = null;
            this.detailsSettingString = null;
        }

        public SettingDetail(SettingBoolDetail detailsSettingBool) {
            this.detailsSettingBool = detailsSettingBool;
            this.detailsSettingAction = null;
            this.detailsSettingAddon = null;
            this.detailsSettingInt = null;
            this.detailsSettingList = null;
            this.detailsSettingNumber = null;
            this.detailsSettingPath = null;
            this.detailsSettingString = null;
        }

        public SettingDetail(SettingIntDetail detailsSettingInt) {
            this.detailsSettingInt = detailsSettingInt;
            this.detailsSettingAction = null;
            this.detailsSettingAddon = null;
            this.detailsSettingBool = null;
            this.detailsSettingList = null;
            this.detailsSettingNumber = null;
            this.detailsSettingPath = null;
            this.detailsSettingString = null;
        }

        public SettingDetail(SettingListDetail detailsSettingList) {
            this.detailsSettingList = detailsSettingList;
            this.detailsSettingAction = null;
            this.detailsSettingAddon = null;
            this.detailsSettingBool = null;
            this.detailsSettingInt = null;
            this.detailsSettingNumber = null;
            this.detailsSettingPath = null;
            this.detailsSettingString = null;
        }

        public SettingDetail(SettingNumberDetail detailsSettingNumber) {
            this.detailsSettingNumber = detailsSettingNumber;
            this.detailsSettingAction = null;
            this.detailsSettingAddon = null;
            this.detailsSettingBool = null;
            this.detailsSettingInt = null;
            this.detailsSettingList = null;
            this.detailsSettingPath = null;
            this.detailsSettingString = null;
        }

        public SettingDetail(SettingPathDetail detailsSettingPath) {
            this.detailsSettingPath = detailsSettingPath;
            this.detailsSettingAction = null;
            this.detailsSettingAddon = null;
            this.detailsSettingBool = null;
            this.detailsSettingInt = null;
            this.detailsSettingList = null;
            this.detailsSettingNumber = null;
            this.detailsSettingString = null;
        }

        public SettingDetail(SettingStringDetail detailsSettingString) {
            this.detailsSettingString = detailsSettingString;
            this.detailsSettingAction = null;
            this.detailsSettingAddon = null;
            this.detailsSettingBool = null;
            this.detailsSettingInt = null;
            this.detailsSettingList = null;
            this.detailsSettingNumber = null;
            this.detailsSettingPath = null;
        }

        public SettingDetail(JsonNode node) {
            if (node.isObject()) {
                this.detailsSettingAction = null;
                this.detailsSettingAddon = null;
                this.detailsSettingBool = null;
                this.detailsSettingInt = null;
                this.detailsSettingList = null;
                this.detailsSettingNumber = null;
                this.detailsSettingPath = null;
                this.detailsSettingString = null;
            } else if (node.isObject()) {
                this.detailsSettingAction = null;
                this.detailsSettingAddon = null;
                this.detailsSettingBool = null;
                this.detailsSettingInt = null;
                this.detailsSettingList = null;
                this.detailsSettingNumber = null;
                this.detailsSettingPath = null;
                this.detailsSettingString = null;
            } else if (node.isObject()) {
                this.detailsSettingAction = null;
                this.detailsSettingAddon = null;
                this.detailsSettingBool = null;
                this.detailsSettingInt = null;
                this.detailsSettingList = null;
                this.detailsSettingNumber = null;
                this.detailsSettingPath = null;
                this.detailsSettingString = null;
            } else if (node.isObject()) {
                this.detailsSettingAction = null;
                this.detailsSettingAddon = null;
                this.detailsSettingBool = null;
                this.detailsSettingInt = null;
                this.detailsSettingList = null;
                this.detailsSettingNumber = null;
                this.detailsSettingPath = null;
                this.detailsSettingString = null;
            } else if (node.isObject()) {
                this.detailsSettingAction = null;
                this.detailsSettingAddon = null;
                this.detailsSettingBool = null;
                this.detailsSettingInt = null;
                this.detailsSettingList = null;
                this.detailsSettingNumber = null;
                this.detailsSettingPath = null;
                this.detailsSettingString = null;
            } else if (node.isObject()) {
                this.detailsSettingAction = null;
                this.detailsSettingAddon = null;
                this.detailsSettingBool = null;
                this.detailsSettingInt = null;
                this.detailsSettingList = null;
                this.detailsSettingNumber = null;
                this.detailsSettingPath = null;
                this.detailsSettingString = null;
            } else if (node.isObject()) {
                this.detailsSettingAction = null;
                this.detailsSettingAddon = null;
                this.detailsSettingBool = null;
                this.detailsSettingInt = null;
                this.detailsSettingList = null;
                this.detailsSettingNumber = null;
                this.detailsSettingPath = null;
                this.detailsSettingString = null;
            } else if (node.isObject()) {
                this.detailsSettingAction = null;
                this.detailsSettingAddon = null;
                this.detailsSettingBool = null;
                this.detailsSettingInt = null;
                this.detailsSettingList = null;
                this.detailsSettingNumber = null;
                this.detailsSettingPath = null;
                this.detailsSettingString = null;
            } else {
                throw new RuntimeException("Weird type for \"Details.Setting\", I'm confused!");
            }
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.detailsSettingAction != null) {
                return this.detailsSettingAction.toJsonNode();
            }
            if (this.detailsSettingAddon != null) {
                return this.detailsSettingAddon.toJsonNode();
            }
            if (this.detailsSettingBool != null) {
                return this.detailsSettingBool.toJsonNode();
            }
            if (this.detailsSettingInt != null) {
                return this.detailsSettingInt.toJsonNode();
            }
            if (this.detailsSettingList != null) {
                return this.detailsSettingList.toJsonNode();
            }
            if (this.detailsSettingNumber != null) {
                return this.detailsSettingNumber.toJsonNode();
            }
            if (this.detailsSettingPath != null) {
                return this.detailsSettingPath.toJsonNode();
            }
            if (this.detailsSettingString != null) {
                return this.detailsSettingString.toJsonNode();
            }
            return null;
        }

        static List<SettingDetail> getSettingModelSettingDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<SettingDetail> l = new ArrayList<SettingDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new SettingDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<SettingDetail>(0);
        }
    }

    public static class SectionDetail
    extends BaseDetail {
        public static final String API_TYPE = "Setting.Details.Section";
        public static final String CATEGORIES = "categories";
        public final List<CategoryDetail> categories;

        public SectionDetail(JsonNode node) {
            super(node);
            this.categories = CategoryDetail.getSettingModelCategoryDetailList(node, CATEGORIES);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            ArrayNode categoriesArray = OM.createArrayNode();
            for (CategoryDetail item : this.categories) {
                categoriesArray.add(item.toJsonNode());
            }
            node.put(CATEGORIES, (JsonNode)categoriesArray);
            return node;
        }

        static List<SectionDetail> getSettingModelSectionDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<SectionDetail> l = new ArrayList<SectionDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new SectionDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<SectionDetail>(0);
        }
    }

    public static class GroupDetail
    extends AbstractModel {
        public static final String API_TYPE = "Setting.Details.Group";
        public static final String ID = "id";
        public static final String SETTINGS = "settings";
        public final String id;
        public final List<SettingDetail> settings;

        public GroupDetail(String id, List<SettingDetail> settings) {
            this.id = id;
            this.settings = settings;
        }

        public GroupDetail(JsonNode node) {
            this.id = node.get(ID).getTextValue();
            this.settings = SettingDetail.getSettingModelSettingDetailList(node, SETTINGS);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = OM.createObjectNode();
            node.put(ID, this.id);
            ArrayNode settingsArray = OM.createArrayNode();
            for (SettingDetail item : this.settings) {
                settingsArray.add(item.toJsonNode());
            }
            node.put(SETTINGS, (JsonNode)settingsArray);
            return node;
        }

        static List<GroupDetail> getSettingModelGroupDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<GroupDetail> l = new ArrayList<GroupDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new GroupDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<GroupDetail>(0);
        }
    }

    public static class ControlSpinnerDetail
    extends ControlBaseDetail {
        public static final String API_TYPE = "Setting.Details.ControlSpinner";
        public static final String FORMATLABEL = "formatlabel";
        public static final String MINIMUMLABEL = "minimumlabel";
        public static final String TYPE = "type";
        public final String formatlabel;
        public final String minimumlabel;
        public final String type;

        public ControlSpinnerDetail(JsonNode node) {
            super(node);
            this.formatlabel = ControlSpinnerDetail.parseString(node, FORMATLABEL);
            this.minimumlabel = ControlSpinnerDetail.parseString(node, MINIMUMLABEL);
            this.type = ControlSpinnerDetail.parseString(node, TYPE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(FORMATLABEL, this.formatlabel);
            node.put(MINIMUMLABEL, this.minimumlabel);
            node.put(TYPE, this.type);
            return node;
        }

        static List<ControlSpinnerDetail> getSettingModelControlSpinnerDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<ControlSpinnerDetail> l = new ArrayList<ControlSpinnerDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new ControlSpinnerDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<ControlSpinnerDetail>(0);
        }

        public static interface Type {
            public static final String SPINNER = "spinner";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("spinner"));
        }
    }

    public static class ControlSliderDetail
    extends ControlHeadingDetail {
        public static final String API_TYPE = "Setting.Details.ControlSlider";
        public static final String FORMATLABEL = "formatlabel";
        public static final String POPUP = "popup";
        public static final String TYPE = "type";
        public final String formatlabel;
        public final Boolean popup;
        public final String type;

        public ControlSliderDetail(JsonNode node) {
            super(node);
            this.formatlabel = node.get(FORMATLABEL).getTextValue();
            this.popup = node.get(POPUP).getBooleanValue();
            this.type = ControlSliderDetail.parseString(node, TYPE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(FORMATLABEL, this.formatlabel);
            node.put(POPUP, this.popup);
            node.put(TYPE, this.type);
            return node;
        }

        static List<ControlSliderDetail> getSettingModelControlSliderDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<ControlSliderDetail> l = new ArrayList<ControlSliderDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new ControlSliderDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<ControlSliderDetail>(0);
        }

        public static interface Type {
            public static final String SLIDER = "slider";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("slider"));
        }
    }

    public static class ControlRangeDetail
    extends ControlBaseDetail {
        public static final String API_TYPE = "Setting.Details.ControlRange";
        public static final String FORMATLABEL = "formatlabel";
        public static final String FORMATVALUE = "formatvalue";
        public static final String TYPE = "type";
        public final String formatlabel;
        public final String formatvalue;
        public final String type;

        public ControlRangeDetail(JsonNode node) {
            super(node);
            this.formatlabel = node.get(FORMATLABEL).getTextValue();
            this.formatvalue = node.get(FORMATVALUE).getTextValue();
            this.type = ControlRangeDetail.parseString(node, TYPE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(FORMATLABEL, this.formatlabel);
            node.put(FORMATVALUE, this.formatvalue);
            node.put(TYPE, this.type);
            return node;
        }

        static List<ControlRangeDetail> getSettingModelControlRangeDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<ControlRangeDetail> l = new ArrayList<ControlRangeDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new ControlRangeDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<ControlRangeDetail>(0);
        }

        public static interface Type {
            public static final String RANGE = "range";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("range"));
        }
    }

    public static class ControlListDetail
    extends ControlHeadingDetail {
        public static final String API_TYPE = "Setting.Details.ControlList";
        public static final String MULTISELECT = "multiselect";
        public static final String TYPE = "type";
        public final Boolean multiselect;
        public final String type;

        public ControlListDetail(JsonNode node) {
            super(node);
            this.multiselect = node.get(MULTISELECT).getBooleanValue();
            this.type = ControlListDetail.parseString(node, TYPE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(MULTISELECT, this.multiselect);
            node.put(TYPE, this.type);
            return node;
        }

        static List<ControlListDetail> getSettingModelControlListDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<ControlListDetail> l = new ArrayList<ControlListDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new ControlListDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<ControlListDetail>(0);
        }

        public static interface Type {
            public static final String LIST = "list";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("list"));
        }
    }

    public static class ControlHeadingDetail
    extends ControlBaseDetail {
        public static final String API_TYPE = "Setting.Details.ControlHeading";
        public static final String HEADING = "heading";
        public final String heading;

        public ControlHeadingDetail(JsonNode node) {
            super(node);
            this.heading = ControlHeadingDetail.parseString(node, HEADING);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(HEADING, this.heading);
            return node;
        }

        static List<ControlHeadingDetail> getSettingModelControlHeadingDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<ControlHeadingDetail> l = new ArrayList<ControlHeadingDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new ControlHeadingDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<ControlHeadingDetail>(0);
        }
    }

    public static class ControlEditDetail
    extends ControlHeadingDetail {
        public static final String API_TYPE = "Setting.Details.ControlEdit";
        public static final String HIDDEN = "hidden";
        public static final String TYPE = "type";
        public static final String VERIFYNEWVALUE = "verifynewvalue";
        public final Boolean hidden;
        public final String type;
        public final Boolean verifynewvalue;

        public ControlEditDetail(JsonNode node) {
            super(node);
            this.hidden = node.get(HIDDEN).getBooleanValue();
            this.type = ControlEditDetail.parseString(node, TYPE);
            this.verifynewvalue = node.get(VERIFYNEWVALUE).getBooleanValue();
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(HIDDEN, this.hidden);
            node.put(TYPE, this.type);
            node.put(VERIFYNEWVALUE, this.verifynewvalue);
            return node;
        }

        static List<ControlEditDetail> getSettingModelControlEditDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<ControlEditDetail> l = new ArrayList<ControlEditDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new ControlEditDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<ControlEditDetail>(0);
        }

        public static interface Type {
            public static final String EDIT = "edit";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("edit"));
        }
    }

    public static class ControlCheckmarkDetail
    extends ControlBaseDetail {
        public static final String API_TYPE = "Setting.Details.ControlCheckmark";
        public static final String FORMAT = "format";
        public static final String TYPE = "type";
        public final String format;
        public final String type;

        public ControlCheckmarkDetail(JsonNode node) {
            super(node);
            this.format = ControlCheckmarkDetail.parseString(node, FORMAT);
            this.type = ControlCheckmarkDetail.parseString(node, TYPE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(FORMAT, this.format);
            node.put(TYPE, this.type);
            return node;
        }

        static List<ControlCheckmarkDetail> getSettingModelControlCheckmarkDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<ControlCheckmarkDetail> l = new ArrayList<ControlCheckmarkDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new ControlCheckmarkDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<ControlCheckmarkDetail>(0);
        }

        public static interface Type {
            public static final String TOGGLE = "toggle";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("toggle"));
        }

        public static interface Format {
            public static final String BOOLEAN = "boolean";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("boolean"));
        }
    }

    public static class ControlButtonDetail
    extends ControlHeadingDetail {
        public static final String API_TYPE = "Setting.Details.ControlButton";
        public static final String TYPE = "type";
        public final String type;

        public ControlButtonDetail(JsonNode node) {
            super(node);
            this.type = ControlButtonDetail.parseString(node, TYPE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(TYPE, this.type);
            return node;
        }

        static List<ControlButtonDetail> getSettingModelControlButtonDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<ControlButtonDetail> l = new ArrayList<ControlButtonDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new ControlButtonDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<ControlButtonDetail>(0);
        }

        public static interface Type {
            public static final String BUTTON = "button";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("button"));
        }
    }

    public static class ControlBaseDetail
    extends AbstractModel {
        public static final String API_TYPE = "Setting.Details.ControlBase";
        public static final String DELAYED = "delayed";
        public static final String FORMAT = "format";
        public static final String TYPE = "type";
        public final Boolean delayed;
        public final String format;
        public final String type;

        public ControlBaseDetail(Boolean delayed, String format, String type) {
            this.delayed = delayed;
            this.format = format;
            this.type = type;
        }

        public ControlBaseDetail(JsonNode node) {
            this.delayed = node.get(DELAYED).getBooleanValue();
            this.format = node.get(FORMAT).getTextValue();
            this.type = node.get(TYPE).getTextValue();
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = OM.createObjectNode();
            node.put(DELAYED, this.delayed);
            node.put(FORMAT, this.format);
            node.put(TYPE, this.type);
            return node;
        }

        static List<ControlBaseDetail> getSettingModelControlBaseDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<ControlBaseDetail> l = new ArrayList<ControlBaseDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new ControlBaseDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<ControlBaseDetail>(0);
        }
    }

    public static class ControlDetail
    extends AbstractModel {
        public static final String API_TYPE = "Setting.Details.Control";
        public final ControlButtonDetail detailsControlButton;
        public final ControlCheckmarkDetail detailsControlCheckmark;
        public final ControlEditDetail detailsControlEdit;
        public final ControlListDetail detailsControlList;
        public final ControlRangeDetail detailsControlRange;
        public final ControlSliderDetail detailsControlSlider;
        public final ControlSpinnerDetail detailsControlSpinner;

        public ControlDetail(ControlButtonDetail detailsControlButton) {
            this.detailsControlButton = detailsControlButton;
            this.detailsControlCheckmark = null;
            this.detailsControlEdit = null;
            this.detailsControlList = null;
            this.detailsControlRange = null;
            this.detailsControlSlider = null;
            this.detailsControlSpinner = null;
        }

        public ControlDetail(ControlCheckmarkDetail detailsControlCheckmark) {
            this.detailsControlCheckmark = detailsControlCheckmark;
            this.detailsControlButton = null;
            this.detailsControlEdit = null;
            this.detailsControlList = null;
            this.detailsControlRange = null;
            this.detailsControlSlider = null;
            this.detailsControlSpinner = null;
        }

        public ControlDetail(ControlEditDetail detailsControlEdit) {
            this.detailsControlEdit = detailsControlEdit;
            this.detailsControlButton = null;
            this.detailsControlCheckmark = null;
            this.detailsControlList = null;
            this.detailsControlRange = null;
            this.detailsControlSlider = null;
            this.detailsControlSpinner = null;
        }

        public ControlDetail(ControlListDetail detailsControlList) {
            this.detailsControlList = detailsControlList;
            this.detailsControlButton = null;
            this.detailsControlCheckmark = null;
            this.detailsControlEdit = null;
            this.detailsControlRange = null;
            this.detailsControlSlider = null;
            this.detailsControlSpinner = null;
        }

        public ControlDetail(ControlRangeDetail detailsControlRange) {
            this.detailsControlRange = detailsControlRange;
            this.detailsControlButton = null;
            this.detailsControlCheckmark = null;
            this.detailsControlEdit = null;
            this.detailsControlList = null;
            this.detailsControlSlider = null;
            this.detailsControlSpinner = null;
        }

        public ControlDetail(ControlSliderDetail detailsControlSlider) {
            this.detailsControlSlider = detailsControlSlider;
            this.detailsControlButton = null;
            this.detailsControlCheckmark = null;
            this.detailsControlEdit = null;
            this.detailsControlList = null;
            this.detailsControlRange = null;
            this.detailsControlSpinner = null;
        }

        public ControlDetail(ControlSpinnerDetail detailsControlSpinner) {
            this.detailsControlSpinner = detailsControlSpinner;
            this.detailsControlButton = null;
            this.detailsControlCheckmark = null;
            this.detailsControlEdit = null;
            this.detailsControlList = null;
            this.detailsControlRange = null;
            this.detailsControlSlider = null;
        }

        public ControlDetail(JsonNode node) {
            if (node.isObject()) {
                this.detailsControlButton = null;
                this.detailsControlCheckmark = null;
                this.detailsControlEdit = null;
                this.detailsControlList = null;
                this.detailsControlRange = null;
                this.detailsControlSlider = null;
                this.detailsControlSpinner = null;
            } else if (node.isObject()) {
                this.detailsControlButton = null;
                this.detailsControlCheckmark = null;
                this.detailsControlEdit = null;
                this.detailsControlList = null;
                this.detailsControlRange = null;
                this.detailsControlSlider = null;
                this.detailsControlSpinner = null;
            } else if (node.isObject()) {
                this.detailsControlButton = null;
                this.detailsControlCheckmark = null;
                this.detailsControlEdit = null;
                this.detailsControlList = null;
                this.detailsControlRange = null;
                this.detailsControlSlider = null;
                this.detailsControlSpinner = null;
            } else if (node.isObject()) {
                this.detailsControlButton = null;
                this.detailsControlCheckmark = null;
                this.detailsControlEdit = null;
                this.detailsControlList = null;
                this.detailsControlRange = null;
                this.detailsControlSlider = null;
                this.detailsControlSpinner = null;
            } else if (node.isObject()) {
                this.detailsControlButton = null;
                this.detailsControlCheckmark = null;
                this.detailsControlEdit = null;
                this.detailsControlList = null;
                this.detailsControlRange = null;
                this.detailsControlSlider = null;
                this.detailsControlSpinner = null;
            } else if (node.isObject()) {
                this.detailsControlButton = null;
                this.detailsControlCheckmark = null;
                this.detailsControlEdit = null;
                this.detailsControlList = null;
                this.detailsControlRange = null;
                this.detailsControlSlider = null;
                this.detailsControlSpinner = null;
            } else if (node.isObject()) {
                this.detailsControlButton = null;
                this.detailsControlCheckmark = null;
                this.detailsControlEdit = null;
                this.detailsControlList = null;
                this.detailsControlRange = null;
                this.detailsControlSlider = null;
                this.detailsControlSpinner = null;
            } else {
                throw new RuntimeException("Weird type for \"Details.Control\", I'm confused!");
            }
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.detailsControlButton != null) {
                return this.detailsControlButton.toJsonNode();
            }
            if (this.detailsControlCheckmark != null) {
                return this.detailsControlCheckmark.toJsonNode();
            }
            if (this.detailsControlEdit != null) {
                return this.detailsControlEdit.toJsonNode();
            }
            if (this.detailsControlList != null) {
                return this.detailsControlList.toJsonNode();
            }
            if (this.detailsControlRange != null) {
                return this.detailsControlRange.toJsonNode();
            }
            if (this.detailsControlSlider != null) {
                return this.detailsControlSlider.toJsonNode();
            }
            if (this.detailsControlSpinner != null) {
                return this.detailsControlSpinner.toJsonNode();
            }
            return null;
        }

        static List<ControlDetail> getSettingModelControlDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<ControlDetail> l = new ArrayList<ControlDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new ControlDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<ControlDetail>(0);
        }
    }

    public static class CategoryDetail
    extends BaseDetail {
        public static final String API_TYPE = "Setting.Details.Category";
        public static final String GROUPS = "groups";
        public final List<GroupDetail> groups;

        public CategoryDetail(JsonNode node) {
            super(node);
            this.groups = GroupDetail.getSettingModelGroupDetailList(node, GROUPS);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            ArrayNode groupsArray = OM.createArrayNode();
            for (GroupDetail item : this.groups) {
                groupsArray.add(item.toJsonNode());
            }
            node.put(GROUPS, (JsonNode)groupsArray);
            return node;
        }

        static List<CategoryDetail> getSettingModelCategoryDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<CategoryDetail> l = new ArrayList<CategoryDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new CategoryDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<CategoryDetail>(0);
        }
    }

    public static class BaseDetail
    extends AbstractModel {
        public static final String API_TYPE = "Setting.Details.Base";
        public static final String HELP = "help";
        public static final String ID = "id";
        public static final String LABEL = "label";
        public final String help;
        public final String id;
        public final String label;

        public BaseDetail(String help, String id, String label) {
            this.help = help;
            this.id = id;
            this.label = label;
        }

        public BaseDetail(JsonNode node) {
            this.help = BaseDetail.parseString(node, HELP);
            this.id = node.get(ID).getTextValue();
            this.label = node.get(LABEL).getTextValue();
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = OM.createObjectNode();
            node.put(HELP, this.help);
            node.put(ID, this.id);
            node.put(LABEL, this.label);
            return node;
        }

        static List<BaseDetail> getSettingModelBaseDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<BaseDetail> l = new ArrayList<BaseDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new BaseDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<BaseDetail>(0);
        }
    }
}

