/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.notification;

import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.notification.PlayerEvent;
import org.tinymediamanager.jsonrpc.notification.SystemEvent;

public abstract class AbstractEvent {
    public final String sender;

    public AbstractEvent(ObjectNode node) {
        this.sender = node.get("sender").getTextValue();
    }

    public abstract int getId();

    public abstract String getMethod();

    public static AbstractEvent parse(ObjectNode node) {
        String method = node.get("method").getTextValue();
        ObjectNode params = (ObjectNode)node.get("params");
        if (method.equals("Player.OnPlay")) {
            return new PlayerEvent.Play(params);
        }
        if (method.equals("Player.OnPause")) {
            return new PlayerEvent.Pause(params);
        }
        if (method.equals("Player.OnStop")) {
            return new PlayerEvent.Stop(params);
        }
        if (method.equals("Player.OnSpeedChanged")) {
            return new PlayerEvent.SpeedChanged(params);
        }
        if (method.equals("Player.OnSeek")) {
            return new PlayerEvent.Seek(params);
        }
        if (method.equals("System.OnQuit")) {
            return new SystemEvent.Quit(params);
        }
        if (method.equals("System.OnRestart")) {
            return new SystemEvent.Restart(params);
        }
        if (method.equals("System.OnWake")) {
            return new SystemEvent.Wake(params);
        }
        if (method.equals("System.OnLowBattery")) {
            return new SystemEvent.LowBattery(params);
        }
        return null;
    }

    public static int parseInt(ObjectNode node, String key) {
        return node.has(key) ? node.get(key).getIntValue() : -1;
    }

    public static String parseString(ObjectNode node, String key) {
        return node.has(key) ? node.get(key).getTextValue() : null;
    }
}

