/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.jre;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import net.jcores.jre.CoreKeeper;
import net.jcores.jre.annotations.AttentionWithClassloaders;
import net.jcores.jre.annotations.Beta;
import net.jcores.jre.annotations.SupportsOption;
import net.jcores.jre.cores.CoreNumber;
import net.jcores.jre.cores.CoreObject;
import net.jcores.jre.cores.adapter.ListAdapter;
import net.jcores.jre.cores.commons.CommonAlgorithmic;
import net.jcores.jre.cores.commons.CommonNet;
import net.jcores.jre.cores.commons.CommonSys;
import net.jcores.jre.cores.commons.CommonUI;
import net.jcores.jre.interfaces.functions.F0;
import net.jcores.jre.interfaces.functions.F0R;
import net.jcores.jre.managers.Manager;
import net.jcores.jre.managers.ManagerClass;
import net.jcores.jre.managers.ManagerDebugGUI;
import net.jcores.jre.managers.ManagerDeveloperFeedback;
import net.jcores.jre.managers.ManagerExecution;
import net.jcores.jre.managers.ManagerLogging;
import net.jcores.jre.options.KillSwitch;
import net.jcores.jre.options.MessageType;
import net.jcores.jre.options.Option;
import net.jcores.jre.utils.Async;
import net.jcores.jre.utils.internal.Options;
import net.jcores.jre.utils.internal.Reporter;
import net.jcores.jre.utils.internal.structures.ProfileInformation;
import net.jcores.jre.utils.map.ConcurrentMapUtil;
import net.jcores.jre.utils.map.MapUtil;
import net.xeoh.nexus.DefaultNexus;
import net.xeoh.nexus.InternalService;
import net.xeoh.nexus.Nexus;

public class CommonCore {
    private final Reporter reporter = new Reporter(this);
    private final Nexus nexus = new DefaultNexus();
    private final Random random = new Random();
    private ProfileInformation profileInformation;
    private ManagerExecution executionManager;
    private Method cloneMethod;
    public final CommonSys sys = new CommonSys(this);
    public final CommonAlgorithmic alg = new CommonAlgorithmic(this);
    public final CommonUI ui = new CommonUI(this);
    public final CommonNet net = new CommonNet(this);
    protected final String id;

    protected CommonCore() {
        this.manager(ManagerExecution.class, new ManagerExecution());
        this.manager(ManagerClass.class, new ManagerClass());
        this.manager(ManagerDeveloperFeedback.class, new ManagerDeveloperFeedback());
        this.manager(ManagerDebugGUI.class, new ManagerDebugGUI());
        this.manager(ManagerLogging.class, new ManagerLogging());
        try {
            this.cloneMethod = Object.class.getDeclaredMethod("clone", new Class[0]);
            this.cloneMethod.setAccessible(true);
        }
        catch (Exception exception) {
            this.report(MessageType.EXCEPTION, "Unable to get cloning method for objects. $.clone() will not work: " + exception.getMessage());
        }
        this.id = this.sys.uniqueID(new Option[0]);
    }

    protected void updateManagerInformation() {
        this.executionManager = this.manager(ManagerExecution.class);
        this.profileInformation = this.executionManager.getProfile();
    }

    @SupportsOption(options={KillSwitch.class})
    public <R> Async<R> async(final F0R<R> f0R, final Option ... optionArray) {
        final Async.Queue queue = Async.Queue();
        Async async = new Async(this, queue);
        this.sys.oneTime(new F0(){

            @Override
            public void f() {
                try {
                    queue.add(Async.QEntry(f0R.f()));
                    queue.close();
                }
                catch (Exception exception) {
                    Options options = Options.$(CommonCore.this, optionArray);
                    options.failure(f0R, exception, "async:exception", "General exception invoking async function.");
                    queue.close();
                }
            }
        }, 0L, optionArray);
        return async;
    }

    public Integer[] box(int ... nArray) {
        int n = 0;
        Integer[] integerArray = new Integer[nArray.length];
        for (int n2 : nArray) {
            integerArray[n++] = n2;
        }
        return integerArray;
    }

    public Long[] box(long ... lArray) {
        int n = 0;
        Long[] longArray = new Long[lArray.length];
        for (long l : lArray) {
            longArray[n++] = l;
        }
        return longArray;
    }

    public <T> T clone(T t, Option ... optionArray) {
        if (!(t instanceof Cloneable)) {
            return null;
        }
        try {
            return (T)this.cloneMethod.invoke(t, new Object[0]);
        }
        catch (Exception exception) {
            Options.$(this, optionArray).failure(t, exception, "clone:unknown", "Unable to clone object.");
            return null;
        }
    }

    public <T> T[] clone(T[] TArray) {
        if (TArray == null) {
            return null;
        }
        return Arrays.copyOf(TArray, TArray.length);
    }

    public <K, V> ConcurrentMapUtil<K, V> concurrentMap() {
        return new ConcurrentMapUtil(new ConcurrentHashMap());
    }

    public <K, V> ConcurrentMapUtil<K, V> concurrentMap(ConcurrentMap<K, V> concurrentMap) {
        return new ConcurrentMapUtil<K, V>(concurrentMap);
    }

    public <T> CoreObject<T> create(T t, int n) {
        ArrayList<T> arrayList = new ArrayList<T>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(t);
        }
        return new CoreObject(this, new ListAdapter(arrayList));
    }

    public <T> Collection<T> clone(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        return new ArrayList<T>(collection);
    }

    public String coreID() {
        return this.id;
    }

    public <T> T[] deepclone(T[] TArray) {
        if (TArray == null) {
            return null;
        }
        T[] TArray2 = Arrays.copyOf(TArray, TArray.length);
        for (int i = 0; i < TArray2.length; ++i) {
            TArray2[i] = this.clone(TArray2[i], new Option[0]);
        }
        return TArray2;
    }

    public ManagerExecution executor() {
        return this.executionManager;
    }

    @Beta
    public void feedback() {
    }

    @AttentionWithClassloaders
    public Nexus nexus() {
        return this.nexus;
    }

    @AttentionWithClassloaders
    public <T extends Manager> T manager(Class<T> clazz, T t) {
        ArrayList<InternalService<T>> arrayList = new ArrayList<InternalService<T>>();
        arrayList.add(new InternalService<T>(t));
        this.nexus.register(arrayList);
        this.updateManagerInformation();
        return (T)((Manager)this.nexus.get(clazz, new Nexus.Get[0]));
    }

    @AttentionWithClassloaders
    public <T extends Manager> T manager(Class<T> clazz) {
        return (T)((Manager)this.nexus.get(clazz, new Nexus.Get[0]));
    }

    public <K, V> MapUtil<K, V> map() {
        return new MapUtil(new HashMap());
    }

    public <K, V> MapUtil<K, V> map(Map<K, V> map) {
        return new MapUtil<K, V>(map);
    }

    public <T> List<T> list() {
        return new LinkedList();
    }

    public <T> List<T> list(int n) {
        return new ArrayList(n);
    }

    @AttentionWithClassloaders
    public void log(String string, Level level) {
        this.manager(ManagerLogging.class).handler().log(string, level);
    }

    public long measure(F0 f0) {
        long l = System.nanoTime();
        f0.f();
        long l2 = System.nanoTime();
        return l2 - l;
    }

    public ProfileInformation profileInformation() {
        return this.profileInformation;
    }

    public CoreNumber range(int n) {
        return this.range(0, n, 1);
    }

    public CoreNumber range(int n, int n2) {
        return this.range(n, n2, n <= n2 ? 1 : -1);
    }

    public CoreNumber range(int n, int n2, int n3) {
        int[] nArray = new int[Math.abs((n2 - n) / n3)];
        int n4 = 0;
        if (n <= n2) {
            for (int i = n; i < n2; i += n3) {
                nArray[n4++] = i;
            }
        } else {
            for (int i = n; i > n2; i += n3) {
                nArray[n4++] = i;
            }
        }
        return new CoreNumber(this, this.box(nArray));
    }

    public <T> AtomicReference<T> reference() {
        return new AtomicReference();
    }

    public <T> AtomicReference<T> reference(T t) {
        return new AtomicReference<T>(t);
    }

    public void report(MessageType messageType, String string) {
        this.reporter.record(string);
    }

    public void report() {
        this.reporter.printRecords();
    }

    public Random random() {
        return this.random;
    }

    public int[] unbox(Integer ... integerArray) {
        int n = 0;
        int[] nArray = new int[integerArray.length];
        Integer[] integerArray2 = integerArray;
        int n2 = integerArray2.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = integerArray2[i];
            nArray[n++] = n3;
        }
        return nArray;
    }

    public String version() {
        return CoreKeeper.$(this.getClass().getResourceAsStream("jcores.version")).text().split("\n").hashmap(new String[0]).get("build");
    }

    public int requestCPUs(int n) {
        return Math.min(this.profileInformation().numCPUs, n);
    }

    public void releaseCPUs(int n) {
    }
}

